Option Explicit

    ' customize this for the job:
    '----------------------------

' the raw ascii input file:
Global Const gcDefInputName = "c:\vb\asc2mdb\specif\blk_del.rpt"

' the .mdb destination:
Global Const gcDefDbName = "c:\vb\asc2mdb\blk_del.mdb"

' error log: make sure this directory exists!
Global Const gcErrFileName = "c:\vb\asc2mdb\blk_derr.LOG"

' name of the table in the above .mdb file:
Global Const gcTable = "hifinance"

' length of the record when PassFilter is thru with it:
Global Const RecordLen = 54

Function Mode345Key ()
    
    'change this to return the array item number
    ' (in gIOFld) of the Field you want to use for
    ' these Replace Modes.
    ' Field needs unique Index for mode 4/5
    '  since they use the Seek method.
    ' 3>  (block delete from existing database)
    ' 4>  (record by record seek/update; else add)
    ' 5>  (recurd by record seek/update; else error)

    'Mode345Key = 1
     Error 33000 'shouldn't be called in this app
End Function

Function Mode45Index ()
    
    'change this to return the Name of the Index
    ' to use for a Replace Mode 4 or 5 update
    
    ' Field needs unique Index for mode 4/5
    '  since they use the Seek method.
    ' 4>  (record by record seek/update; else add)
    ' 5>  (recurd by record seek/update; else error)
    
    'Mode45Index = "xxx"
    Error 33000  'shouldn't be called in this app

End Function

Function PassFilter (InFileLine)
    Dim Msg As String
    'change this to filter out records you DON'T
    ' want to pass to your database from the ASCII file
    
    'This Function is called by the subroutine
    '   "cmdTranslate_Click" in GENERAL.FRM
    'Just before it posts each line to the database,
    '   it passes the line to this function (PassFilter).
    
    'If TRUE is returned, it posts; otherwise, not posted;
    '  so set PassFilter = False for each InFileLine
    '  (record) you want to reject
    
    'This Function also gives you a chance to change
    ' InFileLine before processing it.
    '  NOTE: When you return TRUE (meaning "post this
    '  record", the InFileLine MUST be the specified
    '  length, with the fields positioned consistent
    '  with the gIOFields array)

    'When reformatting COBOL type report files into
    ' ASCII field oriented records:

    '* define a type in the declarations
    '  section of this module (SPECIFIC.BAS) that defines
    '  the layout of the ASCII record.  This layout
    '  should correspond to gIOFlds array.
    '* Then declare an instance of the type in this
    '  Function, using Static not Dim
    '* build up each record in the Static, returning
    '  True each time it holds a record to post.

    '---------------------------------------------

    On Error GoTo PassFilterError

    ' default will be "true"
    
    Static WorkLine As String * 54

    PassFilter = False

    Select Case True
    
    Case InFileLine Like "FISCAL PERIOD: *"
        Mid$(WorkLine, 1, 2) = Mid$(InFileLine, 16, 2)  'Fiscal_Month (yr)
        Mid$(WorkLine, 3, 2) = Mid$(InFileLine, 19, 2)  'Fiscal_Month (mo)
    Case InFileLine Like "SOP ACCOUNT: *"
        Mid$(WorkLine, 5, 2) = Mid$(InFileLine, 18, 2)  'SOP_Line
        Mid$(WorkLine, 7, 3) = Mid$(InFileLine, 21, 3)  'LSC
    Case InFileLine Like "                     001*"
        Mid$(WorkLine, 10, 3) = Mid$(InFileLine, 27, 3)  'GL_Base
        Mid$(WorkLine, 13, 8) = Mid$(InFileLine, 32, 8) 'GL_Account
        Mid$(WorkLine, 21, 3) = Mid$(InFileLine, 42, 3) 'GL_LSC
        Mid$(WorkLine, 24, 9) = Mid$(InFileLine, 47, 9) 'GL_Alloc
        Mid$(WorkLine, 33, 22) = SvcCurrStrip(Mid$(InFileLine, 57, 22)) 'GL_Amount_US
        'each time we get here, we have a line to post
        InFileLine = WorkLine
        PassFilter = True
    End Select
    
    Exit Function

PassFilterError:

    Msg = Err & " " & Error & NL
    Msg = Msg & " builing the PassFilter, check recordlength?"
    MsgBox Msg
    End


End Function

Private Sub SetupIndexes ()
    
    ' called by SetupSpecifics in this module
    ' customize this for the indexes you want
    ' the array should be the size n = number of
    ' indexes, and each of the n indexes must
    ' be specified
    '----------------------------------------
    
    ReDim gIndexPtrn(3)
    
    gIndexPtrn(1).Name = "Fiscal_Month"
    gIndexPtrn(1).Fields = "Fiscal_Month"
    gIndexPtrn(1).Primary = False
    gIndexPtrn(1).Unique = False
    
    gIndexPtrn(2).Name = "SOP_Line"
    gIndexPtrn(2).Fields = "SOP_Line"
    gIndexPtrn(2).Primary = False
    gIndexPtrn(2).Unique = False
    
    gIndexPtrn(3).Name = "GL_Base"
    gIndexPtrn(3).Fields = "GL_Base"
    gIndexPtrn(3).Primary = False
    gIndexPtrn(3).Unique = False
    
End Sub

Private Sub SetupIOFields ()
    
    ' Called by SetupSpecifics in this module to
    ' initialize gIOFld array.
    ' Customize this for the fields in database.
    ' gIOFld array is used by the cmdTranslate_Click
    ' method of GENERAL.FRM to load the database.

    ' InStart and InLength:

    'a) In the case of record formatted ASCII files:
    '  the inStart and inLength fields tell how
    '  to parse the INPUT FILE, and create the field
    '  contents.
    
    'b) In the case of report formatted ASCII files
    '  (like COBOL report files):
    '  the inStart and inLength fields tell how
    '  to parse the ARGUMENT returned from the
    '  PassFilter method in SPECIFIC.BAS.  (Assuming
    '  your PassFilter Sub reformats the report lines
    '  into records -- see comments in that sub)
    
    ' The array should be the size n = number of
    ' fields, and each of the n fields must
    ' be specified
    '------------------------------------------

    ReDim gIOFld(8)
    
    gIOFld(1).dbName = "Fiscal_Month"    'name for database
    gIOFld(1).dbSize = 4           'size for database
    gIOFld(1).dbType = DB_TEXT     'type for database
    gIOFld(1).inStart = 1          'for parsing input
    gIOFld(1).inLength = 4         'for parsing input
    
    gIOFld(2).dbName = "SOP_Line"
    gIOFld(2).dbSize = 2
    gIOFld(2).dbType = DB_TEXT
    gIOFld(2).inStart = 5
    gIOFld(2).inLength = 2
    
    gIOFld(3).dbName = "LSC"
    gIOFld(3).dbSize = 3
    gIOFld(3).dbType = DB_TEXT
    gIOFld(3).inStart = 7
    gIOFld(3).inLength = 3

    gIOFld(4).dbName = "GL_Base"
    gIOFld(4).dbSize = 3
    gIOFld(4).dbType = DB_TEXT
    gIOFld(4).inStart = 10
    gIOFld(4).inLength = 3

    gIOFld(5).dbName = "GL_Account"
    gIOFld(5).dbSize = 8
    gIOFld(5).dbType = DB_TEXT
    gIOFld(5).inStart = 13
    gIOFld(5).inLength = 8

    gIOFld(6).dbName = "GL_LSC"
    gIOFld(6).dbSize = 3
    gIOFld(6).dbType = DB_TEXT
    gIOFld(6).inStart = 21
    gIOFld(6).inLength = 3

    gIOFld(7).dbName = "GL_Alloc"
    gIOFld(7).dbSize = 9
    gIOFld(7).dbType = DB_TEXT
    gIOFld(7).inStart = 24
    gIOFld(7).inLength = 9

    gIOFld(8).dbName = "GL_Amount_US"
    gIOFld(8).dbSize = 8
    gIOFld(8).dbType = DB_CURRENCY
    gIOFld(8).inStart = 33
    gIOFld(8).inLength = 22

End Sub

Sub SetupSpecifics ()
    
    ' customize this for the job:
    '----------------------------

    App.Title = "Report Muncher"
    ReplaceMode = 0      'see readme

    'shouldn't need customizing:
    '---------------------------

    NL = Chr(13) & Chr(10)
    
    SetupIOFields
    SetupIndexes
    
 
End Sub

