'   ARGV.BAS
'
'   - Improves VB access to command line options
'   - Accomodates different command line "styles"
'   - Similar to argc, argv in C language, with parsing
'   - No restrictions, use freely
'
'      COST:
'            - add ARGV.BAS to your project
'            - call "argvInit" before using the cmd line args
'
'      BENEFIT:
'            - makes available two globals:
'               "argc" (count of command line arguments = n)
'               "argv" (subscript 1..n) array of cmd line args
'
'   Sample command line arguments:
'
'    /col=blue /height=100   c:\test\fu.bar    [vms style]
'     col=blue  height=100   c:\test\fu.bar    [risky style]
'    -cblue    -h100         c:\test\fu.bar    [unix style]
'
'   Returned in argv:
'     The same values are returned regardless of cmd line style
'       (Unix .Option fields contain only 1 character)
'
'       argv(1).Option = col
'       argv(1).Value  = blue
'       argv(2).Option = height
'       argv(2).Value  = 100
'       argv(3).Option =
'       argv(3).Value  = c:\test\fu.bar
'   argc = 3
'
'
      
Option Explicit
Type anArg
    Option As Variant
    Value As Variant
End Type

Global argv() As anArg
Global argc

Sub argvInit ()
    Dim tCommand
    Dim tArg
    Dim marker As Integer
    argc = 0
    tCommand = Trim(Command)
    If Len(Command) = 0 Then Exit Sub
    stuffNCount (tCommand)
    
    'Debug
    'Dim looper As Integer
    'Dim msg As String
    'Dim eol As String
    'eol = Chr$(10) & Chr$(13)
    'msg = "argc = " & argc & eol
    'If argc > 0 Then
    '   msg = msg & "Ubound of argv = " & UBound(argv) & eol
    '   For looper = 1 To argc
    '       msg = msg & "argv " & looper & " option: " & argv(looper).Option & eol
    '       msg = msg & "argv " & looper & " value : " & argv(looper).Value & eol
    '   Next looper
    'End If
    'MsgBox msg
End Sub

Private Sub stuffNCount (tCommand)
    Dim wArg   'working argument holder
    Dim marker As Long
    Dim remCommand  'working remainder of commandline
    remCommand = tCommand & " "  ' add space for end marker
    Do
	marker = InStr(remCommand, " ")
	If marker <= 1 Then Exit Do
	wArg = Trim(Mid(remCommand, 1, marker))
	remCommand = LTrim(Mid(remCommand, marker + 1, Len(remCommand)))
	argc = argc + 1
	stuffOne (wArg)
    Loop
End Sub

Private Sub stuffOne (wArg)
    'chk: argc was incremented just before calling me
    
    Dim marker As Integer
    Dim switchChar As Integer
    ReDim Preserve argv(1 To argc)
    
    If Left(wArg, 1) = "-" Then                 'Unix style switch
	argv(argc).Option = Mid(wArg, 2, 1)
	argv(argc).Value = Mid(wArg, 3)
	Exit Sub
    End If
    
    switchChar = 0
    If Left(wArg, 1) = "/" Then switchChar = 1  'Dos/vms style switch
    marker = InStr(wArg, "=")
    If marker = 0 Then
	If switchChar Then
	    argv(argc).Option = Mid(wArg, 2)
	    argv(argc).Value = ""
	Else
	    argv(argc).Option = ""
	    argv(argc).Value = Mid(wArg, 1)
	Exit Sub
	End If
    Else
	argv(argc).Option = Mid(wArg, 1 + switchChar, marker - (1 + switchChar))
	argv(argc).Value = Mid(wArg, marker + 1, Len(wArg))
	Exit Sub
    End If
End Sub

