Option Explicit

    ' customize these
    '----------------

' the raw ascii input file:
Global Const gcDefInputName = "\vb\asc2mdb\specif\lscmaker.asc"

' the .mdb destination:
Global Const gcDefDbName = "\vb\asc2mdb\lscmaker.mdb"

' error log: make sure this directory exists!
Global Const gcErrFileName = "\vb\asc2mdb\lsc_err.LOG"

' name of the table in the above .mdb file:
Global Const gcTable = "LSC"

' length of the record when PassFilter is thru with it:
Global Const RecordLen = 37

Function Mode345Key ()
    
    'change this
    ' to return the field number
    ' (in gIOFld) you want to use to
    ' lookup the record-to-be-replaced
    ' Field needs unique Index for mode 4/5
    '  since they use the Seek method.
    ' 3>  (block delete from existing database)
    ' 4>  (record by record seek/update; else add)
    ' 5>  (recurd by record seek/update; else error)

    'this allows the app to be used for ReplaceMode 3
    ' if not ReplaceMode 3 or 4 or 5, this never gets called
    Mode345Key = 5

End Function

Function Mode45Index ()
    'change this to return the Name of the Index
    ' to use for a Replace Mode 4 or 5 update
    
    ' Field needs unique Index for mode 4/5
    '  since they use the Seek method.
    ' 4>  (record by record seek/update; else add)
    ' 5>  (recurd by record seek/update; else error)
    
    Mode45Index = "LOB"

End Function

Function PassFilter (InFileLine)
    
    'change this to filter out records you DON'T
    ' want to pass to your database from the ASCII file
    
    'This Function is called by the subroutine
    '   "cmdTranslate_Click" in GENERAL.FRM
    'Just before it posts each line to the database,
    '   it passes the line to this function (PassFilter).
    
    'If TRUE is returned, it posts; otherwise, not posted;
    '  so set PassFilter = False for each InFileLine
    '  (record) you want to reject
    
    'This Function also gives you a chance to change
    ' InFileLine before processing it.
    '  NOTE: When you return TRUE (meaning "post this
    '  record", the InFileLine MUST be the specified
    '  length, with the fields positioned consistent
    '  with the gIOFld array)

    'When reformatting COBOL type report files into
    ' ASCII field oriented records:

    '* define a type in the declarations
    '  section of this module (SPECIFIC.BAS) that defines
    '  the layout of the ASCII record.  This layout
    '  should correspond to gIOFld array.
    '* Then declare an instance of the type in this
    '  Function, using Static not Dim
    '* build up each record in the Static, returning
    '  True each time it holds a record to post.

    '---------------------------------------------


    ' default will be "true"
    
    PassFilter = True
    
End Function

Private Sub SetupIndexes ()
    
    ' called by SetupSpecifics in this module
    ' customize this for the indexes you want.
    ' The array should be the size n, where n =
    ' number of indexes, and each of the n
    ' indexes must be specified here:
    '----------------------------------------
    
    ReDim gIndexPtrn(4)
    
    gIndexPtrn(1).Name = "LSC"
    gIndexPtrn(1).Fields = "LSC"
    gIndexPtrn(1).Primary = True
    gIndexPtrn(1).Unique = True
    
    gIndexPtrn(2).Name = "BU"
    gIndexPtrn(2).Fields = "BU"
    gIndexPtrn(2).Primary = False
    gIndexPtrn(2).Unique = False
    
    gIndexPtrn(3).Name = "BUSeg"
    gIndexPtrn(3).Fields = "BUSeg"
    gIndexPtrn(3).Primary = False
    gIndexPtrn(3).Unique = False
    
    gIndexPtrn(4).Name = "LOB"
    gIndexPtrn(4).Fields = "LOB"
    gIndexPtrn(4).Primary = False
    gIndexPtrn(4).Unique = False
    
End Sub

Private Sub SetupIOFields ()
    
    ' Called by SetupSpecifics in this module to
    ' initialize gIOFld array.
    ' Customize this for the fields in database.
    ' gIOFld array is used by the cmdTranslate_Click
    ' method of GENERAL.FRM to load the database.

    ' InStart and InLength:

    'a) In the case of record formatted ASCII files:
    '  the inStart and inLength fields tell how
    '  to parse the INPUT FILE, and create the field
    '  contents.
    
    'b) In the case of report formatted ASCII files
    '  (like COBOL report files):
    '  the inStart and inLength fields tell how
    '  to parse the ARGUMENT returned from the
    '  PassFilter method in SPECIFIC.BAS.  (Assuming
    '  your PassFilter Sub reformats the report lines
    '  into records -- see comments in that sub)
    
    ' The array should be the size n = number of
    ' fields, and each of the n fields must
    ' be specified
    '------------------------------------------

    ReDim gIOFld(5)
    
    gIOFld(1).dbName = "LSC"    'name for database
    gIOFld(1).dbSize = 3           'size for database
    gIOFld(1).dbType = DB_TEXT     'type for database
    gIOFld(1).inStart = 1          'for parsing input
    gIOFld(1).inLength = 3         'for parsing input
    
    gIOFld(2).dbName = "LSCDescription"
    gIOFld(2).dbSize = 20
    gIOFld(2).dbType = DB_TEXT
    gIOFld(2).inStart = 4
    gIOFld(2).inLength = 20
    
    gIOFld(3).dbName = "BU"
    gIOFld(3).dbSize = 2
    gIOFld(3).dbType = DB_INTEGER
    gIOFld(3).inStart = 26
    gIOFld(3).inLength = 3

    gIOFld(4).dbName = "BUSeg"
    gIOFld(4).dbSize = 2
    gIOFld(4).dbType = DB_INTEGER
    gIOFld(4).inStart = 30
    gIOFld(4).inLength = 3

    gIOFld(5).dbName = "LOB"
    gIOFld(5).dbSize = 2
    gIOFld(5).dbType = DB_INTEGER
    gIOFld(5).inStart = 34
    gIOFld(5).inLength = 3

End Sub

Sub SetupSpecifics ()
    
    ' customize this for the job:
    '----------------------------

    App.Title = "LSC Helpmate"
    ReplaceMode = 0      'explained in "readme"


    'shouldn't need customizing:
    '---------------------------

    NL = Chr(13) & Chr(10)
    
    SetupIOFields
    SetupIndexes

End Sub

