Option Explicit
'**************************************************
'*   NOTE: CTL3DV2.DLL must be installed in your  *
'*         Windows\System directory, or an error  *
'*         msgbox will be generated at run time,  *
'*         and the dll won't work!                *
'**************************************************


' Functions for CTL3DV2.DLL:
Declare Function GetWindowWord% Lib "User" (ByVal hWnd%, ByVal nIndex%)
Declare Function Ctl3dRegister% Lib "CTL3DV2.DLL" (ByVal hInstance%)
Declare Function Ctl3dAutoSubClass% Lib "CTL3DV2.DLL" (ByVal hInstance%)
Declare Function Ctl3dUnregister% Lib "CTL3DV2.DLL" (ByVal hInstance%)
Global Const GWW_HINSTANCE = (-6)
' use Load_CTL3D in the load event of the startup.frm and
' Unload_CTL3D in the unload event of the main.frm

Sub Load_CTL3D (frm As Form)
' registers the dll
  Dim inst%, ret
  inst% = GetWindowWord(frm.hWnd, GWW_HINSTANCE)
  ret = Ctl3dRegister(inst%)
  ret = Ctl3dAutoSubClass(inst%)
End Sub

Sub Unload_CTL3D (frm As Form)
' unloads the dll, preventing GPF in USER when app quits...
  Dim inst%, ret
  inst% = GetWindowWord(frm.hWnd, GWW_HINSTANCE)
  ret = Ctl3dUnregister(inst%)
End Sub

