Option Explicit
Global Const WM_USER = &H400
Global Const EM_GETLINECOUNT = WM_USER + 10
'   Global Variables
'
'Global Filename$    ' Current file to examine
Global crlf$
Global active%
Declare Function SendMessage& Lib "User" (ByVal hWnd%, ByVal wMsg%, ByVal wParam%, lParam As Any)
'constants
Global Const SRCCOPY = &HCC0020
'flags for painting
Dim loading%
'general purpose
Dim i%, r%

Type POINTAPI
    x As Integer
    y As Integer
End Type

Type RECT
    Left As Integer
    Top As Integer
    right As Integer
    bottom As Integer
End Type

Type boxsize
    Width As Integer
    Height As Integer
End Type

Type twipdata
    'scaling constants for each instance
    x As Integer            'twips/per/pixelx - depends on parent's scale mode
    y As Integer            'twips/per/pixely
    bx As Integer           'width of nonclient in twips
    by As Integer           'height of nonclient
End Type

'===========structure to hold the size data===========

Type TabData
    'control 'properties' - set by caller
    num As Integer          'num of Page()'s
    active As Integer       'active Page()
    'orient As Integer       'up = 0, down = 1
    cols As Integer         'horz# of tabs
    Left As Integer         'control left in twips
    Top As Integer          'control top in twips
    offset As Integer       'tab angle
    'optional 'properties' - set by caller for sizable windows
    minwidth As Integer     'based on size of captions
    minheight As Integer    'user-defined
    Width As Integer        'width of whole control
    Height As Integer       'height of whole control
    'optional properties for 'nonaligned' controls
    insetx  As Integer
    insety As Integer
    'calculated by DefineControl()
    rows As Integer         '# of tabs horiz
    box As boxsize          'tabbox
    tab As boxsize          'invbox
    'twips or pixels,depending on scalemode of parent:
    t As twipdata
    'pixels, used by graphic routines:
End Type

Declare Function BitBlt% Lib "GDI" (ByVal hDestDC%, ByVal x%, ByVal y%, ByVal nWidth%, ByVal nHeight%, ByVal hSrcDC%, ByVal XSrc%, ByVal YSrc%, ByVal dwRop&)
Declare Sub ClientToScreen Lib "User" (ByVal hWnd%, lpPoint As POINTAPI)
Declare Sub GetClientRect Lib "User" (ByVal hWnd%, lpRect As RECT)
Declare Function GetParent% Lib "User" (ByVal hWnd%)
Declare Function GetWindowLong& Lib "User" (ByVal hWnd%, ByVal nIndex%)
Declare Sub GetWindowRect Lib "User" (ByVal hWnd%, lpRect As RECT)

Sub DefineControl (f As Form, tbox As Control, ibox As Control, page0 As Control, tb As TabData)
Dim pageleft%, pagetop%, pageheight%, pagewidth%'in pixels
Dim w%, h%  'in twips
Dim theight%, pheight% 'in scalemode of container
'
loading = -1
Debug.Print "=========new run================"
zGetScaleData f, tbox, tb

'===initialize structure with size of the control======
    tb.offset = 4
    tb.rows = tb.num \ tb.cols + 1
'---set height of invbox & tabbox based on textsize
    tb.tab.Height = (tbox.TextHeight("X") + tb.offset)
    tb.box.Height = tb.tab.Height * tb.rows
    ' add 2 pixels to boxheight for 'focus' lines
    theight% = (tb.box.Height + 2) * tb.t.x

'---set an integral pixel width for invbox & tabbox
    pagewidth = page0.Width \ tb.t.x
    tb.tab.Width = (pagewidth + (2 * tb.insetx \ tb.t.x)) \ tb.cols
    tb.box.Width = tb.tab.Width * tb.cols
    tb.Width = tb.box.Width * tb.t.x
'--- Calculate size of Page() height & inset---------------
    'use page0 to set control and form height
    pageheight = page0.Height \ tb.t.y
    tb.insetx = (tb.Width - page0.Width) \ 2
    pheight% = page0.Height + 2 * tb.insety
'----height of entire control-----
    tb.Height = theight% + pheight%

'===position it all=======
pageleft = tb.Left + tb.insetx
pagetop = tb.Top + tb.insety + theight%
'---size page0
page0.Move pageleft, pagetop, pagewidth * tb.t.x, pageheight * tb.t.y
tbox.Move tb.Left, tb.Top, tb.Width, theight%
'----Draw the constant elements-----
DrawTabs ibox, tbox, tb
'----resize the form
w = tb.Width + tb.t.bx: h = tb.Height + tb.t.by
If tb.t.x = 1 Then
    w = w * screen.TwipsPerPixelX
    h = h * screen.TwipsPerPixelY
End If
f.Move f.Left, f.Top, w, h
End Sub

Sub DrawTabs (ibox As Control, tbox As Control, tb As TabData)
Debug.Print "Entering DrawTabs------------"
'called by DefineControl
Dim box As RECT
Dim off%                'inset for angled line
Dim x%, y%, res%

ibox.Cls
ibox.Move 0, 0, tb.tab.Width, tb.tab.Height
'set color and scale
box.right = ibox.ScaleWidth - 1
off = 4
box.bottom = ibox.ScaleHeight
' Draw black lines
ibox.Line (0, off)-(off, 0)                 'angle
ibox.Line -(box.right - off - 1, 0)
ibox.Line (box.right - off - 1, 0)-(box.right, off + 1)  'angle
ibox.Line (box.right, 0)-(box.right, box.bottom)                       'box.right
' Draw white/grey lines
ibox.Line (0, box.bottom)-(0, off + 1), QBColor(15)   'box.left
ibox.Line -(off, 1), QBColor(15)            'angle
ibox.Line -(box.right - off - 1, 1), QBColor(15)  'top
ibox.Line -(box.right - 1, off + 1), QBColor(8)       'angle
ibox.Line -(box.right - 1, box.bottom), QBColor(8)               'right
ibox.Line (0, 0)-(0, off), QBColor(15)
ibox.Line (box.right, 0)-(box.right, off)
ibox.Line (box.right - 1, 0)-(box.right - 1, off), QBColor(8)

'add some grey for the background
ibox.Line (0, 0)-(0, off), QBColor(8)
ibox.Line (1, 0)-(1, off - 1), QBColor(8)
ibox.Line (2, 0)-(2, off - 2), QBColor(8)
ibox.Line (box.right, 0)-(box.right, off + 1), QBColor(8)
ibox.Line (box.right - 1, 0)-(box.right - 1, off), QBColor(8)
ibox.Line (box.right - 2, 0)-(box.right - 2, off - 1), QBColor(8)
ibox.Line (box.right - 3, 0)-(box.right - 3, off - 2), QBColor(8)
ibox.PSet (3, 0), QBColor(8)
ibox.PSet (box.right - 4, 0), QBColor(8)
'blit to  the row
tbox.Visible = 0
tbox.AutoRedraw = -1
y = 0
For x = 0 To tb.cols - 1
res = BitBlt(tbox.hDC, x * tb.tab.Width, y * tb.tab.Height, tb.tab.Width, tb.tab.Height, ibox.hDC, 0, 0, SRCCOPY)
Next
tbox.Visible = -1
tbox.AutoRedraw = 0

End Sub

Sub DrawText (tbox As Control, captions$(), tb As TabData)
'called by tbox_paint
'draws tab captions and focus line
Dim s$
Dim txtw%, y1%, y2%
Dim x%, y%, inner%, outer%, theight%, cell%
'
Debug.Print "Entering DrawText---------"
'
tbox.Cls
cell = 0
y = 0'tb.box.Height - tb.tab.Height
For x = 0 To tb.num * tb.tab.Width Step tb.tab.Width
    If cell = tb.active Then tbox.FontBold = -1 Else tbox.FontBold = 0
    s$ = captions(cell)
    txtw = tbox.TextWidth(s$)
    tbox.CurrentX = x + (tb.tab.Width - txtw) \ 2
    tbox.CurrentY = y + tb.offset \ 2
    tbox.Print s$
    cell = cell + 1
Next

' draw a blank line underneath the selected tab
    inner = 15
    y1 = tbox.ScaleHeight - 1: y2 = tbox.ScaleHeight - 2
'solid line
tbox.Line (0, y1)-(tbox.ScaleWidth, y1), QBColor(inner)
tbox.Line (0, y2)-(tbox.ScaleWidth, y2)
'focus line
x = (tb.active Mod tb.cols) * tb.tab.Width
tbox.Line (x + 1, y1)-(x + tb.tab.Width - 2, y1), tbox.BackColor
tbox.Line (x + 1, y2)-(x + tb.tab.Width - 1, y2), tbox.BackColor
tbox.PSet (x, y1), QBColor(15)
tbox.PSet (x, y2), QBColor(15)
'tbox.ZOrder 0
End Sub

Sub TabClick (Button%, x As Single, y As Single, tbox As Control, captions$(), tb As TabData)
'called by tbox_MouseUp
Dim hpos%, vpos%
Dim activerow%, thisrow%, row%, n%

activerow = 0
'
hpos = x \ tb.tab.Width  '=0,1,2...
vpos = y \ tb.tab.Height
vpos = tb.rows - vpos - 1
'
vpos = vpos + activerow
If vpos >= tb.rows Then
    vpos = vpos - (tb.rows)
End If
n = (vpos * tb.cols) + hpos

'blank tabs:
If n < 0 Or n > tb.num Then Exit Sub

tb.active = n
DrawText tbox, captions(), tb
End Sub

Private Sub zGetScaleData (f As Form, tbox As Control, tb As TabData)
'called by DefineControl
Dim containerhwnd%
Dim win As RECT, client As RECT
'adjustment for scalemode of the form
tb.t.x = screen.TwipsPerPixelX
tb.t.y = screen.TwipsPerPixelY
'
containerhwnd% = GetParent(tbox.hWnd)
If containerhwnd% = f.hWnd Then
    If f.ScaleMode = 3 Then tb.t.x = 1: tb.t.y = 1
Else
For i = 0 To f.Controls.Count - 1
On Error Resume Next
    If f.Controls(i).hWnd = containerhwnd Then
	If f.Controls(i).ScaleMode = 3 Then
	    If Err Then Exit For
	    tb.t.x = 1: tb.t.y = 1
	End If
    Exit For
    End If
Next
End If

'subtract client area from window for border sizes
GetWindowRect f.hWnd, win
GetClientRect f.hWnd, client
tb.t.bx = (win.right - win.Left - client.right) * tb.t.x
tb.t.by = (win.bottom - win.Top - client.bottom) * tb.t.y
End Sub

