' 3D Routines - By Daniel Benito [TeleSoft]

' This is a minute collection of very simple routines that enable
' you to paint several kinds of frames around controls and forms,
' adding a 3D effect to your application.

' They were written to cover a basic need, while keeping code
' simple and fast.

' These subroutines are loosely based on a routine called Outlines,
' which is included in the VB 3.0 sample application VISDATA.

' If you have any questions, send me a message to the CIS address
' 100022,141, or post it in the MSBASIC forum.

Sub InLinePic (pic_name As Control, bevel_size As Integer)
    
' This subroutine paints a raised frame on the border of a form,
' giving it a 3D effect.
'
' Parameters:
' pic_name   - Picture on which to paint frame
' bevel_size - Bevel width


    Dim darkgray As Long, brwhite As Long
    Dim i As Integer, x As Integer, y As Integer, x1 As Integer, y1 As Integer
    Dim col1 As Long, col2 As Long
    Dim pic_top As Integer, pic_left As Integer, pic_right As Integer, pic_bottom As Integer
    darkgray = RGB(128, 128, 128)
    brwhite = RGB(255, 255, 255)
    pic_top = pic_name.ScaleTop
    pic_left = pic_name.ScaleLeft
    pic_bottom = pic_name.ScaleHeight - screen.TwipsPerPixelY 'bottom minus one pixel
    pic_right = pic_name.ScaleWidth - screen.TwipsPerPixelX 'right minus one pixel
    bevel_size = bevel_size - 1
    x1 = screen.TwipsPerPixelX 'twips per pixel horizontally
    y1 = screen.TwipsPerPixelY 'twips per pixel vertically

    For i = -1 To bevel_size
        x = x1 * i 'distance of horiz. lines from edge
        y = y1 * i 'distance of vert. lines from edge
        pic_name.Line (pic_left + x, pic_bottom - y)-(pic_right - x, pic_bottom - y), darkgray
        pic_name.Line (pic_right - x, pic_top + y)-(pic_right - x, pic_bottom - y), darkgray
        pic_name.Line (pic_left + x, pic_top + y)-(pic_right - x, pic_top + y), brwhite
        pic_name.Line (pic_left + x, pic_top + y)-(pic_left + x, pic_bottom - y), brwhite
    Next i
End Sub

Sub OutlineControl (form_name As Form, ctrl_name As Control, bevel_size As Integer, dn As Integer)
  
' This subroutine paints a frame around a control, giving it a 3D effect.
' Parameters:
' form_name  - Form on which control is
' ctrl_name  - Control on which to paint frame
' bevel_size - Bevel width
' dn         - If TRUE, box is drawn sunken. If FALSE, box is drawn raised

    Dim darkgray As Long, brwhite As Long
    Dim i As Integer, x As Integer, y As Integer, x1 As Integer, y1 As Integer
    Dim col1 As Long, col2 As Long
    Dim ctrl_top As Integer, ctrl_left As Integer, ctrl_right As Integer, ctrl_bottom As Integer
    darkgray = RGB(128, 128, 128)
    brwhite = RGB(255, 255, 255)

    Select Case dn
        Case True
            col1 = brwhite
            col2 = darkgray
        Case False
            col2 = brwhite
            col1 = darkgray
        Case Else
            Exit Sub
    End Select

    x1 = screen.TwipsPerPixelX 'twips per pixel horizontally
    y1 = screen.TwipsPerPixelY 'twips per pixel vertically
    bevel_size = bevel_size - 1

    For i = 0 To bevel_size Step 1
        x = x1 * i 'distance of horiz. lines from edge
        y = y1 * i 'distance of vert. lines from edge
        ctrl_top = ctrl_name.Top - screen.TwipsPerPixelY
        ctrl_left = ctrl_name.Left - screen.TwipsPerPixelX
        ctrl_right = ctrl_name.Left + ctrl_name.Width
        ctrl_bottom = ctrl_name.Top + ctrl_name.Height
        form_name.Line (ctrl_left - x, ctrl_bottom + y)-(ctrl_right + x, ctrl_bottom + y), col1
        form_name.Line (ctrl_right + x, ctrl_top - y)-(ctrl_right + x, ctrl_bottom + y), col1
        form_name.Line (ctrl_left - x, ctrl_top - y)-(ctrl_right + x, ctrl_top - y), col2
        form_name.Line (ctrl_left - x, ctrl_top - y)-(ctrl_left - x, ctrl_bottom + y), col2
    Next i
End Sub

Sub OutlineControlPic (pic_name As Control, ctrl_name As Control, bevel_size As Integer, dn As Integer)
    
' This subroutine paints a frame around a control inside a picture box,
' giving it a 3D effect.
'
' Parameters:
' pic_name   - Picture box which contains control
' ctrl_name  - Control on which to paint frame
' bevel_size - Bevel width
' dn         - If TRUE, box is drawn sunken. If FALSE, box is drawn raised

    
    Dim darkgray As Long, brwhite As Long
    Dim i As Integer, x As Integer, y As Integer, x1 As Integer, y1 As Integer
    Dim col1 As Long, col2 As Long
    Dim ctrl_top As Integer, ctrl_left As Integer, ctrl_right As Integer, ctrl_bottom As Integer

    darkgray = RGB(128, 128, 128)
    brwhite = RGB(255, 255, 255)

    Select Case dn
        Case True
            col1 = brwhite
            col2 = darkgray
        Case False
            col2 = brwhite
            col1 = darkgray
        Case Else
            Exit Sub
    End Select

    x1 = screen.TwipsPerPixelX 'twips per pixel horizontally
    y1 = screen.TwipsPerPixelY 'twips per pixel vertically
    bevel_size = bevel_size - 1

    For i = 0 To bevel_size Step 1
        x = x1 * i 'distance of horiz. lines from edge
        y = y1 * i 'distance of vert. lines from edge
        ctrl_top = ctrl_name.Top - screen.TwipsPerPixelY
        ctrl_left = ctrl_name.Left - screen.TwipsPerPixelX
        ctrl_right = ctrl_name.Left + ctrl_name.Width
        ctrl_bottom = ctrl_name.Top + ctrl_name.Height
        pic_name.Line (ctrl_left - x, ctrl_bottom + y)-(ctrl_right + x, ctrl_bottom + y), col1
        pic_name.Line (ctrl_right + x, ctrl_top - y)-(ctrl_right + x, ctrl_bottom + y), col1
        pic_name.Line (ctrl_left - x, ctrl_top - y)-(ctrl_right + x, ctrl_top - y), col2
        pic_name.Line (ctrl_left - x, ctrl_top - y)-(ctrl_left - x, ctrl_bottom + y), col2
    Next i
End Sub

Sub OutlineForm (form_name As Form, bevel_size As Integer)
    
' This subroutine paints a raised frame on the border of a form around a control,
' giving it a 3D effect.
'
' Parameters:
' form_name  - Form on which to paint frame
' bevel_size - Bevel width


    Dim darkgray As Long, brwhite As Long
    Dim i As Integer, x As Integer, y As Integer, x1 As Integer, y1 As Integer
    Dim col1 As Long, col2 As Long
    Dim form_top As Integer, form_left As Integer, form_right As Integer, form_bottom As Integer
    darkgray = RGB(128, 128, 128)
    brwhite = RGB(255, 255, 255)
    form_top = form_name.ScaleTop
    form_left = form_name.ScaleLeft
    form_bottom = form_name.ScaleHeight - screen.TwipsPerPixelY 'bottom minus one pixel
    form_right = form_name.ScaleWidth - screen.TwipsPerPixelX 'right minus one pixel
    bevel_size = bevel_size - 1
    x1 = screen.TwipsPerPixelX 'twips per pixel horizontally
    y1 = screen.TwipsPerPixelY 'twips per pixel vertically

    For i = -1 To bevel_size
        x = x1 * i 'distance of horiz. lines from edge
        y = y1 * i 'distance of vert. lines from edge
        form_name.Line (form_left + x, form_bottom - y)-(form_right - x, form_bottom - y), darkgray
        form_name.Line (form_right - x, form_top + y)-(form_right - x, form_bottom - y), darkgray
        form_name.Line (form_left + x, form_top + y)-(form_right - x, form_top + y), brwhite
        form_name.Line (form_left + x, form_top + y)-(form_left + x, form_bottom - y), brwhite
    Next i

End Sub

Sub OutlinePic (form_name As Form, ctrl_name As Control, dn As Integer)
    
' This subroutine paints a 3D box, with a 1 pixel bevel, around a control.
' Parameters:
' form_name  - Form on which control is
' ctrl_name  - Control on which to paint frame
' dn         - If TRUE, box is drawn sunken. If FALSE, box is drawn raised
    
    Dim darkgray As Long, brwhite As Long
    Dim i As Integer
    Dim col1 As Long, col2 As Long
    Dim ctrl_top As Integer, ctrl_left As Integer, ctrl_right As Integer, ctrl_bottom As Integer

    darkgray = RGB(128, 128, 128)
    brwhite = RGB(255, 255, 255)

    Select Case dn
        Case True
            col1 = brwhite
            col2 = darkgray
        Case False
            col2 = brwhite
            col1 = darkgray
        Case Else
            Exit Sub
    End Select

    x = screen.TwipsPerPixelX 'twips per pixel horizontally
    y = screen.TwipsPerPixelY 'twips per pixel vertically
    

        x2 = x * 2
        y2 = y * 2
        'First box
        ctrl_top = ctrl_name.Top - screen.TwipsPerPixelY
        ctrl_left = ctrl_name.Left - screen.TwipsPerPixelX
        ctrl_right = ctrl_name.Left + ctrl_name.Width
        ctrl_bottom = ctrl_name.Top + ctrl_name.Height
        form_name.Line (ctrl_left - x, ctrl_bottom + y2)-(ctrl_right + x2, ctrl_bottom + y2), col1
        form_name.Line (ctrl_right + x2, ctrl_top - y)-(ctrl_right + x2, ctrl_bottom + y2), col1
        form_name.Line (ctrl_left - x, ctrl_top - y)-(ctrl_right + x2, ctrl_top - y), col1
        form_name.Line (ctrl_left - x, ctrl_top - y)-(ctrl_left - x, ctrl_bottom + y2), col1
        
        'Second box
        ctrl_top = ctrl_name.Top - screen.TwipsPerPixelY
        ctrl_left = ctrl_name.Left - screen.TwipsPerPixelX
        ctrl_right = ctrl_name.Left + ctrl_name.Width
        ctrl_bottom = ctrl_name.Top + ctrl_name.Height
        form_name.Line (ctrl_left - x2, ctrl_bottom + y)-(ctrl_right + x, ctrl_bottom + y), col2
        form_name.Line (ctrl_right + x, ctrl_top - y2)-(ctrl_right + x, ctrl_bottom + y), col2
        form_name.Line (ctrl_left - x2, ctrl_top - y2)-(ctrl_right + x, ctrl_top - y2), col2
        form_name.Line (ctrl_left - x2, ctrl_top - y2)-(ctrl_left - x2, ctrl_bottom + y), col2
    

End Sub

Sub RemoveOutlineControl (form_name As Form, ctrl_name As Control, bevel_size As Integer, dn As Integer)
  
' This subroutine UNpaints a frame around a control, REMOVING its 3D effect.
' Parameters:
' form_name  - Form on which control is
' ctrl_name  - Control on which to paint frame
' bevel_size - Bevel width
' dn         - If TRUE, box is drawn sunken. If FALSE, box is drawn raised

    Dim darkgray As Long, brwhite As Long
    Dim i As Integer, x As Integer, y As Integer, x1 As Integer, y1 As Integer
    Dim col1 As Long, col2 As Long
    Dim ctrl_top As Integer, ctrl_left As Integer, ctrl_right As Integer, ctrl_bottom As Integer
    darkgray = RGB(64, 64, 64)
    brwhite = RGB(64, 64, 64)

    Select Case dn
        Case True
            col1 = brwhite
            col2 = darkgray
        Case False
            col2 = brwhite
            col1 = darkgray
        Case Else
            Exit Sub
    End Select

    x1 = screen.TwipsPerPixelX 'twips per pixel horizontally
    y1 = screen.TwipsPerPixelY 'twips per pixel vertically
    bevel_size = bevel_size - 1

    For i = 0 To bevel_size Step 1
        x = x1 * i 'distance of horiz. lines from edge
        y = y1 * i 'distance of vert. lines from edge
        ctrl_top = ctrl_name.Top - screen.TwipsPerPixelY
        ctrl_left = ctrl_name.Left - screen.TwipsPerPixelX
        ctrl_right = ctrl_name.Left + ctrl_name.Width
        ctrl_bottom = ctrl_name.Top + ctrl_name.Height
        form_name.Line (ctrl_left - x, ctrl_bottom + y)-(ctrl_right + x, ctrl_bottom + y), col1
        form_name.Line (ctrl_right + x, ctrl_top - y)-(ctrl_right + x, ctrl_bottom + y), col1
        form_name.Line (ctrl_left - x, ctrl_top - y)-(ctrl_right + x, ctrl_top - y), col2
        form_name.Line (ctrl_left - x, ctrl_top - y)-(ctrl_left - x, ctrl_bottom + y), col2
    Next i

End Sub

