;RM82TS8,16,24,32,40,48,56,64
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================


DOSSEG
.model medium, Basic
.code

;============================================================================
; DECLARE FUNCTION DOSPRINT% (BYVAL Row%, BYVAL Col%, Text$)
; Uses DOS Write services to print to STDERR.  STDERR allways == CON.
; Does not change the current background attribute, uses whatever was there.
; Only prints to page 0, but no range checks on ROW and COL.
; Returns:
;        Error code:
;         0 if no error
;        -1 if ASCII CHR$(26) found in input stream
;
; Warning:
;        Assumes Text$ only contains ASCII text or Carriage return
;        control characters.  Any other control characters, e.g. CTRL-C
;        will cause Program to terminate, probably destroying file.
;        Routine checks for CTRL-C, CTRL-S, CTRL-P after each character
;
; Notes:
; Moves the cursor to the beginning of the string.  However does not tell
; QBASIC the current cursor location.  Should be a well managed function
; under WINDOWS or other multitasker.
;============================================================================

EVEN
DOSPRINT Proc FAR BASIC ROW:Ptr, COL:Ptr, TEXTSTRG:Ptr

comment |
     Register usage when all done:
     CX = Length of Text string.
     DX = Offset within DGROUP of String
     DS = Assumed to point to segment containing Text string.
          Program does not set this, so string is assumed to
          be a near string in DGROUP, the default in QB 4.5
     BX = is used as a scratch variable register
     AX = returns 0 if no error, else error code
     |
			   ;move cursor to beginning of print location
	Mov   BX,ROW       ;NOTE uses BYVAL
	Dec   BL           ;make it zero based
	Mov   DH,BL        ;store ROW in DH
	Mov   BX,COL       ;NOTE uses BYVAL
	Dec   BL           ;make it zero based
	Mov   DL,BL        ;store COL in DL
	Xor   BH,BH        ;select page 0
	Mov   AH,2         ;move cursor to desired location
	Int   10h          ;using BIOS
	Mov   BX,TEXTSTRG  ;put descriptor to TEXT$ into BX
	Mov   CX,[BX]      ;put Len(TEXT$) into CX for loop counter
	JCXZ  Error        ;if CX = 0, it's a null string, exit with Error
	Mov   DX,[BX+02]   ;put address of first character in X$ into DX
	Mov   BX,2         ;set handle of STDERR
	Mov   AH,40h       ;Use DOS write to device function
	Int   21h
	JC    Exit         ;if carry set, error reported in AX
	Cmp   CX,AX        ;did DOS receive number of characters sent?
	JNE   Error        ;if no, report error
	Xor   AX,AX        ;else clear AX to report no error
	Jmp   Short Exit   ;now exit
Error:
	Mov   AX,-1        ;use -1 to report 01Ah found in input stream,
			   ;or report input stream was a null
Exit:
	Xor   DX,DX
	Ret                ;return skipping the passed parameters
DOSPRINT  Endp

;============================================================================
; DECLARE FUNCTION DMPRINT% (BYVAL Row%, BYVAL Col%, Text$)
; Uses DOS Write services to print to STDERR.  STDERR allways == CON.
; Does not change the current background attribute, uses whatever was there.
; Only prints to page 0, but no range checks on ROW and COL.
; Returns:
;        Error code:
;         0 if no error
;        -1 if CON error.
;
; Warning:
;        Ignores any control characters, merely prints string.
;
; Notes:
; Moves the cursor to the beginning of the string.  However does not tell
; QBASIC the current cursor location.  Should be a well managed function
; under WINDOWS or other multitasker.
;
; Routine is about 1.23 times faster than DOSPRINT on an EGA
;============================================================================

CON_STATUS	DB	0	;save original status of CON

EVEN
DMPRINT Proc FAR BASIC ROW:Ptr, COL:Ptr, TEXTSTRG:Ptr

comment |
     Register usage when nearly done:
     CX = Length of Text string.
     DX = Offset within DGROUP of String
     DS = Assumed to point to segment containing Text string.
	  Program does not set this, so string is assumed to
	  be a near string in DGROUP, the default in QB 4.5
     BX = is used as a scratch variable register
     AX = returns 0 if no error, else error code
     |
	Mov   AX,4400h     ;get current mode of STDERR
	Mov   BX,2         ;set BX to STDERR handle
	Int   21h
	Xor   DH,DH        ;clear DH
	Mov   CON_STATUS,DL  ;save current CON status
	Or    DL,20h       ;set BINARY or RAW bit
	Mov   AX,4401h     ;do it
	Int   21h
			   ;move cursor to beginning of print location
	Mov   BX,ROW       ;NOTE uses BYVAL
	Dec   BL           ;make it zero based
	Mov   DH,BL        ;store ROW in DH
	Mov   BX,COL       ;NOTE uses BYVAL
	Dec   BL           ;make it zero based
	Mov   DL,BL        ;store COL in DL
	Xor   BH,BH        ;select page 0
	Mov   AH,2         ;move cursor to desired location
	Int   10h          ;using BIOS
	Mov   BX,TEXTSTRG  ;put descriptor to TEXT$ into BX
	Mov   CX,[BX]      ;put Len(TEXT$) into CX for loop counter
	JCXZ  Error        ;if CX = 0 it's a null string, exit with an error
	Mov   DX,[BX+02]   ;put address of first character in X$ into DX
	Mov   BX,2         ;set handle to STDERR
	Mov   AH,40h       ;write to device function
	Int   21h
	JC    Exit         ;if carry set, error reported in AX
	Cmp   CX,AX        ;did DOS receive number of characters sent?
	JNE   Error        ;if no, report error of -1
	Xor   AX,AX        ;else clear AX to report no error
	Jmp   Short Exit   ;now exit
Error:
	Mov   AX,-1        ;use -1 to report CON error, input stream a Null.
Exit:
	Mov   CX,AX        ;save AX in CX
	Mov   BX,2         ;Set BX to STDERR handle
	Xor   DH,DH        ;clear DH
	Mov   DL,CON_STATUS ;restore CON to original status
	Mov   AX,4401h     ;do it
	Int   21h
	Xor   DX,DX        ;clear DX in case call long
	Mov   AX,CX        ;get error code back from CX
	Ret                ;return skipping the passed parameters
DMPRINT  Endp
END
