;RM125TS8,16,24,32,40,48
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.Model Medium, Basic
.Code

;=========================================================================
;DECLARE SUB CLEARSCR (BYVAL ULR%, BYVAL ULC%, BYVAL LRR%, BYVAL LRC%,  
;_BYVAL ATTRIB%)
;CALL CLEARSCR(ULR%,  ULC%,  LRR%,  LRC%, ATTRIB%)
;      range:   1-50  1-80  1-50   1-80   0-255
; Uses the video bios to scroll a window.
;=========================================================================

EVEN
CLEARSCR Proc FAR BASIC  \
ULR:Word, ULC:Word, LRR:Word, LRC:Word, ATTRIB:Word

	Mov  BX,ULR        ;get the address for ULR%
	Mov  CH,BL         ;put it into CH
	Dec  CH            ;adjust 1-50 to 0-49 and allow EGA/VGA 43/50 line mode
	Cmp  CH,49         ;range check
	JBE  @f
	Xor  CH,CH
@@:
	Mov  BX,ULC        ;get the address for ULC%
	Mov  CL,BL         ;put it into CL
	Dec  CL            ;adjust 1-80 to 0-79
	Cmp  CL,79         ;range check
	JBE  @f
	Mov  CL,79
@@:
	Mov  BX,LRR        ;range check
	Mov  DH,BL
	Dec  DH
	Cmp  DH,49
	JBE  @F
	Mov  DH,1          ;make LLR at least equal to 1
@@:
	Mov  BX,LRC
	Mov  DL,BL
	Dec  DL
	Cmp  CL,79         ;range check
	JBE  @F
	Mov  CL,79         ;make LRC at least equal to 79
@@:
	Mov  BX,ATTRIB
	Mov  BH,BL
	OR   BH,BH
	Jnz  @f
	Mov  BH,07        ; use default of white on black if ATTRIB = 0
@@:
	Mov  AX,600h       ;Call clear screen function
	Int  10h
	Ret
CLEARSCR EndP

;=========================================================================
;DECLARE SUB SCROLLUP (BYVAL ULR%, BYVAL ULC%, BYVAL LRR%, BYVAL LRC%, BYVAL ROWS%, 
; _BYVAL ATTRIB%)
;CALL SCROLLUP(ULR%, ULC%, LRR%, LRC%, ROWS%, ATTRIB%)
; If ROWS%=0 then entire window cleared
; Description of parameters:
;    Because a rectangle can be described by two points, we us the following 
;    data points:
;	ULR = Upper left row
;	UCL = Upper left column
;	LRR = Lower right row
;	LRC = Lower right column
;       Rows = number of rows to scroll
; Uses the video bios to scroll a window.
;=========================================================================

EVEN
SCROLLUP Proc FAR BASIC  \
ULR:Word, ULC:Word, LRR:Word, LRC:Word, ROWS:Word, ATTRIB:Word

	Mov  AH,6
Intro::                   ;Entry location for SCROLLDOWN
	Mov  BX,ULR        ;get the address for ULR%
	Mov  CH,BL         ;put it into CH
	Dec  CH
	Cmp  CH,49         ;range check
	JBE  @f
	Xor  CH,CH
@@:
	Mov  BX,ULC
	Mov  CL,BL
	Dec  CL
	Cmp  CL,79         ;range check
	JBE  @f
	Mov  CL,79
@@:
	Mov  BX,LRR
	Mov  DH,BL
	Dec  DH
	Cmp  DH,49          ;range chech
	JBE  @f
	Mov  DH,1
@@:
	Mov  BX,LRC
	Mov  DL,BL
	Dec  DL
	Cmp  CL,79         ;range check
	JBE  @f
	Mov  CL,79
@@:
	Mov  BX,ROWS
	Mov  AL,BL
	Cmp  AL,50         ;see if # of ROWS is >50, use one line instead
	Jb   @f
	Mov  AL,1
@@:
	Mov  BX,ATTRIB
	Mov  BH,BL
	OR   BH,BH
	Jnz  @f
	Mov  BH,07	  ; use default of white on black if ATTRIB = 0
@@:
	Int  10h
	Ret
SCROLLUP  EndP

;=========================================================================
;DECLARE SUB SCROLLDOWN (BYVAL ULR%, BYVAL ULC%, BYVAL LRR%, BYVAL LRC%, BYVAL ROWS%, 
; _BYVAL ATTRIB%)
;CALL SCROLLDOWN(ULR%, ULC%, LRR%, LRC%, ROWS%, ATTRIB%)
; If ROWS%=0 then entire window cleared
; Description of parameters:
;    Because a rectangle can be described by two points, we us the following 
;    data points:
;	ULR = Upper left row
;	UCL = Upper left column
;	LRR = Lower right row
;	LRC = Lower right column
;       Rows = number of rows to scroll
; Uses the video bios to scroll a window.
;=========================================================================

EVEN
SCROLLDOWN Proc FAR BASIC  \
ULR:Word, ULC:Word, LRR:Word, LRC:Word, ROWS:Word, ATTRIB:Word
	Mov  AH,7
	Jmp  short Intro
SCROLLDOWN EndP
End
