;RM83TS8,16,24,32,40,48
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.MODEL MEDIUM, BASIC

.data
	;external data so all video routines can access
	EVEN
	EXTRN  B$DVIDEOSEG:WORD
	EXTRN  B$DVIDEOPORT:WORD
	EXTRN  B$DVIDEOINSTL:BYTE
.code

INCLUDE  NOWAIT.INC
EXTRN	Get_Adapter:FAR

comment         |
Calc_DI_Offset_Addr  macro
	;; standard routine
	;; Note destroys AX, BX, CL
	;;               ;8086  ;80286
	Mov   AX,CurrRow   ;14     ;5
	Dec   AX           ;3      ;2   ;;change from 1-25 to 0-24
	Mov   cl,160       ;4      ;2
	Mul   cl           ;77     ;13  ;;multiply CurrRow by 160
	Mov   BX,BegCol    ;14     ;5   ;;get starting column
	Dec   BX           ;3      ;2   ;;change from 1-80 to 0-79
	Shl   BX,1         ;2      ;2   ;;multiply (CurrRow-1) by 2
	Add   AX,BX        ;3      ;2   ;;get offset
	Mov   DI,AX        ;3      ;2   ;;move to source index
	endm               ;---------
			   ;123    ;35  ;;clocks
		|

Calc_DI_Offset_Addr    macro
	;; This is slightly slower in the abstract
	;; sense on a 80286.  Cannot observe the difference
	;; on a 8088 with a CGA because of delay waiting for retrace.
	;; Though if have an 8088 with MONO or VGA/EGA it is faster
	;;
	;; Input:     Nothing
	;; Output:    DI = Memory Offset
	;; Destroys:  CX,AX
	;; Macro is used because inline code speeds routine
	;;               ;8088 ;80286
	Xor     CL, CL     ;3    ;2   ;; Clear CL
	Mov     AX,CurrRow ;14   ;5   ;; get starting Row
	Dec     AX         ;3    ;2   ;; change from 1-25 to 0-24
	Mov     CH, AL     ;2    ;2   ;; CX = Row * 256
	Shr     CX, 1      ;2    ;2   ;; CX = Row * 128
	Mov     DI, CX     ;2    ;2   ;; Store in DI
	Shr     DI, 1      ;2    ;2   ;; DI = Row * 64
	Shr     DI, 1      ;2    ;2   ;; DI = Row * 32
	Add     DI, CX     ;3    ;2   ;; DI = (Row * 128)+(Row * 32)={Row*160}
	Xor     CH, CH     ;3    ;2   ;; Clear CH register
	Mov     AX,BegCol  ;14   ;5   ;; get starting Column
	Dec     AX         ;3    ;2   ;; change from 1-80 to 0-79
	Mov     CL, AL     ;2    ;2   ;; CX = Columns
	Shl     CX, 1      ;2    ;2   ;; Account for attribute
	Add     DI, CX     ;3    ;2   ;; DI = (Row * 160) + (Col * 2)
			  ;--------
      endm                ;60    ;36  ;; clocks

.code
;=====================Some data variables==================================
;         Stored in Code segment to save space in DGROUP

EVEN
CurrRow        DW    0           ;current CurrRow
BegCol         DW    0           ;Starting Column
Num_Cols       DW    0           ;words to copy per line
EndingRow      DW    0           ;Ending Row
BACKCOLOR      DW    0           ;store shadow color for MAKEBOXES
Color          DB    0           ;Store color attribute


;===========================================================================
; DECLARE SUB
; CLEARAREA (BYVAL ULR%, BYVAL ULC%, BYVAL LRR%, BYVAL LRC%, BYVAL ATTRIB%)
; CALL CLEARAREA (ULR%, ULC%, LRR%, LRC%, ATTRIB%)
; Changes the attribute of an area on the screen in text mode
;===========================================================================

EVEN
CLEARAREA Proc FAR BASIC USES SI DI, \
ULR:Word, ULC:Word, LRR:Word, LRC:Word, ATTRIB:Word

comment |
	Register usage when all done:
	AH = Color attribute to change line to
	AL = loading point for STOB, scratch.
	CX = Number of characters to change on a line.
	DX = Port for CGA video retrace check, if necessary.
		0 means display is not a not a CGA display
	DI = Offset of Screen for current character
	ES = Segment of Video display, 0xB000 or 0xB800
	BX = is used as a scratch variable register
	DS & SI are not changed
     |

	Cmp   B$DVIDEOINSTL,1
	JE    Didit
	Call  Get_Adapter       ;determine the display type routine
Didit:
	Mov   ES,B$DVIDEOSEG    ;store Video Segment in ES
	Mov   DX,B$DVIDEOPORT   ;Get B$VDIDEOPORT

	Mov   BX,ULC           ;get first column
	Mov   BegCol,BX

	Mov   BX,LRC           ;get last column
	Cmp   BX,80
	JBE   @f
	Mov   BX,80            ; make sure right margin not > 80
			       ; so no wrap around on left margin
@@:
	Sub   BX,BegCol        ;subtract last column from first column
	Inc   BX               ;add 1 to get number of columns to print
	Mov   Num_Cols,BX      ;BX equals number of words to copy per line

	Mov   BX,LRR           ;get last line
	Mov   EndingRow,BX

	Mov   BX,ULR           ;get first line
	Mov   CurrRow,BX       ;set current row to first line

	Calc_DI_Offset_Addr    ;calculate offset for line MACRO
	Mov   CX,Num_Cols      ;load counter with words to copy
	JCXZ  Exit2            ;if CX is zero it's a zero length line
			       ;so exit now

	Mov   BX,ATTRIB        ;get the color ATTRIBUTE% that was passed
	Mov   AX,BX            ;put it into AH for screen writing below
	Mov   Color,AL
	Cld                    ;clear the direction flag to move data forward
EVEN
Main2:
	Mov   AH,Color         ;get attribute & put it in AH
	Mov   AL,AH            ;get attribute & put it in AL
	Or    DL,DL            ;are we on a mono or EGA system?
	JZ    Mono2            ;yes, skip over the retrace stuff
EVEN
CGA2:
	CLI                    ;prevent hardware interrupts
	Wait_CGA_Retrace       ;wait for retrace on CGA MACRO
	Mov   AL,AH            ;get attribute & put it in AL
	Inc   DI
	Stosb                  ;store the attribute
	STI                    ;allow interrupts again
	Loop  CGA2             ;loop until CX is zero
	Jmp  Short Next_Line2
EVEN
Mono2:
	Inc   DI               ;the increment before store allows one
			       ;to change just the color attribute
	Stosb                  ;store the attribute
	Loop  Mono2            ;loop until CX is zero
Next_Line2:
	Mov   AX,EndingRow
	Cmp   AX,CurrRow       ;Are we done restoring window?
	Je    Exit2            ;exit if complete
	INC   CurrRow          ;next line
	Calc_DI_Offset_Addr    ;compute new offset address MACRO
	Mov   CX,Num_Cols      ;set counter to # of words to copy
	JMP Short Main2        ;jump to print next line
Exit2:
	Ret                    ;return skipping the passed parameters
CLEARAREA   Endp

;===========================================================================
; DECLARE SUB BACKFILL
;(BYVAL ULR%, BYVAL ULC%, BYVAL LRR%, BYVAL LRC%, BYVAL ATTRIB%, BYVAL TEXTCHAR%)
; CALL BACKFILL(ULR%, ULC%, LRR%, LRC%, ATTRIB%, TEXT$)
; Fills the display area with a character and a fixed text attribute
;===========================================================================

EVEN
BACKFILL Proc FAR BASIC USES DI SI, \
ULR:Word, ULC:Word, LRR:Word, LRC:Word, ATTRIB:Word, TEXTS:Word

comment |
	Register usage when all done:
	AH = Color attribute to change line to
	AL = loading point for text character.
	CX = Number of characters to change on a line.
	DX = Port for CGA video retrace check, if necessary.
	     0 means display is not a not a CGA display
	DI = Offset of Screen for current character
	ES = Segment of Video display, 0xB000 or 0xB800
	BX = is used as a scratch variable register
	SI = holds the text & character attribute
	DS  is not changed
     |

	Cmp   B$DVIDEOINSTL,1
	JE    Didit1
	Call Get_Adapter        ;determine the display type routine

Didit1:
	Mov   ES,B$DVIDEOSEG    ;store Video Segment in ES
	Mov   DX,B$DVIDEOPORT   ;Get B$VDIDEOPORT

	Mov   BX,ULC           ;get first column
	Mov   BegCol,BX

	Mov   BX,LRC           ;get last column
	Cmp   BX,80
	JBE   @f
	Mov   BX,80            ; make sure right margin not > 80
			       ; so no wrap around on left margin
@@:
	Sub   BX,BegCol        ;subtract first column from last column
	Inc   BX               ;add 1 to get number of columns to print
	Mov   Num_Cols,BX      ;BX equals number of words to copy per line

	Mov   BX,LRR           ;get last line
	Mov   EndingRow,BX     ;store in EndingRow

	Mov   BX,ULR           ;get first line and
	Mov   CurrRow,BX       ;store in CurrRow

	Calc_DI_Offset_Addr    ;calculate offset for line MACRO
	Mov   CX,Num_Cols      ;load counter with words to copy
	JCXZ  Exit3            ;if CX is zero it's a zero length line
			       ;so exit now

	Mov   BX,ATTRIB        ;get the color ATTRIBUTE% that was passed
	Mov   Color,BL         ;store BL temporarily in Color
	Mov   BX,TEXTS         ;get text string character#
	Or    BX,BX            ;see if string character is &H00
	JZ    Exit3            ;it is zero so exit
	Mov   AX,BX            ;store in AX
	Mov   AH,Color         ;add Color to AH
	Mov   SI,AX            ;store text & attribute in SI
	Cld                    ;clear the direction flag to move data forward
EVEN
Main3:
	Mov   AX,SI            ;get attribute & text chr# & put it in AX
	Or    DL,DL            ;are we on a mono or EGA system (is DL = 0)?
	JZ    Mono3            ;yes, skip over the retrace stuff
EVEN
CGA3:
	CLI                    ;prevent hardware interrupts
	Wait_CGA_Retrace       ;wait for CGA retrace MACRO
	Mov  AX,SI             ;reload Attribute & Text$
	Stosw
	STI                    ;allow interrupts again
	Loop  CGA3             ;loop until CX is zero
	Jmp  Short Next_Line3

Mono3:
	Rep Stosw              ;store the attribute & text$

Next_Line3:
	Mov   AX,EndingRow
	Cmp   AX,CurrRow       ;Are we done restoring window?
	Je    Exit3            ;exit if complete
	INC   CurrRow          ;next line
	Calc_DI_Offset_Addr    ;compute new offset address MACRO
	Mov   CX,Num_Cols      ;set counter to # of words to copy
	JMP Short Main3        ;jump to print next line
Exit3:
	Ret                    ;return skipping the passed parameters
BACKFILL   Endp

;============================================================================
;DECLARE SUB MAKEBOXES _
;(BYVAL ULR%, BYVAL ULC%, BYVAL LRR%, BYVAL LRC%, BYVAL HASNO%, BYVAL BORDER%,_
; BYVAL ATTRIB%)
;CALL MAKEBOXES(ULR,ULC,LRR,LRC,HASHNO,BORDER,ATTRIB)
;
; Somewhat shorter and 1.0076 times faster than using the primitives
; in this .OBJ file to do the same thing
;============================================================================
EVEN
BOXD		LABEL	WORD
		DB	'ͺɻȼ'
BOXS		LABEL	WORD
		DB	'ĳڿ'
BOXSVDH		LABEL	WORD
		DB	'ͳոԾ'
BOXSHDV		LABEL	WORD
		DB	'ĺַӽ'
BOXSOLID	LABEL	WORD
		DB      ''

EVEN
MAKEBOXES Proc FAR BASIC USES DS DI SI, \
ULR:Word, ULC:Word, LRR:Word, LRC:Word, HASHNO:Word, BORDER:Word, ATTRIB:Word

	Mov     BX,HASHNO
	Or      BX,BX
	JZ      No_Background           ; no back fill so skip ahead

Fill_In_Background:
	Mov     AX,BX                   ; push values on the stack
	Mov     BX,ULR
	Push    BX                      ; Push ULR
	Mov     BX,ULC
	Push    BX                      ; Push ULC
	Mov     BX,LRR
	Push    BX                      ; Push LRR
	Mov     BX,LRC
	Push    BX                      ; Push LRC
	Mov     BX,ATTRIB
	Push    BX                      ; push ATTRIB
	Push    AX                      ; push the Hashno
	CALL    BACKFILL

No_Background:				; Draw Main Outline
	Mov	BX,BORDER               ; see if we have a Border choice
	Or	BL,BL                   ; if border not zero, do BORDER
	JNZ	@f
	JMP	DrawShadow              ; plain border
@@:
	Push	DS
	Push	CS
	Pop	DS

	;Must keep this so the OFFSET is calculated correctly
	Assume	ES:NOTHING, DS:NOTHING

        Cmp	BL,2
	JNE	@f
	Mov	SI,OFFSET BOXS		; single sided
	Jmp	Short	StartBorder
@@:
	Cmp	BL,3
	JNE	@f
	Mov	SI,OFFSET BOXSVDH       ; single vertical, double horizontal
	Jmp	Short	StartBorder
@@:
	Cmp	BL,4
	JNE	@f
	Mov	SI,OFFSET BOXSHDV       ; double vertical, single horizontal
        Jmp	Short	StartBorder
@@:
	Cmp	BL,5
	JNE	@f
	Mov	SI,OFFSET BOXSOLID      ; solid box
        Jmp	Short	StartBorder
@@:

        Mov	SI,OFFSET BOXD          ; default format, double sided

EVEN
StartBorder:
	Pop	DS                      ; reset DS to @data

	Assume	DS:@data

		;Draw Top Row
	Mov     BX,ULR
	Push    BX                      ; Push ULR
	Mov     BX,ULC
	Push    BX                      ; Push ULC
	Mov     BX,ULR
	Push    BX                      ; Push ULR
	Mov     BX,LRC
	Push    BX                      ; Push LRC
	Mov     BX,ATTRIB
	Push    BX                      ; push ATTRIB
	Mov     AL,CS:[SI]
	Push    AX                      ; Push Top Row Character
	CALL    BACKFILL

		;Draw Left Side
	Mov     BX,ULR
	Push    BX                      ; Push ULR
	Mov     BX,ULC
	Push    BX
	Mov     BX,LRR
	Push    BX
	Mov     BX,ULC
	Push    BX
	Mov     BX,ATTRIB
	Push    BX                      ; Push ATTRIB
	Mov     AL,CS:[SI+1]
	Push    AX                      ; Push Bottom Row Character
	CALL    BACKFILL

		;Draw Right Side
	Mov     BX,ULR
	Push    BX
	Mov     BX,LRC
	Push    BX
	Mov     BX,LRR
	Push    BX
	Mov     BX,LRC
	Push    BX
	Mov     BX,ATTRIB
	Push    BX                      ; push ATTRIB
	Mov     AL,CS:[SI+1]
	Push    AX                      ; Push Right Side Character
	CALL    BACKFILL

		;Draw Bottom Row
	Mov     BX,LRR
	Push    BX
	Mov     BX,ULC
	Push    BX
	Mov     BX,LRR
	Push    BX
	Mov     BX,LRC
	Push    BX
	Mov     BX,ATTRIB
	Push    BX
	Mov     AL,CS:[SI]
	Push    AX
	CALL    BACKFILL

;Draw Border Edges
		;Draw Upper Left
	Mov     BX,ULR
	Mov     AX,BX
	Push    BX
	Mov     BX,ULC
	Mov     CX,BX
	Push    BX
	Push    AX
	Push    CX
	Mov     BX,ATTRIB
	Push    BX
	Mov     AL,CS:[SI+2]
	Push    AX
	CALL    BACKFILL

		;Draw Upper Right
	Mov     BX,ULR
	Mov     AX,BX
	Push    BX
	Mov     BX,LRC
	Mov     CX,BX
	Push    BX
	Push    AX
	Push    CX
	Mov     BX,ATTRIB
	Push    BX
	Mov     AL,CS:[SI+3]
	Push    AX
	CALL    BACKFILL

		;Draw Lower Right
	Mov     BX,LRR
	Mov     AX,BX
	Push    BX
	Mov     BX,LRC
	Mov     CX,BX
	Push    BX
	Push    AX
	Push    CX
	Mov     BX,ATTRIB
	Push    BX
	Mov     AX,CS:[SI+5]
	Push    AX
	CALL    BACKFILL

		;Draw Lower Left
	Mov     BX,LRR
	Mov     AX,BX
	Push    BX
	Mov     BX,ULC
	Mov     CX,BX
	Push    BX
	Push    AX
	Push    CX
	Mov     BX,ATTRIB               ; push attribute
	Push    BX
	Mov     AL,CS:[SI+4]            ; draw bottom left
	Push    AX
	CALL    BACKFILL

DrawShadow:
;Select shadow color depending on MONO or COLOR display mode
	Mov	BX,BORDER     ;get BORDER
	Or	BH,BH         ;see if we must draw a Shadow
	JZ      Quit          ;nope, so quit
	Xor     BX,BX         ;set ES to Ram BIOS area
	Mov     ES,BX
	Mov     BX,ES:[0463h] ;look a port info stored in RAM bios
			      ; at 0000:0463h
	Mov     AX,17h        ;Assume a Mono Display
	Cmp     BL,0B4h
	Je      @f            ;test port address
	Mov     AX,7          ;COLOR ADAPTER
@@:
	Mov     BACKCOLOR,AX  ;store shadow color
	Mov     BX,LRC
	Mov     CX,BX
	Cmp     BX,77         ; can't draw a shadow if LRC > 77
	JBE     @f
	Jmp     Short  Quit
@@:
	Mov     BX,LRR
	Mov     ES,BX         ; store temporarily in ES
	Cmp     BX,24         ; can't draw a shadow if LRR >24
	JBE     @f
	Jmp     Short  Quit
@@:
		;Draws bottom right shadow
	Mov     BX,ULR
	Inc     BX
	Push    BX            ; push ULR+1
	Inc     CX
	Push    CX            ; push LRC+1
	Mov     BX,ES
	Inc     BX
	Push    BX            ; push LRR+1
	Inc     CX
	Push    CX            ; push LRC+2
	Mov     BX,BACKCOLOR
	Push    BX
	CALL    CLEARAREA

		;draws bottom left shadow
	Mov     BX,LRR
	Inc     BX
	Mov     CX,BX
	Push    BX            ; push LRR+1
	Mov     BX,ULC
	Add     BX,2
	Push    BX            ; push ULC+2
	Push    CX            ; push LRR+1
	Mov     BX,LRC
	Inc     BX
	Push    BX            ; push LRC+1
	Mov     BX,BACKCOLOR
	Push    BX            ; push shadow color
	CALL    CLEARAREA

Quit:
	Ret
MAKEBOXES     ENDP
END
