DEFINT A-Z
'===========================================================================
'Demo of all the video routines.
'Updated 11/26/90
'===========================================================================
REM $INCLUDE: 'VIDEO.BI'

'Main routines

DECLARE SUB NormalWindow (ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$)
DECLARE SUB ExplodingWindow (ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$)
DECLARE SUB DropWindow (ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$)
DECLARE SUB ExplodingDrop (ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$)

'Help routines
 ' This makes text move up and down
DECLARE SUB FunScroll (ULR%, ULC%, LRR%, LRC%, ATTR%)
 ' Scrolls text down three rows
DECLARE SUB DownRow (ULR%, ULC%, LRR%, LRC%, ATTR%)
 ' Clears the display from the outside in.
DECLARE SUB ClearCircle ()
 ' Allow for a time delay so can see the action.  This is a suboptimal routine
 ' a better version is descibed in the Delayer header
DECLARE SUB Delayer (Factor!)

'Selects the Border% Elements based on Choice of Border%
'Listed by Border% Number
	'Double Line Border%                           'Border% 1
	'Single Line Border%                           'Border% 2
	'Double Horizontal Single Vertical Border%     'Border% 3
	'Double Vertical Single Horizontal Border%     'Border% 4
	'Hash Border% (the default for case else)      'Border% 5

DIM Scrn%(2000) 'Display storage area

'These are the Border% elements
DIM SHARED Factor!

'------------------- Regular Window Module -------------------------------
CLS
'turn cursor off, the same as LOCATE ,,0
CALL CURSET(0)

'if have EGA/VGA MONO use HERC type attributes
CALL EGAMONO(1)

	ULC = 1: LRC = 80
	ULR = 1: LRR = 25:
	BORDER% = 1
	LABEL$ = "Normal Box"
   
SELECT CASE VIDEOSTAT     'test for display that can show color well
	CASE -3, -2, 0, 3, 4, 10
		Attrib1 = &H7   'Select white on black
					 'for Herc, COMPAQ, AT&T, EGA/VGA mono display
		ATTR% = &H70    'Background color = 7: Foreground color = 0
	CASE ELSE
		Attrib1 = &H17  'select White on blue for other displays
		ATTR% = &H30    'Background color = 3: Foreground color = 0
END SELECT

    
	CALL NormalWindow(ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$)
	' Save screen 1
	CALL SAVESCRN(VARSEG(Scrn%(0)), VARPTR(Scrn%(0)))

DO
    
	CALL RESTSCRN(VARSEG(Scrn%(0)), VARPTR(Scrn%(0)))
	CALL Delayer(.18)

	IF LEN(INKEY$) THEN EXIT DO    'faster than testing if INKEY$ = ""
    
	ULC = 9: LRC = 70
	ULR = 3: LRR = 17:
	BORDER% = 4 OR 256
	LABEL$ = "Drop Box"
	ATTR% = &H17    'Back = 1: Fore = 7
	CALL DropWindow(ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$)
	Text$ = "Moving Text"
	CALL QPRINT(ULR% + 1, ULC% + 25, Text$, &H1E)
	CALL Delayer(.18)
    
	IF LEN(INKEY$) THEN EXIT DO
    
	ULC = 12: LRC = 67
	ULR = 10: LRR = 21:
	LABEL$ = "Exploding Drop Box"
	BORDER% = 2 OR 256
	ATTR% = &H47   'Back = 4: Fore = 7
	CALL ExplodingDrop(ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$)
    
	CALL DownRow(4, 10, 8, 68, &H1E)
    
	IF LEN(INKEY$) THEN EXIT DO
	
	BORDER% = 2 OR 256 'add shadow to border type 2 with OR 256
	ULC = 30: LRC = 54
	ULR = 16: LRR = 23:
	LABEL$ = "Another Drop Box"
	ATTR% = &H2F     'Back = 2: Fore = 15
				  'don't use black foreground w/ green background
				  'if will have an EGA mono display because it
				  'wont show up
	CALL DropWindow(ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$)
    
	Text$ = "(c) S J Kelly 1990"  'faster if assign text to variable
	CALL QPRINT(ULR% + 1, ULC% + 3, Text$, &H2F)
	CALL FunScroll(ULR% + 1, ULC% + 1, LRR% - 1, LRC% - 1, &H2F)
    
	IF LEN(INKEY$) THEN EXIT DO
    
	BORDER% = 3 OR 256
	ULC = 63: LRC = 77
	ULR = 2: LRR = 11:
	LABEL$ = "Tiny"
	ATTR% = &H5E      'Back = 5: Fore = 14
	CALL DropWindow(ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$)
	Text$ = "Bounce text"
	CALL QPRINT(ULR% + 1, ULC% + 2, Text$, ATTR%)
    
	CALL Delayer(.18)
    
	CALL FunScroll(ULR% + 1, ULC% + 2, LRR% - 1, LRC% - 1, ATTR%)
	CALL FunScroll(ULR% + 1, ULC% + 2, LRR% - 1, LRC% - 1, ATTR%)
    
	CALL Delayer(.13)
    
	ULC = 2: LRC = 25
	ULR = 18: LRR = 24:
	LABEL$ = "Lower Box"
	BORDER% = 2
	ATTR% = &H70     'Back = 7: Fore = 0
	CALL ExplodingWindow(ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$)
	CALL Delayer(.4)

	IF LEN(INKEY$) THEN EXIT DO

LOOP
CALL SAVESCRN(VARSEG(Scrn%(0)), VARPTR(Scrn%(0)))

'Clears the display when complete
CALL ClearCircle

'shows that the text was not affected
ULR = 1: ULC = 1: LRR = 25: LRC = 80

FOR X% = 0 TO 120 STEP 5
	CALL CLEARAREA(ULR, ULC, LRR, LRC, X%)
	CALL Delayer(.25)
	CALL RESTSCRN(VARSEG(Scrn%(0)), VARPTR(Scrn%(0)))
	CALL Delayer(.15)
NEXT X%

CALL Delayer(.1)

IF (Attrib1 = &H17) THEN    ' if have a display that can show color well
	'show how one set of colors can be changed at a time
	CALL RECOLOR(&H70, &H17)
	CALL Delayer(.15)
	CALL RECOLOR(&H5E, &H17)
	CALL Delayer(.15)
	CALL RECOLOR(&H2F, &H17)
	CALL Delayer(.15)
	CALL RECOLOR(&H47, &H17)
	CALL Delayer(.15)
	CALL RECOLOR(&H1E, &H17)
	CALL Delayer(.15)
	CALL RECOLOR(&H7, &H20)
	CALL Delayer(.15)
	CALL RECOLOR(&H30, &H40)
END IF

CALL Delayer(2)
CALL EGAMONO(0)    'turn of EGA mono pallette, use default

CALL FADE          'fade out display



CALL SETQP(10, 10, Attrib1) 'set up information for QPRINTL

Text$ = "Status information concerning your video adapter."
CALL QPRT(10, 10, Text$)   'note that no attribute has to be selected

IF DUALDISPLAY% THEN
	Text$ = "You have a DUAL DISPLAY, so I will select the other."
	CALL QPRT(11, 10, Text$)
	    
		IF INCOLOR THEN
			CALL SWAPMONO       'sets any herc to half mode if have 2 displays
			CALL QPRINTL("A mono display.")
			CALL Delayer(.45)
			CALL SWAPCOLOR
		ELSE
			CALL SWAPCOLOR
			CALL QPRINTL("A color display.")
			CALL Delayer(.45)
			CALL SWAPMONO       'sets any herc to half mode if have 2 displays
		END IF
		    
		SCREEN 0: WIDTH 80, 25
		LOCATE 1, 1

ELSE
	Text$ = "You only have one display type active: "
	CALL QPRT(12, 10, Text$)
	IF FINDCOLOR% THEN
		CALL QPRINTL("A color display.")
	ELSE
		CALL QPRINTL("A mono display.")
	END IF
END IF

LOCATE 13, 10
PRINT "Active Display:  ";
	SELECT CASE VIDEOSTAT%
		CASE 13
			PRINT "VGA with color";
		CASE 11
			PRINT "MCGA with color";
		CASE 10
			PRINT "EGA, VGA or MCGA monochrome";
		CASE 9
			PRINT "EGA with color ECD";
		CASE 8
			PRINT "64KB EGA with color ECD";
		CASE 4
			PRINT "AT&T single color CGA";
		CASE 3
			PRINT "Hercules, with graphics enabled ";
		CASE 2
			PRINT "CGA";
		CASE 0
			PRINT "normal mono";
		CASE -2
			PRINT "COMPAQ single color CGA";
		CASE -3
			PRINT "Hercules, (but MSHERC.COM is not installed)";
		CASE -8
			PRINT "64KB EGA with CGA";
		CASE -9
			PRINT "EGA with CGA";
		CASE -11
			PRINT "MCGA with ECD";
		CASE ELSE
			PRINT "error";
	END SELECT
	PRINT " display."
	PRINT

CALL VIDINFO(Mode%, ROW%, COLUMN%, CURPAGE%, PAGESIZE%)
LOCATE , 10
PRINT "Current Bios Mode: "; Mode%
LOCATE , 10
PRINT "Current Length of display:"; ROW; "lines."
LOCATE , 10
PRINT "Current Width of display:"; COLUMN%; "columns."
LOCATE , 10
PRINT "The current active Page:"; CURPAGE%
LOCATE , 10
PRINT "The current Pagesize: ";
PRINT USING "#####,"; PAGESIZE%; : PRINT " bytes."

Text$ = "The End!!"    'faster if assign text to variable
CALL VPRINT(1, 1, Text$, &H47)  'shows vertical printing

Text$ = "Copyright Copr. 1990, Sidney J. Kelly, All Rights Reserved"
CALL QPRINT(2, 5, Text$, &H47)

END

'============================================================================
'Clears the display of a Color display
'============================================================================
SUB ClearCircle STATIC
    
	STATIC Click!

MaxLen = 25   'length of display
Click! = .04
StopNum = MaxLen \ 2 + 1
Characters = 1

Attrib = 0
Bottom = MaxLen
Right = 80
Top = 1: Left = 1

DO
   
	ROW = Top                 'Clear Across the row
	FOR COL = Left TO Right
		CALL QATTRIB(ROW%, COL%, Characters%, Attrib%)
	NEXT COL
    
	CALL Delayer(Click!)

	SELECT CASE Top           'Stop at center of screen
		CASE StopNum
			EXIT DO
		CASE ELSE
			Top = Top + 1
	END SELECT
  
	COL = Right
    
	FOR ROW = Top TO Bottom    'Clear Down the right side
		CALL QATTRIB(ROW%, COL%, Characters%, Attrib%)
	NEXT ROW
	CALL Delayer(Click!)
	Right = Right - 1
   
	ROW = Bottom                 'Clear across the bottom
    
	FOR COL = Right TO Left STEP -1
		CALL QATTRIB(ROW%, COL%, Characters%, Attrib%)
	NEXT COL
	Bottom = Bottom - 1

	COL = Left                   'Clear up the left side
	CALL Delayer(Click!)
    
	FOR ROW = Bottom TO Top STEP -1
		CALL QATTRIB(ROW%, COL%, Characters%, Attrib%)
	NEXT ROW
    
	CALL Delayer(Click!)
	Left = Left + 1
	
LOOP

END SUB

' =============================== Delay ================================
'   Better Timer Delay Function
'   Delay based on time so that wait will be the same on any processor.
'   Notice the check for negative numbers so that the delay won't
'   freeze at midnight when the delay could become negative.
'
'   A much better routine is available in Programmers Journal that uses
'   Long integers for more precise delays without the 10kb overhead of
'   floating point numbers.  The routine is copyrighted by ETHAN WINER
'   of Cresent Software.
' ======================================================================
SUB Delayer (Factor!) STATIC
   STATIC Begin!
  
   Begin! = TIMER
   DO UNTIL (TIMER - Begin! > Factor!) OR (TIMER - Begin! < 0)
   LOOP

END SUB

'===========================================================================
'Scroll down text in defined window three rows
'===========================================================================
SUB DownRow (ULR%, ULC%, LRR%, LRC%, ATTR%) STATIC
	STATIC Factor1!
	Factor1! = .025

	CALL SCROLLDOWN(ULR%, ULC%, LRR%, LRC%, 1, ATTR%)
	CALL Delayer(Factor1!)
  
	CALL SCROLLDOWN(ULR%, ULC%, LRR%, LRC%, 1, ATTR%)
	CALL Delayer(Factor1!)
  
	CALL SCROLLDOWN(ULR%, ULC%, LRR%, LRC%, 1, ATTR%)
	CALL Delayer(Factor1!)
    
END SUB

'======================================================================
'Draws a Drop Windowed box
'======================================================================
SUB DropWindow (ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$) STATIC

	HASHNO% = 32
	CALL MAKEBOXES(ULR, ULC, LRR, LRC, HASHNO%, BORDER%, ATTR%)
   
	SELECT CASE LEN(LABEL$)
		CASE 1 TO ((LRC - ULC) - 5)
			T$ = "[" + LABEL$ + "]"
			CALL QPRINT(ULR, ULC + 3, T$, ATTR)
		CASE ELSE
	END SELECT
	T$ = ""

END SUB

'=========================================================================
'Exploding Drop Windows
'
'Note this can be rather messy looking on snowy CGA displays.
'=========================================================================
SUB ExplodingDrop (ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$) STATIC
 
	STATIC Factor1!
	Factor1! = .0001

	X1% = ULC + ((LRC% - ULC%) \ 2)
	X2% = LRC - ((LRC% - ULC%) \ 2)
	Y1% = ULR + ((LRR% - ULR%) \ 2)
	Y2% = LRR - ((LRR% - ULR%) \ 2)

DO
    
	IF X1% > ULC THEN X1% = X1% - 3: IF X1% < ULC THEN X1% = ULC
	IF X2% < LRC THEN X2% = X2% + 3: IF X2% > LRC THEN X2% = LRC
	IF Y1% > ULR THEN Y1% = Y1% - 1
	IF Y2% < LRR THEN Y2% = Y2% + 1
    
	IF (X1% = ULC) AND (X2% = LRC) AND (Y1% = ULR) AND Y2% = (LRR) THEN
	    
		HASHNO% = 32
		CALL MAKEBOXES(ULR, ULC, LRR, LRC, HASHNO%, BORDER%, ATTR%)
		SELECT CASE LEN(LABEL$)
			CASE 1 TO ((LRC - ULC) - 5)
				T$ = "[" + LABEL$ + "]"
				CALL QPRINT(ULR, ULC + 3, T$, ATTR)
			CASE ELSE
		END SELECT
		T$ = ""
		EXIT SUB
    
	END IF
    
	'Draw main window
    
	HASHNO% = 32
	CALL MAKEBOXES(Y1%, X1%, Y2%, X2%, HASHNO%, BORDER%, ATTR%)
	SELECT CASE LEN(LABEL$)
		CASE 1 TO ((X2 - X1) - 5)
			T$ = "[" + LABEL$ + "]"
			CALL QPRINT(Y1, X1 + 3, T$, ATTR)
		CASE ELSE
	END SELECT
	T$ = ""
    
	CALL Delayer(Factor1!)

LOOP

END SUB

'===========================================================================
'Draws an Exploding window
'===========================================================================
SUB ExplodingWindow (ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$) STATIC
   
	X1% = ULC + INT((LRC - ULC) / 2)
	X2% = LRC - INT((LRC - ULC) / 2)
	Y1% = ULR + INT((LRR - ULR) / 2)
	Y2% = LRR - INT((LRR - ULR) / 2)

DO
    
	IF X1% > ULC THEN X1% = X1% - 3: IF X1% < ULC THEN X1% = ULC
	IF X2% < LRC THEN X2% = X2% + 3: IF X2% > LRC THEN X2% = LRC
	IF Y1% > ULR THEN Y1% = Y1% - 1
	IF Y2% < LRR THEN Y2% = Y2% + 1
	
	'Calling setup Border%s also acts as a delay factor
    
	HASHNO% = 32
	CALL MAKEBOXES(Y1%, X1%, Y2%, X2%, HASHNO%, BORDER%, ATTR%)
 
	SELECT CASE LEN(LABEL$)
		CASE 1 TO ((X2 - X1) - 5)
			T$ = "[" + LABEL$ + "]"
			CALL QPRINT(Y1, X1 + 3, T$, ATTR)
		CASE ELSE
	END SELECT
	T$ = ""
	CALL Delayer(.001)
    
	IF (X1% = ULC) AND (X2% = LRC) AND (Y1% = ULR) AND Y2% = (LRR) THEN
		EXIT DO
	END IF
LOOP

END SUB

'===========================================================================
'Make text in a defined window bounce
'===========================================================================
SUB FunScroll (ULR%, ULC%, LRR%, LRC%, ATTR%) STATIC
	STATIC MiliDelay!
	MiliDelay! = .034

	CALL SCROLLDOWN(ULR%, ULC%, LRR%, LRC%, 1, ATTR%)
	CALL Delayer(MiliDelay!)
   
	CALL SCROLLDOWN(ULR%, ULC%, LRR%, LRC%, 1, ATTR%)
	CALL Delayer(MiliDelay!)
   
	CALL SCROLLDOWN(ULR%, ULC%, LRR%, LRC%, 1, ATTR%)
	CALL Delayer(MiliDelay!)
   
	CALL SCROLLDOWN(ULR%, ULC%, LRR%, LRC%, 1, ATTR%)
	CALL Delayer(MiliDelay!)
   
	CALL SCROLLUP(ULR%, ULC%, LRR%, LRC%, 1, ATTR%)
	CALL Delayer(MiliDelay!)

	CALL SCROLLUP(ULR% + 1, ULC%, LRR%, LRC% - 1, 1, ATTR%)
	CALL Delayer(MiliDelay!)

END SUB

'===========================================================================
'NormalWindow Program, typical popup w/o drops or exploding
'===========================================================================
SUB NormalWindow (ULR%, ULC%, LRR%, LRC%, ATTR%, BORDER%, LABEL$) STATIC
	
	SELECT CASE BORDER%
		CASE 1 - 4
			HASHNO% = 32
		CASE ELSE
			HASHNO% = 176
	END SELECT
	
	CALL MAKEBOXES(ULR, ULC, LRR, LRC, HASHNO%, BORDER%, ATTR%)
    
	SELECT CASE LEN(LABEL$)
		CASE 1 TO ((LRC - ULC) - 5)
			T$ = "[" + LABEL$ + "]"
			CALL QPRINT(ULR, ULC + 3, T$, ATTR)
		CASE ELSE
	END SELECT
	T$ = ""

END SUB

