DEFINT A-Z
'$DYNAMIC

DECLARE SUB LoadFont (vec.file$)
DECLARE SUB OutText (TEXT$, x%, y%, sc%, co%, wi%)

DECLARE SUB xOutText (TEXT$, x%, y%, sc%, co%, wi%, attr%)
DECLARE SUB waitkey ()

'-----------
' Init
'-----------
  DIM SHARED DCHR$(256)
  CONST FALSE = 0, TRUE = NOT FALSE
  CONST max.color = 15
  RANDOMIZE 10
 
  LoadFont "ASCII.VEC"
  SCREEN 12: CLS
  xOutText "Show 1", 1, 1, 12, 9, 0, 4
  xOutText "Show 2", 1, 100, 12, 9, 0, 4
 waitkey
SCREEN 0, 0, 0: WIDTH 80: CLS : END

REM $STATIC
DEFSNG A-Z
'---------------------------------------
' LoadFont       (Laden der Vektordaten)
'---------------------------------------
SUB LoadFont (VectorFile AS STRING)
   OPEN VectorFile FOR RANDOM AS #1
   IF LOF(1) = 0 THEN
     CLOSE : KILL VectorFile
     BEEP
     PRINT
     PRINT "Vektorzeichensatz '"; VectorFile; "' kann nicht geladen werden!"
     PRINT "Taste drcken...";
     x$ = INPUT$(1)
     END
   ELSE
     CLOSE
   END IF
   OPEN VectorFile FOR INPUT AS #1
   DO WHILE NOT EOF(1)
     LINE INPUT #1, DCHR$(t%)
     t% = t% + 1
   LOOP
   CLOSE
END SUB

'---------------------------------------
' OutText              (Standardausgabe)
'---------------------------------------
SUB OutText (TEXT$, x%, y%, sc%, co%, wi%)
  IF x% = -1 THEN x% = POINT(0)
  IF y% = -1 THEN y% = POINT(1)
  PSET (x%, y%), POINT(x%, y%)
  L% = LEN(TEXT$)
  IF sc% = 0 THEN sc% = 4
  DRAW "s=" + VARPTR$(sc%)
  DRAW "c=" + VARPTR$(co%)
  DRAW "ta=" + VARPTR$(wi%)
  FOR t% = 1 TO L%
    DRAW DCHR$(ASC(MID$(TEXT$, t%)))
  NEXT
END SUB

DEFINT A-Z
SUB waitkey
  x$ = INPUT$(1)
END SUB

DEFSNG A-Z
'---------------------------------------
' eXtended OutText  (erweiterte Ausgabe)
'---------------------------------------
SUB xOutText (TEXT$, x%, y%, sc%, co%, wi%, attr%)
  IF x% = -1 THEN x% = POINT(0)
  IF y% = -1 THEN y% = POINT(1)
  IF sc% <= 12 THEN rad! = 1.5 ELSE rad! = 2.5
  ON attr% GOTO fett, schattrt, rund, ext

   OutText TEXT$, x%, y%, sc%, co%, wi%
 EXIT SUB

fett:
  OutText TEXT$, x%, y%, sc%, co%, wi%
  OutText TEXT$, x% + 1, y%, sc%, co%, wi%
 EXIT SUB
                   
schattrt:
  OutText TEXT$, x%, y%, sc%, co%, wi%
  co% = co% - 8
  IF co% < 0 THEN co% = co% + 16
  x% = x% + 2: y% = y% + 2
  OutText TEXT$, x%, y%, sc%, co%, wi%
 EXIT SUB

rund:
  FOR z% = 0 TO 8
    xx% = x% + SIN(z%) * rad!
    yy% = y% + COS(z%) * rad!
    IF xx% = -1 THEN xx% = 0
    IF yy% = -1 THEN yy% = 0
    OutText TEXT$, xx%, yy%, sc%, co%, wi%
  NEXT
 EXIT SUB

ext:
  FOR z% = 0 TO 9
    xx% = x% + SIN(z%) * rad!
    yy% = y% + COS(z%) * rad!
    co% = RND * max.color
    IF xx% = -1 THEN xx% = 0
    IF yy% = -1 THEN yy% = 0
    OutText TEXT$, xx%, yy%, sc%, co%, wi%
  NEXT
END SUB

