
'------------------------------------------------------------
' Programm:   VECFONT.BAS
' Funktion:   Toolbox fr Quick Basic/Basic PDS  (inkl. Demo)
' Autor:      Jrn Peters, DATA-Force
' letzte nderung am:  1.3.93
'------------------------------------------------------------
'          (C) DATA-Force Softwaredevelopment Corp.
'------------------------------------------------------------

DEFINT A-Z
'$DYNAMIC

DECLARE SUB LoadFont (vec.file$)
DECLARE SUB OutText (TEXT$, x%, y%, sc%, co%, wi%)
DECLARE SUB xOutText (TEXT$, x%, y%, sc%, co%, wi%, attr%)
DECLARE SUB SinText (TEXT$, x%, y%, sc%, co%, a%, b%)
DECLARE SUB CircText (TEXT$, x%, y%, sc%, co%)
DECLARE SUB WaitKey ()

'-----------
' Init
'-----------
  RANDOMIZE 10
  DIM SHARED DCHR$(256)
  CONST FALSE = 0, TRUE = NOT FALSE
  CONST max.color = 15
 
  SCREEN 0: WIDTH 80: PRINT "Vektordaten werden eingelesen ...";
  LoadFont "ASCII.VEC"

'--------------
' Programmstart
'--------------
    ON ERROR GOTO no.vga
    SCREEN 12: SCREEN 13
    ON ERROR GOTO 0
  GOTO main

no.vga:
    SCREEN 0, 0, 0: WIDTH 80: CLS
    PRINT "Diese Demonstration bentigt eine VGA-Karte.": PRINT
    PRINT "Die Routinen dieser Toolbox arbeiten aber":
    PRINT "mit jeder Grafikkarte, die von Quick Basic"
    PRINT "untersttzt werden."
    x$ = INPUT$(1)
  END

'----------------------------------------------
' Demonstration der Vektortextausgabe-Routinen
'----------------------------------------------
main:
  SCREEN 12: CLS
  LINE (0, 0)-(639, 479), 12, B
  t$ = "Vektorzeichensatz"
  OutText t$, 49, 121, 20, 10, 0
  OutText t$, 50, 120, 20, 3, 0
  OutText t$, 51, 119, 20, 9, 0
  OutText t$, 49, 122, 20, 14, 0
 
  xOutText "Toolbox fr Quick Basic 4.5", 160, 180, 8, 7, 0, 2
  OutText "Version 1.5, letzte nderung am 1.3.1993", 190, 230, 4, 7, 0
  t$ = "fgpgmtnmkoe,{aa0[az5Frl|hh"
  FOR t = 1 TO LEN(t$)
    z = ASC(MID$(t$, t, 1)) XOR t
    MID$(t$, t, 1) = CHR$(z)
  NEXT
  xOutText t$, 140, 300, 8, 11, 0, 1
  WaitKey

  SCREEN 12: CLS
  t$ = "Dies ist der VGA-Grafikmodus 12 mit 640 auf 480 Punkten bei 16 Farben. "
  OutText t$, 100, 10, 4, 12, 0
  OutText "Schriftgre 4 (die kleinste)", 250, 100, 4, 9, 0
  OutText "Schriftgre 8", 245, 130, 8, 9, 0
  OutText "Schriftgre 12", 200, 180, 12, 9, 0
  OutText "Schriftgre 24", 50, 250, 24, 9, 0
  t$ = "Die Schriftgre ist eine ganze Zahl, die sich ohne Rest "
  t$ = t$ + "durch Vier teilen lt."
  OutText t$, 100, 380, 4, 2, 0
  OutText "Die Werte drfen zwischen 4 und 255 liegen.", 100, 397, 4, 2, 0
  WaitKey
  
  SCREEN 12: CLS
  t$ = "Texte knnen auch schrg oder senkrecht ausgegeben werden."
  OutText t$, 150, 10, 4, 12, 0
  OutText "Dieser Text ist um 10 Grad gekippt.", 130, 180, 8, 9, 10
  OutText "Dieser Text steht senkrecht.", 610, 410, 8, 9, 90
  OutText "Auch auf dem Kopf ist mglich...", 510, 300, 8, 9, 180
  t$ = "Der Winkel, in dem die Schrift ausgegeben wird, darf"
  t$ = t$ + " zwischen 360 und -360 liegen."
  OutText t$, 80, 400, 4, 2, 0
  WaitKey

  SCREEN 12: CLS
  t$ = "Die Routinen sind so geschrieben, da sie mehrere Vektorzeichenstze"
  t$ = t$ + "untersttzen."
  OutText t$, 70, 10, 4, 12, 0
  t$ = "Was Sie bisher gesehen haben war die Standardschrift."
  OutText t$, 175, 180, 4, 2, 0
  t$ = "Ich lade jetzt den Vektorzeichensatz 'OUTLINE.VEC' ..."
  OutText t$, 170, 260, 4, 15, 0
  LoadFont "OUTLINE.VEC"
  OutText "Ausgabe mit dem OUTLINE-Zeichensatz.", 90, 350, 8, 11, 0
  LoadFont "ASCII.VEC"
  WaitKey

  SCREEN 12: CLS
  t$ = "Dieser Vektorzeichensatz kann genauso ausgegeben werden wie"
  t$ = t$ + " der Standardzeichensatz:"
  OutText t$, 50, 10, 4, 12, 0
  LoadFont "OUTLINE.VEC"
  OutText "schief...", 260, 170, 12, 9, 45
  OutText "senkrecht...", 30, 370, 12, 9, 90
  LoadFont "ASCII.VEC"
  OutText "oder in verschiedenen Gren:", 220, 230, 4, 2, 0
  LoadFont "OUTLINE.VEC"
  OutText "am kleinsten", 230, 260, 4, 9, 0
  OutText "klein", 230, 280, 8, 9, 0
  OutText "mittel", 230, 310, 12, 9, 0
  OutText "gross", 230, 347, 16, 9, 0
  OutText "usw.", 230, 390, 32, 9, 0
  LoadFont "ASCII.VEC"
  WaitKey

  SCREEN 13: CLS
  t$ = "Speziell fr niedrig-auflsende Modi (320/200) wur-"
  OutText t$, 5, 5, 4, 12, 0
  t$ = "de der folgende Zeichensatz (SMALL.VEC) entwickelt:"
  OutText t$, 5, 17, 4, 12, 0
  OutText "Zum Vergleich:", 5, 105, 4, 12, 0
  LoadFont "SMALL.VEC"
  OutText "Das ist der SMALL-Zeichensatz.", 90, 60, 4, 9, 0
  OutText "Natrlich auch in anderen Grssen.", 20, 72, 8, 9, 0
  LOCATE 16, 14
  PRINT "Normale Ausgabe...";
  OutText "Mit dem Vektorzeichensatz...", 104, 135, 4, 15, 0
  t$ = "Mit diesem Zeichensatz ist eine Auflsung von ca. 80 Zeichen pro"
  OutText t$, 25, 160, 4, 2, 0
  t$ = "Zeile und 30 Zeilen pro Bildschirm mglich (statt 40 auf 25)."
  OutText t$, 30, 168, 4, 2, 0
  OutText "Taste drcken...", 1, 192, 4, 15, 0
  WaitKey
  LoadFont "ASCII.VEC"

  SCREEN 12: CLS
  t$ = "Im Standardzeichensatz sind folgende Zeichen enthalten:"
  OutText t$, 150, 10, 4, 12, 0
  y% = 100: z% = 0
  FOR t% = 0 TO 255 STEP 32
    FOR a% = t% TO t% + 31
      z% = z% + 1
      x% = 70 + z% * 15
      OutText "_", x%, y%, 8, 8, 0
      OutText CHR$(a%), x%, y%, 8, 9, 0
    NEXT
    y% = y% + 30: z% = 0
  NEXT
  t$ = "Der Vektorzeichensatz kann jederzeit nachtrglich erweitert"
  t$ = t$ + " und abgendert werden."
  OutText t$, 65, 400, 4, 2, 0
  WaitKey

  SCREEN 12: CLS
  t$ = "Mit erweiterten Routinen lassen sich auch besondere Effekte erzielen:"
  OutText t$, 100, 10, 4, 12, 0
  CircText "Dieser Text ist kreisfrmig... ", 320, 270, 12, 9
  t$ = "Dieser Text wurde mit der Sinusfunktion gebogen..."
  SinText t$, 20, 370, 8, 9, 4, 27
  WaitKey
  LINE (0, 50)-(639, 479), 0, BF
  OutText "normale Ausgabe", 100, 100, 12, 9, 0
  xOutText "fette Ausgabe", 100, 150, 12, 9, 0, 1
  xOutText "schattierte Ausgabe", 100, 200, 12, 9, 0, 2
  xOutText "abgerundete Ausgabe", 100, 250, 12, 9, 0, 3
  xOutText "Search A1", 100, 300, 12, 9, 0, 4
  WaitKey

  SCREEN 12: CLS
  t$ = "Der Aufruf der Routinen ist denkbar einfach:"
  OutText t$, 180, 10, 4, 12, 0
  OutText "Zum Laden des Vektorzeichensatzes:", 100, 90, 4, 7, 0
  OutText "Zur normalen Ausgabe:", 100, 130, 4, 7, 0
  OutText "Zur kreisfrmigen Ausgabe:", 100, 170, 4, 7, 0
  OutText "Zur wellenfrmigen Ausgabe:", 100, 210, 4, 7, 0
  OutText "Zur fetten Ausgabe:", 100, 250, 4, 7, 0
  OutText "Zur schattierten Ausgabe:", 100, 290, 4, 7, 0
  OutText "Zur abgerundeten Ausgabe:", 100, 330, 4, 7, 0
  OutText "Zur erweiterten Ausgabe:", 100, 370, 4, 7, 0
  t$ = "LOADFONT 'Vektorzeichensatzdatei'"
  OutText t$, 140, 105, 4, 11, 0
  t$ = "OUTTEXT 'Text', X-Koordinate, Y-Koordinate, Gre, Farbe, Winkel"
  OutText t$, 140, 145, 4, 11, 0
  t$ = "CIRCTEXT 'Text', X-Koordinate, Y-Koordinate, Gre, Farbe"
  OutText t$, 140, 185, 4, 11, 0
  t$ = "SINTEXT 'Text', X-Koordinate, Y-Koordinate, Gre, Farbe, Hhe, Breite"
  OutText t$, 140, 225, 4, 11, 0
  t$ = "XOUTTEXT 'Text', X-Koordinate, Y-Koordinate, Gre, Farbe, Winkel, 1"
  OutText t$, 140, 265, 4, 11, 0
  t$ = "XOUTTEXT 'Text', X-Koordinate, Y-Koordinate, Gre, Farbe, Winkel, 2"
  OutText t$, 140, 305, 4, 11, 0
  t$ = "XOUTTEXT 'Text', X-Koordinate, Y-Koordinate, Gre, Farbe, Winkel, 3"
  OutText t$, 140, 345, 4, 11, 0
  t$ = "XOUTTEXT 'Text', X-Koordinate, Y-Koordinate, Gre, Farbe, Winkel, 4"
  OutText t$, 140, 385, 4, 11, 0
  t$ = "Wenn statt den Koordinaten der Wert -1 bergeben wird, wird"
  t$ = t$ + " an der Position weitergezeichnet,"
  OutText t$, 50, 424, 4, 2, 0
  t$ = "an der die letzte Grafikausgabe stattgefunden hat."
  OutText t$, 50, 440, 4, 2, 0
  WaitKey

  SCREEN 12: CLS
  t$ = "Weil die Routinen in Basic geschrieben sind, arbeiten sie "
  t$ = t$ + "problemlos mit anderen Befehlen zusammen:"
  OutText t$, 10, 10, 4, 12, 0
  OutText "z.B. mit dem VIEW-Befehl. :", 100, 100, 4, 2, 0
  OutText "<-- Fenster, da mit dem VIEW-Befehl", 400, 200, 4, 7, 0
  OutText "    definiert worden ist.", 400, 216, 4, 7, 0
  VIEW (160, 130)-(390, 360), 0, 11
  OutText "Dies ist ein Beispieltext...", -10, 180, 8, 9, 45
  SinText "...noch ein Beispieltext", 10, 210, 8, 9, 5, 40
  VIEW
  WaitKey

  SCREEN 12: CLS
  t$ = "that's all.": L% = LEN(t$)
     xx% = -3
     FOR t% = 1 TO L%
       G! = 1: x! = 649: y! = 479
       FOR w% = 0 TO 360 STEP 9
         G! = G! * 1.09: s% = INT(G!)
         x! = xx% + x! / 1.06 - .4
         y! = y! / 1.07
         PSET (x!, y!), POINT(x!, y!)
         DRAW "c9 ta=" + VARPTR$(w%)
         DRAW "s=" + VARPTR$(s%)
         DRAW DCHR$(ASC(MID$(t$, t%)))
         PSET (x!, y!), POINT(x!, y!)
         DRAW "c8 ta=" + VARPTR$(w%)
         DRAW "s=" + VARPTR$(s%)
         DRAW DCHR$(ASC(MID$(t$, t%)))
       NEXT
       x% = x!: y% = y!: xx% = xx% + 3.5
       tt$ = MID$(t$, t%, 1)
       xOutText tt$, x%, y%, s%, 4, 0, 2
     NEXT
     LoadFont "OUTLINE.VEC"
     t$ = "see you..."
     xOutText t$, 15, 390, 24, 0, 0, 4
     x$ = INPUT$(1)

SCREEN 0, 0, 0: WIDTH 80: CLS : END

REM $STATIC
DEFSNG A-Z
'---------------------------------------
' CircText        (kreisfrmige Ausgabe)
'---------------------------------------
SUB CircText (TEXT$, x%, y%, sc%, co%)
  IF x% = -1 THEN x% = POINT(0)
  IF y% = -1 THEN y% = POINT(1)
  PSET (x%, y%), POINT(x%, y%)
  L% = LEN(TEXT$): wi% = 0
  IF sc% = 0 THEN sc% = 4
  DRAW "S=" + VARPTR$(sc%)
  DRAW "C=" + VARPTR$(co%)
  FOR t% = 1 TO L%
    wi% = wi% + 355 / L%
    DRAW "TA=" + VARPTR$(wi%)
    DRAW DCHR$(ASC(MID$(TEXT$, t%)))
  NEXT
END SUB

'---------------------------------------
' LoadFont       (Laden der Vektordaten)
'---------------------------------------
SUB LoadFont (VectorFile AS STRING)
   OPEN VectorFile FOR RANDOM AS #1
   IF LOF(1) = 0 THEN
     CLOSE : KILL VectorFile
     BEEP
     PRINT
     PRINT "Vektorzeichensatz '"; VectorFile; "' kann nicht geladen werden!"
     PRINT "Taste drcken...";
     x$ = INPUT$(1)
     END
   ELSE
     CLOSE
   END IF
   OPEN VectorFile FOR INPUT AS #1
   DO WHILE NOT EOF(1)
     LINE INPUT #1, DCHR$(t%)
     t% = t% + 1
   LOOP
   CLOSE
END SUB

'---------------------------------------
' OutText              (Standardausgabe)
'---------------------------------------
SUB OutText (TEXT$, x%, y%, sc%, co%, wi%)
  IF x% = -1 THEN x% = POINT(0)
  IF y% = -1 THEN y% = POINT(1)
  PSET (x%, y%), POINT(x%, y%)
  L% = LEN(TEXT$)
  IF sc% = 0 THEN sc% = 4
  DRAW "s=" + VARPTR$(sc%)
  DRAW "c=" + VARPTR$(co%)
  DRAW "ta=" + VARPTR$(wi%)
  FOR t% = 1 TO L%
    DRAW DCHR$(ASC(MID$(TEXT$, t%)))
  NEXT
END SUB

'---------------------------------------
' SinText        (wellenfrmige Ausgabe)
'---------------------------------------
SUB SinText (TEXT$, x%, y%, sc%, co%, a%, b%)
  IF x% = -1 THEN x% = POINT(0)
  IF y% = -1 THEN y% = POINT(1)
  PSET (x%, y%), POINT(x%, y%)
  L% = LEN(TEXT$)
  IF sc% = 0 THEN sc% = 4
  IF a% = 0 THEN a% = 5
  IF b% = 0 THEN b% = 50
  DRAW "S=" + VARPTR$(sc%)
  DRAW "C=" + VARPTR$(co%)
  FOR t% = 1 TO L%
    wi% = SIN(t% / a%) * b%
    DRAW "TA=" + VARPTR$(wi%)
    DRAW DCHR$(ASC(MID$(TEXT$, t%)))
  NEXT
END SUB

SUB WaitKey
  TEXT$ = "Beliebige Taste zum Fortfahren drcken..."
  OutText TEXT$, 2, 465, 4, 15, 0
  x$ = INPUT$(1)
  IF x$ = CHR$(27) THEN
    '*** ESC ***
    SCREEN 0, 0, 0: WIDTH 80: CLS : END
  END IF
END SUB

'---------------------------------------
' eXtended OutText  (erweiterte Ausgabe)
'---------------------------------------
SUB xOutText (TEXT$, x%, y%, sc%, co%, wi%, attr%)
  IF x% = -1 THEN x% = POINT(0)
  IF y% = -1 THEN y% = POINT(1)
  IF sc% <= 12 THEN rad! = 1.5 ELSE rad! = 2.5
  ON attr% GOTO fett, schattrt, rund, ext

   OutText TEXT$, x%, y%, sc%, co%, wi%
 EXIT SUB

fett:
  OutText TEXT$, x%, y%, sc%, co%, wi%
  OutText TEXT$, x% + 1, y%, sc%, co%, wi%
 EXIT SUB
                   
schattrt:
  OutText TEXT$, x%, y%, sc%, co%, wi%
  co% = co% - 8
  IF co% < 0 THEN co% = co% + 16
  x% = x% + 2: y% = y% + 2
  OutText TEXT$, x%, y%, sc%, co%, wi%
 EXIT SUB

rund:
  FOR z% = 0 TO 8
    xx% = x% + SIN(z%) * rad!
    yy% = y% + COS(z%) * rad!
    IF xx% = -1 THEN xx% = 0
    IF yy% = -1 THEN yy% = 0
    OutText TEXT$, xx%, yy%, sc%, co%, wi%
  NEXT
 EXIT SUB

ext:
  FOR z% = 0 TO 9
    xx% = x% + SIN(z%) * rad!
    yy% = y% + COS(z%) * rad!
    co% = RND * max.color
    IF xx% = -1 THEN xx% = 0
    IF yy% = -1 THEN yy% = 0
    OutText TEXT$, xx%, yy%, sc%, co%, wi%
  NEXT
END SUB

