DEFINT A-Z
DECLARE FUNCTION CDROMDrv$ ()
DECLARE FUNCTION FilPtrMov% (FilNum%, Mov&, Methd%)
DECLARE FUNCTION FilRead% (FilNum%, Posn&, Segmt%, Offst%, NumByts&)
DECLARE FUNCTION FilWrit% (FilNum%, Posn&, Segmt%, Offst%, NumByts&)
DECLARE SUB ReBoot ()
DECLARE SUB KBBufRtn (Code$)
DECLARE SUB CtrlCBrk (Code%)
DECLARE SUB VerifyW (Code%)
DECLARE FUNCTION SetFilTD% (Spec$, Tim$, Dat$)
DECLARE FUNCTION RemotDrv% (Driv$)
DECLARE FUNCTION PrntChk% ()
DECLARE FUNCTION NetwrkLd% ()
DECLARE FUNCTION SetFilAt% (Spec$, Attr)
DECLARE FUNCTION VolLbl$ (Driv$)
DECLARE FUNCTION FlushBuf% (FilNum%)
DECLARE SUB ApComRd (ECode%, Code$)
DECLARE SUB ApComStr (ECode%, Code$)
DECLARE FUNCTION CmdLin$ (Swtch$)
DECLARE FUNCTION DiskRW% (Code%, Path$)
DECLARE FUNCTION SetPath% (Path$)
DECLARE FUNCTION CurPath$ ()
DECLARE SUB ScrnCopy (Src%, Dst%)
DECLARE FUNCTION FloppySet% (Path$)
DECLARE FUNCTION PrntInit% (PtrPt%)
DECLARE FUNCTION ModInit% ()
DECLARE SUB SystmData ()
DECLARE FUNCTION DskSpace& (Path$)
DECLARE FUNCTION FloppyRd% (Path$)
DECLARE SUB GetFiles (Spec$, Code%, FData() AS ANY, Nctr%)
DECLARE SUB EditPath (Inspec$, Outspec$)
DECLARE SUB SetDir (Path$, Result%)
DECLARE FUNCTION CurDir$ (Driv$)
DECLARE FUNCTION DFExist% (Code%, Spec$)
DECLARE SUB SetDriv (Driv$)
DECLARE FUNCTION CurDriv$ ()
DECLARE FUNCTION Monitor% ()

'Module SUPPRT1.BAS
'Support routines for QB 4 program system data, I/O, setup.
'
'Documentation is included with each routine.
'There is some redundancy in routines and others can be effectively
' combined for single calls in your program.  Return options (e.g. -1, 0)
' should be adjusted to fit your program logic.  Modify as you need.
'Brian Dinsmoor 76675,1606

'Requires INTERRUPT library support (Start with qb/l).
'Will work with both supplied QB.QLB and corrected INTRPT.OBJ to avoid
'   hanging program on critical errors.  See MS Library QB4CRIT.
'Limited testing on:
'  IBM, MS, OEM DOS 3.1, 3.2, 3.3, 4.0, 5.0, 6.0.
'  Most functions work on DR DOS 6.0.
'  XT, 286, 386, 486 machines.
'  IBM PC/XT, Compaq, PC Ltd, Dell, PS/2, Expo, Zenith, Toshiba, Leading Edge.
'  Novell networks
'Refs:
'System BIOS for IBM PCs, Compatibles, and EISA Computers, 2nd ed, Phoenix Tech Ltd
'The Programmer's PC Sourcebook, 2nd ed, Microsoft Press.
'PC Mag BASIC Techniques and Utilities, Ethan Winer, ZD Press.
'Microsoft Quickbasic Programmer's Toolbox, J C Craig, Microsoft Press.
'PC Resource Magazine columns and code examples.
'MS Knowledge Base.
'All the MS BASIC Forum folks and their contributions

TYPE RegType                                     'INTERRUPT variables
	ax AS INTEGER
	bx AS INTEGER
	cx AS INTEGER
	dx AS INTEGER
	bp AS INTEGER
	si AS INTEGER
	di AS INTEGER
	flags AS INTEGER
END TYPE
TYPE RegTypeX                                    'INTERRUPTX variables
	ax AS INTEGER
	bx AS INTEGER
	cx AS INTEGER
	dx AS INTEGER
	bp AS INTEGER
	si AS INTEGER
	di AS INTEGER
	flags AS INTEGER
	ds AS INTEGER
	es AS INTEGER
END TYPE
TYPE FileData                                    'GetFiles file variables
	nam AS STRING * 8                            ' filename
	ext AS STRING * 3                            ' extension
	att AS INTEGER                               ' attribute byte
	yr AS INTEGER                                ' year of file date
	mon AS INTEGER                               ' month of file date
	day AS INTEGER                               ' day of file date
	hr AS INTEGER                                ' hour of file time
	min AS INTEGER                               ' minute of file time
	siz AS LONG                                  ' length in bytes
END TYPE
TYPE SystmData                                   'SystmData variables
	vid AS INTEGER                               ' video adapter (0-3)
	flp AS INTEGER                               ' number of floppy drives
	ptr AS INTEGER                               ' number of parallel printer ports
	ser AS INTEGER                               ' number of serial ports
	mse AS INTEGER                               ' non-zero is active mouse + type
	cop AS INTEGER                               ' coprocessor installed (1 vs 0)
	ems AS INTEGER                               ' EMS installed (page frame segment vs 0)
	mem AS LONG                                  ' available memory bytes
	drv AS STRING * 1                            ' startup or boot drive
	dir AS STRING * 40                           ' current default drive + directory path
	ver AS INTEGER                               ' DOS version in form 3.3 = 330
	pth AS STRING * 40                           ' path to the program now executing
END TYPE

'$DYNAMIC

DIM SHARED inregs AS RegType, outregs AS RegType
DIM SHARED inregx AS RegTypeX, outregx AS RegTypeX
DIM SHARED FData(1 TO 1) AS FileData, SData AS SystmData
CONST false = 0, true = NOT false


CLS
PRINT "This is start of SUPPRT1...."
PRINT ""
CALL SystmData
PRINT "SystmData: Video, Flops, Ptrs, Sers, Mse, Pth, Cop, EMS, Memry, Drv, Dir, Ver..."
PRINT SData.vid; SData.flp; SData.ptr; SData.ser; SData.mse; SData.pth
PRINT SData.cop; SData.ems; SData.mem; SData.drv; SData.dir; SData.ver
PRINT ""

'ROM BIOS Compatibility Segment System Configuration Table
DEF SEG = &HF000
x$ = ""
FOR i = 0 TO 7
	   x$ = x$ + CHR$(PEEK(&HFFF5 + i))
NEXT i
PRINT "Model byte, Submodel byte, ROM BIOS date, System model ID ..."
PRINT PEEK(&HE6F7), PEEK(&HE6F8), x$, PEEK(&HFFFE)
PRINT ""
DEF SEG

EndPgm:
	a$ = INPUT$(1)
	CLS
	COLOR 7, 0
	END

REM $STATIC
SUB ApComRd (ECode, Code$) STATIC

'Reads information stored in memory from another application program.
'ECode is integer exit or error code from the first program.
'Code$ is a 54 byte (max) string of information.
'If Code$ not needed, erase in calling routine or eliminate below.
'See routine ApComStr (ECode, Code$) for further details.

DEF SEG = 0                                      'Go to interrupt vector table
t$ = CHR$(PEEK(&H294)) + CHR$(PEEK(&H295))       'Read first two locations and convert to integer
ECode = CVI(t$)

Code$ = ""
FOR i = 0 TO 53                                  'Peek bytes and convert to string
	t = PEEK(&H296 + i)                          'Include ASCII characters only
	IF t < 32 THEN t = 32
	Code$ = Code$ + CHR$(t)
NEXT i
Code$ = RTRIM$(Code$)                            'Trim zero bytes at end
DEF SEG

END SUB

SUB ApComStr (ECode, Code$) STATIC

'Store information in memory to communicate from one application to another.
'ECode is a integer exit or error code to save.
'Code$ is a 54 byte (max) string of information to save such as login codewords, file names,
' or path strings.  Any parsing must be done outside of of the ApCom routines.
'Use this routine at the end of one program.  Read the information in another program
' using the ApComRd (Ecode, Code$) routine.  Reboot machine to erase.
'Can run text, graphics, TSR, and network apps without disturbing.
'Use null string for Code$, if only have ECode to save.
'Only known incompatibility is with IBM machines running an interpreted basic program
' with BASICA.COM or BASIC.COM.  GWBASIC, QuickBasic, and QBasic that do not
' use the IBM ROM BASIC are OK.

DEF SEG = 0                                      'Go to interrupt vector table
POKE &H294, 0: POKE &H295, 0                     'Set integer location to 0 initially
t$ = MKI$(ECode)                                 'Convert exitcode to string
IF t$ <> "" THEN                                 'If not null poke into first two locations
	POKE &H294, ASC(t$)
	POKE &H295, ASC(RIGHT$(t$, 1))
END IF

IF Code$ = "" THEN                               'If no string to save, then return
	DEF SEG
	EXIT SUB
END IF

Code$ = LEFT$(Code$ + SPACE$(54), 54)            'Be sure string covers available space
FOR i = 0 TO 53                                  'Poke string into memory
	POKE &H296 + i, ASC(MID$(Code$, i + 1, 1))
NEXT i
DEF SEG

END SUB

FUNCTION CDROMDrv$ STATIC

'Returns one byte capital letter string of first CD-ROM drive in system.
'Returns null string if no drives.
'Active CD-ROM requires device driver in CONFIG.SYS and MSCDEX.EXE installed.
'Requires INTERRUPT, SData(SystmData) support.

CDROMDrv$ = ""                                   'Default no CD-ROM
IF SData.ver < 330 THEN EXIT FUNCTION            'Exclude earlier DOS
inregs.ax = &H1500                               'Get No of Drives function
inregs.bx = 0
CALL INTERRUPT(&H2F, inregs, outregs)
IF outregs.bx < 1 THEN EXIT FUNCTION             'Check for driver install
IF outregs.cx < 0 OR outregs.cx > 25 THEN EXIT FUNCTION  'Check for valid drive range
CDROMDrv$ = CHR$(outregs.cx + 65)                'A=0, B=1, ...

END FUNCTION

FUNCTION CmdLin$ (Swtch$) STATIC

'Confirms that a command line switch exists or if the switch
' passes a parameter, it determines the parameter in a string variable.
'Swtch$ is the parameter to check for in the format "/Swtch$" such
' as /c or /W=abcd
'As setup, switches are not case sensitive.  Upper case is returned.
'If the input switch exists, CmdLin$ returns the switch (e.g. C) or
' any string after an equal sign (e.g. ABCD).
'Returns the null string if switch not present.

CmdLin$ = ""                                     'Start with no valid switch
Swtch$ = UCASE$(Swtch$)
IF Swtch$ = "" THEN
	CmdLin$ = "": EXIT FUNCTION
END IF
IF dum = 0 THEN                                  'If first time, get command line
	dum = -1
	cmd$ = UCASE$(LTRIM$(RTRIM$(COMMAND$)))
	FOR i = 1 TO LEN(cmd$)                       'Remove any single spaces found
		IF MID$(cmd$, i, 1) = " " THEN
			cmd$ = LEFT$(cmd$, i - 1) + MID$(cmd$, i + 1)
		END IF
	NEXT i
	cmd$ = cmd$ + "/"                            'Add trailing divider to simplify parsing
END IF

offset = INSTR(cmd$, "/" + Swtch$)               'Search for input switch
IF offset = 0 THEN EXIT FUNCTION                 'Didn't start program with this switch
IF MID$(cmd$, offset + 2, 1) = "=" THEN          'See if includes parameter
	CmdLin$ = MID$(cmd$, offset + 3, INSTR(offset + 3, cmd$, "/") - offset - 3)
ELSE                                             'Extract parameter only or return switch
	CmdLin$ = Swtch$
END IF

END FUNCTION

SUB CtrlCBrk (Code) STATIC

'Sets extended Ctrl-C checking as in using DOS BREAK=on/off.
'Code =  0 - checking is off (default unless set ON in CONFIG.SYS)
'Code <> 0 - turn checking on
'Will give you added opportunity to break out of a program if needed, but will
' slow down execution.
'Note that BREAK ON can conflict with proper functioning of some programs.
'Requires INTERRUPT support.

IF Code THEN
	inregs.dx = 1                                'Set check flag for nonzero Code
ELSE
	inregs.dx = 0                                'Disable checking
END IF
inregs.ax = &H3301                               'Set Ctrl-C check flag
CALL INTERRUPT(&H21, inregs, outregs)

END SUB

FUNCTION CurDir$ (Driv$) STATIC

'Returns path to current directory in specified drive (Driv$).
'If no drive$ specified, then the current default drive is obtained from
'the function CurDriv$.
'If not successful, will return Null string.  If successful will return upper
' case of correct format for complete path.
'Be sure floppy drive is ready to read to avoid fatal error.
'Trap for single floppy drive system.
'Requires INTERRUPT, CurDriv$ support.

IF LEN(Driv$) THEN
	IF LEN(Driv$) = 1 THEN Driv$ = Driv$ + ":"
	Driv$ = UCASE$(Driv$)                        'If passed a drive, be sure upper case
ELSE                                             'Service uses 1 for A, etc.
	Driv$ = CurDriv$                             'Get current default drive, if none passed
END IF                                           'If no Driv$ passed, then 0 uses default drive

tmp$ = SPACE$(65)                                'Space for directory path
inregs.ax = &H4700
inregs.dx = ASC(Driv$) - 64
inregs.si = SADD(tmp$)
CALL INTERRUPT(&H21, inregs, outregs)
IF outregs.flags AND 1 THEN                      'Invalid drive or directory
	CurDir$ = ""
ELSE
	tmp$ = LEFT$(tmp$, INSTR(tmp$, CHR$(0)) - 1)
	CurDir$ = Driv$ + "\" + tmp$                 'Set up complete path
END IF

END FUNCTION

FUNCTION CurDriv$ STATIC

'Returns Current default Drive letter plus colon.
'DOS returns 0 for A, 1 for B, ... .
'Requires INTERRUPT support.

inregs.ax = &H1900
CALL INTERRUPT(&H21, inregs, outregs)
CurDriv$ = CHR$((outregs.ax AND &HFF) + 65) + ":"

END FUNCTION

FUNCTION CurPath$ STATIC

'Returns current default drive plus default directory.
'Will include \ after drive, but not after last subdirectory.
'If error, will return current dot directory entry for use in I/O.
'Be sure floppy drive is ready for read to avoid fatal error.
'Requires INTERRUPT support.

inregs.ax = &H1900                               'Find default drive
CALL INTERRUPT(&H21, inregs, outregs)            '0 for A, 1 for B, ...
t1$ = CHR$((outregs.ax AND &HFF) + 65) + ":\"

t2$ = SPACE$(65)                                 'Space for directory path
inregs.ax = &H4700
inregs.dx = outregs.ax + 1                       'Use default drive with
inregs.si = SADD(t2$)                            ' 1 for A, 2 for B, ...
CALL INTERRUPT(&H21, inregs, outregs)
IF outregs.flags AND 1 THEN                      'If error, return as current
	CurPath$ = "."                               ' directory
ELSE
	t2$ = LEFT$(t2$, INSTR(t2$, CHR$(0)) - 1)    'Combine for complete path
	CurPath$ = t1$ + t2$
END IF
t1$ = "": t2$ = ""

END FUNCTION

FUNCTION DFExist% (Code, Spec$) STATIC

'Determines if a subdirectory or file specified by Spec$ exists (-1) or not (0).
'Will not verify root of blank disk with drive only input, so A:, B: checks added.
'Requires drive letter + : as a minimum.  For a  subdirectory, leave off last "\".
'If testing files in drive with subdirectories, requires "\" after drive colon.
'Be sure floppy drive is ready for command.  Trap for single floppy system
'  diskette change.
'Requires INTERRUPT, SData (SystmData) support.
'  code =0 - Normal files  (excludes hidden, system)
'       =1 - Normal Directory
'       =2 - All files

Driv$ = UCASE$(LEFT$(Spec$, 1))                  'See if valid drive provided
IF Driv$ < "A" OR Driv$ > "Z" THEN
	DFExist% = 0
	EXIT FUNCTION
ELSE
	DFExist% = -1                                'Assume it exists for now
END IF
tmp$ = Spec$: flopcode = 0                       'Set code for floppy checks
IF Code = 1 THEN
	Attr = 16                                    'Subdirectory bit in attr byte
	t = LEN(Spec$)
	IF t < 4 THEN                                'Check for root of floppy
		IF Driv$ = "A" THEN flopcode = -1
		IF SData.flp = 2 THEN
			IF Driv$ = "B" THEN flopcode = -1
		END IF
		IF t = 2 THEN tmp$ = Spec$ + "\*.*"      'Get into subdirectory
		IF t = 3 THEN tmp$ = Spec$ + "*.*"
	END IF
ELSEIF Code = 2 THEN
	Attr = 39                                    '32+4+2+1
ELSE
	Attr = 0                                     '<==> 32+1
END IF
dta$ = SPACE$(43)                                'Set up DTA address
inregs.dx = SADD(dta$)
inregs.ax = &H1A00
CALL INTERRUPT(&H21, inregs, outregs)
tmp$ = tmp$ + CHR$(0)                            'Pass path string
inregs.ax = &H4E00
inregs.cx = Attr                                 'Attr check to make
inregs.dx = SADD(tmp$)
CALL INTERRUPT(&H21, inregs, outregs)
IF outregs.flags AND 1 THEN
	IF flopcode THEN
		DFExist% = -1                            'Assume blank floppy root directory
	ELSE
		DFExist% = 0                             'Failure
	END IF
END IF
tmp$ = ""

END FUNCTION

FUNCTION DiskRW (Code, Path$) STATIC

'Determines if floppy drive specified in Path$ is ready for read or write.
'If code = 1 - see if drive ready to read
'        = 2 - make sure can read (disk in drive, door shut) and write to
'              drive (not write protected disk)
'Returns -1 if OK; 0 if drive/disk not ready; 1 if error in input Path$.
'Checks physical drive without any resetting of logical drive.
'Tries to read and write a sector to verify operations.
'Requires INTERRUPT, SData(SystmData).

Driv$ = LEFT$(UCASE$(Path$), 1)                  'Check for valid path/drive
IF Driv$ < "A" OR Driv$ > "Z" THEN
	DiskRW = 1: EXIT FUNCTION
END IF
IF Driv$ > "B" THEN
	DiskRW = -1: EXIT FUNCTION
END IF
DiskRW = -1                                      'Assume OK at this point
inregs.dx = 0                                    'Work with physical drive
IF Driv$ = "B" AND SData.flp = 2 THEN inregs.dx = 1  'A=0, B=1

inregs.ax = 0                                    'Reset drive
CALL INTERRUPT(&H13, inregs, outregs)

tmp$ = SPACE$(514)                               'Reserve space for sector
inregs.ax = &H201                                'Read disk sector
inregs.cx = 1
inregs.bx = SADD(tmp$)
CALL INTERRUPT(&H13, inregs, outregs)            'Two tries to be sure disk on
CALL INTERRUPT(&H13, inregs, outregs)
IF outregs.ax \ 256 <> 0 THEN                    'Check status byte for error
	DiskRW = 0
	EXIT FUNCTION
END IF
IF Code = 1 THEN                                 'If only checking for read then return
	tmp$ = "": EXIT FUNCTION
END IF

inregs.ax = &H301                                'Write back disk sector
CALL INTERRUPT(&H13, inregs, outregs)
IF outregs.ax \ 256 <> 0 THEN                    'Check status byte for error
	DiskRW = 0
END IF
tmp$ = ""

END FUNCTION

FUNCTION DskSpace& (Path$) STATIC

'Returns bytes of space available in specified path (Path$) drive.
'Returns -1 if invalid drive or error.  Null input for Path$
'  gives result for current drive.  Be sure floppy drive is ready to read
'  to avoid critical error.  Trap for single floppy system diskette change.
'Requires INTERRUPT support.

Driv$ = UCASE$(LEFT$(Path$, 1))                  'Extract drive letter
IF LEN(Driv$) = 0 THEN
	inregs.dx = 0                                'Current drive
ELSE
	inregs.dx = ASC(Driv$) - 64
END IF
inregs.ax = &H3600
CALL INTERRUPT(&H21, inregs, outregs)
IF outregs.ax < 0 THEN
	DskSpace& = -1                               'Invalid drive or error
ELSE
	IF outregs.bx < 0 THEN                       'Check for large available
		NClust& = outregs.bx + 65536             '  clusters and free space
	ELSE
		NClust& = outregs.bx
	END IF
	DskSpace& = NClust& * outregs.ax * outregs.cx
END IF    'typ =   n          4             512

END FUNCTION

SUB EditPath (Inspec$, Outspec$) STATIC

'Trys to correct common errors on user input path spec to generate a
' valid path for checking and generating valid directories and files.
'Will correct errors like "/" vs "\" which will pass some program checks.
'Assumes a non-Null Inspec$ string is passed.
'Leaves Inspec$ unchanged and returns Outspec$ as the guess valid path.
'Requires CurDriv$, INTERRUPT support.

Outspec$ = ""                                    'Default no valid guess
Spec$ = UCASE$(LTRIM$(RTRIM$(Inspec$)))          'Prelim adjustments
slen = LEN(Spec$)
IF slen = 0 THEN EXIT SUB                        'Return if no input string

FOR i = 1 TO slen                                'Get proper slash direction
	IF MID$(Spec$, i, 1) = "/" THEN MID$(Spec$, i, 1) = "\"
NEXT i

FOR i = 1 TO slen                                'Remove any single spaces
	IF MID$(Spec$, i, 1) = " " THEN
		Spec$ = LEFT$(Spec$, i - 1) + MID$(Spec$, i + 1)
		slen = slen - 1
	END IF
NEXT i

t$ = LEFT$(Spec$, 1)
IF t$ = "\" THEN                                 'If start with \, assume meant root
	Spec$ = CurDriv$ + Spec$                     'of default drive
	slen = slen + 2
END IF

t$ = LEFT$(Spec$, 1)
IF t$ < "A" OR t$ > "Z" THEN EXIT SUB            'If not \, then force alpha start
IF slen = 1 THEN                                 'May have given just drive letter
	Spec$ = Spec$ + ":\"
	slen = slen + 2
END IF

IF MID$(Spec$, 2, 1) <> ":" THEN                  'May have forgotten :
	Spec$ = LEFT$(Spec$, 1) + ":" + MID$(Spec$, 2)
	slen = slen + 1
END IF

IF MID$(Spec$, 3, 1) <> "\" THEN                 'Added check for \ in 3rd position
	Spec$ = LEFT$(Spec$, 2) + "\" + MID$(Spec$, 3)
	slen = slen + 1
END IF

FOR i = 1 TO slen - 1                            'Remove double slashes
	IF MID$(Spec$, i, 2) = "\\" THEN
		Spec$ = MID$(Spec$, 1, i) + MID$(Spec$, i + 2)
		slen = slen - 1
	END IF
NEXT i

IF slen > 3 THEN
	IF MID$(Spec$, slen, 1) = "\" THEN           'If ended subdirectory (not root) with \, remove it
		Spec$ = LEFT$(Spec$, slen - 1)
	END IF
END IF

ctr = 4                                          'Now search for and truncate any
DO                                               'names longer than 8 characters
p = INSTR(ctr, Spec$, "\")
IF p = 0 THEN EXIT DO
IF p > ctr + 8 THEN
	Spec$ = LEFT$(Spec$, ctr + 7) + MID$(Spec$, p)
END IF
ctr = ctr + 9
LOOP
l = LEN(Spec$) - ctr                             'Check the last name for length
IF l > 7 THEN Spec$ = LEFT$(Spec$, ctr + 7)
Outspec$ = Spec$                                 'Set equal to the return string

END SUB

FUNCTION FilPtrMov (FilNum, Mov&, Methd) STATIC

'Moves file pointer in OPEN'd file for subsequent read/write.
'FilNum - BASIC filenumber for open file.  This determines the DOS handle.
'Mov& - movement of the pointer from the starting position in the file.
'Methd - movement method which is starting point for pointer movement:
'         0 = start of file   1 = current location in file  2 = end of file
'If Mov& goes past EOF, then the file is extended and can incorporate garbage.
'Be sure file OPEN is successful.  Can use Int 21h functions instead of QB OPEN
'For Methd=1 Mov& can be + or -.  No checking for valid inputs within FilPtrMov.
'With Mov&=0 and Methd=2, then as a special case, Mov& returns the length of the
' file in bytes.
'Returns -1 if successful, 0 if error.
'Requires INTERRUPT support.

FilPtrMov = -1                                   'Assume OK
inregs.ax = &H4200 + Methd                       'AL contains movement method
inregs.bx = FILEATTR(FilNum, 2)                  'Convert input filenumber to handle
inregs.cx = Mov& \ 65536                         'Extract hi order pointer offset
tmp& = Mov& AND 65535                            'Extract lo order pointer offset
IF tmp& > 32767 THEN                             'Correct to QB signed integer
	inregs.dx = tmp& - 65536
ELSE
	inregs.dx = tmp&
END IF
CALL INTERRUPT(&H21, inregs, outregs)
IF outregs.flags AND 1 THEN                      'If carry flag set, return error
	FilPtrMov = 0
	EXIT FUNCTION
END IF
IF Methd = 2 AND Mov& = 0 THEN                   'Special case: start at end of file
	Mov& = outregs.ax                            ' with no pointer movement
	IF Mov& < 0 THEN Mov& = Mov& + 65536         'outregs.ax +.dx contain pointer position
	Mov& = Mov& + 65536 * outregs.dx             ' which is length of file
END IF

END FUNCTION

FUNCTION FilRead (FilNum, Posn&, Segmt, Offst, NumByts&) STATIC

'Reads blocks of bytes from a file or a whole file into program memory.
'FilNum - BASIC filenumber of OPEN'd file.  This determines the equivalent DOS handle.
'Posn& - starting byte number for bytes read into memory. the first byte is 1.
'Segmt - segment of pointer to buffer (variable) or memory location for read.
'Offst - offset of pointer to buffer or memory.
'NumByts& - number of bytes to read starting at Posn&.
'Can return error, if read past EOF.  No checking of valid inputs within FilRead.
'Be sure file OPEN is successful.  Can use Int 21h functions instead of QB OPEN.
'Returns -1 if successful, 0 if error, 1 if read 0 bytes.
'Requires INTERRUPTX support and network read access rights.
'Note that the initial movement of pointer to Posn& for beginning of read can be
' done by modifying this routine and calling on FilPtrMov.

FilRead = -1                                     'Assume OK to start
inregx.ax = &H4200                               'Invoke file pointer movement function
inregx.bx = FILEATTR(FilNum, 2)                  'Convert filnumber to handle
Posn& = Posn& - 1                                'For DOS initial byte is position 0
inregx.cx = Posn& \ 65536                        'Set up hi order pointer offset
tmp& = Posn& AND 65535
IF tmp& > 32767 THEN                             'Lo order pointer offset
	inregx.dx = tmp& - 65536
ELSE
	inregx.dx = tmp&
END IF
CALL INTERRUPTX(&H21, inregx, outregx)
IF outregx.flags AND 1 THEN                      'If carry flag set, return error
	FilRead = 0
	EXIT FUNCTION
END IF

inregx.ax = &H3F00                               'Read file with current handle
IF NumByts& > 32767 THEN                         'Set up bytes to read
	inregx.cx = NumByts& - 65536
ELSE
	inregx.cx = NumByts&
END IF
inregx.dx = Offst                                'Pointer offset for placing bytes
inregx.ds = Segmt                                'Pointer segment
CALL INTERRUPTX(&H21, inregx, outregx)
IF outregx.flags AND 1 THEN                      'If carry flag set, return error
	FilRead = 0
	EXIT FUNCTION
END IF
IF outregx.ax = 0 THEN FilRead = 1               'Flag error if read 0 bytes
							  
END FUNCTION

FUNCTION FilWrit (FilNum, Posn&, Segmt, Offst, NumByts&) STATIC

'Writes a block of memory into an open file.
'FilNum - BASIC filenumber of OPEN'd file.  Used to determine the DOS file handle.
'Posn& - starting position in file for writing bytes (Be sure > 0).
'Segmt - segment of pointer to data being written.
'Offst - offset of pointer to data.
'NumByts& - number of bytes to write to the file. Maximum 65536 (2 byte integer).
'If NumByts&=0 then file is truncated at the pointer position, which can be useful
' for erasing old file contents.
'Be sure file OPEN is successful.  Can use Int 21h functions instead of QB OPEN.
'The file can be extended beyond the starting EOF.
'Returns -1 if OK, 0 if error, 1 if wrote < specified bytes (e.g. full disk).
'Requires INTERRUPTX support and network write access rights.
'Note that this routine can be modified and the initial pointer movement to Posn&
' done by invoking FilPtrMov.

FilWrit = -1                                     'Assume OK at start
inregx.ax = &H4200                               'Invoke file pointer movement function
inregx.bx = FILEATTR(FilNum, 2)                  'Convert filnumber to handle
Posn& = Posn& - 1                                'Byte position starts with 0 in DOS
inregx.cx = Posn& \ 65536                        'Set up hi order pointer offset
tmp& = Posn& AND 65535
IF tmp& > 32767 THEN                             'Lo order pointer offset
	inregx.dx = tmp& - 65536
ELSE
	inregx.dx = tmp&
END IF
CALL INTERRUPTX(&H21, inregx, outregx)
IF outregx.flags AND 1 THEN                      'If carry flag set, return error
	FilWrit = 0
	EXIT FUNCTION
END IF

inregx.ax = &H4000                               'Write file function using current handle
IF NumByts& > 32767 THEN                         'Write upto 65536 bytes. Convert to signed integer
	inregx.cx = NumByts& - 65536
ELSE
	inregx.cx = NumByts&
END IF
inregx.dx = Offst                                'Offset of pointer to source data
inregx.ds = Segmt                                'Segment of pointer
CALL INTERRUPTX(&H21, inregx, outregx)
IF outregx.flags AND 1 THEN                      'If carry flag set, return error
	FilWrit = 0
	EXIT FUNCTION
END IF
IF outregx.ax <> inregx.cx THEN FilWrit = 1      'If wrote less than specified bytes, disk
												 ' could be full or other error
END FUNCTION

FUNCTION FloppyRd (Path$) STATIC

'Tests for A or B drive as floppy drive ready to receive a command.
'Result =  1  -  non A or B drive input with Path$.
'       = -1  -  was able to access diskette.  assume floppy drive is ready.
'       =  0  -  could not access diskette.  assume drive not ready.
'May have to reinsert diskette and close door to get -1 result.
'Requires INTERRUPT, SData (SystmData) support.  Will always test physical
'  drive 0 if only one floppy drive.


Driv$ = UCASE$(LEFT$(Path$, 1))                  'Extract drive letter
IF Driv$ < "A" OR Driv$ > "B" THEN
	FloppyRd = 1: EXIT FUNCTION                  'A or B drive not selected
END IF
IF SData.flp = 1 THEN
		inregs.dx = 0                            'For single floppy, test physical A drive
ELSE
		inregs.dx = ASC(Driv$) - 65              'Test either A or B drive for dual system
END IF

inregs.ax = &H401                                'Use verify sector function
inregs.cx = 1                                    '0 track, 1 sector
CALL INTERRUPT(&H13, inregs, outregs)
IF outregs.ax \ 256 = 0 OR outregs.ax \ 256 = 6 THEN    'Error code in AH
	FloppyRd = -1                                'No error or active change line OK
ELSE
	FloppyRd = 0
END IF

END FUNCTION

FUNCTION FloppySet (Path$) STATIC

'For use with other routines that may generate the "insert diskette"
'  message for single floppy systems.
'Requires INTERRUPT, SData (SystmData) support.
'Path$ includes initial drive letter, which will be checked for "A" or "B".
'Returns -1 if reset logical drive; -2 if modified Path$ to A drive for
'  a single floppy machine;  0 if error, although error codes are not
'  generally meaningful nor do they indicate logical drive not reset.
'  This return code is retained for potential debug on problem machines.
'Can use returned Path$ for subsequent disk I/O.

FloppySet = -1
Driv$ = UCASE$(LEFT$(Path$, 1))                  'Extract drive letter
IF Driv$ < "A" OR Driv$ > "B" THEN EXIT FUNCTION
IF SData.flp = 2 THEN EXIT FUNCTION              'Continue only if one drive
rem$ = UCASE$(RIGHT$(Path$, LEN(Path$) - 1))
IF SData.ver < 320 THEN                          'Change path if early DOS
	Path$ = "A" + rem$
	rem$ = ""
	FloppySet = -2: EXIT FUNCTION
END IF
inregs.ax = &H440F
inregs.bx = ASC(Driv$) - 64
CALL INTERRUPT(&H21, inregs, outregs)            'Remap logical drive
IF outregs.flags AND 1 THEN FloppySet = 0        'Can be deleted
rem$ = ""

END FUNCTION

FUNCTION FlushBuf (FilNum) STATIC

'Flushes random file buffers to file so data can not be lost in subsequent operation.
'FilNum is BASIC filenumber of open file for write.
'Be sure file is open and ready for output or will get critical error in FILEATTR.
'Returns -1 if OK, 0 if possible error or early DOS.
'If it does not flush buffer, then can CLOSE or just continue in program and let normal
' filling of buffer trigger write to disk.  The presence of FlushBuf will not cause problems.
'Note that return of error (=0) does not always mean a failure.
'If this routine is just added insurance between CLOSE operations, may want to just
' eliminate code below INTERRUPT call.
'Requires SData(SystmData), INTERRUPT support.

IF SData.ver < 330 THEN                          'DOS 3.3+ required
	FlushBuf = 0
	EXIT FUNCTION
END IF
inregs.ax = &H6800                               'Commit file service
inregs.bx = FILEATTR(FilNum, 2)                  'Convert to DOS handle
CALL INTERRUPT(&H21, inregs, outregs)
IF outregs.flags AND 1 THEN                      'Note if error
	FlushBuf = 0
	EXIT FUNCTION
ELSE
	FlushBuf = -1                                'OK
END IF

END FUNCTION

SUB GetFiles (Spec$, Code, FData() AS FileData, Nctr) STATIC

'Finds files and/or directories as in DOS DIR command and returns results in an array.
'As is or modified, gives you greater control over directory management than the FILES statement.
'Edit/correct Spec$ before entering routine.  Be sure floppy drive is ready for command.
'Trap for single floppy system diskette change.
'  Spec$ = complete path to files using wildcards, if desired for files.
'          path into parent directory to find subdirectories.
'  Code = attribute indicating what to search for in subdirectory.
'     0 = extracts normal files meeting spec.
'     1 = extracts next level subdirectories plus current/parent dot entries.
'         (dot directories can be removed by IF MID$(dta$, 31, 1) <> "." addition)
'  Nctr = counter giving 0 or number of matching items found.
'  FData = array of file info with shared TYPE FileData.
'Requires INTERRUPT support and dynamic arrays.

Spec$ = UCASE$(Spec$)
IF Spec$ < "A" THEN
	Nctr = 0
	EXIT SUB
END IF
IF LEN(Spec$) = 1 THEN Spec$ = Spec$ + ":"
IF Code = 1 THEN
	Attr = 16                                    'Directories only
	IF INSTR(LEN(Spec$), Spec$, "\") THEN
		Spec$ = MID$(Spec$, 1, LEN(Spec$) - 1)
	END IF
	t$ = Spec$ + "\*.*" + CHR$(0)                'Need something past subdirectory
ELSE
	Attr = 0                                     'Files only
	t$ = Spec$ + CHR$(0)
END IF
dta$ = SPACE$(43)                                'Set DTA address
inregs.dx = SADD(dta$)
inregs.ax = &H1A00
CALL INTERRUPT(&H21, inregs, outregs)
inregs.ax = &H4E00
inregs.cx = Attr
inregs.dx = SADD(t$)
Nctr = 0
DO                                               'Find first match and loop thru all matches
	CALL INTERRUPT(&H21, inregs, outregs)
	IF outregs.flags AND 1 THEN EXIT DO
	nattr = ASC(MID$(dta$, 22, 1))
	IF Code = 1 THEN                             'Normal directories
		IF nattr = 16 THEN Nctr = Nctr + 1
	ELSE                                         'Normal files
		IF nattr = 32 OR nattr = 0 THEN Nctr = Nctr + 1
	END IF
	inregs.ax = &H4F00                           'Set up for find next match and loop
LOOP
IF Nctr = 0 THEN EXIT SUB
REDIM FData(1 TO Nctr) AS FileData               'Dimension array to hold results
inregs.ax = &H4E00                               'Loop thru matches again
i = 1
DO
	CALL INTERRUPT(&H21, inregs, outregs)
	IF outregs.flags AND 1 THEN EXIT DO
	dn$ = MID$(dta$, 31) + CHR$(0)               'Extract name
	nattr = ASC(MID$(dta$, 22, 1))               'Extract attribute number
	IF Code = 1 THEN
		IF nattr = 16 THEN                       'Confirm directory bit
			FData(i).nam = LEFT$(dn$, INSTR(dn$, CHR$(0)) - 1)
			FData(i).att = nattr
			i = i + 1
		END IF
	ELSE                                         'Confirm file bit
		IF nattr = 32 OR nattr = 0 THEN
			npos = INSTR(dn$, ".")               'Separate name and extension
			IF npos > 1 THEN
				FData(i).nam = LEFT$(dn$, npos - 1)
				FData(i).ext = MID$(dn$, npos + 1)
			ELSE
				FData(i).nam = dn$
				FData(i).ext = ""
			END IF
			Tim& = CVI(MID$(dta$, 23, 2))        'File time
			IF Tim& < 0 THEN
				Tim& = Tim& + 65536
			END IF
			FData(i).min = (Tim& \ 32) AND &H3F
			FData(i).hr = (Tim& \ 2048) AND &H1F
			Dat& = CVI(MID$(dta$, 25, 2))        'File date
			FData(i).day = Dat& AND &H1F
			FData(i).mon = (Dat& \ 32) AND &HF
			FData(i).yr = ((Dat& \ 512) AND &H1F) + 80
			dum& = CVL(MID$(dta$, 27, 4))        'Avoid CVL-COMMON Array error
			FData(i).siz = dum&                  'File size
			FData(i).att = nattr                 'Keep attribute for potential use
			i = i + 1
		END IF
	END IF
	inregs.ax = &H4F00                           'Find next match
LOOP

END SUB

SUB KBBufRtn (Code$) STATIC

'Inputs the string defined by Code$ into the KeyBoard buffer at a termination
' point in the current program.  The keystrokes in the buffer then act as if they
' were typed in upon return to the DOS prompt.
'Can be used to run a new program upon exit and serve similar to CHAIN/RUN or
' SHELL commands in QB.
'Works only if keyboard hasn't been modified by a TSR or some remapping progams.
'Ends the program at the conclusion of this routine.

DO                                               'Clear the keyboard buffer
	a$ = INKEY$
LOOP WHILE a$ <> ""

Code$ = LTRIM$(RTRIM$(Code$))                    'Be sure a valid string is input
IF Code$ < " " THEN EXIT SUB
Code$ = LEFT$(Code$, 14) + CHR$(13)              'Add the carriage return used at the prompt
t = LEN(Code$)

DEF SEG = 0                                      'Normal 16-byte buffer starts at 41Eh
POKE &H41A, &H1E                                 'Set head/tail pointers
POKE &H41C, &H1E + t * 2
FOR i = 1 TO t
	POKE &H41C + i * 2, ASC(MID$(Code$, i))      'Put string into buffer by ASCII codes
NEXT i                                           ' Use first byte of word since not extended key codes

END                                              'End current program

END SUB

FUNCTION ModInit STATIC

'Initial check for a connected, on-line modem.
'Checks serial comm ports and if Modem (4 or 5) bits are set with
' no line errors, then returns 1 or 2 for COM1 or 2 connection.
'Invalid port range or no modem returns 0.
'Must remap COM3 or 4 to use in QB.
'Will not avoid external device (modem) errors or communication errors.
'Requires INTERRUPT, SData (SystmData) support


IF SData.ser < 1 THEN                            'Make sure serial port exists
	ModInit = 0: EXIT FUNCTION
END IF
FOR i = 1 TO 2
	inregs.dx = i - 1                            'COM1 or COM2 in QB
	inregs.ax = &H300                            'Check Status
	CALL INTERRUPT(&H14, inregs, outregs)
	IF outregs.ax >= 0 THEN                      'Extract line status byte
		ah = outregs.ax \ 256
	ELSE
		ah = (65536 + outregs.ax) \ 256
	END IF

	IF outregs.ax AND 48 THEN                    'Modem Bits 4, 5
		ModInit = i
		IF ah AND 158 THEN
			ModInit = 0                          'Check for line errors
		ELSE
			EXIT FUNCTION                        'OK
		END IF
	ELSE
		ModInit = 0
	END IF
	IF SData.ser = 1 THEN EXIT FUNCTION          'No 2nd loop, if only 1 port
NEXT i

END FUNCTION

FUNCTION Monitor% STATIC

'Tests for type of video adapter (card) in machine.
'Useful for setting screen modes in program.  Will not detect B/W monitor
' on color adapter such as CGA or EGA.  Allow user to input this on command line.
'Requires INTERRUPT support.
'Returns:  0 = monochrome or Hercules
'          1 = CGA
'          2 = EGA
'          3 = VGA
'SUB SystmData also provides this functionality

DEF SEG = 0
IF PEEK(&H463) = &HB4 THEN                       'Check for mono port
	DEF SEG
	Monitor% = 0
	EXIT FUNCTION
END IF
DEF SEG
inregs.ax = &H1A00
CALL INTERRUPT(&H10, inregs, outregs)            '&H10 for video services
IF (outregs.ax AND &HFF) = &H1A THEN             'Test for VGA
	Monitor% = 3
	EXIT FUNCTION
END IF
inregs.ax = &H1200
inregs.bx = &H10
CALL INTERRUPT(&H10, inregs, outregs)
IF (outregs.bx AND &HFF) = &H10 THEN             'See if other color adapter
	Monitor% = 1                                 'CGA
ELSE
	Monitor% = 2                                 'Remaining alternative is EGA
END IF

END FUNCTION

FUNCTION NetwrkLd STATIC

'Determine if program is running on a networked machine.
'Do to variety of network system interfaces, this routine will not likely
' work in some situations and certainly does not identify all possibilities.
'Also tests if SHARE.EXE is installed on your machine which is used for
' file locking in some networks.
'Returns 0 if no network active.  If active, returns:
'  1 = Novell
'  2 = Banyan VINES
'  3 = LANtastic, LAN Manager, NetWare Lite, 10NET, SilverNET, other MS Net compatible
'  4 = DECnet DOS
'  5 = WEB
'  6 = EASY-NET, TurboNET
'  7 = PC LAN, PC Network
'  8 = TopWare
'  9 = Other possible MS network
'You can delete checks not needed or questionable.
'If SHARE is resident, the negative of 1-9 above is returned.
'For added information on network connections and devices note that
' INT 21h, AX=5F02h can be used to identify some network devices in a defined buffer.
'Requires INTERRUPT, SData(SystmData) support

NetwrkLd = 0
IF SData.ver < 330 THEN EXIT FUNCTION            'Won't work with some DOS 3.1

inregs.ax = &H1000                               'Test for SHARE installed
CALL INTERRUPT(&H2F, inregs, outregs)
IF (outregs.ax AND &HFF) = &HFF THEN
	t = -1
ELSE
	t = 1
END IF

inregs.ax = &H7A00
outregs.ax = 0
CALL INTERRUPT(&H2F, inregs, outregs)            'Novell IPX/SPX install check
IF (outregs.ax AND &HFF) = &HFF THEN
	NetwrkLd = t * 1
	EXIT FUNCTION
END IF

inregs.ax = &HD701                               'Banyan VINES interrupt number
outregs.ax = 0
CALL INTERRUPT(&H2F, inregs, outregs)
IF (outregs.ax AND &HFF) = 0 THEN
	NetwrkLd = t * 2
	EXIT FUNCTION
END IF

inregs.ax = &HB800
outregs.ax = 0
CALL INTERRUPT(&H2F, inregs, outregs)            'MS-Net install check
IF (outregs.ax AND &HFF) <> 0 THEN
	NetwrkLd = t * 3
	EXIT FUNCTION
END IF

inregs.ax = &H100
CALL INTERRUPT(&H69, inregs, outregs)            'DECnet DOS install check
IF (outregs.ax AND &HFF) <> 0 THEN
	NetwrkLd = t * 4
	EXIT FUNCTION
END IF

inregs.ax = &HEE00
CALL INTERRUPT(&H2F, inregs, outregs)            'WEB install check
IF (outregs.ax AND &HFF) <> 0 THEN
	NetwrkLd = t * 5
	EXIT FUNCTION
END IF

inregs.ax = &H8000
CALL INTERRUPT(&H2F, inregs, outregs)            'EASY-NET, TurboNET Server install
IF (outregs.ax AND &HFF) <> 0 THEN
	NetwrkLd = t * 6
	EXIT FUNCTION
END IF

inregs.ax = &H200
CALL INTERRUPT(&H2F, inregs, outregs)            'PC LAN, PC Network redirector install
IF (outregs.ax AND &HFF) <> 0 THEN
	NetwrkLd = t * 7
	EXIT FUNCTION
END IF

inregs.ax = &HFF00
CALL INTERRUPT(&H2F, inregs, outregs)            'TopWare install check
IF (outregs.ax AND &HFF) <> 0 THEN
	NetwrkLd = t * 8
	EXIT FUNCTION
END IF

inregs.ax = &H1100
CALL INTERRUPT(&H2F, inregs, outregs)            'Potential other MS network redirector install check
IF (outregs.ax AND &HFF) <> 0 THEN
	NetwrkLd = t * 9
	EXIT FUNCTION
END IF

END FUNCTION

FUNCTION PrntChk STATIC

'For testing installation of DOS command PRINT to manage printing of files.
'If your application uses PRINT as a print queue, can test with this function
' to see if PRINT.EXE needs to be run.  If not installed, can shell PRINT with
' desired LPT port, buffer size, queue size.
'Note memory fragmentation limitations on running PRINT and other TSR's from
' the QuickBasic environment.
'Returns 0 if not installed, -1 if installed
'Requires INTERRUPT support

PrntChk = 0                                      'Assume not installed
inregs.ax = &H100                                'Check for resident portion
CALL INTERRUPT(&H2F, inregs, outregs)
IF (outregs.ax AND &HFF) = &HFF THEN PrntChk = -1   'Already installed

END FUNCTION

FUNCTION PrntInit (PtrPt) STATIC

'Initial check for connected, on-line printer.
'Writes characters at port PtrPt and checks AH status bits for
' errors.  Checks valid port range.
'Will perform simple test for reroute of LPT1 that some networks may use.
'Returns -1=OK, 0=not ready, 1=valid port range error
'Requires INTERRUPT, SData (SystmData) support.

IF PtrPt > SData.ptr OR PtrPt > 3 OR PtrPt < 1 THEN    'Check for port within range
	PrntInit = 2: EXIT FUNCTION
END IF
IF SData.ver > 300 AND PtrPt = 1 THEN            'Check for reroute of LPT1 for network
	inregs.ax = &H440A                           'Should not be needed
	inregs.bx = 4                                'STDPRN handle
	CALL INTERRUPT(&H21, inregs, outregs)
	IF outregs.dx AND &H8000 THEN                'Hi bit set is remote device
		PrntInit = -2: EXIT FUNCTION
	END IF
END IF

DEF SEG = 0                                      'Go to BIOS printer timeout table
POKE &H477 + PtrPt, 1                            'To avoid delays, use a small time
DEF SEG                                          'Will leave new timeout in place

inregs.ax = 32                                   'Print space (attempted)
inregs.dx = PtrPt - 1
CALL INTERRUPT(&H17, inregs, outregs)
inregs.ax = 8                                    'Print backspace (attempted)
CALL INTERRUPT(&H17, inregs, outregs)
IF outregs.ax AND &H7F00 THEN                    'Check status byte
	PrntInit = -1                                'Some bits set, so active
ELSE
	PrntInit = 0                                 'If no status bits set, then off
END IF
IF outregs.ax AND &H2900 THEN PrntInit = 0       'Flag error bits in status

END FUNCTION

SUB ReBoot STATIC

'Calling this routine gives a warm boot.
'During the ROM BIOS POST process, initializations and tests begin with the
' processor reset vector (FFFF:0000h).  ReBoot uses the QB procedure for
' transferring control to a machine language procedure to jump to this point.
'To minimize reboot time, the low memory reset flag is set for a warm boot.
'This routine can be used to reboot a remotely controlled machine, or automatically
' reboot after system changes.
'Requires ABSOLUTE support which is in the same library as INTERRUPT.

DEF SEG = 0                                      'Go to low memory
POKE &H472, &H34                                 'Bypass memory test with 1234h flag
POKE &H473, &H12
DEF SEG = &HFFFF                                 'Go to reset vector segment
CALL ABSOLUTE(0)                                 'Transfer control to zero offset

END SUB

FUNCTION RemotDrv (Driv$) STATIC

'For some networks can check drive Driv$ to see if it is a network drive.
'Can adjust access of files on drive based on result.
'(Tested on Novell networks).
'Returns 0 if local drive or error, -1 if remote.
'Requires INTERRUPT support.

RemotDrv = 0                                     'Assume local or error
t$ = UCASE$(LEFT$(Driv$, 1))                     'Extract valid drive letter
IF t$ < "A" OR t$ > "Z" THEN EXIT FUNCTION
inregs.ax = &H4409                               'Remote drive function
inregs.bx = ASC(t$) - 64
CALL INTERRUPT(&H21, inregs, outregs)
IF outregs.flags AND 1 THEN EXIT FUNCTION        'If carry flag set, return error
IF outregs.dx AND &H5000 THEN RemotDrv = -1      'Bit 12 set = remote device

END FUNCTION

SUB ScrnCopy (Src, Dst) STATIC

'Copies to/from screen pages.
'Will handle CGA - VGA using QB PCOPY statement.
'For Monochrome (MDA) will manually poke into host video memory.
'For adequate speed in an XT need block memory move routine,
' but this method is OK for faster computers.
'Src = source page.  Dst = destination page.
'Requires SystmData(SData.vid) support.

IF SData.vid = 0 THEN
	DEF SEG = &HB000
	t1 = 4096 * Src: t2 = 4096 * Dst
	FOR i = 0 TO 3999
		POKE (t2 + i), PEEK(t1 + i)
	NEXT i
	DEF SEG
ELSE
	PCOPY Src, Dst
END IF

END SUB

SUB SetDir (Path$, Result) STATIC

'Changes the specified drive to the specified directory.
'(does not change the default drive).
'Best used to see if an input drive + directory really exists.
'Be sure floppy drive is ready.  Trap for single floppy system diskette change.
'Requires INTERRUPT support.
'  Path$ = path spec for new directory including drive
'  Result = success of change.  -1 if OK, else 0.

plen = LEN(Path$)
IF plen = 0 THEN
	Result = 0: EXIT SUB
END IF
IF plen = 1 THEN Path$ = Path$ + ":\"            'Get root directories in std form
IF plen = 2 THEN Path$ = Path$ + "\"

inregs.ax = &H3B00
p$ = Path$ + CHR$(0)                             'Need DOS string
inregs.dx = SADD(p$)
CALL INTERRUPT(&H21, inregs, outregs)
IF outregs.flags AND 1 THEN                      'Check for success
	Result = 0
ELSE
	Result = -1
END IF

END SUB

SUB SetDriv (Driv$) STATIC

'Changes to default drive specified by (Driv$) drive letter.
'Will work with or without trailing colon.
'Be sure floppy drive is ready.  Trap for single floppy system diskette change.
'Requires INTERRUPT support.

t$ = UCASE$(LEFT$(Driv$, 1))                     'Extract drive letter
IF t$ < "A" THEN EXIT SUB
inregs.ax = &HE00
inregs.dx = ASC(t$) - 65
CALL INTERRUPT(&H21, inregs, outregs)

END SUB

FUNCTION SetFilAt (Spec$, Attr) STATIC

'Sets attributes of the file specified by path and filename in Spec$.
'The input file is checked to see if it exists.
'Bit coded attribute byte is changed by Attr =
'  0 - Normal read/write
'  1 - Read only
'  2 - Hidden
'  3 - Read only hidden
'Returns 1 if file/path error or file does not exist.
'Returns 0 if unsuccesful in setting attribute byte.
'Returns -1 if successful.
'Trap for single floppy read and drive not ready to read.
'If you make the file hidden, it will not be visible from DIR, but can be
' found with DFExist% using Code = 2.  Beware of subsequent write access error
' for read only files.  Can require create access right to alter network files.
'Requires DFExist%, INTERRUPT support.

IF NOT DFExist%(2, Spec$) THEN                   'Be sure file exists
	SetFilAt = 1                                 'If not, exit
	EXIT FUNCTION
END IF

IF Attr > 3 OR Attr < 0 THEN Attr = 0            'Keep in desired range
t$ = SPACE$(LEN(Spec$) + 1)                      'Put file spec in string
LSET t$ = Spec$ + CHR$(0)                        'Needs DOS string
inregs.dx = SADD(t$)
inregs.ax = &H4301                               'Set file attribute function
inregs.bx = 0
inregs.cx = Attr                                 'Set attribute byte
CALL INTERRUPT(&H21, inregs, outregs)
t$ = ""
IF outregs.flags AND 1 THEN                      'If error, exit
	SetFilAt = 0
	EXIT FUNCTION
END IF
SetFilAt = -1                                    'OK

END FUNCTION

FUNCTION SetFilTD% (Spec$, Tim$, Dat$) STATIC

'Sets file date and time to input values.  These results display with the
' directory listing of the file.
'Spec$ is complete path to file.  It is checked to see if it exists.
'Trap single floppy drives and drives not ready to read.
'Tim$ is the input time as a 4 byte string in the form HHMM.
'  Seconds are not used.
'Dat$ is the input date as a 6 byte string in the form MMDDYR.  It is good from
' Jan 01 1980 to Dec 31 2040.
'Returns 1 if file not found, error in file spec, or problem opening file.
'Returns 0 if an error in executing the time/date change, although they may still be OK.
'Returns -1 if completed successfully.
'Requires DFExist% and INTERRUPT support.

IF NOT DFExist%(2, Spec$) THEN                   'Be sure file exists
	SetFilTD = 1                                 'If not, exit
	EXIT FUNCTION
END IF

t$ = SPACE$(LEN(Spec$) + 1)                      'Put file spec in string
LSET t$ = Spec$ + CHR$(0)                        'Needs DOS string
inregs.dx = SADD(t$)
inregs.ax = &H3D02                               'Open file to get handle
CALL INTERRUPT(&H21, inregs, outregs)            'outregs.ax is handle
t$ = ""
IF outregs.flags AND 1 THEN                      'If error, exit
	SetFilTD = 1
	EXIT FUNCTION
END IF

td& = 0                                          'Initialize long integer to hold unsigned register integer
Tim$ = RIGHT$("0000" + Tim$, 4)                  'Filter time input for proper range
F = VAL(MID$(Tim$, 3, 2))                        'Set hour and minutes (forget seconds)
IF F > 59 OR F < 0 THEN F = 0                    'Use f for time/date elements.  Start with minutes
td& = td& OR (F * 32)
F = VAL(MID$(Tim$, 1, 2))                        'Process hours
IF F > 23 OR F < 0 THEN F = 0
dum& = 1                                         'Hours shifted can exceed integer range
td& = td& OR (dum& * F * 2048)
IF td& > 32767 THEN td& = td& - 65536            'With bit 15 set, convert to signed integer
inregs.cx = td&                                  'Put into cx register

td& = 0
Dat$ = RIGHT$("000000" + Dat$, 6)                'Filter date input
F = VAL(MID$(Dat$, 1, 2))                        'Start with month
IF F > 12 OR F < 1 THEN F = 1
td& = td& OR (F * 32)
F = VAL(MID$(Dat$, 3, 2))                        'Day is second field (You can specify 31st day
IF F > 31 OR F < 1 THEN F = 1                    '  in 30 day month)
td& = td& OR F
F = VAL(MID$(Dat$, 5, 2))
IF F < 80 THEN F = F + 100                       'Good for 60 years after 1980
IF F > 140 OR F < 80 THEN F = 80
td& = td& OR ((F - 80) * 512)                    'Yr is vs 1980
inregs.dx = td&                                  'Put into dx register

inregs.ax = &H5701                               'Set file date and time function
inregs.bx = outregs.ax                           'Use file handle from open function
CALL INTERRUPT(&H21, inregs, outregs)
IF outregs.flags AND 1 THEN
	SetFilTD = 0                                 'Error on resetting time/date
ELSE
	SetFilTD = -1                                'OK
END IF

inregs.ax = &H3E00                               'Close file with inregs.bx handle
inregs.cx = 0: inregs.dx = 0
CALL INTERRUPT(&H21, inregs, outregs)

END FUNCTION

FUNCTION SetPath% (Path$) STATIC

'Change default drive and directory to Path$.
'(Can be alternative to subprograms SetDir and SetDriv).
'Use for I/O direction and to see if path really exists.
'Be sure floppy drive ready to read.
'Trap for single floppy system diskette change.
'Requires trailing \ for check of drive root directory, but
' not for subdirectories.  Do not include file specs.
'Returns  =  1 for null Path$ or path error
'         =  0 if Path$ does not exist
'         = -1 if Path$ exists
'Requires INTERRUPT support.

Path$ = UCASE$(Path$)                            'Will return upper case
IF LEFT$(Path$, 1) < "A" OR LEFT$(Path$, 1) > "Z" THEN
	SetPath = 1: EXIT FUNCTION
END IF
IF LEN(Path$) = 1 THEN Path$ = Path$ + ":\"
IF LEN(Path$) = 2 THEN Path$ = Path$ + "\"
inregs.ax = &HE00                                'Set default drive
inregs.dx = ASC(LEFT$(Path$, 1)) - 65
CALL INTERRUPT(&H21, inregs, outregs)
inregs.ax = &H3B00                               'Set default directory
t$ = Path$ + CHR$(0)                             'Need DOS string
inregs.dx = SADD(t$)
CALL INTERRUPT(&H21, inregs, outregs)
IF outregs.flags AND 1 THEN                      'Check for error
	SetPath = 0
ELSE
	SetPath = -1                                 'OK, it exists
END IF

END FUNCTION

SUB SystmData STATIC

'Extracts system parameters and loads into SData (SystmData) TYPE variable
'Requires INTERRUPT support.  Use for DOS > 2.
'Delete SystmData variables not needed by your program.
'Use this routine at program startup for setting control and I/O parameters.
'Can use SData variables for temporary storage as well.

DEF SEG = 0                                      'Most system info resides in low memory
'Tests video adapter for use in programs
'  0 = monochrome or Hercules, 1 = CGA, 2 = EGA, 3 = VGA
IF PEEK(&H463) = &HB4 THEN                       'Check for mono port
	SData.vid = 0
	GOTO SD1:
END IF
inregs.ax = &H1A00
CALL INTERRUPT(&H10, inregs, outregs)
IF (outregs.ax AND &HFF) = &H1A THEN             'Test for VGA
	SData.vid = 3: GOTO SD1:
END IF
inregs.ax = &H1200
inregs.bx = &H10
CALL INTERRUPT(&H10, inregs, outregs)
IF (outregs.bx AND &HFF) = &H10 THEN             'See if other color adapter
	SData.vid = 1                                'It's a CGA
ELSE
	SData.vid = 2                                'Only alternative is EGA
END IF
SD1:

inregs.ax = &H3000                               'Get DOS Version
CALL INTERRUPT(&H21, inregs, outregs)
SData.ver = 100 * (outregs.ax AND 255) + outregs.ax \ 256

inregs.ax = &H1900                               'Find current default drive for use in directory
CALL INTERRUPT(&H21, inregs, outregs)            ' variable
SData.drv = CHR$((outregs.ax AND &HFF) + 65)     'Store temporarily in TYPE .drv item
t$ = SPACE$(65)                                  'Find current directory for use in I/O
inregs.ax = &H4700
inregs.dx = 0                                    'Use default drive
inregs.si = SADD(t$)
CALL INTERRUPT(&H21, inregs, outregs)
IF outregs.flags AND 1 THEN                      'Check carry flag for error
	LSET SData.dir = SData.drv + ":\"            'If error, return drive only
ELSE
	t$ = LEFT$(t$, INSTR(t$, CHR$(0)) - 1)       'Put default drive+dir in .dir variable
	LSET SData.dir = SData.drv + ":\" + t$       '(Can use for file location and I/O)
END IF

inregs.ax = &H3305                               'Now put startup drive in SystmData variable .drv
CALL INTERRUPT(&H21, inregs, outregs)            '(Can use variable for I/O drive selection)
t$ = CHR$((outregs.dx AND &HFF) + 64)
IF t$ > "@" THEN SData.drv = t$                  'outregs.dx returns 0 for some DOS

CALL INTERRUPT(&H11, inregs, outregs)            'Check equipment list
SData.ptr = (outregs.ax AND &H4000) \ 16384      'Parallel port count
IF outregs.ax < 0 THEN SData.ptr = SData.ptr + 2 'Allow for hi bit being set
SData.ser = (outregs.ax AND &HE00) \ 512         'Serial port count
SData.flp = (outregs.ax AND &HC0) \ 64 + 1       'Number of floppies (assumed A, B)
SData.cop = (outregs.ax AND 2) \ 2               'Coprocessor present (1)
'For info only. If outregs.ax AND 4 THEN PS/1 mouse bit is set.

inregs.ax = 0
CALL INTERRUPT(&H33, inregs, outregs)            'Check mouse driver status
IF outregs.ax = -1 THEN                          'Driver installed
	inregs.ax = &H24
	CALL INTERRUPT(&H33, inregs, outregs)        'Get type/location. Simplify as needed
	IF outregs.cx \ 256 = 2 THEN                 'Serial mouse
		SELECT CASE outregs.cx AND 255
			CASE IS = 4
				SData.mse = 1                    'COM1
			CASE IS = 3
				SData.mse = 2                    'COM2
			CASE ELSE
				SData.mse = 0                    'Can't work with any other
		END SELECT
	ELSEIF outregs.cx \ 256 = 4 THEN             'PS/2 mouse
		SData.mse = 3
	ELSE
		SData.mse = 4                            'Bus, other mouse, or error
	END IF
ELSE
	SData.mse = 0                                'No driver installed
END IF

'DEF SEG = &HF000              'Can Check for XT vintage at BIOS Compatibility Segment
'IF PEEK(&HFFFE) < 253 AND SData.ver > 330 THEN ...
'  For AT and later machines and Microsoft (not some others) DOS 3.3+ ,
'   typically all low level services and interrupts used in SUPPORT1.BAS will be defined

DEF SEG = PEEK(&H19E) + 256 * PEEK(&H19F)        'Find Int67h segment address
t$ = ""
FOR i = 10 TO 17                                 'Search for EMS header string
	t$ = t$ + CHR$(PEEK(i))
NEXT i
IF t$ = "EMMXXXX0" THEN                          'If match LIM EMS spec, then it exists
	inregs.ax = &H4100
	CALL INTERRUPT(&H67, inregs, outregs)        'Get page frame address to serve as marker
	IF outregs.ax = 0 THEN                       'Page frame segment
		SData.ems = outregs.bx                   '(Can be used in EMS access)
	ELSE
		SData.ems = 0                            'Error found.  Don't use
	END IF
ELSE
	SData.ems = 0                                'No EMS
END IF

IF SData.ver > 300 THEN                          'Find current path to pgm
	inregs.ax = &H6200                           'Get PSP address
	CALL INTERRUPT(&H21, inregs, outregs)
	DEF SEG = outregs.bx                         'Go to address segment
	DEF SEG = PEEK(44) + 256 * PEEK(45)
	b = 0
	DO                                           'Go past 2 zero bytes
		IF PEEK(b) = 0 THEN
			IF PEEK(b + 1) = 0 THEN
				b = b + 2
				EXIT DO
			END IF
		END IF
		b = b + 1
	LOOP
	t$ = ""                                      'Executing pgm path+name starts here
	IF PEEK(b) = 1 THEN                          'Ends at next byte=1
		b = b + 2                                'Capture each name byte to string
		DO WHILE PEEK(b)
			t$ = t$ + CHR$(PEEK(b))
			b = b + 1
		LOOP
	END IF
	DEF SEG
	FOR i = LEN(t$) TO 1 STEP -1                 'Extract path in front of pgm name
		IF INSTR(i, t$, "\") THEN                '(Can be used for file location)
			t$ = LEFT$(t$, i - 1)
			EXIT FOR
		END IF
	NEXT
	IF LEN(t$) = 2 THEN t$ = t$ + "\"
	LSET SData.pth = UCASE$(t$)
ELSE
	SData.pth = SData.dir                        'If early DOS, use default
END IF

SData.mem = FRE(-1)                              'Compact strings and return free memory
												 '(Can use for program memory testing)
DEF SEG                                          'Go back to default segment
t$ = ""

END SUB

SUB VerifyW (Code) STATIC

'Turns DOS VERIFY on or off for disk writing.
'Code = 0 turns it off (default).
'Code <> 0 turns verify on.
'VERIFY is not supported for network drives.
'Requires INTERRUPT support.

IF Code THEN
	inregs.ax = &H2E01                           'Set verify flag
ELSE
	inregs.ax = &H2E00                           'Set verify off
END IF
CALL INTERRUPT(&H21, inregs, outregs)

END SUB

FUNCTION VolLbl$ (Driv$) STATIC

'Returns drive volume label as string.
'Driv$ is drive or path used for extracting drive letter.
'Be sure drive is ready to read to avoid fatal error.
'Trap for single floppy drive.
'Requires INTERRUPT support.

d$ = LEFT$(UCASE$(Driv$), 1)                     'Extract drive letter
IF d$ < "A" THEN
	VolLbl$ = ""
	EXIT FUNCTION
END IF
d$ = d$ + ":\*.*" + CHR$(0)                      'Set up as DOS path string

dta$ = SPACE$(43)                                'Set DTA address
inregs.dx = SADD(dta$)
inregs.ax = &H1A00
CALL INTERRUPT(&H21, inregs, outregs)
inregs.ax = &H4E00
inregs.cx = 40                                   'Search for attributes 8 + 32
inregs.dx = SADD(d$)

DO                                               'Loop thru root directory file
	CALL INTERRUPT(&H21, inregs, outregs)
	IF outregs.flags AND 1 THEN EXIT DO          'Error exit route
	nattr = ASC(MID$(dta$, 22, 1))               'Extract attribute from DTA
	IF nattr = 40 OR nattr = 8 THEN              'See if match to volume label found
		t$ = MID$(dta$, 31) + CHR$(0)
		VolLbl$ = LEFT$(t$, INSTR(t$, CHR$(0)) - 1)
		EXIT FUNCTION
	END IF
	inregs.ax = &H4F00                           'Find next match
LOOP
VolLbl$ = ""                                     'No volume label found

END FUNCTION

