'****************************************************************************
'Total Control Systems                                         QuickBasic 4.5
'****************************************************************************
'
'  Program     : WEEKDAY.BAS
'  Written by  : Tim Beck
'  Written On  : 10-01-90
'  Function    : WEEK DAY SUBROUTINE - RETURNS THE DAY OF THE WEEK
'
'****************************************************************************
'  This program and those associated with it were written for use with Quick-
'  Windows Advanced (Version 1.5+).  Possesion of this program entitles you
'  to certain priviliges.  They are:
'
'     1. You may compile, use, or modify this program in any way you choose
'        provided you do not sell or give away the source code to this prog-
'        ram or any of it's companions to anyone for any reason.  You may,
'        however, sell the resulting executable program as you see fit.
'
'     2. You may modify, enhance or change these programs as you see fit. I
'        as that you keep a copy of the original code and that you notify
'        me of any improvements you make.  I like to think that the code is
'        bug free and cannot be improved upon, but I'm sure someone will
'        find a way to make it better.  If it's you, I'm looking forward to
'        seeing your changes.  I can be reached at:
'
'              Tim Beck                      Tim Beck (C/O Debbie Beck)
'              19419 Franz Road              8030 Fairchild Avenue
'              Houston, Texas  77084         Canoga Park, California 91306
'              (713) 639-3079                (818) 998-0588
'
'     3. This code has been tested and re-tested in a variety of applications
'        and although I have not found any bugs, doesn't mean none exist. So,
'        this program along with it's companions comes with NO WARRANTY,
'        either expressed or implied.  I'm sorry if there are problems, but
'        I can't be responsible for your work.  I've tried to provide a safe
'        and efficient programming enviroment and I hope you find it helpful
'        for you.  I do, however, need to cover my butt!
'
'  I have enjoyed creating this library of programs and have found them to be
'  a great time saver.  I hope you agree.
'
'                                                            Tim Beck //
'
'****************************************************************************

   DECLARE FUNCTION Get.MDY% (Dte$)
   DECLARE SUB WEEKDAY (Dte$, Day%, Ddy%, Day$, NDay$, Month$)

  '-------------------------------------------------------------------------
  '   Returns some useful information about the date ...
  '
  '   Dte$  = Date in European Format (YYMMDD)
  '   Day%  = Number of Day of Week (1=Sunday, 2=Monday, ...)
  '   Ddy%  = Number of Days since 1-01-1980
  '   Day$  = Literary Day (Monday, Tuesday, etc.)
  '   NDay$ = Number of Day (1st, 2nd, 3rd, 4th, etc.)
  '   Month$= Month of Year (January, February, March, ...)

   REM $INCLUDE: 'STDCOM.INC'
  
   TIMER OFF   'Enables Event Trapping

SUB WEEKDAY (Dte$, Day%, Ddy%, Day$, NDay$, Month$) STATIC

   Yr% = VAL(MID$(Dte$, 1, 2))
   Mo% = VAL(MID$(Dte$, 3, 2))
   Dy% = VAL(MID$(Dte$, 5, 2))
   Dyr% = Yr% - 80
   Lyr% = FIX(Dyr% / 4) + 1
   IF Mo% > 2 AND (Yr% MOD 4 = 0) THEN
      Lyr% = Lyr% - 1
   END IF
   Ddy% = Dyr% * 365
   Ddy% = Ddy% + Lyr%
   Ddy% = Ddy% + Get.MDY%(Dte$) + 1
   Day% = (Ddy% MOD 7) + 1
     
   SELECT CASE Day%
      CASE 1
         Day$ = "Sunday"
      CASE 2
         Day$ = "Monday"
      CASE 3
         Day$ = "Tuesday"
      CASE 4
         Day$ = "Wednesday"
      CASE 5
         Day$ = "Thursday"
      CASE 6
         Day$ = "Friday"
      CASE 7
         Day$ = "Saturday"
      CASE ELSE
   END SELECT

   SELECT CASE Mo%
      CASE 1
         Month$ = "January"
      CASE 2
         Month$ = "February"
      CASE 3
         Month$ = "March"
      CASE 4
         Month$ = "April"
      CASE 5
         Month$ = "May"
      CASE 6
         Month$ = "June"
      CASE 7
         Month$ = "July"
      CASE 8
         Month$ = "August"
      CASE 9
         Month$ = "September"
      CASE 10
         Month$ = "October"
      CASE 11
         Month$ = "November"
      CASE 12
         Month$ = "December"
      CASE ELSE
   END SELECT

   SELECT CASE Dy%
      CASE 1, 21, 31
         NDay$ = MID$(STR$(Dy%), 2) + "st"
      CASE 2, 22
         NDay$ = MID$(STR$(Dy%), 2) + "nd"
      CASE 3, 23
         NDay$ = MID$(STR$(Dy%), 2) + "rd"
      CASE ELSE
         NDay$ = MID$(STR$(Dy%), 2) + "th"
   END SELECT

END SUB

