'****************************************************************************
'Total Control Systems                                         QuickBasic 4.5
'****************************************************************************
'
'  Program     : PCENTER.BAS
'  Written by  : Tim Beck
'  Written On  : 10-01-90
'  Function    : PRINT MESSAGE CENTERED BETWEEN COLUMNS C1 AND C2 ON ROW R
'
'****************************************************************************
'  This program and those associated with it were written for use with Quick-
'  Windows Advanced (Version 1.5+).  Possesion of this program entitles you
'  to certain priviliges.  They are:
'
'     1. You may compile, use, or modify this program in any way you choose
'        provided you do not sell or give away the source code to this prog-
'        ram or any of it's companions to anyone for any reason.  You may,
'        however, sell the resulting executable program as you see fit.
'
'     2. You may modify, enhance or change these programs as you see fit. I
'        as that you keep a copy of the original code and that you notify
'        me of any improvements you make.  I like to think that the code is
'        bug free and cannot be improved upon, but I'm sure someone will
'        find a way to make it better.  If it's you, I'm looking forward to
'        seeing your changes.  I can be reached at:
'
'              Tim Beck                      Tim Beck (C/O Debbie Beck)
'              19419 Franz Road              8030 Fairchild Avenue
'              Houston, Texas  77084         Canoga Park, California 91306
'              (713) 639-3079                (818) 998-0588
'
'     3. This code has been tested and re-tested in a variety of applications
'        and although I have not found any bugs, doesn't mean none exist. So,
'        this program along with it's companions comes with NO WARRANTY,
'        either expressed or implied.  I'm sorry if there are problems, but
'        I can't be responsible for your work.  I've tried to provide a safe
'        and efficient programming enviroment and I hope you find it helpful
'        for you.  I do, however, need to cover my butt!
'
'  I have enjoyed creating this library of programs and have found them to be
'  a great time saver.  I hope you agree.
'
'                                                            Tim Beck //
'
'****************************************************************************
   DECLARE FUNCTION Show$ (Show.String$, Show.len%)

   DECLARE SUB PCENTER (R%, C1%, C2%, msg$, attr%)

   '----------------------------------------------------------------------
   '  Print a Message on Row R% between Columns C1% and C2%
   '
   '  R%       = Row to Print on
   '  C1%, C2% = Columns to Center Between
   '  msg$     = Message to print (truncates if too long)
   '  attr%    = Color Attribute (Fore% + (Back% * 16)) 0 = Screen


   REM $INCLUDE: 'STDCOM.INC'

   TIMER OFF    'Enables Event Trapping

'  ON ERROR GOTO ErrorTrap

ErrorTrap:

'  RESUME

SUB PCENTER (R%, C1%, C2%, msg$, attr%) STATIC

   IF R% <= 0 OR R% > 25 THEN
      R% = CSRLIN
   END IF

   IF C1% <= 0 OR C1% > 80 THEN
      C1% = POS(X)
   END IF

   IF C2% <= 0 OR C2% > 80 THEN
      C2% = 80
   END IF

   IF attr% = 0 THEN
      attr% = S.attr%
   END IF
 
   LN% = C2% - C1% + 1
   HL% = LN% / 2
   T% = (LN% - (LEN(msg$)))
   T% = T% / 2
   T% = T% - 1

   IF C2% < C1% THEN
      EXIT SUB
   ELSEIF T% < 1 THEN
      IF LEN(msg$) > 1 THEN
         msg$ = LEFT$(msg$, LEN(msg$) - 1)
         CALL PCENTER(R%, C1%, C2%, msg$, attr%)
         EXIT SUB
      ELSE
         EXIT SUB
      END IF
   ELSEIF T% + LEN(msg$) > C2% THEN
      IF LEN(msg$) > 1 THEN
         msg$ = LEFT$(msg$, LEN(msg$) - 1)
         CALL PCENTER(R%, C1%, C2%, msg$, attr%)
         EXIT SUB
      ELSE
         EXIT SUB
      END IF
   END IF

  'LOCATE R%, C1%
 
  'PRINT TAB(C1% + T%); msg$; TAB(C2%); " ";

   msg$ = Show$(SPACE$(T%) + msg$, LN%)
   CALL PRINTA(C1%, R%, attr%, msg$)

END SUB

