'****************************************************************************
'Total Control Systems                                         QuickBasic 4.5
'****************************************************************************
'
'  Program     : ECHECK.BAS
'  Written by  : Tim Beck
'  Written On  : 10-01-90
'  Function    : ERROR CHECK SUB ROUTINE
'
'****************************************************************************
'  This program and those associated with it were written for use with Quick-
'  Windows Advanced (Version 1.5+).  Possesion of this program entitles you
'  to certain priviliges.  They are:
'
'     1. You may compile, use, or modify this program in any way you choose
'        provided you do not sell or give away the source code to this prog-
'        ram or any of it's companions to anyone for any reason.  You may,
'        however, sell the resulting executable program as you see fit.
'
'     2. You may modify, enhance or change these programs as you see fit. I
'        as that you keep a copy of the original code and that you notify
'        me of any improvements you make.  I like to think that the code is
'        bug free and cannot be improved upon, but I'm sure someone will
'        find a way to make it better.  If it's you, I'm looking forward to
'        seeing your changes.  I can be reached at:
'
'              Tim Beck                      Tim Beck (C/O Debbie Beck)
'              19419 Franz Road              8030 Fairchild Avenue
'              Houston, Texas  77084         Canoga Park, California 91306
'              (713) 639-3079                (818) 998-0588
'
'     3. This code has been tested and re-tested in a variety of applications
'        and although I have not found any bugs, doesn't mean none exist. So,
'        this program along with it's companions comes with NO WARRANTY,
'        either expressed or implied.  I'm sorry if there are problems, but
'        I can't be responsible for your work.  I've tried to provide a safe
'        and efficient programming enviroment and I hope you find it helpful
'        for you.  I do, however, need to cover my butt!
'
'  I have enjoyed creating this library of programs and have found them to be
'  a great time saver.  I hope you agree.
'
'                                                            Tim Beck //
'
'****************************************************************************
  
   DECLARE SUB ERROR.CHECK (Error.Number%, Location%, Error.Count%, Abort.Code%, Resume.Code%, Status%)

  '--------------------------------------------------------------------------
  '   Display an Error Message in the Center of the Screen (Uses MESSAGEBOX)
  '
  '   Error.Number%  = ERR (BASIC Error Number)
  '   Location%      = ERL (BASIC Error Line)
  '   Error.Count%   = Number of Errors that have occured ... Resets if
  '                    Last Error <> Current Error
  '   Abort.Code%    = Determines whether or not application should
  '                    automatically Abort (0 = NO, 1 = YES)
  '   Resume.Code%   = Type of Resume (0=NONE, 1=RESUME, 2=NEXT, 3=EXIT)
  '   Status%        = Reports whether or not operation was successful (0,1)
  '
  '   Example:
  '
  'echeck:
  '
  '  CALL ERROR.CHECK(ERR, ERL, Error.Count%, Abort.Code%, Resume.Code%, status%)
  '  IF Abort.Code% = 0 THEN
  '     IF Resume.Code% = 0 THEN
  '        SYSTEM
  '     ELSEIF Resume.Code% = 1 THEN
  '        RESUME
  '     ELSEIF Resume.Code% = 2 THEN
  '        RESUME exit.label
  '     ELSEIF Resume.Code% = 3 THEN
  '        RESUME NEXT
  '     END IF
  '  ELSE
  '     SYSTEM
  '  END IF

   REM $INCLUDE: 'STDCOM.INC'

   TIMER OFF 'Enables event trapping
  

SUB ERROR.CHECK (Error.Number%, Location%, Error.Count%, Abort.Code%, Resume.Code%, Status%) STATIC

   Status% = 0
   button1$ = ""
   button2$ = ""
   button3$ = ""
   Resume.Code% = 0

   IF Error.Number% <> Last.Error% THEN
      Error.Count% = 0
   END IF

   SELECT CASE Error.Number%
      CASE 1 TO 4
         Error.Count% = Error.Count% + 1
         msg$ = " Internal Program Error ~ The Programmer Goofed! "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 1
         Abort.Code% = 0
         button1$ = " OK "
      CASE 5
         Error.Count% = Error.Count% + 1
         msg$ = "        Illegal Function Call       ~ I'm so confused?  Wanna try again? "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 6
         Error.Count% = Error.Count% + 1
         msg$ = " A Number is too large to Process "
         Msg.Lines% = 1
         Msg.Width% = LEN(msg$)
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 7
         Error.Count% = Error.Count% + 1
         msg$ = " Out of Memory.  Exiting "
         Msg.Lines% = 1
         Msg.Width% = LEN(msg$)
         Msg.Type% = 1
         Abort.Code% = 1
         button1$ = " Ok to Exit "
      CASE 11
         Error.Count% = Error.Count% + 1
         msg$ = "      Division by Zero!     ~   It's blowing my mind!    "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 14
         Error.Count% = Error.Count% + 1
         msg$ = "   Out of String Space!      ~ May not be able to continue "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 17, 19
         Error.Count% = Error.Count% + 1
         msg$ = " Sorry. I tried, but I'm unable to continue! "
         Msg.Lines% = 1
         Msg.Width% = LEN(msg$)
         Msg.Type% = 1
         Abort.Code% = 0
         button1$ = " OK to Exit "
      CASE 20
         Error.Count% = Error.Count% + 1
         msg$ = " How'd I get here?  There's been no error "
         Msg.Lines% = 1
         Msg.Width% = LEN(msg$)
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 24
         Error.Count% = Error.Count% + 1
         msg$ = " Timeout.  Would you like to try again? "
         Msg.Lines% = 1
         Msg.Width% = LEN(msg$)
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Yes, try Again "
         button2$ = " No, give it up "
      CASE 25
         Error.Count% = Error.Count% + 1
         msg$ = " Device Fault!  It's not working ... "
         Msg.Lines% = 1
         Msg.Width% = LEN(msg$)
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 27
         Error.Count% = Error.Count% + 1
         msg$ = "        Out of Paper!        ~ Would you like to add more? "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Continue "
         button2$ = "   Stop   "
      CASE 50
         Error.Count% = Error.Count% + 1
         msg$ = "        Field Overflow!       ~ There's something wrong with ~      that data file ...      "
         Msg.Lines% = 3
         Msg.Width% = LEN(msg$) / 3
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 52
         Error.Count% = Error.Count% + 1
         msg$ = "   Bad File Name/Number!     ~ Would you like to try again? "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
       CASE 53
         Error.Count% = Error.Count% + 1
         msg$ = "  Couldn't find that one!   ~ Want to enter another one? "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 54
         Error.Count% = Error.Count% + 1
         msg$ = "          Bad File Mode!         ~ The Programmer screwed up Again "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 55
         Error.Count% = Error.Count% + 1
         msg$ = " Attempt to re-open an open file! ~ I'm unable to continue. Aborting "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 1
         Abort.Code% = 0
         button1$ = " OK "
      CASE 57, 72
         Error.Count% = Error.Count% + 1
         msg$ = " Data Error found during Input/Output "
         Msg.Lines% = 1
         Msg.Width% = LEN(msg$)
         Msg.Type% = 3
         Resume.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
         button3$ = " Ignore "
      CASE 58
         Error.Count% = Error.Count% + 1
         msg$ = " Found Another with the same name ~    Want to enter another name?   "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 3
         Abort.Code% = 0
         button1$ = "   Yes  "
         button2$ = "   No   "
         button3$ = " Ovrwrt "
      CASE 61
         Error.Count% = Error.Count% + 1
         msg$ = "      Your Disk is Full!     ~   I'm unable to continue.   ~  Press [Enter] to Exit Now. "
         Msg.Lines% = 3
         Msg.Width% = LEN(msg$) / 3
         Msg.Type% = 1
         Abort.Code% = 0
         button1$ = " Exit Program "
      CASE 62
         Error.Count% = Error.Count% + 1
         msg$ = " Attempted to Read More than was there! "
         Msg.Lines% = 1
         Msg.Width% = LEN(msg$)
         Msg.Type% = 3
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
         button3$ = " Ignore "
      CASE 67
         Error.Count% = Error.Count% + 1
         msg$ = "       Too many files are open.       ~ Check your CONFIG.SYS and try again. "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 68
         Error.Count% = Error.Count% + 1
         msg$ = " DOS reports that the Device isn't Available ~      Is everything connected properly?      "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 69
         Error.Count% = Error.Count% + 1
         msg$ = " Wow!  There's too much Data for me!  ~ Slow down the communications, Please "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         Resume.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 70
         Error.Count% = Error.Count% + 1
         msg$ = "        Permission Denied!        ~ What're you trying to do anyway? "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 71
         Error.Count% = Error.Count% + 1
         msg$ = "    Your disk isn't ready.    ~ Would you like to try again? "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 74
         Error.Count% = Error.Count% + 1
         msg$ = "         Attempt to Rename across Disks!        ~ Don't you know you're not supposed to do that? "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 75
         Error.Count% = Error.Count% + 1
         msg$ = "     Path/File Access Error.     ~ Check your entry and try again. "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 1
         Abort.Code% = 0
         button1$ = " OK "
      CASE 76
         Error.Count% = Error.Count% + 1
         msg$ = "         Path not found.         ~ Check your entry and try again. "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 2
         Abort.Code% = 0
         button1$ = " Retry "
         button2$ = " Abort "
      CASE 8 TO 10, 12, 13, 16, 18, 26, 28, 29, 30, 33, 35, 37, 38, 39, 40, 51, 56, 59, 73
         Error.Count% = Error.Count% + 1
         msg$ = "            Memory Overflow Error!           ~ Commence Immeditate Shutdown of all systems "
         Msg.Lines% = 2
         Msg.Width% = LEN(msg$) / 2
         Msg.Type% = 1
         Abort.Code% = 1
         button1$ = " OK "
      CASE ELSE
         msg$ = " Unknown Error.  Attempt to Resume? "
         Msg.Width% = LEN(msg$)
         Msg.Lines% = 1
         Msg.Type% = 2
         button1$ = " Continue "
         button2$ = " Abort "
   END SELECT

   IF Error.Count% > 3 OR Abort.Code% = 1 THEN
      Error.Count% = 0
      Abort.Code% = 1
      EXIT SUB
   ELSEIF Msg.Type% = 1 THEN
      CALL MESSAGEBOX(button1$, 1 + Sh.Flag% + EX.Flag%, HB.attr%, msg$, Msg.Lines%, Msg.Width%, DE.attr%, Resume.Code%, msg.array%())
   ELSEIF Msg.Type% = 2 THEN
      CALL MESSAGEBOX2(button1$, button2$, 1 + Sh.Flag% + EX.Flag%, HB.attr%, msg$, Msg.Lines%, Msg.Width%, DE.attr%, Resume.Code%, msg.array%())
   ELSEIF Msg.Type% = 3 THEN
      CALL MESSAGEBOX3(button1$, button2$, button3$, 1 + Sh.Flag% + EX.Flag%, HB.attr%, msg$, Msg.Lines%, Msg.Width%, DE.attr%, Resume.Code%, msg.array%())
   END IF

   IF ERR = 1 OR ERR = 2 OR ERR = 3 OR ERR = 4 OR ERR = 7 OR ERR = 17 OR ERR = 19 OR ERR = 55 OR ERR = 61 OR ERR = 65 THEN
      Resume.Code% = 2           'Sets Resume code to Exit
   END IF
         
END SUB

