'****************************************************************************
'Total Control Systems                                         QuickBasic 4.5
'****************************************************************************
'
'  Program     : BOXMENU.BAS
'  Written by  : Tim Beck
'  Written On  : 10-01-90
'  Function    : BOX MENU SUBROUTINE
'
'****************************************************************************
'  This program and those associated with it were written for use with Quick-
'  Windows Advanced (Version 1.5+).  Possesion of this program entitles you
'  to certain priviliges.  They are:
'
'     1. You may compile, use, or modify this program in any way you choose
'        provided you do not sell or give away the source code to this prog-
'        ram or any of it's companions to anyone for any reason.  You may,
'        however, sell the resulting executable program as you see fit.
'
'     2. You may modify, enhance or change these programs as you see fit. I
'        as that you keep a copy of the original code and that you notify
'        me of any improvements you make.  I like to think that the code is
'        bug free and cannot be improved upon, but I'm sure someone will
'        find a way to make it better.  If it's you, I'm looking forward to
'        seeing your changes.  I can be reached at:
'
'              Tim Beck                      Tim Beck (C/O Debbie Beck)
'              19419 Franz Road              8030 Fairchild Avenue
'              Houston, Texas  77084         Canoga Park, California 91306
'              (713) 639-3079                (818) 998-0588
'
'     3. This code has been tested and re-tested in a variety of applications
'        and although I have not found any bugs, doesn't mean none exist. So,
'        this program along with it's companions comes with NO WARRANTY,
'        either expressed or implied.  I'm sorry if there are problems, but
'        I can't be responsible for your work.  I've tried to provide a safe
'        and efficient programming enviroment and I hope you find it helpful
'        for you.  I do, however, need to cover my butt!
'
'  I have enjoyed creating this library of programs and have found them to be
'  a great time saver.  I hope you agree.
'
'                                                            Tim Beck //
'
'****************************************************************************
   DECLARE SUB GET.INPUT (Row%, Col%, C.pos%, C.type%, AR.Flag%, C.Flag%, Blank%, I.Color%, Format$, Linp$, M.len%, E.flag%, kb%)
   DECLARE FUNCTION Show$ (Show.String$, Show.Len%)

   DECLARE SUB BOX.MENU (Row%, Col%, Hdr$, Menu%, M$(), H$(), Choice%, Allow.Exit%, Prompt%)

   '------------------------------------------------------------------------
   '  Create a Boxed Vertical Menu - Return Selected Option
   '
   '  Row%, Col%  = Top Left Row and Column of Menu (0,0 = Centered on Screen)
   '  Hdr$        = Menu Header Text (ie: MAIN MENU)
   '  Menu%       = Number of Menu Items
   '  M$()        = Menu Item Array
   '  H$()        = Help Text for Each Menu Item (Prints on Line 23)
   '  Choice%     = Number of Selected Item
   '  Allow.Exit% = Allow [ESC] to Exit Menu
   '  Prompt%     = Print "Your Choice: " prompt two lines beneath Menu
   '

   REM $INCLUDE: 'STDCOM.INC'

   TIMER OFF    'Enables Event Trapping

'   ON ERROR GOTO ErrorTrap

ErrorTrap:

'   RESUME

SUB BOX.MENU (Row%, Col%, Hdr$, Menu%, M$(), H$(), Choice%, Allow.Exit%, Prompt%) STATIC

   COLOR M.Fore%, M.Back%

   Choices$ = ""
   max.wid% = 0
   Style% = Sh.Flag% + EX.Flag% + 8
   Style2% = Sh.Flag% + EX.Flag% + 1

   IF Choice% = 0 THEN
      Choice% = 1
   END IF

   FOR Item% = 1 TO Menu%
      IF LEN(M$(Item%)) > max.wid% THEN
         max.wid% = LEN(M$(Item%))
      END IF
   NEXT Item%

   Dup.items% = 0
   FOR Item% = 1 TO Menu%
      M$(Item%) = LEFT$(M$(Item%) + SPACE$(max.wid%), max.wid%)
      IF INSTR(Choices$, LEFT$(M$(Item%), 1)) > 0 THEN
         Dup.items% = 1
      END IF
      Choices$ = Choices$ + LEFT$(M$(Item%), 1)
   NEXT Item%

   IF Row% = 0 AND Col% = 0 AND LEN(P.msg$) THEN
      PB.attr% = M.Fore% + (16 * M.Back%)
      x1% = 38 - (LEN(P.msg$) / 2)
      x2% = x1% + LEN(P.msg$) + 3
      IF LEN(Hdr$) THEN
         y1% = 10 - Menu%
         y2% = y1% + 2
      ELSE
         y1% = 12 - Menu%
         y2% = y1% + 2
      END IF
      CALL QBOX(x1%, y1%, x2%, y2%, Style2%, M.attr%, "")
     'CALL PRINTA(x1% + 2, y1% + 1, S.Fore% + 8, P.msg$)
      CALL PRINTA(x1% + 2, y1% + 1, PB.attr%, P.msg$)
      COLOR M.Fore%, M.Back%
   END IF
 
   IF Row% = 0 THEN
      Row% = (12 - Menu% + 3)
   END IF

   IF Col% = 0 THEN
      Col% = (40 - (max.wid% / 2)) - 2
   END IF

   IF LEN(Hdr$) THEN
      IF LEN(Hdr$) >= max.wid% THEN
         Hdr$ = LEFT$(Hdr$, max.wid%)
      ELSE
         hsp% = ((max.wid% / 2) - (LEN(Hdr$) / 2)) + 1
         Hdr$ = Show$(SPACE$(hsp%) + Hdr$, max.wid% + 2)
      END IF
      x1% = Col%
      y1% = Row%
      x2% = Col% + max.wid% + 3
      y2% = Row% + Menu% + 3
      dx% = x1% + ((max.wid% / 2) - (LEN(LetDate$) / 2)) + 2
      CALL PRINTA(dx%, y1% - 1, S.attr%, LetDate$)
      CALL QBOX(x1%, y1%, x2%, y2%, Style%, M.attr%, "")
      CALL PRINTA(x1% + 1, y1% + 1, HB.attr%, Hdr$)
      CALL QLINE(x1%, y1% + 2, x2%, y1% + 2, 1, M.attr%, 1)
      Row% = Row% + 2
   ELSE
      x1% = Col%
      y1% = Row%
      x2% = Col% + max.wid% + 3
      y2% = Row% + Menu% + 1
      dx% = x1% + ((max.wid% / 2) - (LEN(LetDate$) / 2)) + 2
      CALL PRINTA(dx%, y1% - 1, S.attr%, LetDate$)
      CALL QBOX(x1%, y1%, x2%, y2%, Style%, M.attr%, "")
   END IF

   x1% = Col%
   y1% = Row%
   IF MB.attr% = 0 THEN
      IF M.Fore% > 7 THEN
         MB.attr% = M.Back% + (16 * (M.Fore% - 8))
      ELSE
         MB.attr% = M.Back% + (16 * M.Fore%)
      END IF
   END IF
  
   IF M.Fore% <= 7 THEN
      MH.attr% = M.Fore% + 8 + (16 * M.Back%)
   ELSE
      MH.attr% = M.Back% + (16 * (M.Fore% - 8))
   END IF
  
   FOR Item% = 1 TO Menu%
      CALL PRINTA(x1% + 2, y1% + Item%, MH.attr%, LEFT$(M$(Item%), 1))
      CALL PRINTA(x1% + 3, y1% + Item%, M.attr%, MID$(M$(Item%), 2))
   NEXT Item%

   DO
      CALL PRINTA(x1% + 2, y1% + Choice%, MB.attr%, M$(Choice%))
      CALL PRINTA(2, 23, H.attr%, Show$(H$(Choice%), 78))
      COLOR S.Fore%, S.Back%
      IF Prompt% THEN
         CRow% = Row% + Menu% + 3
         CCol% = 46
         CALL PRINTA(33, Row% + Menu% + 3, S.attr%, "Your Choice: ")
         M.linp$ = " "
      ELSE
         CRow% = Row% + Choice%
         CCol% = Col% + 2
         M.linp$ = MID$(Choices$, Choice%, 1)
      END IF
      CALL GET.INPUT(CRow%, CCol%, 1, Prompt% * 4, 1, 1, 0, 1, CHR$(238), M.linp$, 0, E.flag%, X%)
      CALL PRINTA(x1% + 2, y1% + Choice%, MH.attr%, LEFT$(M$(Choice%), 1))
      CALL PRINTA(x1% + 3, y1% + Choice%, M.attr%, MID$(M$(Choice%), 2))
      IF X% = Down.Arrow% THEN
         IF Choice% = Menu% THEN
            Choice% = 1
         ELSE
            Choice% = Choice% + 1
         END IF
      ELSEIF X% = Up.Arrow% THEN
         IF Choice% = 1 THEN
            Choice% = Menu%
         ELSE
            Choice% = Choice% - 1
         END IF
      ELSEIF X% = Enter% THEN
         M.linp$ = MID$(STR$(Choice%), 2)
      ELSEIF LEN(RTRIM$(M.linp$)) AND E.flag% = 0 THEN
         IF INSTR(Choices$, M.linp$) > 0 THEN
            IF Dup.items% THEN
               IF INSTR(Choice% + 1, Choices$, M.linp$) > 0 THEN
                  Choice% = INSTR(Choice% + 1, Choices$, M.linp$)
               ELSE
                  Choice% = INSTR(Choices$, M.linp$)
               END IF
            ELSE
               Choice% = INSTR(Choices$, M.linp$)
               M.linp$ = MID$(STR$(Choice%), 2)
            END IF
         END IF
      ELSEIF E.flag% AND Allow.Exit% THEN
         Choice% = 0
         COLOR S.Fore%, S.Back%
         EXIT SUB
      ELSEIF E.flag% = 0 THEN
         M.linp$ = MID$(STR$(Choice%), 2)
      END IF
   LOOP WHILE VAL(M.linp$) = 0

   COLOR S.Fore%, S.Back%

END SUB

