'****************************************************************************
'Total Control Systems                                         QuickBasic 4.5
'****************************************************************************
'
'  Program     : GSTRING.BAS
'  Written by  : Tim Beck
'  Written On  : 10-01-90
'  Function    : GET STRING INPUT
'
'****************************************************************************
'  This program and those associated with it were written for use with Quick-
'  Windows Advanced (Version 1.5+).  Possesion of this program entitles you
'  to certain priviliges.  They are:
'
'     1. You may compile, use, or modify this program in any way you choose
'        provided you do not sell or give away the source code to this prog-
'        ram or any of it's companions to anyone for any reason.  You may,
'        however, sell the resulting executable program as you see fit.
'
'     2. You may modify, enhance or change these programs as you see fit. I
'        as that you keep a copy of the original code and that you notify
'        me of any improvements you make.  I like to think that the code is
'        bug free and cannot be improved upon, but I'm sure someone will
'        find a way to make it better.  If it's you, I'm looking forward to
'        seeing your changes.  I can be reached at:
'
'              Tim Beck                      Tim Beck (C/O Debbie Beck)
'              19419 Franz Road              8030 Fairchild Avenue
'              Houston, Texas  77084         Canoga Park, California 91306
'              (713) 639-3079                (818) 998-0588
'
'     3. This code has been tested and re-tested in a variety of applications
'        and although I have not found any bugs, doesn't mean none exist. So,
'        this program along with it's companions comes with NO WARRANTY,
'        either expressed or implied.  I'm sorry if there are problems, but
'        I can't be responsible for your work.  I've tried to provide a safe
'        and efficient programming enviroment and I hope you find it helpful
'        for you.  I do, however, need to cover my butt!
'
'  I have enjoyed creating this library of programs and have found them to be
'  a great time saver.  I hope you agree.
'
'                                                            Tim Beck //
'
'****************************************************************************
   DECLARE FUNCTION FreeWind% ()
   DECLARE SUB CLOSE.WINDOW (wid%)
   DECLARE SUB GET.INPUT (Row%, Col%, C.pos%, C.type%, AR.Flag%, C.Flag%, blank%, I.Color%, Format$, Linp$, M.len%, E.Flag%, kb%)
   DECLARE SUB MAXWID (M.Item%, msg$(), max.wid%)

   DECLARE SUB GETSTRING (x1%, y1%, Hgt%, Hdr$, msg$, cpos%, accept$, Format$, S$, flag%)
   DECLARE SUB GETSTRINGS (x1%, y1%, Hgt%, Hdr$, msgs$(), msgs%, cpos%, accept$(), Format$(), fields$(), flag%)

   '------------------------------------------------------------------------
   '  Gets string input from the user
   '
   '  x1%, y1%          = Top left column and row of the Input Box
   '  Hgt%              = Height of the Input Box
   '  Hdr$              = Header of Input Box
   '  msg$, msgs$()     = Message(s) of Input Line
   '  msgs%             = Number of Elements of msgs$() array (GETSTRINGS only)
   '  cpos%             = Position of Cursor in First Input item
   '  accept$, accept$()= Characters to accept (ie only accept "ABCDEF")
   '  Format$, Format$()= Input string Format(s) (see GET.INPUT)
   '  s$, fields$()     = returned Input string(s)
   '  flag%             = Input Flag% (0 = OK!)
   '
   '
   '  GETSTRING and GETSTRINGS prompt the user for (optionally formatted)
   '  string input from within a window (style is 1 + SH.Flag% + EX.Flag%).
   '  GETSTRINGS will prompt for a number of items, with each item being
   '  separated by a blank line.  If there are to many items to fit vert-
   '  ically, GETSTRINGS will attempt to make the box Half-Height.  That
   '  is, items are set next to each other like so:
   '
   '           item 1   item 2
   '
   '           item 3   item 4
  

   REM $INCLUDE: 'STDCOM.INC'

   TIMER OFF    'Enables Event Trapping

'  ON ERROR GOTO ErrorTrap

ErrorTrap:

'  RESUME

SUB GETSTRING (x1%, y1%, Hgt%, Hdr$, msg$, cpos%, accept$, Format$, S$, flag%) STATIC
  
   flag% = 1
  
   Style% = Sh.Flag% + EX.Flag% + 1

   edits% = 8449  '(keep contents, any character, allow INS/DEL, normal exit when full)
   exits% = 17407 '(all function keys + ESC)
  
   IF x1% = 0 THEN
      x1% = 80 - ((LEN(msg$) + LEN(S$)) + 6)
      x1% = x1% / 2
   END IF
   IF y1% = 0 THEN
      y1% = 10
   END IF
   x2% = x1% + (LEN(msg$) + LEN(S$)) + 6
   IF Hgt% = 0 THEN
      y2% = y1% + 4
      pp% = 1
   ELSE
      y2% = y1% + Hgt%
      pp% = (Hgt% - 2) / 2
   END IF

   C.Flag% = 0
   FOR C% = 1 TO LEN(accept$)
      IF ASC(MID$(accept$, C%, 1)) >= 65 AND ASC(MID$(accept$, C%, 1)) <= 90 THEN
         C.Flag% = 1
      ELSEIF ASC(MID$(accept$, C%, 1)) >= 97 THEN
         C.Flag% = 0
         EXIT FOR
      END IF
   NEXT C%

   wid% = FreeWind%
   sav% = wid%                      'In case of error, wid% will be returned
                                    'negative, sav restores original value
   idx% = ((wid% - 1) * 2000)       'each window is allotted 2000 characters

   CALL WOPENI(x1%, y1%, x2%, y2%, Style%, S.attr%, Hdr$, w.array%(), idx%, wid%)
   IF wid% <= 0 THEN
      wid% = sav%
   END IF

   CALL WPRINTA(wid%, 2, pp%, S.attr%, msg$)
   CALL WTITLE(wid%, 1, S.attr%, Hdr$)
   IF LEN(Format$) OR F% = 2 THEN
      IF F% = 2 THEN
         M.pwd% = 1
      END IF
      LOCATE y1% + pp% + 1, x1% + LEN(msg$) + 3
      DO
         accept% = -1
         CALL GET.INPUT(y1% + pp% + 1, x1% + LEN(msg$) + 3, cpos%, 2, 1, C.Flag%, 0, 1, Format$, S$, 0, F%, kb%)
         IF LEN(accept$) THEN
            FOR C% = 1 TO LEN(S$)
               IF INSTR(accept$, MID$(S$, C%, 1)) = 0 THEN
                  IF MID$(S$, C%, 1) <> MID$(Format$, C%, 1) THEN
                     accept% = 0
                     EXIT FOR
                  END IF
               END IF
            NEXT C%
         END IF
      LOOP UNTIL accept% OR F%
   ELSE
      cpos% = cpos% - 1
      IF cpos% < 0 THEN
         cpos% = 0
      END IF
      F% = 1
      edits% = edits% + (32 * C.Flag%)
      CALL WLOCATE(wid%, LEN(msg$) + 2, pp%)
      CALL WINPUT(wid%, S$, cpos%, edits%, exits%, accept$, kb%, F%)
      IF F% = 1 THEN
         F% = 0
      ELSE
         F% = 1
      END IF
   END IF
   CALL CLOSE.WINDOW(wid%)

   flag% = F%

END SUB

SUB GETSTRINGS (x1%, y1%, Hgt%, Hdr$, msgs$(), msgs%, cpos%, accept$(), Format$(), fields$(), flag%) STATIC
 
   pp% = 1
   flag% = 1
   Half.Height% = 0
 
   Style% = Sh.Flag% + EX.Flag% + 1

   edits% = 8449  '(keep contents, any character, allow INS/DEL, normal exit when full)
   exits% = 17407 '(all function keys + ESC)
 
   IF y1% = 0 THEN
      y1% = 10 - (msgs% / 2)
   END IF
  
   IF Hgt% = 0 THEN
      y2% = y1% + 2 + (msgs% * 2)
      IF y2% > 22 THEN
         Half.Height% = -1
         y2% = y1% + 2 + msgs%
      END IF
   ELSEIF Hgt% > msgs% THEN
      y2% = y1% + Hgt%
   ELSEIF Hgt% > (msgs% / 2) THEN
      Half.Height% = -1
      y2% = y1% + Hgt%
   END IF

   IF y1% < 1 OR y2% > 22 THEN
      EXIT SUB
   END IF
 
   CALL MAXWID(msgs%, msgs$(), Len.msg%)
   CALL MAXWID(msgs%, fields$(), Len.fld%)
   
   IF Half.Height% THEN
      Len.Box% = (2 * (Len.msg% + Len.fld%)) + 7
   ELSE
      Len.Box% = (Len.msg% + Len.fld%) + 5
   END IF

   IF Len.Box% < LEN(Hdr$) + 6 THEN
      Len.Box% = LEN(Hdr$) + 6
   END IF

   IF x1% = 0 THEN
      x1% = 80 - Len.Box%
      x1% = x1% / 2
   END IF
  
   x2% = x1% + Len.Box%

   IF x1% < 1 OR x2% > 79 THEN
      EXIT SUB
   END IF

   wid% = FreeWind%
   sav% = wid%                      'In case of error, wid% will be returned
                                    'negative, sav restores original value
   idx% = ((wid% - 1) * 2000)       'each window is allotted 2000 characters

   CALL WOPENI(x1%, y1%, x2%, y2%, Style%, S.attr%, Hdr$, w.array%(), idx%, wid%)
   IF wid% <= 0 THEN
      wid% = sav%
   END IF

   CALL WTITLE(wid%, 1, S.attr%, Hdr$)

   FOR fld% = 1 TO msgs%
  
      CALL WPRINTA(wid%, 2, pp%, S.attr%, msgs$(fld%))
      CALL WPRINTA(wid%, 2 + Len.msg%, pp%, DE.attr%, fields$(fld%))
      IF Half.Height% THEN
         fld% = fld% + 1
         CALL WPRINTA(wid%, 2 + Len.msg% + Len.fld% + 2, pp%, S.attr%, msgs$(fld%))
         CALL WPRINTA(wid%, 2 + Len.msg% + Len.fld% + 2 + Len.msg%, pp%, DE.attr%, fields$(fld%))
      END IF
      pp% = pp% + 2

   NEXT fld%
  
   pp% = 1
   fld% = 1

   DO
  
      C.Flag% = 0
      accept$ = accept$(fld%)
      Format$ = Format$(fld%)
      field$ = fields$(fld%)

      FOR C% = 1 TO LEN(accept$)
         IF ASC(MID$(accept$, C%, 1)) >= 65 AND ASC(MID$(accept$, C%, 1)) <= 90 THEN
            C.Flag% = 1
         ELSEIF ASC(MID$(accept$, C%, 1)) >= 97 THEN
            C.Flag% = 0
            EXIT FOR
         END IF
      NEXT C%

      IF LEN(Format$) OR F% = 2 THEN
         IF F% = 2 THEN
            M.pwd% = 1
         END IF
         Row% = y1% + pp% + 1
         IF fld% MOD 2 = 0 AND Half.Height% THEN
            Col% = x1% + (2 * Len.msg%) + 5 + Len.fld%
         ELSE
            Col% = x1% + Len.msg% + 3
         END IF
         DO
            accept% = -1
            CALL GET.INPUT(Row%, Col%, cpos%, 2, 1, C.Flag%, 0, 1, Format$, field$, LEN(field$), F%, kb%)
            cpos% = 0
            fields$(fld%) = field$
            IF kb% = Up.Arrow% THEN
               fld% = fld% - 2
               pp% = pp% - (2 + (2 * ABS(NOT Half.Height%)))
               IF fld% < 0 THEN
                  F% = 1
                  EXIT DO
               ELSE
                  F% = 0
               END IF
            ELSEIF kb% = F.9% THEN
               F% = 1
               EXIT DO
            ELSEIF LEN(accept$) THEN
               FOR C% = 1 TO LEN(field$)
                  IF INSTR(accept$, MID$(field$, C%, 1)) = 0 THEN
                     IF MID$(field$, C%, 1) <> MID$(Format$, C%, 1) THEN
                        accept% = 0
                        EXIT FOR
                     END IF
                  END IF
               NEXT C%
            END IF
         LOOP UNTIL accept% OR F%
      ELSE
         cpos% = cpos% - 1
         IF cpos% < 0 THEN
            cpos% = 0
         END IF
         F% = 1
         edits% = edits% + (32 * C.Flag%)
         IF fld% MOD 2 = 0 AND Half.Height% THEN
            CALL WLOCATE(wid%, 2 + Len.msg% + Len.fld% + Len.msg% + 2, pp%)
         ELSE
            CALL WLOCATE(wid%, 2 + Len.msg%, pp%)
         END IF
         CALL WINPUT(wid%, field$, cpos%, edits%, exits%, accept$, kb%, F%)
         cpos% = 0
         fields$(fld%) = field$
         IF kb% = Up.Arrow% THEN
            fld% = fld% - 2
            pp% = pp% - (2 + (2 * ABS(NOT Half.Height%)))
            IF fld% < 0 THEN
               F% = 1
               EXIT DO
            END IF
         END IF
         IF F% = 1 THEN
            F% = 0
         ELSE
            F% = 1
         END IF
      END IF

      fld% = fld% + 1
      IF NOT (fld% MOD 2 = 0 AND Half.Height%) THEN
         pp% = pp% + 2
      END IF
  
   LOOP UNTIL fld% > msgs% OR F% = 1 OR kb% = F.10%

   CALL CLOSE.WINDOW(wid%)

   flag% = F%

END SUB

