'****************************************************************************
'Total Control Systems                                         QuickBasic 4.5
'****************************************************************************
'
'  Program     : FUNCTION.BAS
'  Written by  : Tim Beck
'  Written On  : 10-01-90
'  Function    : FUNCTIONS
'
'****************************************************************************
'  This program and those associated with it were written for use with Quick-
'  Windows Advanced (Version 1.5+).  Possesion of this program entitles you
'  to certain priviliges.  They are:
'
'     1. You may compile, use, or modify this program in any way you choose
'        provided you do not sell or give away the source code to this prog-
'        ram or any of it's companions to anyone for any reason.  You may,
'        however, sell the resulting executable program as you see fit.
'
'     2. You may modify, enhance or change these programs as you see fit. I
'        as that you keep a copy of the original code and that you notify
'        me of any improvements you make.  I like to think that the code is
'        bug free and cannot be improved upon, but I'm sure someone will
'        find a way to make it better.  If it's you, I'm looking forward to
'        seeing your changes.  I can be reached at:
'
'              Tim Beck                      Tim Beck (C/O Debbie Beck)
'              19419 Franz Road              8030 Fairchild Avenue
'              Houston, Texas  77084         Canoga Park, California 91306
'              (713) 639-3079                (818) 998-0588
'
'     3. This code has been tested and re-tested in a variety of applications
'        and although I have not found any bugs, doesn't mean none exist. So,
'        this program along with it's companions comes with NO WARRANTY,
'        either expressed or implied.  I'm sorry if there are problems, but
'        I can't be responsible for your work.  I've tried to provide a safe
'        and efficient programming enviroment and I hope you find it helpful
'        for you.  I do, however, need to cover my butt!
'
'  I have enjoyed creating this library of programs and have found them to be
'  a great time saver.  I hope you agree.
'
'                                                            Tim Beck //
'
'****************************************************************************
   DECLARE FUNCTION Get.MDY% (dte$)
   DECLARE FUNCTION Show$ (Show.String$, Show.Len%)
   DECLARE FUNCTION FreeWind% ()
   DECLARE FUNCTION FileName$ (filespec$)
   DECLARE FUNCTION DriveName$ (filespec$)
   DECLARE FUNCTION PathName$ (filespec$)
   DECLARE FUNCTION Pad$ (Number%, Padby%, Padwith%)
   DECLARE FUNCTION PadL$ (Number&, Padby%, Padwith%)
   DECLARE FUNCTION PadS$ (Number$, Padby%, Padwith%)
  
   '-----------------------------------------------------------------------
   '  Several Helpful Functions
   '
   '     GET.MDY!    returns the number of Days since the first of the Year
   '     Show$       returns a string of a specified length (Elongating or Truncating as Necessary
   '     FreeWind%   returns the next Free Window number
   '     FileName$   returns the File Name of FileSpec$
   '     DriveName$  returns the associated Drive of FileSpec$
   '     PathName$   returns the associated path of FileSpec$
   '     Pad$, PadL$ returns a number either padded with 0's or  's
   '                 ie:      0003 (Padwith% = 0, Padby% = 4)
   '                      or     3 (Padwith% = 1, Padby% = 4)
   '     PadS$       is the same as PadL$ but with Strings


   REM $INCLUDE: 'STDCOM.INC'
  
   TIMER OFF    'Enables Event Trapping

'   ON ERROR GOTO ErrorTrap

ErrorTrap:

'   RESUME

FUNCTION DriveName$ (filespec$) STATIC

   DString$ = RTRIM$(filespec$)
   Colon% = INSTR(DString$, ":")
  
   IF Colon% > 0 THEN
      IF MID$(DString$, Colon% + 1, 1) = "\" THEN
         DString$ = LEFT$(DString$, Colon% + 1)
      ELSE
         DString$ = LEFT$(DString$, Colon%)
      END IF
   ELSE
      DString$ = ""
   END IF

   DriveName$ = DString$
  
END FUNCTION

FUNCTION FileName$ (filespec$) STATIC

   DString$ = filespec$
  
   IF LEN(DString$) = 0 THEN
      EXIT FUNCTION
   ELSEIF INSTR(DString$, "\") > 0 THEN
      WHILE INSTR(DString$, "\")
         DString$ = MID$(DString$, INSTR(DString$, "\") + 1)
      WEND
      FileName$ = DString$
   ELSEIF INSTR(DString$, ":") > 0 THEN
      DString$ = MID$(DString$, INSTR(DString$, ":") + 1)
   ELSE
      FileName$ = DString$
   END IF

END FUNCTION

FUNCTION FreeWind%

   FreeWind% = 0
   FOR w% = 1 TO 16
      IF Free.Window%(w%) = 0 THEN
         Free.Window%(w%) = -1
         FreeWind% = w%
         EXIT FOR
      END IF
   NEXT w%
   IF w% = 16 THEN
      BEEP
      FreeWind% = 16
   END IF

END FUNCTION

FUNCTION Get.MDY% (Ymddate$) STATIC

   Mo% = VAL(MID$(Ymddate$, 3, 2))
   Dy% = VAL(MID$(Ymddate$, 5, 2))
   Yr% = VAL(MID$(Ymddate$, 1, 2))

   IF Mo% = 1 THEN MDY% = 0
   IF Mo% = 2 THEN MDY% = 31
   IF Mo% = 3 THEN MDY% = 59
   IF Mo% = 4 THEN MDY% = 90
   IF Mo% = 5 THEN MDY% = 120
   IF Mo% = 6 THEN MDY% = 151
   IF Mo% = 7 THEN MDY% = 181
   IF Mo% = 8 THEN MDY% = 212
   IF Mo% = 9 THEN MDY% = 243
   IF Mo% = 10 THEN MDY% = 273
   IF Mo% = 11 THEN MDY% = 304
   IF Mo% = 12 THEN MDY% = 334
   IF Mo% > 2 AND Yr% MOD 4 = 0 THEN
      MDY% = MDY% + 1
   END IF

   MDY% = MDY% + Dy%

   Get.MDY% = MDY%

END FUNCTION

FUNCTION Pad$ (Number%, Padby%, Padwith%) STATIC

   IF Padwith% THEN
      Pad$ = RIGHT$(SPACE$(Padby%) + MID$(STR$(Number%), 2), Padby%)
   ELSE
      Pad$ = MID$(STR$(Number% + (10 ^ Padby%)), 3, Padby%)
   END IF

END FUNCTION

FUNCTION PadL$ (Number&, Padby%, Padwith%) STATIC

   IF Padwith% THEN
      PadL$ = RIGHT$(SPACE$(Padby%) + MID$(STR$(Number&), 2), Padby%)
   ELSE
      PadL$ = MID$(STR$(Number& + (10 ^ Padby%)), 3, Padby%)
   END IF

END FUNCTION

FUNCTION PadS$ (Number$, Padby%, Padwith%) STATIC

   Number# = VAL(Number$)

   IF Padwith% THEN
      PadS$ = RIGHT$(SPACE$(Padby%) + MID$(STR$(Number#), 2), Padby%)
   ELSE
      PadS$ = MID$(STR$(Number# + (10 ^ Padby%)), 3, Padby%)
   END IF

END FUNCTION

FUNCTION PathName$ (filespec$) STATIC

   DString$ = RTRIM$(filespec$)
   PathName$ = ""

   IF LEN(DString$) > 0 THEN

      IF INSTR(DString$, FileName$(DString$)) > 1 THEN

         PathName$ = LEFT$(DString$, INSTR(DString$, FileName$(DString$)) - 1)

      END IF

   END IF

END FUNCTION

FUNCTION Show$ (Show.String$, Show.Len%) STATIC

   Show$ = LEFT$(Show.String$ + SPACE$(Show.Len%), Show.Len%)

END FUNCTION

