 TITLE	BASSCR	- Screen Design	Aid - Support Module
 SUBTTL	Version	1.0 - January 1983
 PAGE	81,132
 COMMENT \
*******************************************************************************
*		 Copyright 1983	- DD Systems - Springdale, AR		      *
*******************************************************************************
*									      *
*	The utilities required to service a screen under BASIC		      *
*									      *
*   Calls:	DISP - to display primary screen			      *
*   *-Local	FLDOUT - to output a string to a field			      *
*		FLDINP - to input from a field				      *
*		FLDCLR - to clear a field				      *
*		FLDPOS - to position to	a field				      *
*									      *
*   Data (Ext):	Compressed image    Data (Loc):	IMGCNT - Count of screens     *
*						IMGTAB - Pointer to screens   *
*						IMGPTR - Offset	of current    *
*							 compressed image     *
*						IMGFLG - hardware line length *
*									      *
*	The primary entry point	simply determines which	function is being     *
*	invoked, and transfers control to that function.  All registers	      *
*	are saved and restored.	 Interface with	the BASIC data area is	      *
*	also performed.							      *
*									      *
******************************************************************************\
;;
;;	Console	output - Normal	- P1 or	the content of the DL register is
;;				  output to the	current	cursor position.
;;
$COUT	MACRO	P1
	IFNB	<P1>
	MOV	DL,P1
	ENDIF
	MOV	AH,2
	INT	21H
	ENDM
;;
;;	Console	Input -	No Echo	- Wait - Character is returned in AL
;;
$CINE	MACRO
	MOV	AH,8
	INT	21H
	ENDM
;
;  The following structure defines the stack content on	entry.
;
PARMS	STRUC
;
SAVEBP	DW	?
SAVOFF	DW	?
SAVSEG	DW	?
PARM3	DW	?
PARM2	DW	?
PARM1	DW	?
;
PARMS	ENDS
;
PLENG	EQU	6
;
CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE
;
	EXTRN	BASMEN:BYTE		;Expects an external stack of screens
;
IMGCNT	DW	-1			;Set for initialization
IMGTAB	DW	10 DUP (?)		;Up to 10 screens
IMGPTR	DW	0			;Current compressed image pointer
IMGFLG	DB	0			;Length	flag for image 0=80,1=40
IMGLEN	DB	0			;Length	of hardware line
;
SAVSS	DW	0			;Stack seg save	area
SAVSP	DW	0			;Stack pointer save area
SAVSI	DW	0			;String	pointer	save area
PRM2	DW	0			;Pointer to second parameter
;
SBUF	DB	81 DUP (?)		;Work buffer
;
	DB	10 DUP ('STACK ')	;Internal stack	area
ENDSTK	EQU	$
;
	PUBLIC	BASSCR
;
BASSCR	PROC	FAR
	PUSH	BP
	MOV	BP,SP			;Get stack reference
	MOV	SI,[BP].PARM1		;Get ptr to first parm
	MOV	AX,WORD	PTR [SI]	;Get first parm
	MOV	SI,[BP].PARM2		;Get ptr to second parm
	MOV	DI,SI			;Save it for return of data
	MOV	BX,WORD	PTR [SI]	;Get second parm
	MOV	SI,[BP].PARM3		;Get ptr to string vector
	MOV	CX,CS			;Now we	can blow DS
	MOV	DS,CX			;Addressability	to 'code' segment
	MOV	PRM2,DI			;Save 2nd parm pointer
	MOV	SAVSS,SS		;Save old stack	segment
	MOV	SAVSP,SP		;   and	pointer
	MOV	SAVSI,SI		;Also string vector address
	MOV	SS,CX			;Set to	new stack
	MOV	SP,OFFSET ENDSTK
	PUSH	ES			;Now save ES
	OR	AX,AX			;Check command
	JZ	DISP			;Standard display screen
	DEC	AX
	JNZ	A1
	JMP	FLDOUT			;Field output request
A1:	DEC	AX
	JNZ	A2
	JMP	FLDINP			;Field input request
A2:	DEC	AX
	DEC	AX
	JNZ	A3
	JMP	FLDCLR			;Field clear request
A3:	DEC	AX
	JNZ	RESRET
	JMP	FLDPOS			;Field position	request
RESRET:	MOV	SS,SAVSS		;Restore stack segment
	MOV	SP,SAVSP		;  and pointer
	MOV	AX,SS
	MOV	ES,AX
	MOV	DS,AX
	POP	BP
	RET	PLENG			;Do a "far" return
;
;	Display	Menu - Expects BX to contain the number	of the
;			compressed image to be displayed.  This	reference
;			is saved for field handling calls.
;
DISP:	MOV	AX,IMGCNT		;Check count for initial value
	INC	AX
	JNZ	IMGINT			;Already initialized
	CALL	SETAB			;Set up	image table
IMGINT:	DEC	BX			;Image number -	1
	SHL	BX,1			;  times two
	MOV	DX,IMGTAB[BX]		;Get pointer to	image
	MOV	IMGPTR,DX		;   and	save for field calls
	CALL	SETES			;Set ES	to proper regen	buffer
	XOR	CX,CX
	MOV	DI,CX			;Initialize regen pointer
	CLD				;Assure	direction
	MOV	SI,DX			;Point to image
	LODSW				;Load field count
	ADD	AX,AX
	ADD	AX,AX			;AX contains size of field table
	ADD	SI,AX			;So step over it
	LODSW				;Load size of compressed image
	MOV	IMGFLG,0
	TEST	AH,80H			;Establish image size flag
	JZ	SIMG1
	MOV	IMGFLG,1		;Forty character image
	AND	AH,7FH
SIMG1:	MOV	BX,SI
	ADD	BX,AX			;BX points one cell beyond image
	MOV	AH,7			;Initial attribute
LODLP:	CMP	SI,BX			;See if	out of screen
	JAE	LODDNE			;Out, so display complete
	LODSB				;Get image byte
	INC	AL			;Check for attribute flag
	JNZ	LOD1			;Not attribute flag
	LODSB				;Load attribute
	MOV	AH,AL			;   and	save
	JMP	LODLP
LOD1:	INC	CX			;Set loop count	to 1
	DEC	AL			;Test for repeat count flag
	JNZ	LOD2			;No
	LODSB				;Load repeat count
	MOV	CL,AL			;   and	set loop count
	LODSB				;Load character	to be repeated
LOD2:	REP	STOSW			;Store character and attribute in regen
	JMP	LODLP
LODDNE:	CMP	IMGLEN,160		;Check for hardware LL
	JZ	LD80
	TEST	IMGFLG,1
	JZ	LDFIX
	MOV	IMGFLG,0		;40/40,	so no adjustment
	JMP	SHORT LODOUT
LD80:	TEST	IMGFLG,1
	JZ	LODOUT			;80/80,	so no adjustment
LDFIX:	PUSH	DS
	PUSH	ES
	POP	DS
	TEST	CS:IMGFLG,1
	JZ	LDTRNC			;Truncate screen
	STD				;Center	screen
	MOV	SI,7CEH			;Point to end of image
	MOV	DI,0F9EH		;Point to end of screen
	MOV	DL,25			;Do 25 lines
XLP2:	MOV	CX,20
	MOV	AX,720H			;Clear 20 columns
	REP	STOSW
	MOV	CX,40			;Move 40 columns
	REP	MOVSW
	MOV	CX,20
	MOV	AX,720H			;Clear 20 columns
	REP	STOSW
	DEC	DL
	JNZ	XLP2			;Loop through 25 lines
	CLD
	JMP	SHORT LODPOP
LDTRNC:	XOR	SI,SI			;Truncate image
	MOV	DI,SI
	MOV	DL,25
XLP1:	MOV	CX,40			;Move 40 columns
	REP	MOVSW
	ADD	SI,80			;Skip 40 columns
	DEC	DL
	JNZ	XLP1			;Loop through 25 lines
LODPOP:	POP	DS
LODOUT:	JMP	RESRET			;Restore registers
;
;	Field Output - Expects DX to point to string for output
;
FLDOUT:	MOV	CX,WORD	PTR ES:[SI]	;Get length of string
	CMP	CX,80
	JBE	LENOK
	MOV	CX,80			;Force to 80 as	max
LENOK:	MOV	SI,WORD	PTR ES:[SI+2]	;Now point to string
	XOR	DI,DI
OLP1:	MOV	AL,BYTE	PTR ES:[SI]	;Get Basic's string
	MOV	SBUF[DI],AL		;  and put in work buffer
	INC	SI
	INC	DI
	LOOP	OLP1			;Loop till string in buffer
	MOV	SBUF[DI],0		;Put on	terminator
	MOV	SI,OFFSET SBUF		;String	pointer	to SI
	MOV	AX,BX			;Put field number in AL
	CALL	FNDFLD			;Set for field requested
	CALL	SETES			;Set ES	for regen buffer
	ADD	DL,CL			;Make col end of field plus 1
FO1:	LODSB				;Get string byte
	OR	AL,AL			;Check for terminator
	JZ	FO3			;String	shorter	than field
	STOSW				;Save string byte and attribute
	LOOP	FO1			;Loop till end of field
FO2:	CALL	SETCUR			;Position cursor
	JMP	RESRET			;  and return
FO3:	MOV	AL,' '
	REP	STOSW			;Clear remainder of field
	JMP	FO2
;
;	Clear requested	field to field attribute
;
FLDCLR:	CALL	DOCLR
	JMP	RESRET
;
;	Position cursor	to start of field
;
FLDPOS:	MOV	AX,BX
	CALL	SETRCL			;Get row/col
	CALL	SETCUR			;  and set cursor
	JMP	RESRET
;
;	Field Input
;
FLDINP:	MOV	AX,BX
	PUSH	AX			;Save field number
	TEST	AL,80H
	JNZ	NOCLR			;Don't clear before input
	AND	AL,7FH
	CALL	DOCLR			;Clear the field in AL
NOCLR:	POP	AX
	AND	AL,7FH			;Clear flag bit, if any
	CALL	SETES
	CALL	FNDFLD			;Set for field data
	MOV	BL,AH			;Save attribute
	INC	CL			;Make field one	count longer
	MOV	SI,OFFSET SBUF		;Use internal buffer
	JMP	SHORT SETC		;  and enter read loop
;
ILP:	DEC	CL			;Decrement characters remaining
	JZ	BEEP			;Out of	field
	MOV	BYTE PTR [SI],AL	;Save current input byte
	INC	SI			;   and	setp to	next buffer locn
	INC	DL			;Step cursor position
	INC	CH			;Step string (read) length
	MOV	AH,BL			;Restore attribute
	STOSW				;  and put char	and attrb to screen
SETC:	CALL	SETCUR			;Advance cursor
FIINP:	$CINE				;Read next character
	OR	AL,AL
	JZ	SCODE			;Scan code character coming
	CMP	AL,13
	JZ	CR			;Carriage return input
	CMP	AL,1BH
	JZ	ESC			;Escape	input
	CMP	AL,9
	JZ	TABR			;Tab right input
	CMP	AL,8
	JZ	BS			;Back space input
	CMP	AL,7FH
	JZ	BS			;Delete	input
	CMP	AL,' '
	JB	FIINP			;Don't take anything less than blank
	JMP	ILP			;Go save character
;
BEEP:	PUSH	DX
	$COUT	7			;Out of	field, so "beep" at him
	POP	DX
	INC	CL
	JMP	FIINP
;
CR:	XOR	AH,AH			;Set flag register
COM:	MOV	BYTE PTR[SI],0		;Set nul at end	of string
	MOV	AL,AH
	CBW
	MOV	DI,PRM2
	POP	ES
	STOSW				;Save return code
	MOV	AL,CH
	CBW
	MOV	CX,AX			;Set CX	to input string	length
	MOV	SI,SAVSI		;Get string vector pointer
	CMP	CX,WORD	PTR ES:[SI]
	JBE	INLOK			;Less than or equal to string
	MOV	CX,WORD	PTR ES:[SI]	   ;Don't move more than field length
INLOK:	PUSH	CX
	MOV	DI,WORD	PTR ES:[SI+2]	   ;Get	pointer	to string
	MOV	SI,OFFSET SBUF
	REP	MOVSB			;Move string to	BASIC
	MOV	SI,SAVSI		;Get pointer again
	MOV	CX,WORD	PTR ES:[SI]	   ;Compute difference in length
	POP	AX
	SUB	CX,AX
	JZ	INDNE
	MOV	AL,' '
	REP	STOSB			;Clear remainder of string
INDNE:	JMP	RESRET
;
SCODE:	$CINE				;Get next character after nul
	MOV	AH,8
	CMP	AL,15
	JNZ	SCN1
	MOV	AH,2			;Set Tab left flag
SCN1:	OR	AL,80H			;Set scan code zone
	MOV	BYTE PTR [SI],AL	;  and save character
	INC	SI
	INC	CH			;Step pointer and length of string
CARRY:	STC				;Set flag
	JMP	COM
;
TABR:	MOV	AH,1			;Set tab right flag
	JMP	CARRY
;
ESC:	MOV	AH,4			;Escape	flag
	JMP	CARRY
;
BS:	OR	CH,CH			;See if	at start
	JNZ	BS1
	JMP	FIINP			;Yes, so ignore	BS
BS1:	DEC	CH			;Decrement string length
	INC	CL			;  and add back	to field length
	DEC	SI			;Step back buffer pointer
	MOV	AH,BL			;Restore attribute
	MOV	AL,' '
	SUB	DI,2			;Move screen pointer back
	STOSW				;Blank last character on screen
	SUB	DI,2
	DEC	DL			;Step cursor back
	JMP	SETC
;
BASSCR	ENDP
;
;	Sets ES	to proper segment for equipment	"installed"
;
SETES	PROC	NEAR
	PUSH	AX
	INT	11H			;Get equipment word
	AND	AL,30H
	XOR	AL,30H			;Mask for display type
	JNZ	ES1			;Not a Mono
	MOV	AX,0B000H		;Monochrome Adapter
	JMP	ES2
ES1:	MOV	AX,0B800H		;Color/graphics	Adapter
ES2:	MOV	ES,AX			;Set ES	for regen buffer
	MOV	AH,15
	INT	10H			;Check DOS mode
	SHL	AH,1
	MOV	IMGLEN,AH		;Save hardware line length
	POP	AX
	RET
SETES	ENDP
;
;	Find field - Sets DI to	regen offset for field
;			  DX to	row/col	for field
;			  CX to	length of field
;			  AH to	attribute of field
;
FNDFLD	PROC	NEAR
	CALL	SETRCL			;Get row/col and length
	MOV	AL,DH			;Row to	accumulator
	MOV	AH,IMGLEN		;Multiplier for	one row
	MUL	AH
	MOV	DI,AX			;Move to regen pointer
	MOV	AL,DL			;Column	to accumulator
	XOR	AH,AH
	ADD	AX,AX			;Double	column for word	offset
	ADD	DI,AX			;DI now	points to field	in regen
	MOV	AH,CH			;Attribute to AH
	XOR	CH,CH			;Leave length in CX
	RET
FNDFLD	ENDP
;
;	Set row/col/length/attribute
;
SETRCL	PROC	NEAR
	CBW
	DEC	AX
	MOV	CX,2
	SHL	AX,CL
	ADD	AX,CX
	MOV	BX,IMGPTR		;Get pointer to	compressed image
	ADD	BX,AX			;And set offset
	MOV	DX,WORD	PTR [BX]	;Load row/col
	XCHG	DH,DL			;DH=Row, DL=Col
	TEST	IMGFLG,1		;See if	screen to be centered
	JZ	FF1
	ADD	DL,20			;It was
FF1:	MOV	CX,WORD	PTR [BX+2]	;  and attrb/length
	RET
SETRCL	ENDP
;
;	Position cursor	to row/col in DX
;
SETCUR	PROC	NEAR
	PUSH	CX
	MOV	AH,1
	MOV	CX,0607H
	INT	10H			;Turn cursor on	(BASIC does
	MOV	AH,2			;  funny things)
	MOV	BH,0			;Page 0
	INT	10H			;Set cursor
	POP	CX
	RET
SETCUR	ENDP
;
SETAB	PROC	NEAR
	XOR	DX,DX
	MOV	DI,DX
	MOV	CX,DX
	INC	CX
	INC	CX
	MOV	SI,OFFSET BASMEN	;External screen stack
STBLP:	MOV	AX,WORD	PTR [SI]	;Get "field table" count
	INC	AX
	JZ	ATEND			;At end	of screens
	MOV	IMGTAB[DI],SI		;Save pointer to start of screen
	ADD	DI,CX			;Step to next entry
	INC	DX			;  and count screen
	DEC	AX
	SHL	AX,CL			;Size of field table
	ADD	AX,CX			;  plus	count word
	ADD	SI,AX			;SI now	points to image	length word
	MOV	AX,WORD	PTR [SI]
	AND	AH,7FH			;Clear flag, if	any
	ADD	SI,AX			;SI points to "next" screen
	JMP	STBLP
ATEND:	MOV	IMGCNT,DX		;Save count of screens
	RET
SETAB	ENDP
;
;	Clear requested	field
;
DOCLR	PROC	NEAR
	CALL	SETES			;Set to	regen buffer
	MOV	AX,BX
	CALL	FNDFLD			;Get pointer to	regen and attribute
	MOV	AL,' '			;Clear to blanks
	REP	STOSW			;Stores	blank plus attribute
	CALL	SETCUR			;Position cursor to start of field
	RET
DOCLR	ENDP
;
CODE	ENDS
;
	END
