' *****************************************************************************
' ****                                                                     ****
' **                        Rtx Professional Toolbox                         **
' **      Copyright (c) 1992 by Cyberphilia, Inc.  All Rights Reserved.      **
' ****                                                                     ****
' *****************************************************************************

Const _
  RTXMAXHEADERS% =   5%, _
  RTXMAXFOOTERS% =   5%, _
  RTXMAXCOLUMNS% =  10%, _
  RTXMAXBREAKS%  =   5%, _
  RTXMAXCOLSIZE% =  80%, _
  RTXMAXWIDTH%   = 255%, _
  RTXMAXLENGTH%  = 255%
  '
Const _
  TRUE        =  -1%, _
  FALSE       =   0%
  '
Const _
  RTXALREADYOPEN% =  1%, _
  RTXBADBOTTOM%   =  2%, _
  RTXBADBREAK%    =  3%, _
  RTXBADCOLUMN%   =  4%, _
  RTXBADCONTENTS% =  5%, _
  RTXBADCOPIES%   =  6%, _
  RTXBADFILENAME% =  7%, _
  RTXBADFOOTER%   =  8%, _
  RTXBADHEADER%   =  9%, _
  RTXBADLEFT%     = 10%
  '
Const _
  RTXBADLENGTH%   = 11%, _
  RTXBADMASK%     = 12%, _
  RTXBADPRINTER%  = 13%, _
  RTXBADROW%      = 14%, _
  RTXBADSKIP%     = 15%, _
  RTXBADSOURCE%   = 16%, _
  RTXBADSTYLE%    = 17%, _
  RTXBADTOP%      = 18%, _
  RTXBADTOTAL%    = 19%, _
  RTXBADWIDTH%    = 20%
  '
Const _
  RTXFILEEXISTS%  = 21%, _
  RTXIOERROR%     = 22%, _
  RTXNOTONLINE%   = 23%, _
  RTXNOTOPEN%     = 24%, _
  RTXOUTOFPAPER%  = 25%, _
  RTXSUCCESS%     = 26%, _
  RTXTIMEOUT%     = 27%, _
  RTXUNKNOWN%     = 28%
  '
Const _
  RTXSTRING%   = 1%, _
  RTXINTEGER%  = 2%, _
  RTXLONG%     = 3%, _
  RTXSINGLE%   = 4%, _
  RTXDOUBLE%   = 5%, _
  RTXCURRENCY% = 6%
  '
Const _
  RTXLEFT%  = 0%, _
  RTXRIGHT% = 1%, _
  RTXCENTER = 2%
  '
Type RtxStruc
  FileName   As String*64
  FileHandle As Integer
  Printer    As Integer
  OpLine     As Integer
  FormWidth  As Integer
  FormLength As Integer
  FormLM     As Integer
  FormTM     As Integer
  FormBM     As Integer
  FormLPP    As Integer
  FormPage   As Integer
  FormLine   As Integer
  Suppress   As Integer
  Headers    As Integer
  Footers    As Integer
  Columns    As Integer
  Breaks     As Integer
  LineImage  As String*RTXMAXWIDTH%
  Success    As Integer
  Result     As Integer
End Type
'
Type RtxPrinterStruc
  NotBusy     As Integer
  Acknowledge As Integer
  OutOfPaper  As Integer
  Selected    As Integer
  IOError     As Integer
  TimedOut    As Integer
End Type
'
Type RtxHeaderFooterStruc
  Style As Integer
  Text  As String*RTXMAXWIDTH%
End Type
'
Type RtxColumnStruc
  Label                   As String*RTXMAXCOLSIZE%
  Source                  As Integer
  Mask                    As String*RTXMAXCOLSIZE%
  Start                   As Integer
  Size                    As Integer
  Style                   As Integer
  Total                   As Integer
  First                   As Integer
  Set                     As Integer
  Acc(0 To RTXMAXBREAKS%) As String*8
  OldData                 As String*RTXMAXCOLSIZE%
  NewData                 As String*RTXMAXCOLSIZE%
End Type
'
Type RtxBreakStruc
  Column  As Integer
  Count   As Integer
  Skip    As Integer
  Text    As String*RTXMAXCOLSIZE%
End Type
'
Declare Sub RtxClose (Copies%, Retain%)
Declare Sub RtxData (Column%, Contents$)
Declare Function RtxGetBreak ()
Declare Function RtxGetPage ()
Declare Function RtxGetRemaining ()
Declare Sub RtxInit ()
Declare Sub RtxNewPage ()
Declare Sub RtxOpen (FileName$, Overwrite%)
Declare Sub RtxOutput ()
Declare Function RtxResult ()
Declare Sub RtxSetBreak (Number%, Column%, Skip%, Text$)
Declare Sub RtxSetBreak0 (Text$)
Declare Sub RtxSetColumn (Column%, Label$, Source%, Mask$, Style%, Total%, First%)
Declare Sub RtxSetError (Row%)
Declare Sub RtxSetFooting (Num%, Text$, Style%)
Declare Sub RtxSetForm (Columns%, Lines%, LeftMargin%, TopMargin%, BottomMargin%)
Declare Sub RtxSetHeading (Num%, Text$, Style%)
Declare Sub RtxSetPrinter (Number%)
Declare Sub RtxSkip (Lines%)
Declare Sub RtxSuppress (Switch%)
'
Common Shared /Rtx/ GloReport   As RtxStruc
Common Shared /Rtx/ GloPrinter  As RtxPrinterStruc
Common Shared /Rtx/ GloHeader() As RtxHeaderFooterStruc
Common Shared /Rtx/ GloFooter() As RtxHeaderFooterStruc
Common Shared /Rtx/ GloColumn() As RtxColumnStruc
Common Shared /Rtx/ GloBreak()  As RtxBreakStruc
