'************************************************************
'*      Program Name    RLE.BAS                             *
'*      Author          Kenneth G. White                    *
'*      Date            9/3/90                              *
'*      Language        QuickBasic 4.x / PDS 7.x            *
'*      Purpose         RLE Data Compression Functions      *
'************************************************************
DECLARE FUNCTION compr$ (source$)
DECLARE FUNCTION uncompr$ (source$)
DEFINT A-Z

END

FUNCTION compr$ (source$)

slen = LEN(source$)
size$ = CHR$(slen \ 255)
size$ = size$ + CHR$(slen MOD 255)  'uncompressed buffer length

IF slen < 2 THEN
   compr$ = size$ + source$ 'if input 1-2 chars process and bail out
   EXIT FUNCTION
END IF

tcomp$ = size$ + SPACE$(slen * 2)  'set buffer length for worst case
count = 1                          'sequential char count
cspot = 1                          'input string read position
ncspot = 3                         'location of first buffer write
newchr = ASC(MID$(source$, cspot, 1)) 'get starting character
cspot = cspot + 1

DO
   DO
      nxtchr = ASC(MID$(source$, cspot, 1)) 'next char for comparison
      IF nxtchr = newchr THEN
         count = count + 1
         cspot = cspot + 1 'loop until char transition, end of input
      END IF               'or sequential char count of 255
   LOOP UNTIL nxtchr <> newchr OR cspot > slen OR count = 255
   SELECT CASE count
   CASE 1, 2                  'not enough chars to compress
      IF newchr <> 2 THEN
         MID$(tcomp$, ncspot, count) = STRING$(count, newchr)
         ncspot = ncspot + count
      ELSE            'process compression marker char as special case
         MID$(tcomp$, ncspot, 3) = CHR$(2)+CHR$(count)+CHR$(newchr)
         ncspot = ncspot + 3
      END IF
   CASE IS > 2             'encode sequential chars
      MID$(tcomp$, ncspot, 3) = CHR$(2) + CHR$(count) + CHR$(newchr)
      ncspot = ncspot + 3
   CASE ELSE               'don't process if char count = 0
   END SELECT
   count = 0
   newchr = nxtchr         'set up new comparison char
LOOP UNTIL cspot > slen

compr$ = LEFT$(tcomp$, ncspot - 1)
END FUNCTION

