 REM
 REM this program saves two pages of graphics to foo files then reads them back in
 REM information on screen mode 9:
 REM 1. each plane is 32K (32767) long
 REM 2. each page is 128K long
 REM 3. offset to page 1 is 32767 when saving 28000 length planes
 REM 4. there are only 2 pages when using this technique
 REM
 DECLARE SUB ega (myFile$, mode!, rw!)
 SCREEN 9
 LINE (0, 0)-(639, 349), , B          'draw a box to page 0
 FOR i = 1 TO 200                     'draw some lines to page 1
     x1 = INT(640 * RND)
     y1 = INT(350 * RND)
     x2 = INT(640 * RND)
     y2 = INT(350 * RND)
     co = INT(15 * RND)
     LINE (x1, y1)-(x2, y2), co
 NEXT i
 INPUT a$                              'pause, input something to stop pause
 SCREEN 9, 1, 1                        'change visual and active pages to 1
 PRINT "hello 9 - 1"
 FOR i = 1 TO 200                      'write some lines to page 1
     x1 = INT(640 * RND)
     y1 = INT(350 * RND)
     x2 = INT(640 * RND)
     y2 = INT(350 * RND)
     co = INT(15 * RND)
     LINE (x1, y1)-(x2, y2), co
 NEXT i
 SCREEN 9, 0, 0                         'change visual and active pages back to 0
 myFile$ = "foo"                        'filename to save graphics to
 mode = 9                               'screen mode 9 is used
 rw = 0                                 'save/load flag 0=save
 CALL ega(myFile$, mode, rw)            'call routine to save pages 1 and 0
 CLS
 INPUT "hit enter to restore the screen", a$
 rw = 1                                 'load in the graphics from foo
 CALL ega(myFile$, mode, rw)            'call routine
                                        'view page 0
 WHILE INKEY$ = "": WEND                'pause, hit key to continue
 SCREEN 9, 0, 1                         'view page 1
 END

 SUB ega (myFile$, mode, rw) STATIC
 SELECT CASE mode
    CASE 7
      total = 8000
    CASE 8
       total = 16000
    CASE 9 TO 10
       total = 65535               'save two pages of graphics
    CASE ELSE
       PRINT "error: nonega"
       GOTO noega
 END SELECT
 IF mode = 10 THEN cycle = 1 ELSE cycle = 3
 DEF SEG = &HA000
    FOR i = 0 TO cycle
       IF rw = 1 THEN
         OUT &H3C4, 2
         OUT &H3C5, 2 ^ i
         f$ = myFile$ + CHR$(i + 48) + ".EGA"
         BLOAD f$, 0
       ELSE
         OUT &H3CE, 4
         OUT &H3CF, i
         f$ = myFile$ + CHR$(i + 48) + ".EGA"
         BSAVE f$, 0, total
       END IF
     NEXT i
 DEF SEG
noega:
 END SUB

