'*****************************************************************
'***  QB4BAS.BI - Assembly Support Include File                ***
'***                                                           ***
'***        Written by Harold Thomson                          ***
'***                                                           ***
'***  Purpose:                                                 ***
'***       This include file gives the DECLARE statements for  ***
'***       the assembly language functions and subroutines     ***
'***       found in QB4BAS.LIB and QB4BAS.QLB.                 ***
'***                                                           ***
'*****************************************************************
'
'*****************************************************************
'***        DATE Related Functions and SubRoutines ...         ***
'*****************************************************************
'
'Function ****************** QDATECVT ******************* Function
'
DECLARE FUNCTION QDATECVT$ (InDate AS STRING, _
                            FunCode AS STRING)
'
'Function ****************** QDATE    ******************* Function
'
DECLARE FUNCTION QDATE$ (FunCode AS STRING)
'
'Function ****************** QDATEIN  ******************* Function
'
DECLARE FUNCTION QDATEIN$ (InDate AS STRING, _
                           FunCode AS STRING)
'
'Function ***************** QDATE2INT ******************* Function
'
DECLARE FUNCTION QDATE2INT% (InDate AS STRING)
'
'Function ***************** QINT2DATE ******************* Function
'
DECLARE FUNCTION QINT2DATE$ (BYVAL InDate AS INTEGER)
'
'Function ****************** QJULCALC ******************* Function
'
DECLARE FUNCTION QJULCALC% (CalcDate AS STRING, _
                            BYVAL Amount AS INTEGER)
'
'
'*****************************************************************
'***        DISK Related Functions and SubRoutines ...         ***
'*****************************************************************
'
'SubRoutine **************** QDISKSTAT **************** SubRoutine
'
DECLARE SUB QDISKSTAT (DrvName AS STRING, _
                       FreeClusters AS INTEGER, _
                       TotClusters AS INTEGER, _
                       SectorSize AS INTEGER, _
                       SectorsCluster AS INTEGER)
'
'Function ****************** QDISKTYP  ****************** Function
'
DECLARE FUNCTION QDISKTYP% ()
'
'Function ****************** QDRVSPACE ****************** Function
'
DECLARE FUNCTION QDRVSPACE& (DrvName AS STRING)
'
'Function ****************** QGETDRV  ******************* Function
'
DECLARE FUNCTION QGETDRV$ ()
'
'Function ****************** QGETVOL  ******************* Function
'
DECLARE FUNCTION QGETVOL$ ()
'
'SubRoutine **************** QSETDRV  ***************** SubRoutine
'
DECLARE SUB QSETDRV (DrvName AS STRING)
'
'Function ****************** QSETVOL  ******************* Function
'
DECLARE FUNCTION QSETVOL% (Volid AS STRING)
'
'
'*****************************************************************
'***        FILE Related Functions and SubRoutines ...         ***
'*****************************************************************
'
'Function ****************** QCNTFILE ******************* Function
'
DECLARE FUNCTION QCNTFILE% (InFileName AS STRING, _
                            BYVAL Attr AS INTEGER)
'
'Function ****************** QCOPYFIL ******************* Function
'
DECLARE FUNCTION QCOPYFIL% (InFileName AS STRING, _
                            OutFileName AS STRING)
'
'Function ****************** QDELETE  ******************* Function
'
DECLARE FUNCTION QDELETE% (FileName AS STRING)
'
'Function ****************** QEXIST   ******************* Function
'
DECLARE FUNCTION QEXIST% (FileName AS STRING)
'
'Function **************** QFINDFIRST ******************* Function
'
DECLARE FUNCTION QFINDFIRST% (BYVAL Trec AS INTEGER, _
                              DrvStr AS STRING, _
                              BYVAL Attr AS INTEGER)
'
'Function **************** QFINDNEXT  ******************* Function
'
DECLARE FUNCTION QFINDNEXT% (BYVAL Trec AS INTEGER)
'
'Function ****************** QFINDF   ******************* Function
'
DECLARE FUNCTION QFINDF% (FileName AS STRING, _
                          BYVAL Attr AS INTEGER)
'
'Function ****************** QFINDN   ******************* Function
'
DECLARE FUNCTION QFINDN% ()
'
'SubRoutine **************** QFATTR   ***************** SubRoutine
'
DECLARE SUB QFATTR (Attr AS INTEGER)
'
'SubRoutine **************** QFDATE   ***************** SubRoutine
'
DECLARE SUB QFDATE (Month AS INTEGER, _
                    Day AS INTEGER, _
                    Year AS INTEGER)
'
'SubRoutine **************** QFDATEI  ***************** SubRoutine
'
DECLARE SUB QFDATEI (MDY AS INTEGER)
'
'SubRoutine **************** QFNAME   ***************** SubRoutine
'
DECLARE SUB QFNAME (FileName AS STRING)
'
'SubRoutine **************** QFSIZE   ***************** SubRoutine
'
DECLARE SUB QFSIZE (Size AS LONG)
'
'SubRoutine **************** QFSTAMP  ***************** SubRoutine
'
DECLARE FUNCTION QFSTAMP (Qfilname AS STRING, _
                          Qfiltime AS STRING, _
                          Qfildate AS STRING)
'
'SubRoutine **************** QFTIME   ***************** SubRoutine
'
DECLARE SUB QFTIME (Hrs AS INTEGER, _
                    Min AS INTEGER)
'
'Function ****************** QFCREATE ******************* Function
'
DECLARE FUNCTION QFCREATE% (FileName AS STRING, _
                            BYVAL FAttr AS INTEGER, _
                            Handle AS INTEGER)
'
'Function ****************** QFOPEN   ******************* Function
'
DECLARE FUNCTION QFOPEN% (FileName AS STRING, _
                          BYVAL FAccess AS INTEGER, _
                          Handle AS INTEGER)
'
'Function ****************** QFREAD   ******************* Function
'
DECLARE FUNCTION QFREAD% (BYVAL Handle AS INTEGER, _
                          Buffer AS STRING, _
                          BYVAL ReadLen AS INTEGER, _
                          BytesRead AS INTEGER)
'
'Function ****************** QFSETEND ******************* Function
'
DECLARE FUNCTION QFSETEND% (BYVAL Handle AS INTEGER)
'
'Function ****************** QFSETREC ******************* Function
'
DECLARE FUNCTION QFSETREC% (BYVAL Handle AS INTEGER, _
                            BYVAL RecLen AS INTEGER, _
                            BYVAL RecNum AS INTEGER)
'
'Function ****************** QFSETRECL ****************** Function
'
DECLARE FUNCTION QFSETRECL% (BYVAL Handle AS INTEGER, _
                             BYVAL RecLen AS INTEGER, _
                             BYVAL RecNum AS LONG)
'
'Function ******************** QFLOF ******************** Function
'
DECLARE FUNCTION QFLOF& (BYVAL Handle AS INTEGER)
'
'Function ****************** QFWRITE  ******************* Function
'
DECLARE FUNCTION QFWRITE% (BYVAL Handle AS INTEGER, _
                           Buffer AS STRING, _
                           BYVAL WriteLen AS INTEGER, _
                           BytesWritten AS INTEGER)
'
'Function ****************** QFCLOSE  ******************* Function
'
DECLARE FUNCTION QFCLOSE% (BYVAL Handle AS INTEGER)
'
'Function ****************** QMOVEFIL ******************* Function
'
DECLARE FUNCTION QMOVEFIL% (InFileName AS STRING, _
                            OutFileName AS STRING)
'
'Function ****************** QPARSEF  ******************* Function
'
DECLARE FUNCTION QPARSEF% (Pstring AS STRING, _
                           BYVAL Pseg AS INTEGER, _
                           BYVAL Pptr AS INTEGER)
'
'Function ****************** QRENAME  ******************* Function
'
DECLARE FUNCTION QRENAME% (InFileName AS STRING, _
                           OutFileName AS STRING)
'
'Function ******************* QSHARE ******************** Function
'
DECLARE FUNCTION QSHARE% ()
'
'Function ****************** QTREAD   ******************* Function
'
DECLARE FUNCTION QTREAD% (BYVAL Handle AS INTEGER, _
                          BYVAL BufSeg AS INTEGER, _
                          BYVAL BufPtr AS INTEGER, _
                          BYVAL ReadLen AS INTEGER, _
                          BytesRead AS INTEGER)
'
'Function ****************** QTWRITE  ******************* Function
'
DECLARE FUNCTION QTWRITE% (BYVAL Handle AS INTEGER, _
                           BYVAL BufSeg AS INTEGER, _
                           BYVAL BufPtr AS INTEGER, _
                           BYVAL WriteLen AS INTEGER, _
                           BytesWritten AS INTEGER)
'
'
'*****************************************************************
'*** KEYBOARD Related Functions and SubRoutines ...            ***
'*****************************************************************
'
'Function ****************** QALTKEY  ******************* Function
'
DECLARE FUNCTION QALTKEY% ()
'
'Function ****************** QCAPSKEY ******************* Function
'
DECLARE FUNCTION QCAPSKEY% ()
'
'Function ****************** QCTRLKEY ******************* Function
'
DECLARE FUNCTION QCTRLKEY% ()
'
'Function ****************** QGETKEY  ******************* Function
'
DECLARE FUNCTION QGETKEY% (Character AS STRING)
'
'Function ****************** QINKEY   ******************* Function
'
DECLARE FUNCTION QINKEY% (Character AS STRING)
'
'Function ****************** QINPUT   ******************* Function
'
DECLARE FUNCTION QINPUT% (VerStr AS STRING, _
                          Buffer AS STRING, _
                          BYVAL Row AS INTEGER, _
                          BYVAL Col AS INTEGER, _
                          BYVAL Attr AS INTEGER, _
                          BYVAL Page AS INTEGER, _
                          BYVAL Keys AS INTEGER)
'
'Function ****************** QINPUTM  ******************* Function
'
DECLARE FUNCTION QINPUTM% (VerStr AS STRING, _
                           Buffer AS STRING, _
                           Mask AS STRING, _
                           BYVAL Row AS INTEGER, _
                           BYVAL Col AS INTEGER, _
                           BYVAL Attr AS INTEGER, _
                           BYVAL Page AS INTEGER, _
                           BYVAL Keys AS INTEGER)
'
'Function ****************** QKEYFLAG ******************* Function
'
DECLARE FUNCTION QKEYFLAG% ()
'
'Function ****************** QKEYSTAT ******************* Function
'
DECLARE FUNCTION QKEYSTAT% ()
'
'Function ****************** QNUMKEY  ******************* Function
'
DECLARE FUNCTION QNUMKEY% ()
'
'Function ****************** QPOPMENU ******************* Function
'
DECLARE FUNCTION QPOPMENU% (BYVAL Count AS INTEGER, _
                            BYVAL MenuSeg AS INTEGER, _
                            BYVAL MenuOff AS INTEGER, _
                            BYVAL Row AS INTEGER, _
                            BYVAL Col AS INTEGER, _
                            BYVAL Norm AS INTEGER, _
                            BYVAL Actn AS INTEGER, _
                            BYVAL High AS INTEGER, _
                            BYVAL Page AS INTEGER)
'
'Function ****************** QMENU    ******************* Function
'
DECLARE FUNCTION QMENU% (BYVAL Count AS INTEGER, _
                         BYVAL MenuSeg AS INTEGER, _
                         BYVAL MenuOff AS INTEGER, _
                         BYVAL Row AS INTEGER, _
                         BYVAL Col AS INTEGER, _
                         BYVAL Norm AS INTEGER, _
                         BYVAL Actn AS INTEGER, _
                         BYVAL High AS INTEGER, _
                         BYVAL Page AS INTEGER)
'
'Function ****************** QMENUS   ******************* Function
'
DECLARE FUNCTION QMENUS% (BYVAL Count AS INTEGER, _
                          BYVAL MenuSeg AS INTEGER, _
                          BYVAL MenuOff AS INTEGER, _
                          BYVAL Row AS INTEGER, _
                          BYVAL Norm AS INTEGER, _
                          BYVAL Actn AS INTEGER, _
                          BYVAL High AS INTEGER, _
                          BYVAL Page AS INTEGER)
'
'Function ****************** QSCRLKEY ******************* Function
'
DECLARE FUNCTION QSCRLKEY% ()
'
'Function ******************* QYESNO ******************** Function
'
DECLARE FUNCTION QYESNO% ()
'
'
'*****************************************************************
'***    MISCELLANEOUS Related Functions and SubRoutines ...    ***
'*****************************************************************
'
'SubRoutine **************** QALARM  ****************** SubRoutine
'
DECLARE SUB QALARM ()
'
'Function ******************  QARGC  ******************** Function
'
DECLARE FUNCTION QARGC% ()
'
'Function ******************  QARGV  ******************** Function
'
DECLARE FUNCTION QARGV$ (BYVAL ArgNumber AS INTEGER)
'
'Function ***************** QBSTCHT ********************* Function
'
DECLARE FUNCTION QBSRCHT% (BYVAL Vseg AS INTEGER, _
                           BYVAL Vptr AS INTEGER, _
                           BYVAL Rlen AS INTEGER, _
                           BYVAL Nrec AS INTEGER, _
                           TstStr AS STRING)
'
'SubRoutine **************** QCAPSOFF ***************** SubRoutine
'
DECLARE SUB QCAPSOFF ()
'
'SubRoutine **************** QCAPSON  ***************** SubRoutine
'
DECLARE SUB QCAPSON ()
'
'SubRoutine **************** QCLOCK   ***************** SubRoutine
'
DECLARE SUB QCLOCK (BYVAL Row AS INTEGER, _
                    BYVAL Col AS INTEGER, _
                    BYVAL NAttr AS INTEGER, _
                    BYVAL Page AS INTEGER, _
                    BYVAL Switch AS INTEGER)
'
'Function ****************** QCMDLEN  ******************* Function
'
DECLARE FUNCTION QCMDLEN% ()
'
'Function ****************** QCMDLINE ******************* Function
'
DECLARE FUNCTION QCMDLINE$ ()
'
'Function ****************** QCRCCHK  ******************* Function
'
DECLARE FUNCTION QCRCCHK% (Record AS STRING)
'
'Function ****************** QCRCSET  ******************* Function
'
DECLARE FUNCTION QCRCSET% (Record AS STRING)
'
'SubRoutine **************** QDOSVER  ***************** SubRoutine
'
DECLARE SUB QDOSVER (Major AS INTEGER, _
                     Minor AS INTEGER)
'
'SubRoutine **************** QEMSSIZE ***************** SubRoutine
'
DECLARE SUB QEMSSIZE (Total AS INTEGER, _
                      Free AS INTEGER)
'
'SubRoutine *************** QEQUIPMENT **************** SubRoutine
'
DECLARE SUB QEQUIPMENT (Memory AS INTEGER, _
                        Parallel AS INTEGER, _
                        Serial AS INTEGER, _
                        Game AS INTEGER)
'
'Function ******************* QEXEC ********************* Function
'
DECLARE FUNCTION QEXEC% (PgmName AS STRING)
'
'SubRoutine **************** QEXIT    ***************** SubRoutine
'
DECLARE SUB QEXIT (BYVAL ErrorLevel AS INTEGER)
'
'Function ****************** QINPORT ******************** Function
'
DECLARE FUNCTION QINPORT% (BYVAL Port AS INTEGER)
'
'Function ****************** QMAXINT ******************** Function
'
DECLARE FUNCTION QMAXINT% (BYVAL Num1 AS INTEGER, _
                           BYVAL Num2 AS INTEGER)
'
'Function ****************** QMININT ******************** Function
'
DECLARE FUNCTION QMININT% (BYVAL Num1 AS INTEGER, _
                           BYVAL Num2 AS INTEGER)
'
'Function ***************** QMAXLONG ******************** Function
'
DECLARE FUNCTION QMAXLONG& (BYVAL Num1 AS LONG, _
                            BYVAL Num2 AS LONG)
'
'Function ***************** QMINLONG ******************** Function
'
DECLARE FUNCTION QMINLONG& (BYVAL Num1 AS LONG, _
                            BYVAL Num2 AS LONG)
'
'SubRoutine ************* QNUMLOCKOFF ***************** SubRoutine
'
DECLARE SUB QNUMLOCKOFF ()
'
'SubRoutine ************* QNUMLOCKON  ***************** SubRoutine
'
DECLARE SUB QNUMLOCKON ()
'
'Function ****************** QPRINTER ******************* Function
'
DECLARE FUNCTION QPRINTER% ()
'
'SubRoutine **************** QPRTSCRN ***************** SubRoutine
'
DECLARE SUB QPRTSCRN ()
'
'SubRoutine ************* QPRTSCRNOFF ***************** SubRoutine
'
DECLARE SUB QPRTSCRNOFF ()
'
'SubRoutine ************* QPRTSCRNON  ***************** SubRoutine
'
DECLARE SUB QPRTSCRNON ()
'
'SubRoutine **************** QPAUSE   ***************** SubRoutine
'
DECLARE SUB QPAUSE (BYVAL Seconds AS INTEGER)
'
'SubRoutine **************** QPAUSE18 ***************** SubRoutine
'
DECLARE SUB QPAUSE18 (BYVAL Count AS INTEGER)
'
'SubRoutine **************** QREBOOT ****************** SubRoutine
'
DECLARE SUB QREBOOT ()
'
'SubRoutine **************** QSCRLOFF ***************** SubRoutine
'
DECLARE SUB QSCRLOFF ()
'
'SubRoutine **************** QSCRLON  ***************** SubRoutine
'
DECLARE SUB QSCRLON ()
'
'Function ****************** QSHIFTIL ******************* Function
'
DECLARE FUNCTION QSHIFTIL% (BYVAL Number AS INTEGER, _
                            BYVAL Shift AS INTEGER)
'
'Function ****************** QSHIFTIR ******************* Function
'
DECLARE FUNCTION QSHIFTIR% (BYVAL Number AS INTEGER, _
                            BYVAL Shift AS INTEGER)
'
'Function ****************** QSHIFTLL ******************* Function
'
DECLARE FUNCTION QSHIFTLL& (BYVAL Number AS LONG, _
                            BYVAL Shift AS INTEGER)
'
'Function ****************** QSHIFTLR ******************* Function
'
DECLARE FUNCTION QSHIFTLR& (BYVAL Number AS LONG, _
                            BYVAL Shift AS INTEGER)
'
'Function ******************* QTEMPC ******************** Function
'
DECLARE FUNCTION QTEMPC% (BYVAL Temp AS INTEGER)
'
'Function ******************* QTEMPF ******************** Function
'
DECLARE FUNCTION QTEMPF% (BYVAL Temp AS INTEGER)
'
'SubRoutine ***************** QTIME  ****************** SubRoutine
'
DECLARE SUB QTIME (Hours AS INTEGER, _
                   Minutes AS INTEGER, _
                   Seconds AS INTEGER, _
                   TotSeconds AS LONG)
'
'Function ****************** QVERIFY  ******************* Function
'
DECLARE FUNCTION QVERIFY% ()
'
'SubRoutine *************** QVERIFYOFF **************** SubRoutine
'
DECLARE SUB QVERIFYOFF ()
'
'SubRoutine *************** QVERIFYON ***************** SubRoutine
'
DECLARE SUB QVERIFYON ()
'
'Function ******************* Q8087 ********************* Function
'
DECLARE FUNCTION Q8087% ()
'
'
'*****************************************************************
'***        STRING Related Functions and SubRoutines ...       ***
'*****************************************************************
'
'SubRoutine **************** QCAPIT   ***************** SubRoutine
'
DECLARE SUB QCAPIT (Cstring AS STRING)
'
'SubRoutine **************** QCENTER  ***************** SubRoutine
'
DECLARE SUB QCENTER (Cstring AS STRING)
'
'Function ****************** QCHARTYP ******************* Function
'
DECLARE FUNCTION QCHARTYP% (InString AS STRING, _
                            VerStr AS STRING)
'
'Function ****************** QDELIM   ******************* Function
'
DECLARE FUNCTION QDELIM% (StringName AS STRING, _
                          BYVAL Index AS INTEGER, _
                          Start AS INTEGER, _
                          StrLen AS INTEGER)
'
'Function ****************** QEXTRACT ******************* Function
'
DECLARE FUNCTION QEXTRACT% (StringName AS STRING, _
                            Delim AS STRING, _
                            BYVAL Index AS INTEGER, _
                            Start AS INTEGER, _
                            StrLen AS INTEGER)
'
'Function ****************** QFORMAT ******************** Function
'
DECLARE FUNCTION QFORMAT$ (StrIn AS STRING, _
                           Mask AS STRING)
'
'SubRoutine **************** QHIGHBIT ***************** SubRoutine
'
DECLARE SUB QHIGHBIT (Cstring AS STRING)
'
'Function ******************  QINSTR  ******************* Function
'
DECLARE FUNCTION QINSTR% (StrIn AS STRING, _
                          TstStr AS STRING, _
                          Index AS INTEGER)
'
'Function ******************** QLEN ********************* Function
'
DECLARE FUNCTION QLEN% (StringName AS STRING)
'
'Function ******************* QMID ********************** Function
'
DECLARE FUNCTION QMID% (FromStr AS STRING, _
                        ToStr AS STRING, _
                        BYVAL Start AS INTEGER)
'
'Function ****************** QMOVREC ******************** Function
'
DECLARE FUNCTION QMOVREC$ (BYVAL PrtR AS INTEGER, _
                           BYVAL LenR AS INTEGER)
'
'SubRoutine **************** QMOVSTR  ***************** SubRoutine
'
DECLARE SUB QMOVSTR (BYVAL PrtR AS INTEGER, _
                     BYVAL LenR AS INTEGER, _
                     Buffer AS STRING)
'
'SubRoutine **************** QREPLACE ***************** SubRoutine
'
DECLARE SUB QREPLACE (StringName AS STRING, _
                      OldStr AS STRING, _
                      NewStr AS STRING)
'
'Function ****************** QREVERSE ******************* Function
'
DECLARE FUNCTION QREVERSE$ (StrIn AS STRING)
'
'Function ****************** QRINSTR  ******************* Function
'
DECLARE FUNCTION QRINSTR% (StrIn AS STRING, _
                          TstStr AS STRING, _
                          Index AS INTEGER)
'
'Function ******************* QSTRIP ******************** Function
'
DECLARE FUNCTION QSTRIP$ (StringName AS STRING)
'
'Function ****************** QSTRPCHR ******************* Function
'
DECLARE FUNCTION QSTRPCHR$ (StringName AS STRING)
'
'Function ****************** QSUBSTR ******************** Function
'
DECLARE FUNCTION QSUBSTR$ (FromStr AS STRING, _
                           BYVAL Start AS INTEGER, _
                           BYVAL Length AS INTEGER)
'
'Function ****************** QWORD    ******************* Function
'
DECLARE FUNCTION QWORD$ (StringName AS STRING, _
                         BYVAL Index AS INTEGER)
'
'Function ****************** QWORDS   ******************* Function
'
DECLARE FUNCTION QWORDS% (StringName AS STRING)
'
'
'*****************************************************************
'*** SUB-DIRECTORY Related Functions and SubRoutines ...       ***
'*****************************************************************
'
'Function ****************** QCHDIR   ******************* Function
'
DECLARE FUNCTION QCHDIR% (DirName AS STRING)
'
'Function ****************** QCHKDIR  ******************* Function
'
DECLARE FUNCTION QCHKDIR% (DirName AS STRING)
'
'Function ****************** QGETDIR  ******************* Function
'
DECLARE FUNCTION QGETDIR$ ()
'
'Function ****************** QMKDIR   ******************* Function
'
DECLARE FUNCTION QMKDIR% (DirName AS STRING)
'
'Function ****************** QRMDIR   ******************* Function
'
DECLARE FUNCTION QRMDIR% (DirName AS STRING)
'
'
'*****************************************************************
'*** VIDEO Related Functions and SubRoutines ...               ***
'*****************************************************************
'
'Function ****************** QANSIPRT ******************* Function
'
DECLARE SUB QANSIPRT (PrtString AS STRING)
'
'Function ****************** QATTR    ******************* Function
'
DECLARE FUNCTION QATTR% (BYVAL Fore AS INTEGER, _
                        BYVAL Back AS INTEGER)
'
'SubRoutine **************** QCLREOL  ***************** SubRoutine
'
DECLARE SUB QCLREOL ()
'
'Function ****************** QGETMODE ******************* Function
'
DECLARE FUNCTION QGETMODE% ()
'
'SubRoutine **************** QCRTMODE ***************** SubRoutine
'
DECLARE SUB QCRTMODE (CrtType AS INTEGER, _
                      CrtCols AS INTEGER)
'
'SubRoutine **************** QBPRT    ***************** SubRoutine
'
DECLARE SUB QBPRT (PrtLine AS STRING, _
                   BYVAL Row AS INTEGER, _
                   BYVAL Col AS INTEGER, _
                   BYVAL Attr AS INTEGER, _
                   BYVAL Page AS INTEGER)
'
'SubRoutine **************** QPRT     ***************** SubRoutine
'
DECLARE SUB QPRT (PrtLine AS STRING, _
                  BYVAL Row AS INTEGER, _
                  BYVAL Col AS INTEGER, _
                  BYVAL Attr AS INTEGER, _
                  BYVAL Page AS INTEGER)
'
'SubRoutine **************** QBMPRT   ***************** SubRoutine
'
DECLARE SUB QBMPRT (BYVAL Elements AS INTEGER, _
                    BYVAL VSeg AS INTEGER, _
                    BYVAL VOff AS INTEGER, _
                    BYVAL Row AS INTEGER, _
                    BYVAL Col AS INTEGER, _
                    BYVAL Attr AS INTEGER, _
                    BYVAL Page AS INTEGER)
'
'SubRoutine **************** QMPRT    ***************** SubRoutine
'
DECLARE SUB QMPRT (BYVAL Elements AS INTEGER, _
                   BYVAL VSeg AS INTEGER, _
                   BYVAL VOff AS INTEGER, _
                   BYVAL Row AS INTEGER, _
                   BYVAL Col AS INTEGER, _
                   BYVAL Attr AS INTEGER, _
                   BYVAL Page AS INTEGER)
'
'SubRoutine **************** QPAINT ******************* SubRoutine
'
DECLARE SUB QPAINT (BYVAL TRow AS INTEGER, _
                    BYVAL LCol AS INTEGER, _
                    BYVAL BRow AS INTEGER, _
                    BYVAL RCol AS INTEGER, _
                    BYVAL Attr AS INTEGER, _
                    BYVAL Page AS INTEGER)
'
'Function ***************** QPRTANSI ******************** Function
'
DECLARE SUB QPRTANSI (PrtString AS STRING, _
                      BYVAL Row AS INTEGER, _
                      BYVAL Col AS INTEGER, _
                      BYVAL Awindow AS INTEGER)
'
'SubRoutine **************** QRESTSCR ***************** SubRoutine
'
DECLARE SUB QRESTSCR (BYVAL TRow AS INTEGER, _
                      BYVAL LCol AS INTEGER, _
                      BYVAL BRow AS INTEGER, _
                      BYVAL RCol AS INTEGER, _
                      BYVAL Page AS INTEGER, _
                      BYVAL VSeg AS INTEGER, _
                      BYVAL VPtr AS INTEGER)
'
'SubRoutine **************** QSAVESCR ***************** SubRoutine
'
DECLARE SUB QSAVESCR (BYVAL TRow AS INTEGER, _
                      BYVAL LCol AS INTEGER, _
                      BYVAL BRow AS INTEGER, _
                      BYVAL RCol AS INTEGER, _
                      BYVAL Page AS INTEGER, _
                      BYVAL VSeg AS INTEGER, _
                      BYVAL VPtr AS INTEGER)
'
'SubRoutine **************** QSCROLL  ***************** SubRoutine
'
DECLARE SUB QSCROLL (BYVAL TRow AS INTEGER, _
                     BYVAL LCol AS INTEGER, _
                     BYVAL BRow AS INTEGER, _
                     BYVAL RCol AS INTEGER, _
                     BYVAL Lines AS INTEGER)
'
'SubRoutine **************** QSCROLLB ***************** SubRoutine
'
DECLARE SUB QSCROLLB (BYVAL TRow AS INTEGER, _
                      BYVAL LCol AS INTEGER, _
                      BYVAL BRow AS INTEGER, _
                      BYVAL RCol AS INTEGER, _
                      BYVAL Lines AS INTEGER)
'
'Function ****************** QSCRREST ******************* Function
'
DECLARE FUNCTION QSCRREST% (BYVAL ASeg AS INTEGER, _
                            BYVAL AOffset AS INTEGER, _
                            BYVAL Page AS INTEGER)
'
'Function ****************** QSCRSAVE ******************* Function
'
DECLARE FUNCTION QSCRSAVE% (BYVAL ASeg AS INTEGER, _
                            BYVAL AOffset AS INTEGER, _
                            BYVAL Page AS INTEGER)
'
'SubRoutine **************** QSETMODE ***************** SubRoutine
'
DECLARE SUB QSETMODE (BYVAL Vmode as INTEGER)
'
'Function ****************** QVIDREST ******************* Function
'
DECLARE FUNCTION QVIDREST% (BYVAL Page AS INTEGER)
'
'Function ****************** QVIDSAVE ******************* Function
'
DECLARE FUNCTION QVIDSAVE% (BYVAL Page AS INTEGER)
'
'SubRoutine **************** QWINDOW  ***************** SubRoutine
'
DECLARE SUB QWINDOW (BYVAL TRow AS INTEGER, _
                     BYVAL LCol AS INTEGER, _
                     BYVAL BRow AS INTEGER, _
                     BYVAL RCol AS INTEGER, _
                     BYVAL Frame AS INTEGER, _
                     BYVAL Attr AS INTEGER, _
                     BYVAL Page AS INTEGER)
'
'SubRoutine **************** QWINDOWH ***************** SubRoutine
'
DECLARE SUB QWINDOWH (BYVAL TRow AS INTEGER, _
                      BYVAL LCol AS INTEGER, _
                      BYVAL BRow AS INTEGER, _
                      BYVAL RCol AS INTEGER, _
                      BYVAL NLine AS INTEGER, _
                      BYVAL ASeg AS INTEGER, _
                      BYVAL AOff AS INTEGER, _
                      BYVAL Frame AS INTEGER, _
                      BYVAL Attr AS INTEGER, _
                      BYVAL Page AS INTEGER)
'
'SubRoutine **************** QWINDOWV ***************** SubRoutine
'
DECLARE SUB QWINDOWV (BYVAL TRow AS INTEGER, _
                      BYVAL LCol AS INTEGER, _
                      BYVAL BRow AS INTEGER, _
                      BYVAL RCol AS INTEGER, _
                      BYVAL NLine AS INTEGER, _
                      BYVAL ASeg AS INTEGER, _
                      BYVAL AOff AS INTEGER, _
                      BYVAL Frame AS INTEGER, _
                      BYVAL Attr AS INTEGER, _
                      BYVAL Page AS INTEGER)
'
'SubRoutine **************** QWINDOWX ***************** SubRoutine
'
DECLARE SUB QWINDOWX (BYVAL TRow AS INTEGER, _
                      BYVAL LCol AS INTEGER, _
                      BYVAL BRow AS INTEGER, _
                      BYVAL RCol AS INTEGER, _
                      BYVAL Frame AS INTEGER, _
                      BYVAL Attr AS INTEGER, _
                      BYVAL Attrs AS INTEGER, _
                      BYVAL Page AS INTEGER)
'
'Function ****************** QGETATTR ******************* Function
'
DECLARE FUNCTION QGETATTR% (BYVAL Row AS INTEGER, _
                            BYVAL Col AS INTEGER)
'
'SubRoutine **************** QGETCURS ***************** SubRoutine
'
DECLARE SUB QGETCURS (Row AS INTEGER, _
                      Col AS INTEGER, _
                      Page AS INTEGER)
'
'
'*****************************************************************
'*** MOUSE Related Functions and SubRoutines ...               ***
'*****************************************************************
'
'SUB *********************** QMHIDE ************************** SUB
'
DECLARE SUB QMHIDE ()
'
'Function ****************** QMLOC ********************** Function
'
DECLARE FUNCTION QMLOC% (Xloc AS INTEGER, _
                         Yloc AS INTEGER)
'
'Function ****************** QMPRESS ******************** Function
'
DECLARE FUNCTION QMPRESS% (BYVAL MKey AS INTEGER, _
                           Ctr AS INTEGER, _
                           Xloc AS INTEGER, _
                           Yloc AS INTEGER)
'
'SUB *********************** QMSET *************************** SUB
'
DECLARE SUB QMSET (BYVAL Xloc AS INTEGER, _
                   BYVAL Yloc AS INTEGER)
'
'SUB *********************** QMSHOW ************************** SUB
'
DECLARE SUB QMSHOW ()
'
'Function ***************** QMSTATUS ******************** Function
'
DECLARE FUNCTION QMSTATUS% ()
'
'*****************************************************************
'*** The End ...                                               ***
'*****************************************************************

TYPE FileInfo
     Fname AS STRING * 12
     Fdate AS STRING * 8
     Ftime AS STRING * 5
     Fsize AS LONG
     Fattr AS INTEGER
     Fmonth AS INTEGER
     Fday AS INTEGER
     Fyear AS INTEGER
     Fhour AS INTEGER
     Fminute AS INTEGER
END TYPE

TYPE ParseType
     Pdrive AS STRING * 2
     Ppath AS STRING * 64
     Pname AS STRING * 8
     Pext AS STRING * 3
END TYPE
