'    This program show how to display a PCX file in Screen 9 and
'    Screen 12.

DECLARE SUB ShowPCX ()

'--- Define the header of the PCX file

TYPE PCXheaderform
     manufacturer AS STRING * 1
     version AS STRING * 1
     encoding AS STRING * 1
     bitsperpixel AS STRING * 1
     xmin AS INTEGER
     ymin AS INTEGER
     xmax AS INTEGER
     ymax AS INTEGER
     hres AS INTEGER
     vres AS INTEGER
     egapalette AS STRING * 48
     reserved AS STRING * 1
     colourplanes AS STRING * 1
     bytesperline AS INTEGER
     palettetype AS INTEGER
     filler AS STRING * 58
END TYPE

DIM SHARED TheHeader AS PCXheaderform

'--- Open the file and get the header.
OPEN COMMAND$ FOR BINARY AS 1
GET #1, , TheHeader

'--- Check the file.
IF TheHeader.manufacturer <> CHR$(&HA) THEN
     PRINT "This is not a PCX file!"
     END
END IF

'--- Display the Header information.
CLS
PRINT "File: "; COMMAND$
PRINT "Manufacturer code: ", HEX$(ASC(TheHeader.manufacturer))
PRINT "Version number: ", ASC(TheHeader.version)
PRINT "Encoding number: ", ASC(TheHeader.encoding)
PRINT "Bits per Pixel: ", ASC(TheHeader.bitsperpixel)
PRINT "Xmin, Ymin: ", TheHeader.xmin, TheHeader.ymin
PRINT "Xmax, Ymax: ", TheHeader.xmax, TheHeader.ymax
PRINT "Resolutions Horizonal, Vertical: ", TheHeader.hres, TheHeader.vres

'--- Show the Palette values.
PRINT "Palette values: ";
FOR i% = 1 TO 47
     PRINT ASC(MID$(TheHeader.egapalette, i%, 1));
NEXT i%
PRINT ASC(MID$(TheHeader.egapalette, 48, 1))

PRINT "Reserved: ", ASC(TheHeader.reserved)
PRINT "Number of color planes: ", ASC(TheHeader.colourplanes)
PRINT "Bytes per line: ", TheHeader.bytesperline
PRINT "Palette type: ", TheHeader.palettetype

CLOSE #1

'--- Wait for input.
PRINT "Hit a key to display the file...."
DO: x$ = INKEY$: LOOP WHILE x$ = ""

'--- Call the sub to display the file.
ShowPCX

END






SUB ShowPCX

'    The subprogram display a PCX file in either 640 x 350 x 16 or
'    640 x 480 x 16.

'--- The setup.
DIM Cpalette%(48), PalArray&(16)
DIM Byte AS STRING * 1
DIM Addr AS LONG

OPEN COMMAND$ FOR BINARY AS 1
'GET #1, TheHeader

'--- Set the screen and palette.
CLS

FOR i% = 0 TO 47
     Cpalette%(i%) = ASC(MID$(TheHeader.egapalette, i% + 1, 1))
NEXT i%

SELECT CASE TheHeader.vres
     CASE 350
          SCREEN 9, , 0
          FOR j% = 0 TO 15
               Red% = Cpalette%(j% * 3) / 85
               Green% = Cpalette%((j% * 3) + 1) / 85
               Blue% = Cpalette%((j% * 3) + 2) / 85
               Red% = ((Red% AND 1) * 32) OR ((Red% AND 2) * 2)
               Green% = ((Green% AND 1) * 16) OR (Green% AND 2)
               Blue% = ((Blue% AND 1) * 8) OR ((Blue% AND 2) \ 2)
               Hue% = Red% OR Green% OR Blue%
               PalArray&(j%) = Hue%
          NEXT j%

     CASE 480
          SCREEN 12, , 0
          FOR j% = 0 TO 15
               Red% = INT(Cpalette%(j% * 3) / 4)
               Green% = INT(Cpalette%((j% * 3) + 1) / 4)
               Blue% = INT(Cpalette%((j% * 3) + 2) / 4)
               PalArray&(j%) = 65536 * Blue% + 256 * Green% + Red%
          NEXT j%
     CASE ELSE
          PRINT "This file can not be displayed."
          CLOSE #1
          EXIT SUB
END SELECT

PALETTE USING PalArray&(0)

'--- Set the file pointer and the segment.
SEEK #1, 129
DEF SEG = &HA000

'--- Decode and Read the bit map.
FOR k& = TheHeader.ymin TO TheHeader.ymax
     Addr = 80 * k&
     LineEnd& = Addr + TheHeader.bytesperline
     j% = 1
     DO WHILE j% <= 4
          b% = j%
          IF j% = 3 THEN b% = 4
          IF j% = 4 THEN b% = 8
          OUT &H3C4, 2: OUT &H3C5, b%
          GET #1, , Byte
          byte.1% = ASC(Byte)
          IF (byte.1% AND 192) <> 192 THEN
               POKE Addr, byte.1%
               Addr = Addr + 1
               IF Addr >= LineEnd& THEN
                    Addr = 80 * k&
                    j% = j% + 1
               END IF
               ELSE
                    byte.1% = byte.1% AND 63
                    GET #1, , Byte
                    Byte.2% = ASC(Byte)
                    FOR m% = 1 TO byte.1%
                         b% = j%
                         IF j% = 3 THEN b% = 4
                         IF j% = 4 THEN b% = 8
                         OUT &H3C4, 2: OUT &H3C5, b%
                         POKE Addr, Byte.2%
                         Addr = Addr + 1
                         IF Addr >= LineEnd& THEN
                              Addr = 80 * k&
                              j% = j% + 1
                         END IF
                    NEXT m%
               END IF
          LOOP
     NEXT k&
     OUT &H3C4, 2: OUT &H3C5, &HF
     DEF SEG
     CLOSE #1
DO: x$ = INKEY$: LOOP WHILE x$ = ""
SCREEN 0
CLS

END SUB

