'$INCLUDE: 'pcrobots.bi'

DEFINT A-Z

TYPE RegType
    AX    AS INTEGER
    BX    AS INTEGER
    CX    AS INTEGER
    DX    AS INTEGER
    BP    AS INTEGER
    SI    AS INTEGER
    DI    AS INTEGER
    FLAGS AS INTEGER
END TYPE

TYPE RegTypeX
    AX    AS INTEGER
    BX    AS INTEGER
    CX    AS INTEGER
    DX    AS INTEGER
    BP    AS INTEGER
    SI    AS INTEGER
    DI    AS INTEGER
    FLAGS AS INTEGER
    DS    AS INTEGER
    ES    AS INTEGER
END TYPE

DECLARE SUB Interrupt (intnum, inreg AS RegType, outreg AS RegType)

DECLARE SUB InterruptX (intnum, inreg AS RegTypeX, outreg AS RegTypeX)

DECLARE FUNCTION MakeLong&(BYVAL LoByte, BYVAL HiByte)
DECLARE SUB SplitLong(BYVAL Value&, LoByte, HiByte)

FUNCTION MakeLong&(BYVAL LoByte, BYVAL HiByte)
    DIM Result AS Long
    DIM Temp1 AS Long
    DIM Temp2 AS Long
    Temp1 = LoByte
    Temp2 = HiByte
    Result = (Temp1 AND &H7FFF) + (Temp2 AND &H7FFF) * &H10000
    IF Temp1 AND &H8000 THEN Result = (Result OR &H8000)
    IF Temp2 AND &H8000 THEN Result = (Result OR &H80000000)
    MakeLong = Result
END FUNCTION

SUB SplitLong(BYVAL Value&, LoByte, HiByte)
    LoByte = (Value& AND &H7FFF)
    HiByte = (Value& AND &H7FFF0000) \ &H10000
    IF Value& AND &H8000 THEN LoByte = LoByte OR &H8000
    IF Value& AND &H80000000 THEN HiByte = HiByte OR &H8000
END SUB

SUB SwapTask
    DIM Regs AS RegType

    Regs.AX = 0

    Interrupt &HE0, Regs, Regs
END SUB

SUB Movement(BYVAL Fast, BYVAL Angle)
    DIM Regs AS RegType

    Regs.AX = 1
    Regs.BX = Fast
    Regs.CX = Angle

    Interrupt &HE0, Regs, Regs
END SUB

FUNCTION Scan(BYVAL Angle, BYVAL Res, Range)
    DIM Regs AS RegType

    Regs.AX = 2
    Regs.BX = Angle
    Regs.CX = Res

    Interrupt &HE0, Regs, Regs

    Range = Regs.BX
    Scan   = Regs.AX
END FUNCTION

FUNCTION Shoot(BYVAL Angle, BYVAL Range)
    DIM Regs AS RegType

    Regs.AX = 3
    Regs.BX = Angle
    Regs.CX = Range

    Interrupt &HE0, Regs, Regs

    Shoot = Regs.AX
END FUNCTION

SUB GetXY(X, Y)
    DIM Regs AS RegType

    Regs.AX = &H10

    Interrupt &HE0, Regs, Regs

    X = Regs.BX
    Y = Regs.CX
END SUB

FUNCTION Transmit(BYVAL Target, BYVAL Message)
    DIM Regs AS RegType

    Regs.AX = &H11
    Regs.BX = Target
    Regs.CX = Message

    Interrupt &HE0, Regs, Regs

    Transmit = Regs.AX
END FUNCTION

FUNCTION Receive(Source, Message)
    DIM Regs AS RegType

    Regs.AX = &H12

    Interrupt &HE0, Regs, Regs

    Message = Regs.CX
    Source  = Regs.BX
    Receive = Regs.AX
END FUNCTION

FUNCTION Damage
    DIM Regs AS RegType

    Regs.AX = &H13

    Interrupt &HE0, Regs, Regs

    Damage = Regs.BX
END FUNCTION


FUNCTION Speed
    DIM Regs AS RegType

    Regs.AX = &H14

    Interrupt &HE0, Regs, Regs

    Speed = Regs.BX
END FUNCTION


FUNCTION Battery
    DIM Regs AS RegType

    Regs.AX = &H15

    Interrupt &HE0, Regs, Regs

    Battery = Regs.BX
END FUNCTION

FUNCTION Ticks&
    DIM Regs AS RegType

    Regs.AX = &H16

    Interrupt &HE0, Regs, Regs

    Ticks = MakeLong(Regs.CX, Regs.BX)
END FUNCTION

FUNCTION lSin&(BYVAL Angle)
    DIM Regs AS RegType

    Regs.AX = &H17
    Regs.BX = Angle

    Interrupt &HE0, Regs, Regs

    lSin = MakeLong(Regs.CX, Regs.BX)
END FUNCTION


FUNCTION lCos(BYVAL Angle)
    DIM Regs AS RegType

    Regs.AX = &H18
    Regs.BX = Angle

    Interrupt &HE0, Regs, Regs

    lCos = MakeLong(Regs.CX, Regs.BX)
END FUNCTION


FUNCTION lTan&(BYVAL Angle)
    DIM Regs AS RegType

    Regs.AX = &H19
    Regs.BX = Angle

    Interrupt &HE0, Regs, Regs

    lTan = MakeLong(Regs.CX, Regs.BX)
END FUNCTION

FUNCTION lAtan(BYVAL Ratio&)
    DIM Regs AS RegType

    Regs.AX = &H1A

    SplitLong Ratio&, Regs.CX, Regs.BX

    Interrupt &HE0, Regs, Regs

    lAtan = Regs.AX
END FUNCTION

FUNCTION lSqrt&(BYVAL Value&)
    DIM Regs AS RegType

    Regs.AX = &H1b
    SplitLong Value&, Regs.CX, Regs.BX

    Interrupt &HE0, Regs, Regs

    lSqrt = MakeLong(Regs.CX, Regs.BX)
END FUNCTION


SUB SetPattern(Buffer$)
    IF len(Buffer$)=5 THEN
        DIM Regs AS RegType

        Regs.AX = &H1C
        Regs.BX = SSEG(Buffer$)
        Regs.CX = SADD(Buffer$)

        Interrupt &HE0, Regs, Regs
    ENDIF
END SUB


SUB DebugFlag(BYVAL Flag, BYVAL Set)
    DIM Regs AS RegType

    Regs.AX = &H1D
    Regs.BX = Flag
    Regs.CX = Set

    Interrupt &HE0, Regs, Regs
END SUB


SUB BuyArmour(BYVAL ArmourUnits)
    DIM Regs AS RegType

    Regs.AX = &H1E
    Regs.BX = ArmourUnits

    Interrupt &HE0, Regs, Regs
END SUB


SUB BuyShells(BYVAL Shells)
    DIM Regs AS RegType

    Regs.AX = &H1F
    Regs.BX = Shells

    Interrupt &HE0, Regs, Regs
END SUB


FUNCTION ShellsLeft
    DIM Regs AS RegType

    Regs.AX = &H20

    Interrupt &HE0, Regs, Regs

    ShellsLeft = Regs.BX
END FUNCTION


SUB GetLocalMap(Buffer$)
    DIM Regs AS RegType

    Buffer$ = STRING$(81, 0)

    Regs.AX = &H21
    Regs.BX = SSEG(Buffer$)
    Regs.CX = SADD(Buffer$)

    Interrupt &HE0, Regs, Regs
END SUB


SUB Invisibility(BYVAL InvisFlag)
    DIM Regs AS RegType

    Regs.AX = &H22
    Regs.BX = InvisFlag

    Interrupt &HE0, Regs, Regs
END SUB


FUNCTION GetShellStatus
    DIM Regs AS RegType

    Regs.AX = &H23

    Interrupt &HE0, Regs, Regs

    GetShellStatus = Regs.BX
END FUNCTION


FUNCTION IsInvisible
    DIM Regs AS RegType

    Regs.AX = &H24

    Interrupt &HE0, Regs, Regs

    IsInvisible = Regs.BX
END FUNCTION


FUNCTION lAtan2(BYVAL Y, BYVAL X)
    DIM Regs AS RegType

    Regs.AX = &H25
    Regs.BX = Y
    Regs.CX = X

    Interrupt &HE0, Regs, Regs

    lAtan2 = Regs.AX
END FUNCTION


FUNCTION Configure(BYVAL Fast, BYVAL Manouevre, BYVAL Range, BYVAL Armour, BYVAL AcceleRation, BYVAL Invisible)
    DIM Regs AS RegType

    Regs.AX = &H80
    Regs.BX = (Fast AND &H7) + (Manouevre AND &H7) * 8 + (Range AND &H7) * 256 + (Armour AND &H7) * 4096
    Regs.CX = (AcceleRation AND &H7) + (Invisible AND &H1) * 8

    Interrupt &HE0, Regs, Regs

    Configure = Regs.AX
END FUNCTION
