	title NuVal -- a long-integer VAL replacement by Jim Mack

	comment }

NuVal:	Written by Jim Mack [76630,2012].  Uploaded for the free use of
	MSSYS members.  I assume no responsiblilty for your application
	of this code.  Thorough testing has revealed no errors, or any
	anomalies other than those noted below.  If you find this routine
	useful, drop me a note.  Likewise, if you discover any problems,
	please notify me at once.

	This source must be assembled with MASM 5.1 or equivalent.
	(You don't need to assemble it unless you make changes).

	Not copyrighted... enjoy.  Uploaded 7/1/89

Provides an integer-only version of the VAL function which substitutes
for QB's VAL like this:

	DECLARE FUNCTION NuVal& (v$)

	m& = nuval("543210")

The following conditions apply:

    1)  Leading spaces are ignored, as are spaces between any +/- sign and
	the first digit (just like VAL).  Only 0-9 are considered numeric.

    2)	Evaluation stops on any embedded non-digit.  Code is provided to
	ignore embedded commas... uncomment it and reassemble if desired.
	Note that non-embedded (leading) commas are always non-numeric.
	Because this function is integer-only, the decimal point is also
	non-numeric.

    3)	No errors are generated.  Excessively large values are treated as
	unsigned, MOD 2^32.  Since the number is unsigned until returned,
	overflow may alter the sign as seen by QB.  If you really want NuVal
	to generate an error on overflow, uncomment the appropriate lines.
	This makes the code bigger and slower... but not by much.

	} comment ends
	page +

	.model medium, basic
	.code

NuVal	PROC USES si di, string
	LOCAL sign, sos, acc

	cld
	xor	ax, ax
	mov	dx, ax			; clear running total to 0
	mov	sos, ax			; non-zero if inside body of number
	mov	acc, ax			; clear temp accumulator
	mov	sign, ax		; initially, no +/- sign
	mov	bx, string		; pointer to string to evaluate
	mov	cx, [bx]
	or	cx, cx			; check passed string length
	jz	nvexit			; no string, return 0
	mov	si, 2[bx]		; pointer to body of string
@@:
	lodsb				; get byte from string
	cmp	al, '9'			; is it a digit?
	ja	nv90			; nothing above 9 is ever legitimate
	cmp	al, '0'
	jb	@f			; not digit, but could still be OK
	mov	sos, ax			; indicate that number has started
	and	al, not '0'		; isolate true digit value
	cbw				; clear ah
	mov	bx, dx
	mov	di, acc			; running total x10, quickly
	shl	di, 1
	rcl	dx, 1			; x2
;;	or	dx, dx
;;	js	nvof
;;
;;	Uncomment all lines containing "or dx,dx" and "js nvof" if you want
;;	NuVal to generate an overflow error when its value would exceed long
;;	integer range.  Also uncomment the last line in the PROC which has
;;	the label "nvof:".  For simplicity, this excludes one legal long
;;	integer, namely -2,147,483,648.  See me if this matters to you.
;;
	shl	di, 1
	rcl	dx, 1			; x4
;;	or	dx, dx
;;	js	nvof
	add	di, acc
	adc	dx, bx			; x5
;;	js	nvof
	shl	di, 1
	rcl	dx, 1			; x10
;;	or	dx, dx
;;	js	nvof
	add	di, ax			; add current digit to running total
	adc	dx, 0
;;	js	nvof
	mov	acc, di			; save temp
nv60:
	loop	@b
nv90:
	mov	ax, acc			; temp accumulator to low result
	cmp	sign, -1		; is sign exactly -1?
	jne	nvexit
	xor	bx, bx			; if negative, subtract from zero.
	mov	cx, bx			; Because this avoids one jmp, it's a
	sub	bx, ax			;  bit faster on average than NEG/NOT
	sbb	cx, dx			;  for a long integer negate
	mov	dx, cx
	mov	ax, bx
	jmp	short nvexit
;;
;;	Uncomment the following to allow embedded commas.  Note that the
;;	checking is very simplistic, so "9,000,,,,0" is allowed, = "9000"
;;	Change the comma below to a period for European notation.
;;
;;@@:
;;	cmp	al, ','			; not space, is it comma?
;;	jne	@f
;;	test	sos, -1			; yes, is it embedded?
;;	jz	nv90			; no, stop now
;;	jnz	nv60			; yes, ignore it
;;

@@:	test	sos, -1			; have we started number yet?
	jnz	nv90			; yes, only digits allowed now
	cmp	al, ' '			; still in lead in... got a space?
	jz	nv60			; yes, ignore it
	cmp	al, '+'			; is character a + or - sign?
	je	@f
	cmp	al, '-'
	jne	nv90			; not any legal character... exit
@@:
	test	sign, -1		; do we already have a sign?
	jnz	nv90			; done if so, only one allowed
	sub	al, '-' + 1		; this makes sign exactly -1 if "-"
	cbw				; extend into ah
	mov	sign, ax		; now sign is non-zero for testing
	js	nv60			; always taken

nvof:
;;;;;;;	INT	4	;uncomment this line if you're trapping overflow

nvexit:
	ret

NuVal	ENDP

Empty	PROC string

;  Provides a benchmark for testing NuVal.  Does nothing, returns zero.

	xor	ax, ax
	ret

Empty	ENDP

	page +

;	If you got this far, you're my kind of explorer.  Here's a treat
;	for being so persistent... replacements for LEN and ASC which are
;	slightly faster than the originals.  NuAsc has one big advantage
;	over its BC counterpart: it won't crash if you feed it an empty
;	string... it returns zero instead.  While this is technically
;	incorrect, in reality it's what you usually want to happen.
;
;	By the way, NuLen only works with strings, not TYPEs
;
;	Just uncomment everything that follows and re-assemble.

;;NuAsc	PROC string  ;QB Function... AsciiValue% = NuAsc%(a$)
;;
;;	xor	ax, ax
;;	mov	bx, string
;;	mov	cx, [bx]
;;	or	cx, cx
;;	jz	@f
;;	mov	bx, 2[bx]
;;	mov	al, [bx]
;;@@:	ret
;;
;;NuAsc	ENDP
;;
;;NuLen	PROC string  ;QB Function... StringLen% = NuLen%( a$)
;;
;;	mov	bx, string
;;	mov	ax, [bx]
;;	ret
;;
;;NuLen	ENDP

	END
