' ============================================================
'  Name:  MWALLOC.BAS
'  Date:  03/23/1991
'  Type:  Main Module
'  Lang:  Microsoft QuickBASIC v4.00+
'  Auth:  Mike Welch (Dallas)
'  Purp:  MWALLOC will show you not only how to load huge arrays
'         into QuickBASIC programs (that is, use all of the
'         system's available memory, not just 64K) but it will
'         provide some guidelines for determining how much
'         you should allocate in terms of maximum subscripts
'         for your array (to be DIMensioned).  Note that my
'         fixed length string here is 64 bytes long.  You will
'         need to make adjustments to the initial value of X
'         [that is FreeMem& \ 100], changing the 100 to a larger
'         number for larger strings, or a lower number for smaller
'         strings.  I wouldn't drop the 100 value less than about
'         80 in any case, however.
' ============================================================
'
'$DYNAMIC                               ' allow full use of RAM
DEFINT A-Z                              ' integers only here

CLS                                     ' clear display
FreeMem& = SETMEM(0)                    ' ram left for program
PRINT "Free memory now avaliable:"; FreeMem&

' Take the max freeram left after this program is loaded
' (the value in FreeRam&) and divide by 100 to determine
' a good guess of safe memory to use.
x = FreeMem& \ 100                      ' determine max subscripts
DIM MyArray(1 TO x) AS STRING * 64      ' max array number here

PRINT "Alloted subscripts (max): "; x
PRINT "Filling arrays with data...";

ascii = 32                              ' use printable chars
FOR i = 1 TO x                          ' fill array
	ascii = ascii + 1               ' character to fill
	IF ascii > 255 THEN ascii = 33  ' within range
	MyArray(i) = STRING$(64, ascii) ' fill array here
NEXT                                    ' fill up all memory

PRINT
PRINT "Done.  Any key continues.";
DO: LOOP UNTIL LEN(INKEY$)              ' wait for keypress
PRINT

FOR i = 1 TO x                          ' count total RAM used
	s& = s& + LEN(MyArray(i))       ' by this array!
NEXT

FOR i = 1 TO x                          ' show that it worked
	PRINT i; MyArray(i)             ' by printing array
	IF LEN(INKEY$) THEN EXIT FOR    ' exit with keypress
NEXT
PRINT
PRINT "Total bytes of RAM used by array: "; s&

