   REM  Disk Monkey v1.4  Public Domain  Thomas G. Hanlin III
   REM  Requires the shareware ADVBAS library to compile

   DEFINT A-Z
   DEF fnf$ (x) = RIGHT$("0" + MID$(STR$(x), 2), 2)

   seekattr = 23 ' seek read-only, normal, hidden, system, and directory files

   cmd$ = COMMAND$
   IF cmd$ = "" THEN GOTO BadMonkey

   i = INSTR(cmd$, " ")
   IF i THEN fil$ = LEFT$(cmd$, i - 1): cmd$ = MID$(cmd$, i + 1) ELSE fil$ = cmd$: GOTO DoIt

   i = INSTR(cmd$, " ")
   IF i THEN parm1$ = LEFT$(cmd$, i - 1): cmd$ = MID$(cmd$, i + 1) ELSE parm1$ = cmd$: GOTO DoIt

   i = INSTR(cmd$, " ")
   IF i THEN parm2$ = LEFT$(cmd$, i - 1): parm3$ = MID$(cmd$, i + 1) ELSE parm2$ = cmd$

DoIt:
   IF parm1$ = "" THEN GOTO Display
   IF INSTR(parm1$, "/") THEN p$ = parm1$: GOSUB ExtractDate ELSE IF INSTR(parm1$, ":") THEN p$ = parm1$: GOSUB ExtractTime ELSE p$ = parm1$: GOSUB ExtractAttr

   IF parm2$ = "" THEN GOTO Display
   IF INSTR(parm2$, "/") THEN p$ = parm2$: GOSUB ExtractDate ELSE IF INSTR(parm2$, ":") THEN p$ = parm2$: GOSUB ExtractTime ELSE p$ = parm2$: GOSUB ExtractAttr

   IF parm3$ = "" THEN GOTO Display
   IF INSTR(parm3$, "/") THEN p$ = parm3$: GOSUB ExtractDate ELSE IF INSTR(parm3$, ":") THEN p$ = parm3$: GOSUB ExtractTime ELSE p$ = parm3$: GOSUB ExtractAttr

Display:
   fil$ = fil$ + CHR$(0)
   CALL FindFirstF(fil$, seekattr, ercd)
   IF ercd THEN CALL upcase(fil$): PRINT "No such file as "; fil$: END
   WHILE ercd = 0
      GOSUB DisplayFile
      CALL FindNextF(ercd)
   WEND
   END

BadMonkey:
   PRINT "Disk Monkey v1.4      Public Domain 03/14/88    by Thomas Hanlin III"
   PRINT
   PRINT "Allows you to monkey with file date, time, and attributes."
   PRINT
   PRINT "Format: MONKEY filename.ext [date] [time] [attributes]"
   PRINT "Filename may include wildcards.  Date/time/attr may be in any order."
   PRINT "Attributes: N normal, H hidden, S system, D directory, R read-only, A archive."
   END

ExtractTime:
   i = INSTR(p$, ":")
   hour = VAL(p$)
   p$ = MID$(p$, i + 1)
   minute = VAL(p$)
   i = INSTR(p$, ":")
   IF i THEN second = VAL(MID$(p$, i + 1))
   stime = -1
   RETURN

ExtractDate:
   i = INSTR(p$, "/")
   month = VAL(p$)
   p$ = MID$(p$, i + 1)
   day = VAL(p$)
   i = INSTR(p$, "/")
   IF i THEN year = VAL(MID$(p$, i + 1)) ELSE year = VAL(MID$(DATE$, 7))
   sdate = -1
   RETURN

ExtractAttr:
   attr = 0
   CALL upcase(p$)
   IF INSTR(p$, "R") THEN attr = attr + 1
   IF INSTR(p$, "H") THEN attr = attr + 2
   IF INSTR(p$, "S") THEN attr = attr + 4
   IF INSTR(p$, "D") THEN attr = attr + 16
   IF INSTR(p$, "A") THEN attr = attr + 32
   sattr = -1
   RETURN

DisplayFile:
   ky$ = INKEY$
   IF ky$ = CHR$(19) THEN WHILE INKEY$ = "": WEND  '  handle CTRL-S for pause

   dname$ = SPACE$(12)
   CALL GetNameF(dname$, dlen)
   CALL GetTimeF(dhour, dmin, dsec)
   CALL GetDateF(dmonth, dday, dyear)
   CALL GetAttrF(dattr)

   PRINT dname$; "   "; fnf$(dmonth); "/"; fnf$(dday); "/"; fnf$(dyear); "   ";
   PRINT fnf$(dhour); ":"; fnf$(dmin); ":"; fnf$(dsec); "   ";
   pattr = dattr: GOSUB DisplayAttr

   IF NOT (sdate OR stime OR sattr) THEN RETURN

   dname$ = LEFT$(dname$, dlen) + CHR$(0)
   PRINT "   ------>     ";

   IF sdate AND NOT stime THEN hour = dhour: minute = dmin: second = dsec
   IF stime AND NOT sdate THEN day = dday: month = dmonth: year = dyear

   IF sdate OR stime THEN _
      foo = month:_
      CALL setftd(dname$, month, day, year, hour, minute, second):_
      month = foo
   IF sdate THEN PRINT fnf$(month); "/"; fnf$(day); "/"; fnf$(year); "   "; ELSE PRINT SPACE$(11);
   IF stime THEN PRINT fnf$(hour); ":"; fnf$(minute); ":"; fnf$(second); "   ";  ELSE PRINT SPACE$(11);

   IF NOT sattr THEN PRINT : PRINT : RETURN
   IF sattr THEN CALL SetFattr(dname$, attr)
   pattr = attr: GOSUB DisplayAttr
   PRINT
   RETURN

DisplayAttr:
   IF pattr = 0 THEN PRINT "N";
   IF pattr AND 1 THEN PRINT "R";
   IF pattr AND 2 THEN PRINT "H";
   IF pattr AND 4 THEN PRINT "S";
   IF pattr AND 16 THEN PRINT "D";
   IF pattr AND 32 THEN PRINT "A";
   PRINT
   RETURN
