'***************************************************************************
'*                                                                         *
'*           Take the Doc or Comment Text Out of the Source Code           *
'*                               DOC_OUT.BAS                               *
'*                                                                Ver 1.00 *
'*                                                                         *
'***************************************************************************
'*                                                                         *
'* FUNCTION:  This program will take a QuickBASIC source file and split    *
'*            it into a pure code file and a comment file, the original    *
'*            source file is left untouched.  Enter the filename on the    *
'*            command line when evoking the program to process.            *
'*                                                                         *
'***************************************************************************
'*                                                                         *
'* *********************************************************************** *
'* PROGRAM INPUT:                                                          *
'* *********************************************************************** *
'*                                                                         *
'*   COMMAND LINE:                                                         *
'*     The name of the program you wish to have split                      *
'*                                                                         *
'* *********************************************************************** *
'* NOTES & COMMENTS:                                                       *
'* *********************************************************************** *
'*                                                                         *
'*   NOTES:                                                                *
'*                                                                         *
'*     Only comment lines starting with ' will be extracted                *
'*     REMs will not be extracted                                          *
'*     Comments following code will not be extracted                       *
'*                                                                         *
'*                                                                         *
'*   LAST MODIFICATION:                                                    *
'*                                                                         *
'*     DATE        VERSION  PROGRAMMER      DESCRIPTION OF MODIFICATION    *
'*  12/27/1989       1.00    Bob Cox                    N/A                *
'*                                                                         *
'*                                                                         *
'* *********************************************************************** *
'* Bob Cox '89                                              QuickBASIC 4.5 *
'***************************************************************************


'***************************************************************************
'* INTERNAL PROCEDURE DECLARATIONS                                   *******
'***************************************************************************
DECLARE FUNCTION STRIP$ (StringIn$)


'***************************************************************************
'* CONSTANTS                                                         *******
'***************************************************************************
CONST True = 1, False = 0


'***************************************************************************
'* PROGRAM EXECUTABLE CODE BEGINS HERE                               *******
'***************************************************************************
ON ERROR GOTO ErrorRtn


'***************************************************************************
'* M A I N    R O U T I N E                                          *******
'***************************************************************************

  SFileName$ = COMMAND$

  IF SFileName$ <> "" THEN
    EP% = INSTR(SFileName$, ".")
    'Get Base Filename
    IF EP% > 0 THEN
      BFileName$ = LEFT$(SFileName$, EP% - 1)
    ELSE
      BFileName$ = SFileName$
      SFileName$ = SFileName$ + ".BAS"
    END IF
    CodeFileName$ = BFileName$ + ".COD"
    CommentFileName$ = BFileName$ + ".COM"


    SourceFile% = FREEFILE
    OPEN SFileName$ FOR INPUT AS SourceFile%

    CodeFile% = FREEFILE
    OPEN CodeFileName$ FOR OUTPUT AS CodeFile%

    CommentFile% = FREEFILE
    OPEN CommentFileName$ FOR OUTPUT AS CommentFile%

    PRINT "Making Code File (.COD) and Comment File (.COM) From Source "; SFileName$

    LineCount% = 0
    CodeSeg% = True

    WHILE NOT EOF(SourceFile%)
      LINE INPUT #SourceFile%, LineOfProgram$ 'Get A Line From The Program
      LineCount% = LineCount% + 1        'Incr line counter
      CLineOfProgram$ = STRIP$(LineOfProgram$)
      IF LEFT$(CLineOfProgram$, 1) = "'" AND LEFT$(CLineOfProgram$, 2) <> "'$" THEN
        IF CodeSeg% = True THEN
          PRINT #CommentFile%, LineCount% 'Save Pos of Comment Block
          CodeSeg% = False
        END IF
        PRINT #CommentFile%, LineOfProgram$  'Print Line To Comment File
      ELSE
        PRINT #CodeFile%, LineOfProgram$     'Print Line To Code File
        CodeSeg% = True
      END IF
    WEND

    CLOSE

  ELSE
    PRINT "You Must Specify the .BAS File You Want The Comment Text Removed From"
  END IF

  END

'***************************************************************************
'* MAIN MODUAL ERROR ROUTINE                                         *******
'***************************************************************************

ErrorRtn:
  ErrorCode% = ERR
  SELECT CASE ErrorCode%
    CASE 53 'File not found *******
    PRINT "File Not Found"
    END
    CASE 61 'Disk full *******
    PRINT "Disk Full"
    END
    CASE 76 'Path not found *******
    PRINT "Path Not Found"
    END
    CASE ELSE
      'Unrecoverable error
      COLOR 7, 0: LOCATE 25, 1
      PRINT "An error has occurred.   *** ERROR"; ErrorCode%; "***";
      BEEP: BEEP
      DO: kb$ = INKEY$: LOOP WHILE kb$ <> "" 'Clear Keyboard Buffer
      WHILE kb$ = "": kb$ = INKEY$: WEND     'Wait for keypress
      END
  END SELECT


FUNCTION STRIP$ (StringIn$)

'Strips out all spaces, nulls, ctrl-chars from a string

  NewString$ = ""
  l% = LEN(StringIn$)
  IF l% > 0 THEN
    FOR p% = 1 TO l%
      c% = ASC(MID$(StringIn$, p%, 1))
      IF c% > 32 AND c% < 255 THEN
        NewString$ = NewString$ + CHR$(c%)
      END IF
    NEXT
  END IF
  STRIP$ = NewString$

END FUNCTION

