'***************************************************************************
'*                                                                         *
'*                      MENU.BAS Module Demo Program 2                     *
'*                                DEMO2.BAS                                *
'*                                                                Ver 1.00 *
'*                                                                         *
'***************************************************************************
'*                                                                         *
'* FUNCTION:  This program demonstrates how to use the menu module         *
'*            MENU.BAS in an application program.  The program is          *
'*            only intended to illustrate some basic techniques            *
'*            for using MENU.BAS.                                          *
'*                                                                         *
'*                                                                         *
'* *********************************************************************** *
'* Bob Cox '89                                              QuickBASIC 4.5 *
'***************************************************************************


'***************************************************************************
'* INTERNAL PROCEDURE DECLARATIONS                                   *******
'***************************************************************************
DECLARE FUNCTION ItemNum$ (Num%)
DECLARE SUB LoadPhoneBook ()
DECLARE SUB SavePhoneBook ()
DECLARE SUB ListBook ()
DECLARE SUB SearchBook ()
DECLARE SUB AddItem ()
DECLARE SUB ChangeItem ()
DECLARE SUB DeleteItem ()
DECLARE SUB DisplayErrorLine (ErrorText$)
DECLARE SUB BottomBar (BarText$)
DECLARE SUB SetColors ()
DECLARE FUNCTION MonitorType% ()
DECLARE SUB PressAnyKey ()
DECLARE SUB GetKey (KeyPress$)
DECLARE SUB EndRunCleanUp ()
DECLARE SUB HBar (LChar$, MChar$, RChar$, Row%, ColStart%, ColEnd%)
DECLARE SUB MainScreen ()
DECLARE SUB ClearKeyboardBuffer ()
DECLARE SUB PrintPhoneLine (N%, FirstName$, LastName$, Phone$)


'***************************************************************************
'* EXTERNAL PROCEDURE DECLARATIONS                                   *******
'***************************************************************************
'$INCLUDE: 'MENU.BI'

DECLARE SUB CLA (UprleftX%, UprleftY%, LowrigtX%, LowrigtY%)
DECLARE SUB Box (Xtop%, Ytop%, Xbot%, Ybot%, TheBox$)
DECLARE SUB CursorOFF ()
DECLARE SUB CursorON ()


'***************************************************************************
'* CONSTANTS                                                         *******
'***************************************************************************
'Logical Constants ***
CONST On. = 1, Off. = 0
CONST True = 1, False = 0

'Color Constants ***
CONST Black = 0, Blue = 1, Green = 2, Cyan = 3
CONST Red = 4, Magenta = 5, Brown = 6, White = 7
CONST Grey = 8, LightBlue = 9, LightGreen = 10, LightCyan = 11
CONST LightRed = 12, LightMagenta = 13, Yellow = 14, BrightWhite = 15

'Data Structure Constants ***
CONST MaxItems = 999


'***************************************************************************
'* PROGRAM EXECUTABLE CODE BEGINS HERE                               *******
'***************************************************************************
CLS


'***************************************************************************
'* MAIN MODUAL LEVEL SIMPLE VARIABLES                                *******
'***************************************************************************
NumItems% = 0
PhoneBookName$ = "No Phone Book Loaded"


'***************************************************************************
'* MAIN MODUAL STORAGE/DATA STRUCTURES                               *******
'***************************************************************************
DIM LastName$(1 TO MaxItems)
DIM FirstName$(1 TO MaxItems)
DIM Phone$(1 TO MaxItems)


'***************************************************************************
'* M A I N    R O U T I N E                                          *******
'***************************************************************************

'INITIALIZE THE MENUS **********
'MAIN MENU *******
InitMenu MainMenu%
'MENU TITLE ****
MenuTitleText MainMenu%, 0, 0, "Menu Menu"
MenuTitleDivd MainMenu%, 0, "͹"
MenuTitleText MainMenu%, 0, 0, ""
'MENU ITEMS ****
MenuItem MainMenu%, "L", "List Entire Phone Book"
MenuItem MainMenu%, "S", "Search Phone Book"
MenuItem MainMenu%, "A", "Add A New Entry"
MenuItem MainMenu%, "C", "Change An Entry"
MenuItem MainMenu%, "D", "Delete An Entry"
MenuItem MainMenu%, "", "Disk Directory"
MenuItem MainMenu%, "", "Load A Phone Book"
MenuItem MainMenu%, "", "Save Phone Book"
MenuItem MainMenu%, "", "End"
'MENU COMMENT ****
MenuCommentText MainMenu%, 0, 0, ""
MenuCommentText MainMenu%, 2, 0, "Select From Above"
'MENU DISPLAY OPTIONS ****
SpaceLMenuBdr MainMenu%, 1
SpaceLMenuItems MainMenu%, 1
SpaceLMenuPtr MainMenu%, 1
SpaceRMenuItems MainMenu%, 1
SpaceRMenuBdr MainMenu%, 1
MenuHolders MainMenu%, "[", "]"
MenuItemPointerL MainMenu%, ""
MenuItemPointerR MainMenu%, ""
FlickerMenu MainMenu%, 3
MenuCommentInBdr MainMenu%, On.
MenuSetLocation MainMenu%, 4, 0


'SEARCH MENU *******
InitMenu SearchMenu%
'MENU TITLE ****
MenuTitleText SearchMenu%, 0, 0, "Search Menu"
MenuTitleDivd SearchMenu%, 0, "͹"
MenuTitleText SearchMenu%, 0, 0, ""
'MENU ITEMS ****
MenuItem SearchMenu%, "L", "Search by Last Name"
MenuItem SearchMenu%, "F", "Search by First Name"
MenuItem SearchMenu%, "P", "Search by Phone Number"
MenuItem SearchMenu%, "X", "Exit"
'MENU COMMENT ****
MenuCommentText SearchMenu%, 0, 0, ""
MenuCommentText SearchMenu%, 2, 0, "Select From Above"
'MENU DISPLAY OPTIONS ****
SpaceLMenuBdr SearchMenu%, 1
SpaceLMenuItems SearchMenu%, 1
SpaceLMenuPtr SearchMenu%, 1
SpaceRMenuItems SearchMenu%, 1
SpaceRMenuBdr SearchMenu%, 1
MenuHolders SearchMenu%, "[", "]"
MenuItemPointerL SearchMenu%, ""
MenuItemPointerR SearchMenu%, ""
FlickerMenu SearchMenu%, 3
MenuCommentInBdr SearchMenu%, On.
MenuSetLocation SearchMenu%, 44, 0


'Set colors for the program and menus
SetColors
ColorsMenuAllBack ClrBMenuAll%
ColorMenuBoarder ClrFMenuBdr%, ClrBMenuBdr%
ColorMenuComment ClrFMenuBdr%, ClrBMenuBdr%
ColorMenuExit ClrFNorm%, ClrBNorm%

ClearKeyboardBuffer

WHILE Done% = False
  MainScreen
  Menu MainMenu%, OptionSelected%, ReturnCode%
  SELECT CASE OptionSelected%
    CASE 1
      ListBook
    CASE 2
      SearchBook
    CASE 3
      AddItem
    CASE 4
      ChangeItem
    CASE 5
      DeleteItem
    CASE 6
      CLS
      FILES
      PressAnyKey
    CASE 7
      LoadPhoneBook
    CASE 8
      SavePhoneBook
    CASE ELSE
      Done% = True
  END SELECT
WEND


EndRunCleanUp

SUB AddItem

SHARED NumItems%
SHARED LastName$()
SHARED FirstName$()
SHARED Phone$()


  CLA 2, 4, 79, 22

  NumItems% = NumItems% + 1

  LOCATE 7, 3
  LINE INPUT "Last  Name:"; LastName$(NumItems%)

  LOCATE 9, 3
  LINE INPUT "First Name:"; FirstName$(NumItems%)

  LOCATE 11, 3
  LINE INPUT "Phone Number:"; Phone$(NumItems%)

END SUB

SUB BottomBar (BarText$)

'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
'*                                                                     *
'*                              BottomBar                              *
'*                                                            Ver 1.00 *
'*                                                                     *
'* FUNCTION:  This routine places a bar on the bottom of the screen    *
'*            with text on the bar.                                    *
'*                                                                     *
'*                                                                     *
'* INPUT:     BarText$ : Text to be placed on the bar                  *
'*                                                                     *
'*                                                                     *
'* Bob Cox '89                                          QuickBASIC 4.5 *
'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

SHARED ClrFBar%, ClrBBar%
SHARED ClrFNorm%, ClrBNorm%

CONST BBarLoc = 24   'Bar location on screen
CONST BarChar = 32   'Bar character (space)

  COLOR ClrFBar%, ClrBBar%
  LOCATE BBarLoc, 1
  PRINT BarText$; STRING$(80 - LEN(BarText$), BarChar); 'Display the bar
  COLOR ClrFNorm%, ClrBNorm%

END SUB

SUB ChangeItem

SHARED NumItems%
SHARED LastName$()
SHARED FirstName$()
SHARED Phone$()

  CLA 2, 4, 79, 22
  LOCATE 5, 3
  LINE INPUT "Enter Number of Item To Change:"; Num$
  I% = VAL(Num$)
  IF I% > 0 AND I% <= NumItems% THEN
    LOCATE 7, 3
    PrintPhoneLine I%, FirstName$(I%), LastName$(I%), Phone$(I%)
    LOCATE 9, 3
    PRINT "Change This Item (Y/N)?";
    GetKey YN$
    IF UCASE$(YN$) = "Y" THEN
      'Change Item
      LOCATE 11, 3
      LINE INPUT "Last  Name:"; LastName$(I%)
      LOCATE 13, 3
      LINE INPUT "First Name:"; FirstName$(I%)
      LOCATE 15, 3
      LINE INPUT "Phone Number:"; Phone$(I%)
    END IF
  ELSE
    DisplayErrorLine "Out Of Range"
  END IF


END SUB

SUB ClearKeyboardBuffer

  DO: kb$ = INKEY$: LOOP WHILE kb$ <> ""

END SUB

SUB DeleteItem

SHARED NumItems%
SHARED LastName$()
SHARED FirstName$()
SHARED Phone$()

  CLA 2, 4, 79, 22
  LOCATE 5, 3
  LINE INPUT "Enter Number of Item To Delete:"; Num$
  I% = VAL(Num$)
  IF I% > 0 AND I% <= NumItems% THEN
    LOCATE 7, 3
    PrintPhoneLine I%, FirstName$(I%), LastName$(I%), Phone$(I%)
    LOCATE 9, 3
    PRINT "Delete This Item (Y/N)?";
    GetKey YN$
    IF UCASE$(YN$) = "Y" THEN
      'Delete Item
      IF I% < NumItems% THEN
        FOR P% = I% TO NumItems% - 1
          N% = P% + 1
          FirstName$(P%) = FirstName$(N%)
          LastName$(P%) = LastName$(N%)
          Phone$(P%) = Phone$(N%)
        NEXT
      END IF
      NumItems% = NumItems% - 1
    END IF
  ELSE
    DisplayErrorLine "Out Of Range"
  END IF

END SUB

SUB DisplayErrorLine (ErrorText$)

  LOCATE 25, 1
  PRINT SPACE$(79);
  LOCATE , 2
  PRINT ErrorText$;

END SUB

SUB EndRunCleanUp

  COLOR 7, 0
  CLS

END SUB

SUB GetKey (KeyPress$)

'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
'*                                                                     *
'*                               GetKey                                *
'*                                                            Ver 1.00 *
'*                                                                     *
'* FUNCTION:  This routine waits for a key to be pressed then returns  *
'*            that key in KeyPress$.                                   *
'*                                                                     *
'*                                                                     *
'* OUTPUT:    KeyPress$ : The key that was pressed.                    *
'*                                                                     *
'*                                                                     *
'* PSEUDO                                                              *
'*  CODE:     Dowhile no key pressed                                   *
'*              Look for keypress                                      *
'*            Enddo                                                    *
'*                                                                     *
'*                                                                     *
'* NOTES:     KeyPress$ will contain 1 or 2 characters                 *
'*              Regular ASCII code  - 1 char                           *
'*              Extended ASCII code - 2 chars (prefix char is a null)  *
'*                                                                     *
'*                                                                     *
'* Bob Cox '88                                          QuickBASIC 4.0 *
'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

  KeyPress$ = ""

  WHILE KeyPress$ = ""   'Dowhile no key has been pressed
    KeyPress$ = INKEY$   'Look for a keypress
  WEND                   'Enddo

END SUB

SUB HBar (LChar$, MChar$, RChar$, Row%, ColStart%, ColEnd%)

'***************************************************************************
'*                                                                         *
'*                              Horizontal Bar                             *
'*                                   HBar                                  *
'*                                                                Ver 1.00 *
'*                                                                         *
'* FUNCTION:  This routine draws a horizontal bar on the screen at the     *
'*            specified location with the middle and end segments given.   *
'*            The middle of the bar will be located in the same position   *
'*            on the screen even if the end segments are null.             *
'*                                                                         *
'*                                                                         *
'* *********************************************************************** *
'* ARGUMENTS:                                                              *
'* *********************************************************************** *
'*                                                                         *
'*   INPUT:                                                                *
'*     LChar$    : Left character / left end                               *
'*     MChar$    : Middle character                                        *
'*     RChar$    : Right character / right end                             *
'*     Row%      : Row for the bar (Y pos)                                 *
'*     ColStart% : Column start (X start) - location of LChar$             *
'*     ColEnd%   : Column end   (X end)   - location of RChar$             *
'*                                                                         *
'*                                                                         *
'* *********************************************************************** *
'* NOTES & COMMENTS:                                                       *
'* *********************************************************************** *
'*                                                                         *
'*   NOTES:                                                                *
'*                                                                         *
'*                                                                         *
'*   LAST MODIFICATION:                                                    *
'*                                                                         *
'*     DATE        VERSION  PROGRAMMER      DESCRIPTION OF MODIFICATION    *
'*  12/04/1989       1.00    Bob Cox                                       *
'*                                                                         *
'*                                                                         *
'* Bob Cox '89                                              QuickBASIC 4.5 *
'***************************************************************************

'***************************************************************************
'* PROCEDURE LOGIC                                                   *******
'***************************************************************************

  LOCATE Row%, ColStart%
  PRINT LChar$;
  LOCATE , ColStart% + 1
  PRINT STRING$(ColEnd% - ColStart% - 1, MChar$);
  PRINT RChar$;

END SUB

FUNCTION ItemNum$ (Num%)

  ItemNum$ = RIGHT$("000" + MID$(STR$(Num%), 2), 3) + " "

END FUNCTION

SUB ListBook

SHARED NumItems%
SHARED LastName$()
SHARED FirstName$()
SHARED Phone$()

  CLA 2, 4, 79, 22

  IF NumItems% > 0 THEN
    BaseItem% = 1
    Count% = 1
    FOR I% = 1 TO NumItems%
      LOCATE I% - BaseItem% + 5, 3
      PrintPhoneLine I%, FirstName$(I%), LastName$(I%), Phone$(I%)
      IF Count% > 17 THEN
        Count% = 1
        BaseItem% = I% + 1
        PressAnyKey
        CLA 2, 4, 79, 22
      ELSE
        Count% = Count% + 1
      END IF
    NEXT
    PressAnyKey
  ELSE
    DisplayErrorLine "There Are No Items"
  END IF

END SUB

SUB LoadPhoneBook

SHARED PhoneBookName$
SHARED NumItems%
SHARED LastName$()
SHARED FirstName$()
SHARED Phone$()


  CLA 2, 4, 79, 22

  LOCATE 12, 3
  LINE INPUT "Filename for PhoneBook:"; PhoneBookName$

  FileNum% = FREEFILE
  OPEN PhoneBookName$ FOR INPUT AS FileNum%
  INPUT #FileNum%, NumItems%
  FOR I% = 1 TO NumItems%
    INPUT #FileNum%, LastName$(I%)
    INPUT #FileNum%, FirstName$(I%)
    INPUT #FileNum%, Phone$(I%)
  NEXT
  CLOSE


END SUB

SUB MainScreen

SHARED PhoneBookName$

  Box 1, 1, 80, 23, "D"
  HBar "", "", "", 3, 1, 80
  LOCATE 2, 2: PRINT "Address Book"
  BottomBar PhoneBookName$

END SUB

FUNCTION MonitorType%
  'This function returns a value that indicates
  'the monitor type (color or monochrome)
  '1 or 2 = color
  '3      = mono
  '(Reads the equipment list)

  DEF SEG = 0
  MonitorType% = (PEEK(&H410) AND &H30) / &H10

END FUNCTION

SUB PressAnyKey

  CursorOFF
  GetKey dummy$
  CursorON

END SUB

SUB PrintPhoneLine (N%, FirstName$, LastName$, Phone$)

  LenOfItems% = LEN(FirstName$) + LEN(LastName$) + LEN(Phone$)
  LineOfText$ = ItemNum$(N%) + FirstName$ + " " + LastName$ + STRING$(71 - LenOfItems%, ".") + Phone$
  PRINT LineOfText$

END SUB

SUB SavePhoneBook

SHARED PhoneBookName$
SHARED NumItems%
SHARED LastName$()
SHARED FirstName$()
SHARED Phone$()


  CLA 2, 4, 79, 22

  LOCATE 12, 3
  LINE INPUT "Filename for PhoneBook:"; PhoneBookName$

  FileNum% = FREEFILE
  OPEN PhoneBookName$ FOR OUTPUT AS FileNum%
  PRINT #FileNum%, NumItems%
  FOR I% = 1 TO NumItems%
    PRINT #FileNum%, LastName$(I%)
    PRINT #FileNum%, FirstName$(I%)
    PRINT #FileNum%, Phone$(I%)
  NEXT
  CLOSE

END SUB

SUB SearchBook

SHARED SearchMenu%
SHARED NumItems%
SHARED LastName$()
SHARED FirstName$()
SHARED Phone$()


  Menu SearchMenu%, OptionSelected%, ReturnCode%
  IF OptionSelected% < 4 THEN
    CLA 2, 4, 79, 22
    LOCATE 4, 3
    SELECT CASE OptionSelected%
      CASE 1
        LINE INPUT "Last Name To Search For:"; LstName$
        L% = LEN(LstName$)
        FOR I% = 1 TO NumItems%
          IF LstName$ = LEFT$(LastName$(I%), L%) THEN
            LOCATE , 3
            PrintPhoneLine I%, FirstName$(I%), LastName$(I%), Phone$(I%)
          END IF
        NEXT
      CASE 2
        LINE INPUT "First Name To Search For:"; FstName$
        L% = LEN(FstName$)
        FOR I% = 1 TO NumItems%
          IF FstName$ = LEFT$(FirstName$(I%), L%) THEN
            LOCATE , 3
            PrintPhoneLine I%, FirstName$(I%), LastName$(I%), Phone$(I%)
          END IF
        NEXT
      CASE 3
        LINE INPUT "Phone Number To Search For:"; PhoneNum$
        L% = LEN(PhoneNum$)
        FOR I% = 1 TO NumItems%
          IF PhoneNum$ = LEFT$(Phone$(I%), L%) THEN
            LOCATE , 3
            PrintPhoneLine I%, FirstName$(I%), LastName$(I%), Phone$(I%)
          END IF
        NEXT
    END SELECT
    PRINT : LOCATE , 3: PRINT "Press Any Key To Continue"
    PressAnyKey
  END IF

END SUB

SUB SetColors

SHARED ClrFBar%, ClrBBar%                'Bar colors
SHARED ClrFNorm%, ClrBNorm%              'Normal colors
SHARED ClrBMenuAll%                      'Menu Background colors
SHARED ClrFMenuBdr%, ClrBMenuBdr%        'Menu Boarder colors

  IF MonitorType% = 3 THEN
    'Set for MONO
    ClrFBar% = Black
    ClrBBar% = White
    ClrFNorm% = White
    ClrBNorm% = Black
    ClrBMenuAll% = Black
    ClrFMenuBdr% = BrightWhite
    ClrBMenuBdr% = Black
  ELSE
    'Set for COLOR
    ClrFBar% = Black
    ClrBBar% = White
    ClrFNorm% = White
    ClrBNorm% = Blue
    ClrBMenuAll% = Blue
    ClrFMenuBdr% = Yellow
    ClrBMenuBdr% = Blue
  END IF

  COLOR ClrFNorm%, ClrBNorm%
  CLS

END SUB

