'***************************************************************************
'*                                                                         *
'*           External Support Routines for Menu Module (MENU.BAS)          *
'*                               SUPPORT.BAS                               *
'*                                                                Ver 1.00 *
'*                                                                         *
'* FUNCTION:  The procedures contained in this module are called by        *
'*            MENU.BAS.  This is a support module.                         *
'*                                                                         *
'*                                                                         *
'*                                                                         *
'* *********************************************************************** *
'* PROCEDURES:                                                             *
'* *********************************************************************** *
'*                                                                         *
'*   FUNCTIONS & SUBROUTINES CONTAINED IN THIS MODULE:                     *
'*                                                                         *
'*   FUNCTIONS:                                                            *
'*     CenteringPosition% : Returns horizontal position for text centering *
'*                                                                         *
'*   SUBROUTINES:                                                          *
'*     Box           : Draw a box/boarder on the screen                    *
'*     CLA           : Clear an area of the screen                         *
'*     CursorOFF     : Turn the cursor OFF                                 *
'*     CursorOn      : Turn the cursor ON                                  *
'*     Flicker       : Flash/Flicker text on the screen                    *
'*     GetKeyAndCode : Get key press with ASCII code from user             *
'*                                                                         *
'*                                                                         *
'* *********************************************************************** *
'* NOTES & COMMENTS:                                                       *
'* *********************************************************************** *
'*                                                                         *
'*   NOTES:                                                                *
'*                                                                         *
'*     These procedures can be moved into the MENU module.                 *
'*                                                                         *
'*                                                                         *
'* *********************************************************************** *
'* Bob Cox '89                                              QuickBASIC 4.5 *
'***************************************************************************


'***************************************************************************
'* INTERNAL PROCEDURE DECLARATIONS                                   *******
'***************************************************************************
DECLARE FUNCTION CenteringPosition% (SizeOfArea%, SizeOfObjectToCenter%)


'***************************************************************************
'* CONSTANTS                                                         *******
'***************************************************************************
CONST True = 1, False = 0

SUB Box (Xtop%, Ytop%, Xbot%, Ybot%, TheBox$)

'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
'*                                                                     *
'*                                 BOX                                 *
'*                                                            Ver 2.00 *
'*                                                                     *
'* FUNCTION: This routine draws a box on the screen.  The box can      *
'*           be one of the predefined types or the box segments        *
'*           can be passed to this routine to generate a special       *
'*           type of box.                                              *
'*                                                                     *
'*                                                                     *
'* INPUT:    Xtop%: Upper left hand X corner of the box                *
'*           Ytop%: Upper left hand Y corner of the box                *
'*           Xbot%: Lower right hand X                                 *
'*           Ybot%: Lower right hand Y                                 *
'*           TheBox$: The type of box requested                        *
'*                      - can be a number/code corresponding           *
'*                        to one of the predefined types               *
'*                      - can be a string with the nine                *
'*                        segments of the box specified                *
'*                                                                     *
'*                                                                     *
'* OUTPUT:   The requested box on the display                          *
'*                                                                     *
'*                                                                     *
'* NOTES:  PREDEFINED:       "1" or "S"  - Single line                 *
'*                           "2" or "D"  - Double line                 *
'*                           "3" or "DS" - Double/single               *
'*                           "4" or "SD" - Single/double               *
'*                                                                     *
'*         SEGMENT ORDER:    Top left corner                           *
'*                           Top middle                                *
'*                           Top right corner                          *
'*                           Left side                                 *
'*                           Fill character(space)                     *
'*                           right side                                *
'*                           Btm left corner                           *
'*                           Btm middle                                *
'*                           Btm right corner                          *
'*                                                                     *
'*                                                                     *
'*                                                                     *
'* Bob Cox '88                                          QuickBASIC 4.0 *
'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

  'Define standard boxes
  CONST BoxS = "Ŀ "      'Single box
  CONST BoxD = "ͻ ͼ"      'Double box
  CONST BoxDS = "ķ Ľ"     'Double sides-Single top/btm
  CONST BoxSD = "͸ ;"     'Single sides-Double top/btm

  'Get the box definition *******
  SELECT CASE UCASE$(TheBox$)
    CASE "S", "1"
      BoxSegs$ = BoxS                     'Single box
    CASE "D", "2"
      BoxSegs$ = BoxD                     'Double box
    CASE "DS", "3"
      BoxSegs$ = BoxDS                    'Double sides-Single top/btm
    CASE "SD", "4"
      BoxSegs$ = BoxSD                    'Single sides-Double top/btm
    CASE ELSE
      BoxSegs$ = TheBox$                  'Use caller's box
  END SELECT

  'Get the box segments *******
  tlc$ = MID$(BoxSegs$, 1, 1)             'Top Left corner segment
  top$ = MID$(BoxSegs$, 2, 1)             'Top Middle segment
  trc$ = MID$(BoxSegs$, 3, 1)             'Top Right segment
  ls$ = MID$(BoxSegs$, 4, 1)              'Left segment
  mdl$ = MID$(BoxSegs$, 5, 1)             'Middle segment (box fill)
  rs$ = MID$(BoxSegs$, 6, 1)              'Right segment
  blc$ = MID$(BoxSegs$, 7, 1)             'Bottom left corner segment
  btm$ = MID$(BoxSegs$, 8, 1)             'Bottom segment
  brc$ = MID$(BoxSegs$, 9, 1)             'Bottom right corner segment

  'Make the box lines
  MiddleWidth% = Xbot% - Xtop% - 1
  TopLine$ = tlc$ + STRING$(MiddleWidth%, top$) + trc$
  MidLine$ = ls$ + STRING$(MiddleWidth%, mdl$) + rs$
  BtmLine$ = blc$ + STRING$(MiddleWidth%, btm$) + brc$

  'Display the box
  MiddleLen% = Ybot% - Ytop% - 1
  LOCATE Ytop%, Xtop%: PRINT TopLine$
  FOR l% = 1 TO MiddleLen%
    LOCATE Ytop% + l%, Xtop%
    PRINT MidLine$;
  NEXT
  LOCATE Ybot%, Xtop%: PRINT BtmLine$;

END SUB

FUNCTION CenteringPosition% (SizeOfArea%, SizeOfObjectToCenter%)

'***************************************************************************
'*                                                                         *
'*               Calculate the Centering Position of an Area               *
'*                            CenteringPosition%                           *
'*                                                                Ver 1.00 *
'*                                                                         *
'* FUNCTION:  This function returns the displacement from the left side    *
'*            to center text in an area of a specific size on the screen.  *
'*                                                                         *
'*                                                                         *
'* *********************************************************************** *
'* ARGUMENTS:                                                              *
'* *********************************************************************** *
'*                                                                         *
'*   RETURNED:                                                             *
'*     CenteringPosition% : Relative position on the X axis for centering  *
'*                                                                         *
'*   INPUT:                                                                *
'*     SizeOfArea%           : Length of the area text will be centered on *
'*     SizeOfObjectToCenter% : Length of the text to be centered           *
'*                                                                         *
'*                                                                         *
'* Bob Cox '89                                              QuickBASIC 4.5 *
'***************************************************************************

'***************************************************************************
'* PROCEDURE LOGIC                                                   *******
'***************************************************************************

  CenteringPosition% = SizeOfArea% \ 2 - SizeOfObjectToCenter% \ 2 + 1

END FUNCTION

SUB CLA (UprleftX%, UprleftY%, LowrigtX%, LowrigtY%)

'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
'*                                                                     *
'*                                 CLA                                 *
'*                                                            Ver 1.10 *
'*                                                                     *
'* FUNCTION:  This routine clears an area of the display screen.       *
'*                                                                     *
'*                                                                     *
'* INPUT:     UprleftX%: Upper left X position on screen               *
'*            UprleftY%: Upper left Y position on screen               *
'*            LowrigtX%: Lower right X position on screen              *
'*            LowrigtY%: Lower right Y position on screen              *
'*                                                                     *
'*                                                                     *
'* OUTPUT:    Cleared area on the screen                               *
'*                                                                     *
'*                                                                     *
'* NOTES:     The normal clear character for the screen is a space,    *
'*            ASCII 32.  You can reset the clear character by          *
'*            changing the value for the constant ClearChar.           *
'*                                                                     *
'*                                                                     *
'* Bob Cox '88                                          QuickBASIC 4.0 *
'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

  CONST ClearChar = 32     'Clear character is a space

  WidthOfLine% = LowrigtX% - UprleftX% + 1
  ClearLine$ = STRING$(WidthOfLine%, ClearChar)

  FOR ln% = UprleftY% TO LowrigtY%
    LOCATE ln%, UprleftX%
    PRINT ClearLine$;
  NEXT
END SUB

SUB CursorOFF

'***************************************************************************
'*                                                                         *
'*                           Turn Off the Cursor                           *
'*                                CursorOFF                                *
'*                                                                Ver 1.00 *
'*                                                                         *
'* FUNCTION:  This routine turns OFF the cursor on the screen.             *
'*                                                                         *
'*                                                                         *
'*                                                                         *
'* Bob Cox '89                                              QuickBASIC 4.5 *
'***************************************************************************

'***************************************************************************
'* PROCEDURE LOGIC                                                   *******
'***************************************************************************

 LOCATE , , 0 'Turn the Cursor OFF

END SUB

SUB CursorON

'***************************************************************************
'*                                                                         *
'*                            Turn On the Cursor                           *
'*                                 CursorON                                *
'*                                                                Ver 1.00 *
'*                                                                         *
'* FUNCTION:  This routine turns ON the cursor on the screen.              *
'*                                                                         *
'*                                                                         *
'*                                                                         *
'*                                                                         *
'* Bob Cox '89                                              QuickBASIC 4.5 *
'***************************************************************************

'***************************************************************************
'* PROCEDURE LOGIC                                                   *******
'***************************************************************************

  LOCATE , , 1 'Turn ON the Cursor

END SUB

SUB Flicker (NumB%, LocX%, LocY%, HFG%, HBG%, NFG%, NBG%, FlickerStr$)

'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
'*                                                                     *
'*                                Flicker                              *
'*                                                                     *
'*                                                                     *
'* FUNCTION:  This routine blinks and/or highlights the string         *
'*            that it is given.  You give the routine the string,      *
'*            the position on screen, normal, highlighted colors.      *
'*                                                                     *
'*                                                                     *
'* INPUT:     NumB%       : Number of Blinks to Perform                *
'*                          (0 - will disable flicker)                 *
'*            LocX%       : Location on the screen X                   *
'*            LocY%       : Location on the screen Y                   *
'*            HFG%        : Highlight color foreground                 *
'*            HBG%        : Highlight color background                 *
'*            NFG%        : Normal color foreground (set on exit)      *
'*            NBG%        : Normal color background (set on exit)      *
'*            FlickerStr$ : Character Line - string to flicker/blink   *
'*                                                                     *
'*                                                                     *
'* NOTES:  If you wish to disable the blinking effect just set the     *
'*         number of blinks to 0 (text will then just highlight).      *
'*         The normal background and foreground colors are reset       *
'*         on exit from the routine.                                   *
'*                                                                     *
'*                                                                     *
'* Bob Cox '89                                          QuickBASIC 4.5 *
'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

  CONST Delay! = .02  'Blink/Flicker Delay (Recommend .01-.05)

  IF NumB% > 0 THEN
    'Blink the text using color changes and reprints
    FOR BlinkLoop% = 1 TO NumB%
      COLOR HFG%, HBG%
      LOCATE LocY%, LocX%: PRINT FlickerStr$ 'Display highlighted line
      TimeOut! = TIMER + Delay!: WHILE TimeOut! > TIMER: WEND  'Wait
      COLOR NFG%, NBG%
      LOCATE LocY%, LocX%: PRINT FlickerStr$  'Display normal line
      TimeOut! = TIMER + Delay!: WHILE TimeOut! > TIMER: WEND  'Wait
    NEXT
  END IF

  COLOR HFG%, HBG%: LOCATE LocY%, LocX%
  PRINT FlickerStr$ 'Display highlighted line
  COLOR NFG%, NBG%  'Reset colors

END SUB

SUB GetKeyAndCode (KeyPress$, ExtendedFlag%, KeyCode%)

'***************************************************************************
'*                                                                         *
'*                       Get Key Press and ASCII Code                      *
'*                              GetKeyAndCode                              *
'*                                                                Ver 1.00 *
'*                                                                         *
'* FUNCTION:  This routine waits for the user to press a key and then      *
'*            returns the key press in character form as well as the       *
'*            ASCII code AND a flag that indicates if the ASCII code       *
'*            is an extended ASCII code or normal ASCII code.              *
'*                                                                         *
'*                                                                         *
'* *********************************************************************** *
'* ARGUMENTS:                                                              *
'* *********************************************************************** *
'*                                                                         *
'*   OUTPUT:                                                               *
'*     KeyPress$     : The key pressed (1 char if norm./2 chars if ext.)   *
'*     ExtendedFlag% : Extended ASCII code flag (TRUE=KeyCode% is ext.)    *
'*     KeyCode%      : ASCII or Extended ASCII code of the key pressed     *
'*                                                                         *
'*                                                                         *
'* Bob Cox '89                                              QuickBASIC 4.5 *
'***************************************************************************

'***************************************************************************
'* PROCEDURE LOGIC                                                   *******
'***************************************************************************

  'Get keypress
  KeyPress$ = ""
  WHILE KeyPress$ = ""   'Dowhile no key has been pressed
    KeyPress$ = INKEY$   'Look for a keypress
  WEND                   'Enddo

  'Return ASCII code or extended ASCII with Extended Flag set to True
  IF LEN(KeyPress$) > 1 THEN
    ExtendedFlag% = True
    KeyCode% = ASC(RIGHT$(KeyPress$, 1))
  ELSE
    ExtendedFlag% = False
    KeyCode% = ASC(KeyPress$)
  END IF

END SUB

