'***************************************************************************
'*                                                                         *
'*                      MENU.BAS Module Demo Program 1                     *
'*                                DEMO1.BAS                                *
'*                                                                Ver 1.00 *
'*                                                                         *
'***************************************************************************
'*                                                                         *
'* FUNCTION:  This program demonstrates how to use the menu module         *
'*            MENU.BAS.  The calls needed to setup and evoke menus         *
'*            are illustrated here with supporting documentation.          *
'*                                                                         *
'*            There are three menus in this program.  The default          *
'*            number of menus that can be defined at once is three.        *
'*            You can define as many as you need by changing the           *
'*            CONST MaxMenus in the MENU module.                           *
'*                                                                         *
'*            The menus defined in this program do not use all of          *
'*            the options available in the menu module.  In fact,          *
'*            the following menus are not even set to use color.           *
'*                                                                         *
'***************************************************************************
'*                                                                         *
'* *********************************************************************** *
'* PROCEDURES:                                                             *
'* *********************************************************************** *
'*                                                                         *
'*   EXTERNAL FUNCTIONS & SUBROUTINES CALLED BY THIS MODULE:               *
'*                                                                         *
'*   EXTERNAL SUBROUTINES:                                                 *
'*     ColorMenuItemCur    Set the Color Of the Current Item in the Menu   *
'*     FlickerMenu         Set the Flicker Value                           *
'*     InitMenu            Initialize a Menu                               *
'*     Menu                Do a Menu                                       *
'*     MenuCommentArea     Turn the Menu Comment Area On/Off               *
'*     MenuCommentDivd     Place a Divider in the Comment Area             *
'*     MenuCommentText     Place a Line of Text in the Comment Area        *
'*     MenuHolders         Set the Menu Selector Holders                   *
'*     MenuItem            Put an Item into the Menu                       *
'*     MenuItemPointerL    Set the Left Side Pointer to the Items          *
'*     MenuItemPointerR    Set the Right Side Pointer to the Items         *
'*     MenuItemSpacing     Set Spacing Interval Between Menu Items         *
'*     MenuSelector        Turn the Menu Item Selectors On/Off             *
'*     MenuSetLocation     Set the Menu Location On the Screen             *
'*     MenuTitleArea       Turn the Menu Header/Title Area On/Off          *
'*     MenuTitleDivd       Place a Divider in the Title/Header Area        *
'*     MenuTitleText       Place a Line of Text in the Title Area          *
'*     SpaceLMenuBdr       Add Spaces on the Left of the Menu Boarder      *
'*     SpaceLMenuItems     Add Spaces on the Left Side of the Menu Items   *
'*     SpaceRMenuBdr       Add Spaces on the Right of the Menu Boarder     *
'*     SpaceRMenuItems     Add Spaces on the Right Side of the Menu Items  *
'*                                                                         *
'* *********************************************************************** *
'* NOTES & COMMENTS:                                                       *
'* *********************************************************************** *
'*                                                                         *
'*   NOTES:                                                                *
'*                                                                         *
'*                                                                         *
'*   LAST MODIFICATION:                                                    *
'*                                                                         *
'*     DATE        VERSION  PROGRAMMER      DESCRIPTION OF MODIFICATION    *
'*  12/26/1989       1.00    Bob Cox                    N/A                *
'*                                                                         *
'*                                                                         *
'* *********************************************************************** *
'* Bob Cox '89                                              QuickBASIC 4.5 *
'***************************************************************************


'***************************************************************************
'* EXTERNAL PROCEDURE DECLARATIONS                                   *******
'***************************************************************************
DECLARE SUB ColorMenuItemCur (ColorFore%, ColorBack%)
DECLARE SUB FlickerMenu (MenuID%, FlickerCount%)
DECLARE SUB InitMenu (MenuID%)
DECLARE SUB Menu (MenuID%, SI%, Rc%)
DECLARE SUB MenuCommentArea (MenuID%, OnOff%)
DECLARE SUB MenuCommentDivd (MenuID%, Y%, Divd$)
DECLARE SUB MenuCommentText (MenuID%, X%, Y%, Text$)
DECLARE SUB MenuHolders (MenuID%, LHolder$, RHolder$)
DECLARE SUB MenuItem (MenuID%, SelectKey$, MenuItemText$)
DECLARE SUB MenuItemPointerL (MenuID%, Pointer$)
DECLARE SUB MenuItemPointerR (MenuID%, Pointer$)
DECLARE SUB MenuItemSpacing (MenuID%, Spacing%)
DECLARE SUB MenuSelector (MenuID%, OnOff%)
DECLARE SUB MenuSetLocation (MenuID%, X%, Y%)
DECLARE SUB MenuTitleArea (MenuID%, OnOff%)
DECLARE SUB MenuTitleDivd (MenuID%, Y%, Divd$)
DECLARE SUB MenuTitleText (MenuID%, X%, Y%, Text$)
DECLARE SUB SpaceLMenuBdr (MenuID%, NumSpaces%)
DECLARE SUB SpaceLMenuItems (MenuID%, NumSpaces%)
DECLARE SUB SpaceRMenuBdr (MenuID%, NumSpaces%)
DECLARE SUB SpaceRMenuItems (MenuID%, NumSpaces%)


'***************************************************************************
'* CONSTANTS                                                         *******
'***************************************************************************
'Logical constants
CONST On. = 1, Off. = 0


'***************************************************************************
'* PROGRAM EXECUTABLE CODE BEGINS HERE                               *******
'***************************************************************************


'The following calls define the first menu, MENU ONE:
'
' - InitMenu begins each definition.  The variable MenuOne%
'   will now be associated with the menu.  It will be used
'   on all calls to refer to that menu.
' - MenuTitleText & MenuTitleDivd define the header of the menu.
'   Here the text "Menu One" will appear in the first column and
'   on the second line of the menu (not the screen).
'   A divider line between the header text and the menu items
'   is set at line four of the menu.
' - Three menu items are specified with quick select letters.
' - A comment area is set up with a divider line starting the
'   block followed by three lines of text.
'   All of the 0's tell the MENU module to auto-located/auto-center
'   each item.  With the 0's coded the order in which the items
'   occur becomes important.  Since MenuCommentDivd is coded first
'   the divider will be located before the text in the comment area.
' - Finally, a couple of spacing options are set to help provide
'   readability.  SpaceLMenuBdr places spaces off the left boarder,
'   this moves the quick select letters over one to the right.
'   SpaceLMenuItems places spaces off the left side of the menu items,
'   this moves the menu item text to the right of the quick select letters.

'MENU 1 *******
InitMenu MenuOne%
'MENU TITLE ****
MenuTitleText MenuOne%, 1, 2, "Menu One"
MenuTitleDivd MenuOne%, 4, "͹"
'MENU ITEMS ****
MenuItem MenuOne%, "F", "First Option in the Menu"
MenuItem MenuOne%, "S", "Second Option in the Menu"
MenuItem MenuOne%, "T", "Third Option in the Menu"
'MENU COMMENT ****
MenuCommentDivd MenuOne%, 0, "Ķ"
MenuCommentText MenuOne%, 0, 0, "Please Select From Above Options"
MenuCommentText MenuOne%, 0, 0, "or"
MenuCommentText MenuOne%, 0, 0, "Use arrows and press [Enter]"
'MENU DISPLAY OPTIONS ****
SpaceLMenuBdr MenuOne%, 2
SpaceLMenuItems MenuOne%, 1



'The following calls define the second menu, MENU TWO:
'
' - InitMenu begins the definition.
' - MenuTitleText & MenuTitleDivd define the header of the menu.
'   Here the text "Menu Two" will appear centered on the first line
'   of the menu (not the screen), followed by a divider line.
'   Since the 0's are coded for the title (on the text and
'   divider line), they appear in the menu in the order in
'   which they are coded.
' - Three menu items are specified with quick select letters.
' - A comment area is set up with two lines of text.  The first line
'   of text in the comment area is a null ("") and can be used to
'   provide a blank line (this applies to the title area as well).
' - A few options are coded.  MenuItemSpacing is used to double
'   space the items in the menu.  MenuHolders specify character(s)
'   that will surround the quick select letters.

'MENU 2 *******
InitMenu MenuTwo%
'MENU TITLE ****
MenuTitleText MenuTwo%, 0, 0, "Menu Two"
MenuTitleDivd MenuTwo%, 0, "͹"
'MENU ITEMS ****
MenuItem MenuTwo%, "F", "First Option"
MenuItem MenuTwo%, "S", "Second Option"
MenuItem MenuTwo%, "T", "Third Option"
'MENU COMMENT ****
MenuCommentText MenuTwo%, 0, 0, ""
MenuCommentText MenuTwo%, 0, 0, "Select From Above Options"
'MENU DISPLAY OPTIONS ****
SpaceLMenuBdr MenuTwo%, 2
SpaceLMenuItems MenuTwo%, 1
MenuItemSpacing MenuTwo%, 2
MenuHolders MenuTwo%, "[", "]"



'The following calls define the third menu, MENU THREE:
'  The default number of menus that can be defined at
'  once is three - you can define as many as you need
'  by changing the CONST MaxMenus in the MENU module.
'
' - InitMenu begins the definition.
' - MenuTitleText & MenuTitleDivd define the header of the menu.
' - Nine menu items are specified with quick select numbers.
' - A comment area is set up with two lines of text.
' - A few options are coded.  SpaceRMenuBdr places spaces off the
'   right boarder.  MenuItemPointerL and MenuItemPointerR place
'   pointers on the left and right side of the menu to point
'   at the current item (one or both can be used).  FlickerMenu
'   flashes/flickers the item that is selected.

'MENU 3 *******
InitMenu MenuThree%
'MENU TITLE ****
MenuTitleText MenuThree%, 0, 0, "Menu Three"
MenuTitleDivd MenuThree%, 0, "͹"
'MENU ITEMS ****
MenuItem MenuThree%, "1", "Option Number 1"
MenuItem MenuThree%, "2", "Option Number 2"
MenuItem MenuThree%, "3", "Option Number 3"
MenuItem MenuThree%, "4", "Option Number 4"
MenuItem MenuThree%, "5", "Option Number 5"
MenuItem MenuThree%, "6", "Option Number 6"
MenuItem MenuThree%, "7", "Option Number 7"
MenuItem MenuThree%, "8", "Option Number 8"
MenuItem MenuThree%, "9", "Option Number 9"
'MENU COMMENT ****
MenuCommentText MenuThree%, 0, 0, ""
MenuCommentText MenuThree%, 0, 0, "Select 1 - 9"
'MENU DISPLAY OPTIONS ****
SpaceLMenuBdr MenuThree%, 2
SpaceLMenuItems MenuThree%, 1
SpaceRMenuBdr MenuThree%, 2
MenuHolders MenuThree%, "[", "]"
MenuItemPointerL MenuThree%, ""
MenuItemPointerR MenuThree%, ""
FlickerMenu MenuThree%, 7



'Display/select from the menus
CLS
Menu MenuOne%, OptionSelected1%, ReturnCode%
CLS
Menu MenuTwo%, OptionSelected2%, ReturnCode%
CLS
Menu MenuThree%, OptionSelected3%, ReturnCode%



'Position the menus at specific locations on the screen
MenuSetLocation MenuOne%, 1, 1
MenuSetLocation MenuTwo%, 40, 10
MenuSetLocation MenuThree%, 1, 3



'Display/select from the menus
CLS
Menu MenuOne%, OptionSelected1%, ReturnCode%
CLS
Menu MenuTwo%, OptionSelected2%, ReturnCode%
CLS
Menu MenuThree%, OptionSelected3%, ReturnCode%



'Change/set some options on MENU 1
MenuSelector MenuOne%, Off.           'Don't display the quick selectors
MenuCommentArea MenuOne%, Off.        'Don't display the comment area
MenuSetLocation MenuOne%, 0, 0        'Auto-center the menu on the screen

'Change/set some options on MENU 2
MenuSelector MenuTwo%, Off.           'Don't display the quick selectors
MenuTitleArea MenuTwo%, Off.          'Don't display the title area
MenuItem MenuTwo%, "", "ADDED OPTION" 'Add a new menu item (no selector)

'Change/set some options on MENU 3
MenuSetLocation MenuThree%, 0, 0      'Auto-center the menu on the screen
MenuSelector MenuThree%, Off.         'Don't display the quick selectors
MenuTitleArea MenuThree%, Off.        'Don't display the title area
MenuCommentArea MenuThree%, Off.      'Don't display the comment area
SpaceRMenuItems MenuThree%, 1         'Set the spacing to the right of the menu items



'Display the menus
CLS
Menu MenuOne%, OptionSelected1%, ReturnCode%
CLS
ColorMenuItemCur 0, 7
Menu MenuTwo%, OptionSelected2%, ReturnCode%
ColorMenuItemCur 15, 0
CLS
Menu MenuThree%, OptionSelected3%, ReturnCode%


'Display last selected option from each menu
CLS
PRINT "Option Selected from MENU 1:"; OptionSelected1%
PRINT "Option Selected from MENU 2:"; OptionSelected2%
PRINT "Option Selected from MENU 3:"; OptionSelected3%

