PAGE ,132	
.model medium,basic

comment |

	PatchINT3D is a workaround for a wart in the floating point
libraries of VB for DOS earlier earlier MS Basic compilers.  See the CIS
message at the end of this file.  A 2x to 4x floating point performance 
improvement may be seen in some cases using this patch.

	Problem:  Expanded memory emulators slow floating point
		  operations when a coprocessor is present.  The floating
		  point compiled code consists of INTx calls to the
		  respective library functions.  The INTx calls are self
		  modifying code fragments that are converted to inline 
		  x87 operations when a coprocessor is present.  One of these
		  calls (INT 3D) does not convert, but instead simply executes
		  a WAIT instruction from within the INT call.  When EMM 
		  emulators are present the INT calls are slow because they 
		  are virtuilized by the emulator.

		  Although we haven't attempted to check this, it appears this
		  same wart existed in the other MS high level languages since
		  they share floating point libraries.  The fix contained 
		  herein would probably apply to C7 (prior to the patch kit)
		  earlier.

	Solution: The solution, provided by Jonathan Sawyer (see attached 
		  messages) is to replace the INT 3D handler with a routine 
		  that modifies the call (similar to the other INT handlers) 
		  to an inline WAIT instruction (and a NOP).

		  The routine below will replace the INT handler.  In order
		  to use this fix you should place the call

		  CALL PatchINT3D

		  early in your program code.

		  This fix, as shown, will replace the INT3D operation with
		  a WAIT instruction in all cases.  Even if a coprocessor 
		  isn't present a WAIT instruction will still be placed 
		  inline and, while this isn't ideal, there should be no 
		  bad effects from it.  This fix works for VBDOS in both 
		  compile modes (standalone and runtime). It is not needed 
		  and should *not* be used if the alternate math library 
		  "/FPa" is used.  This code is equivalent to the code 
		  Jonathan posted in the forum and it is reported to work 
		  fine with Basic PDS and QuickBasic as well, though it is 
		  untested here.		  
		  
		  In VBDOS a slightly better solution for the "no coprocessor
		  present" case is to allow the existing interrupt handler to
		  function, which replaces the INT3D with a MOV AX,AX (faster
		  than NOP!) instruction.  Removing the ";**" from lines
		  below will allow the patch program to detect the presence
		  of the coprocessor and act only if one is found (note that
		  this option works only for VBDOS compiled for standalone
		  "/O").  This option is equivalent to the library found in
		  MS Visual C++ 1.0.  Although this addition is, in theory, a 
		  little better you probably won't be able to detect a 
		  difference.

	Note:	  The code below is equivalent to the code Jonathan provided
		  with the exceptions noted above.  Procedure names were 
		  changed to reduce the probability of conflict with other
		  libraries.  Jonathan and others have reported using this
		  fix with success in a number of cases including PDS and
		  QuickBasic 4.x.  This specific routine has only been used
		  in small test programs with VB for DOS as of this date.

		  Jonathan's note below indicates the patch works for the
		  standalone (/O) mode, but my tests failed to find a problem
		  with it using the runtime mode either.

	Disclaimers:
		  This fix appears to work the same as later releases of the
		  floating point library by Microsoft.  However, it may not 
		  work for you, it may blow up your program, you may not like
		  it.  If you don't like it don't use it.  If it breaks
		  something don't blame me (or Jonathan).  Use at your own 
		  risk.  If you spot a problem please report it so that the
		  problem might be fixed.


		  Dan Barclay
		  1/5/94
|

;** extrn __fptaskdata:Far

.code
	
PatchINT3D PROC FAR            	    ;this is the routine you call
        PUSH    ES                  ;save es
	PUSH	DS

	XOR     AX,AX               ;set es to the
	MOV     ES,AX               ;segment at 0
	MOV     BX,0F4H             ;point to the vector for INT 3D

				    ; check x87 found flag
;**	MOV	AX,seg __fptaskdata ; get segment for fp data
;**	MOV	DS,AX
;**	CMP	BYTE PTR ds:[0004],00	; Is coproc or FP emulator in play?
;**	JE	DbFPEM		    ; leave alone if no x87

        MOV     WORD PTR ES:[BX],OFFSET DbISR87
                                    ;store the new service routine
        MOV     ES:[BX]+2,CS        ;vector

DbFPEM:
	POP	DS		    ;restore ds
        POP     ES                  ;restore es
        RET                         ;and return 
PatchINT3D ENDP

DbISR87 PROC    NEAR                ;this is the interrupt service routine for coproc
        PUSH    BP                  ;save bp
        MOV     BP,SP               ;
        PUSH    BX
        MOV     BX,[BP]+2           ;retrieve the IP of next instruction
        SUB     BX,2                ;subtract 2 to point to INT 3D instruction
        PUSH    ES                  ;save es
        MOV     ES,[BP]+4           ;retrieve the segment of INT 3D
        MOV     WORD PTR ES:[BX],909BH
                                    ;store a NOP and WAIT instruction
        POP     ES                  ;restore ES
        POP     BX
        POP     BP                  ;restore BP
        WAIT                        ;we need to execute a WAIT for this time
        IRET                        ;and return 
DbISR87 ENDP


END

comment |

#: 212295 S13/DOS Visual Basic
    26-Dec-93  22:19:07
Sb: #212240-PROF ED: Optimizations?
Fm: Jonathan Sawyer 76360,3417
To: Andrew E. Gross 73220,504 (X)

The patch is an ASM subroutine (INT3D) you call once at the beginning of your
program. This is the patch source in ASM:

        PUBLIC  INT3D INT3D   PROC    FAR                 ;this is the routine
you call
        PUSH    ES                  ;save es
        XOR     AX,AX               ;set es to the
        MOV     ES,AX               ;segment at 0
        MOV     BX,0F4H             ;point to the vector for INT 3D
        MOV     WORD PTR ES:[BX],OFFSET ISR
                                    ;store the new service routine
        MOV     ES:[BX]+2,CS        ;vector
        POP     ES                  ;restore es
        RET                         ;and return INT3D   ENDP

ISR     PROC    NEAR                ;this is the interrupt service routine
        PUSH    BP                  ;save bp
        MOV     BP,SP               ;
        PUSH    BX
        MOV     BX,[BP]+2           ;retrieve the IP of next instruction
        SUB     BX,2                ;subtract 2 to point to INT 3D instruction
        PUSH    ES                  ;save es
        MOV     ES,[BP]+4           ;retrieve the segment of INT 3D
        MOV     WORD PTR ES:[BX],909BH
                                    ;store a NOP and WAIT instruction
        POP     ES                  ;restore ES
        POP     BX
        POP     BP                  ;restore BP
        WAIT                        ;we need to execute a WAIT for this time
        IRET                        ;and return ISR     ENDP

Look up the Knowledge Base Article # Q61676 on the MSBASIC Forum for
 MS's statement about this "Problem" This patch eliminates exception checking
and works on QB 4.5, VBDOS and PDS when using the stand alone library (/O).

Although I developed the patch myself, I had help with people on this forum
debugging it.  For that reason I use 'we'.  I am not an employee of MS but a
simple thorn in their toe.  I dont know how to upload this to the libraries.
Let me know how this works out.

Jonathan Sawyer




|
