'============================================================================
'
'                      LDEMO4.BAS - LITE Window Demo #4
'                         ProWindows(tm) LITE 4.00
'              (c) Copyright 1988-1991 DSE Software Publishing
'
'==========================================================================
'
'    To make use of this demonstration program, you must load BASIC
'    EXATCLY as follows:
'
'         QB LDEMO1 /AH /L LITEDEMO               (for QuickBASIC)
'         QBX LDEMO1 /AH /EA /L LITEDEMO          (for BASIC PDS 7)
'
'==========================================================================

REM $DYNAMIC

' =======================================================================
' These constants should be defined in ALL applications, whether or not
' they are actually used.  If a particular module will not be used, define
' the appropraite as '0'.
' =======================================================================

CONST WINMEMSIZE% = 8191           ' Window memory, used by 'VirMem%()'
CONST SCRNMEMSIZE% = 4096          ' Screen storage memory, used by 'scrn%()'
CONST MAXWINDOWS% = 30             ' Maximum number of windows

' =======================================================================
' INCLUDE modules should follow
' =======================================================================

REM $INCLUDE: 'lite.bi'

CLEAR , , 4096                     ' Set aside additional stack space

' =======================================================================
' Be sure to DIM your variables
' =======================================================================

DIM SHARED VirMem(WINMEMSIZE) AS INTEGER
DIM SHARED scrn(SCRNMEMSIZE) AS INTEGER
DIM SHARED vcb(MAXWINDOWS) AS vircb
DIM SHARED wcb(MAXWINDOWS) AS wincb
DIM SHARED wcbndx(MAXWINDOWS) AS INTEGER

' =======================================================================
' Program initialization code
' =======================================================================

	ReCycleMode 1                           ' enable "Video Recycling" saves 24K

	InitPro                                 ' initialize ProWindows

	MouseInstalled = CheckMouse(buttons)
	
' =======================================================================
' Your code goes here
' =======================================================================

' =======================================================================
' Remove next two "REM" statements for simulated monochrome mode
' =======================================================================

	REM SetBWmode ENABLE
	REM SetMonitorColor 6   '1 is blue, 2 is green, 6 is amber, etc...

MainMenu:
	
	FillScreen 1, 1, 25, 80, attr(0, 1), 176, SNOW

	Notice
	NoticeWin = CurrentWindow
	
	OpenWindow 1, 10, 40, attr(7, 4), 1, 1, 1, SELECTABLE
	OpenWindow 2, 10, 40, attr(7, 5), 1, 1, 2, SELECTABLE
	OpenWindow 3, 10, 40, attr(7, 6), 1, 1, 3, SELECTABLE
	OpenWindow 4, 10, 40, attr(7, 1), 1, 1, 4, SELECTABLE
	OpenWindow 5, 10, 40, attr(11, 2), 1, 1, 5, SELECTABLE
	OpenWindow 6, 10, 40, attr(14, 3), 1, 1, 6, SELECTABLE
	OpenWindow 7, 10, 40, attr(15, 7), 1, 1, 7, SELECTABLE
	OpenWindow 8, 10, 40, attr(7, 1), 1, 1, 8, SELECTABLE
	OpenWindow 9, 10, 40, attr(10, 2), 1, 1, 9, SELECTABLE
	OpenWindow 10, 10, 40, attr(15, 3), 1, 1, 10, SELECTABLE
	OpenWindow 11, 10, 40, attr(7, 4), 1, 1, 11, SELECTABLE

	FOR WinNo = 1 TO 11
		SetWindow WinNo
		TitleWindow 1, " Window " + STR$(WinNo) + CHR$(255)
		wcprint 4, "This is ZOOM style" + STR$(WinNo)
	NEXT
	
	SoundMode = GLISANDO          ' this is what makes the "chirp" sound
	SetZoomSpeed 50               ' slow down the zooms a little

	DisplayWindow 1, 0, 0, 10, 40
	SLEEP 1
	
	DisplayWindow 2, 1, 1, 10, 40
	DisplayWindow 9, 15, 41, 10, 40
	SLEEP 1

	DisplayWindow 4, 1, 41, 10, 40
	DisplayWindow 7, 15, 1, 10, 40
	SLEEP 1

	DisplayWindow 3, 1, 0, 10, 40
	DisplayWindow 8, 15, 0, 10, 40
	SLEEP 1

	DisplayWindow 5, 0, 1, 10, 40
	DisplayWindow 6, 0, 41, 10, 40
	SLEEP 1
	
	DisplayWindow 10, 5, 10, 10, 40
	DisplayWindow 11, 11, 35, 10, 40
	SLEEP 1

	SoundMode = DISABLE

	PopWindow 0, 0, 6, 50, 112, 1, 1, 1
	wcprint 2, "Press ANY Key to MOVE windows"
	cwcprint 3, 127, "(Notice Where Each Window Is)"
	WHILE INKEY$ = "": WEND
	RemoveWindow

	RefreshMode DISABLE           ' make the moves go faster

	MoveWindow 11, 0, 0
	MoveWindow 10, 1, 1
	MoveWindow 9, 1, 0
	MoveWindow 8, 1, 41
	MoveWindow 7, 0, 1
	MoveWindow 6, 0, 41
	MoveWindow 5, 15, 1
	MoveWindow 4, 15, 0
	MoveWindow 3, 15, 41
	MoveWindow 2, 5, 10
	MoveWindow 1, 11, 35

	RefreshMode ENABLE                 ' re-enable the refresh

	RefreshAllWindows                  ' refresh the display

	PopWindow 0, 0, 5, 50, 112, 1, 1, 1
	wcprint 2, "Press ANY Key to CLOSE windows"
	WHILE INKEY$ = "": WEND
	RemoveWindow

	FOR WinNo = 1 TO 11
		CloseWindow WinNo
	NEXT

	CloseWindow NoticeWin

