DEFINT A-Z
DECLARE SUB GetData (UnformattedData$, FormattedData$, DataMask$, ValidChars$, FixupOptions$, AutoEnter%, GetRow%, GetCol%, GetExit%)
DECLARE SUB showDemoScreen ()
DECLARE SUB showShareScreen ()

'-----------------------
'   INPUTMA.BAS
'-----------------------

'   Owned by:       Kirk Woodward
'                   d/b/a People Centered Programs
'                   PO Box 610171
'                   Dallas, TX 75261-0171
'                   817-488-4940
'                   CompuServe:  70146,51
'
'                   Distributed as Shareware, not given into
'                   the Public Domain.
'
'                   If after evaluation, you continue to use it,
'                   you should register it for $15.00.
'                
'                   See the showShareScreen SUB for full benefits
'                   of registration.
'
'                   INPUTMA.BAS is just a demo module, only
'                   GetData SUB needs to go into your application.
'

    SCREEN 0
    COLOR 7, 0

    CLS

    showShareScreen
    CLS
    showDemoScreen


programStarts:

    f = 0
    COLOR 0, 7   '  reverse the data entry fields

    DO
        f = f + 1     ' counts the fields
        IF f = 1 THEN CALL GetData(UnformattedData$, Field1Data$, STRING$(30, 32), "", "", -1, 6, 3, GetExit)
        IF f = 2 THEN CALL GetData(UnformattedData$, Field2Data$, STRING$(18, 32), "N", "", -1, 6, 36, GetExit)
        IF f = 3 THEN CALL GetData(UnformattedData$, Field3Data$, " ", "L", "U", -1, 6, 69, GetExit)
        IF f = 4 THEN CALL GetData(UnformattedData$, Field4Data$, STRING$(20, 32), "L", "L", -1, 10, 3, GetExit)
        IF f = 5 THEN CALL GetData(UnformattedData$, Field5Data$, "(   )-   -    ", "N", "", -1, 10, 28, GetExit)
        IF f = 6 THEN CALL GetData(UnformattedData$, Field6Data$, "  /  /  ", "N", "", -1, 10, 45, GetExit)
        IF f = 7 THEN CALL GetData(UnformattedData$, Field7Data$, "   -  -    ", "N", "", -1, 10, 62, GetExit)

        GOSUB showFeatures:

        UnformattedData$ = ""

        SELECT CASE GetExit

            CASE 2
                f = f - 2             ' shift+Tab was pressed, back up a field
                IF f < 1 THEN f = 0

            CASE 3
                EXIT DO               '  ESC key was pressed

        END SELECT

    LOOP UNTIL f > 7

    GOSUB showFeatures


    COLOR 7, 0

    DO

        LOCATE 16, 25: PRINT " <S>ave    <E>dit    <Q>uit "

        d$ = UCASE$(INPUT$(1))



        LOCATE 16, 25: PRINT "                              "

        SELECT CASE d$

            CASE "S"
                LOCATE 12, 5
                PRINT "  Write the Record to a file...."
                SLEEP 2
                f = 8
                GOSUB showFeatures:
                GOTO programStarts:

            CASE "E"
                GOTO programStarts:

            CASE "Q"
                COLOR 15, 0
                CLS
                showShareScreen
                END

            CASE ELSE
                LOCATE 16, 25
                COLOR 0, 7
                PRINT " Not a valid selection"
                SLEEP 1
                COLOR 7, 0
                LOCATE 16, 25
                PRINT SPACE$(30)



        END SELECT

    LOOP UNTIL INSTR("SEQ", d$) > 0




SLEEP


END

showFeatures:          

        COLOR 15, 0

        LOCATE 12, 5: PRINT SPACE$(75)
        LOCATE 12, 5

        SELECT CASE f

            CASE 2
                PRINT "Shift + TAB backs up a field."

            CASE 3
                PRINT "And, of course, we can force all caps, or all lower case."

            CASE 4
                PRINT "On that field we elected to force lower case."
                LOCATE 10, 3: PRINT Field4Data$

            CASE 5
                PRINT "One could just as easily force letters into the mask."

            CASE 8
                PRINT " You can retain as much as you want from previous record..."
                SLEEP 1
                LOCATE 12, 5: PRINT SPACE$(75)


         END SELECT

        COLOR 0, 7

        RETURN

SUB GetData (UnformattedData$, FormattedData$, DataMask$, ValidChars$, FixupOptions$, AutoEnter, GetRow, GetCol, GetExit)

IF LEN(DataMask$) > 0 THEN             'required field; defines the max data length
   GOSUB BuildUserMask                 'generate a working mask
ELSE
   GetExit = -1                        'can't continue
   EXIT SUB
END IF

GOSUB MergeDataAndMask                 'merge the mask with existing data (if any)
GOSUB FindAutoEnterPos                 'find the last user-enterable data position
GOSUB SetUserChars                     'generate valid character list

OrigInput$ = UserInput$                'save the original data

CursorPos = 0                          'init cursor position in data
GOSUB SetCursorPosFwd                  'move to first user-enterable data position
GOSUB ShowUserInput                    'display the data

GetDone = 0
DO                                     'edit the input data
   GOSUB ProcessKeystrokes
LOOP UNTIL GetDone

GOSUB DoFixups                         'do special data conversions
GOSUB ShowUserInput                    'display final data
GOSUB BuildDataFormats                 'generate formatted and unformatted versions

EXIT SUB                               'return


'=============
BuildUserMask:
'=============
UserInput$ = DataMask$

FOR N = 1 TO LEN(UserInput$)           'hide underscores from the user
    IF MID$(UserInput$, N, 1) = "_" THEN
       MID$(UserInput$, N, 1) = " "
    END IF
NEXT

RETURN

'================
MergeDataAndMask:
'================
IF LEN(UnformattedData$) > 0 THEN      'incoming data is unformatted
   I = 0
   FOR N = 1 TO LEN(DataMask$)         'merge the data with the mask
       IF MID$(DataMask$, N, 1) = " " THEN
          IF I < LEN(UnformattedData$) THEN
             I = I + 1
             MID$(UserInput$, N, 1) = MID$(UnformattedData$, I, 1)
          ELSE
             EXIT FOR                  'stop when the data runs out
          END IF
       END IF
   NEXT
ELSE
   IF LEN(FormattedData$) > 0 THEN     'incoming data is already formatted
      FOR N = 1 TO LEN(DataMask$)      'merge the data with the mask
          IF MID$(DataMask$, N, 1) = " " THEN
             IF N <= LEN(FormattedData$) THEN
                MID$(UserInput$, N, 1) = MID$(FormattedData$, N, 1)
             END IF
          END IF
      NEXT
   END IF
END IF

RETURN

'========
DoFixups:
'========
FixedInput$ = UserInput$

IF INSTR(FixupOptions$, "U") THEN      'make all uppercase
   UserInput$ = UCASE$(UserInput$)
   FixedInput$ = UserInput$
END IF

IF INSTR(FixupOptions$, "L") THEN      'make all lowercase
   UserInput$ = LCASE$(UserInput$)
   FixedInput$ = UserInput$
END IF

IF INSTR(FixupOptions$, "0") THEN      'change all blanks to zeros
   FOR N = 1 TO LEN(DataMask$)
       IF MID$(DataMask$, N, 1) = " " THEN
          IF MID$(UserInput$, N, 1) = " " THEN
             MID$(UserInput$, N, 1) = "0"
          END IF
       END IF
   NEXT

   FixedInput$ = UserInput$
END IF

IF INSTR(FixupOptions$, "T") THEN      'trim leading and trailing blanks
   LSET UserInput$ = LTRIM$(UserInput$)
   FixedInput$ = RTRIM$(UserInput$)
END IF

RETURN

'================
BuildDataFormats:
'================
FormattedData$ = FixedInput$           'user data is already formatted
UnformattedData$ = ""

FOR N = 1 TO LEN(DataMask$)            'unmerge the data from the mask
    IF MID$(DataMask$, N, 1) = " " THEN
       IF N <= LEN(FixedInput$) THEN
          UnformattedData$ = UnformattedData$ + MID$(FixedInput$, N, 1)
       END IF
    END IF
NEXT

RETURN

'================
FindAutoEnterPos:
'================
FOR N = LEN(DataMask$) TO 1 STEP -1    'find the last user-enterable data position
    IF MID$(DataMask$, N, 1) = " " THEN
       AutoEnterPos = N
       EXIT FOR
    END IF
NEXT

RETURN

'============
SetUserChars:
'============
Letters$ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
Numbers$ = "0123456789"
Punc$ = "!@#$%^&*?()[]{}<>\/`'-_+=;:,.~|" + CHR$(32) + CHR$(34)

SELECT CASE ValidChars$
   CASE ""                             'use all letters, numbers, and punctuation
      UserChars$ = Letters$ + Numbers$ + Punc$

   CASE "L"
      UserChars$ = Letters$            'use only letters

   CASE "N"
      UserChars$ = Numbers$            'use only numbers

   CASE "LN", "NL"                     'use only letters and numbers
      UserChars$ = Letters$ + Numbers$

   CASE ELSE                           'user-defined character list
      UserChars$ = ValidChars$

END SELECT

RETURN

'===============
SetCursorPosFwd:
'===============
IF CursorPos < LEN(UserInput$) THEN    'find next user-enterable position
   FOR N = CursorPos + 1 TO LEN(UserInput$)
       IF MID$(DataMask$, N, 1) = " " THEN
          CursorPos = N
          EXIT FOR
       END IF
   NEXT
END IF

RETURN

'================
SetCursorPosBack:                      'find previous user-enterable position
'================
IF CursorPos > 1 THEN
   FOR N = CursorPos - 1 TO 1 STEP -1
       IF MID$(DataMask$, N, 1) = " " THEN
          CursorPos = N
          EXIT FOR
       END IF
   NEXT
END IF

RETURN

'=============
ShowUserInput:
'=============
LOCATE GetRow, GetCol, 0               'redisplay input data
PRINT UserInput$;

LOCATE GetRow, GetCol + CursorPos - 1, 1
                                       'reposition user cursor
RETURN

'=================
ProcessKeystrokes:
'=================
K$ = INKEY$                            'read keystroke, and react

SELECT CASE K$
   CASE CHR$(8)                        'Backspace
      MID$(UserInput$, CursorPos, 1) = " "

      GOSUB SetCursorPosBack
      GOSUB ShowUserInput

   CASE CHR$(0) + CHR$(71)             'Home
      CursorPos = 0
      GOSUB SetCursorPosFwd
      GOSUB ShowUserInput

   CASE CHR$(0) + CHR$(79)             'End
      CursorPos = LEN(UserInput$) + 1
      GOSUB SetCursorPosBack
      GOSUB ShowUserInput

   CASE CHR$(0) + CHR$(75)             'Left Arrow
      GOSUB SetCursorPosBack
      GOSUB ShowUserInput

   CASE CHR$(0) + CHR$(77)             'Right Arrow
      GOSUB SetCursorPosFwd
      GOSUB ShowUserInput

   CASE CHR$(13)                       'Enter; accept the new data
      GetDone = NOT GetDone
      GetExit = 0

   CASE CHR$(9)                        'Tab; accept the new data
      GetDone = NOT GetDone
      GetExit = 1

   CASE CHR$(0) + CHR$(15)             'BackTab; accept the new data
      GetDone = NOT GetDone
      GetExit = 2

   CASE CHR$(27)                       'Esc; restore the original data
      UserInput$ = OrigInput$
      GetDone = NOT GetDone
      GetExit = 3

   CASE ""

   CASE ELSE                           'must be a data character
      IF INSTR(UserChars$, K$) THEN    'if it's valid
         MID$(UserInput$, CursorPos, 1) = K$
                                       'insert it into the data

         IF AutoEnter AND CursorPos = AutoEnterPos THEN
            GetDone = NOT GetDone      'if AutoEnter is ON and it's the last character
            GetExit = 0                'simulate an Enter keystroke
         ELSE
            GOSUB SetCursorPosFwd      'else move the cursor
         END IF

         GOSUB ShowUserInput
      ELSE
         SOUND 440, 1                  'signal invalid character
      END IF

END SELECT

RETURN

END SUB

DEFSNG A-Z
SUB showDemoScreen

PRINT "ͻ";
PRINT "         INPUTMA.BAS  The Demonstration Module for the SUB: GetData          ";
PRINT "͹";
PRINT " Accept Any Printable Character  Accept Numbers Only  Single Key Stroke Only";
PRINT "Ķ";
PRINT "                                                                            ";
PRINT "͹";
PRINT " Accept Characters Only  Enter a Phone*  Enter A Date*  Enter SS Number*   ";
PRINT "Ķ";
PRINT "                                                                           ";
PRINT "͹";
PRINT "                                                                              ";
PRINT "                                                                              ";
PRINT "                                                                              ";
PRINT "                                                                              ";
PRINT "                                                                              ";
PRINT "                                                                              ";
PRINT "                                                                              ";
PRINT "                                                                              ";
PRINT "                                                                              ";
PRINT "                                                                              ";
PRINT "͹";
PRINT " *The SUB allows ANY characters in the 'mask,' including blanks that it will  ";
PRINT "                 skip over -  see .DOC file for full details.                 ";
LOCATE 25, 1: PRINT "ͼ";

END SUB

SUB showShareScreen

PRINT "ͻ";
PRINT "               Input Master  The Definitive User Input Manager               ";
PRINT "  ";
PRINT "         This data entry SUB is distributed under a concept known as:         ";
PRINT "                                                                              ";
PRINT "                                  ShareWare                                   ";
PRINT "                                                                              ";
PRINT "      If, after a reasonable evaluation period, you would like to continue    ";
PRINT "      to use the SUB, you should register with the owner:                     ";
PRINT "                                                                              ";
PRINT "                                Kirk Woodward                                 ";
PRINT "                        d/b/a PEOPLE CENTERED PROGRAMS                        ";
PRINT "             PO Box 610171  Dallas, TX 75261-0171  817-488-4940             ";
PRINT "                           CompuServe ID:  70146,51                           ";
PRINT "                                                                              ";
PRINT "      In exchange for your registration fee of $15, you will receive          ";
PRINT "      the most recent version of the software, free telephone or              ";
PRINT "      CompuServe support and regular advisories as useful additions           ";
PRINT "      are made to this line of 'bargain basement' programming                 ";
PRINT "      tools.                                                                  ";
PRINT "                                                                              ";
PRINT "      PLEASE NOTE: INPUTMA.BAS is just a 'demo driver/carrier' for            ";
PRINT "      the SUB that does ALL the work:  GetData.  GetData is the only          ";
PRINT "      thing that goes to your application, the rest is just demo. (Any key...)";
LOCATE 25, 1: PRINT "ͼ";

DO: LOOP UNTIL INKEY$ > ""

END SUB

