DECLARE FUNCTION DecodePCXtoFile% (FileSpec$, Pal%(), Handle AS INTEGER, H AS ANY)
DECLARE SUB LoadImage (FileSpec$, ImageWidth AS INTEGER, ImageHeight AS INTEGER, ErrorCode AS INTEGER)
DECLARE SUB ReadToScreen (Handle AS INTEGER, Segment AS INTEGER, address AS INTEGER, NumberOfBytes AS INTEGER, ErrorCode AS INTEGER)
'==========================================================
'                       GETIMAGE.BAS
'                  Written by Matt Houser
'==========================================================
'Written and for use with VBDOS v1.0
'VBDOS must be loaded with the /LVBDOS.QLB option for LoadImage
'to work.  DecodePCXtoFile% does not need VBDOS.QLB.
'From what I've heard, Microsoft is NOT planning a v2.0
'Use at your own risk. (I did)
'This file is yours to use and abuse.
'I don't think that there is anything wrong with
'this program.  If there is, let me know (somehow).
'Just one thing, please give credit where credit is due.
'I could have created a QLB, just distributed that, and expect
'you to pay for the source and LIB file.  But I didn't.

'NOTE
'If you decode a PCX picture that has more than ONE plane (such as
'a 24 bit image), the LoadImage sub will not take to kindly to the file.
'Yeah, sure it'll load it and display it, but it will look stretched from
'top to bottom

'Here is an example of how to Decode and load a PCX file:
'Make sure you keep '$INCLUDE: 'VBDOS.BI' in this module!
'$INCLUDE: 'VBDOS.BI'
'$INCLUDE: 'DECPCX.BI'

DIM H AS PCXHeader
REDIM Pal%(1 TO 1)
FileSpec$ = "NEW-4.PCX" 'You'll have to change this
TempFile$ = "~HOUSER.TMP"
CLS

OPEN TempFile$ FOR BINARY AS #1
PRINT "Decoding..."
ok% = DecodePCXtoFile(FileSpec$, Pal%(), 1, H)
CLOSE #1
IF NOT ok% THEN
	PRINT "Error Decoding PCX file"
	END
END IF
'Lets print out the Header information

PRINT "Header Info:"
PRINT
PRINT "Manufacturer (10 means true PCX file):"; H.Manufacturer
PRINT "Version:"; H.Version
PRINT "Encoding"; H.Encoding
PRINT "Bits Per Pixel:"; H.BitsPerPixel
PRINT "Dimensions: ("; H.xMin; ","; H.yMin; ")-("; H.xMax; ","; H.yMax; ")"
PRINT "Number of Planes:"; H.NumberOfPlanes
PRINT "Bytes Per Line:"; H.BytesPerLine
PRINT
PRINT "Press any key to continue..."

DO: LOOP UNTIL INKEY$ <> ""
SCREEN 13
FOR i% = 0 TO (UBOUND(Pal%) + 1) \ 3 - 1
	PALETTE i%, 65536 * Pal%(i% * 3 + 2) + 256 * Pal%(i% * 3 + 1) + Pal%(i% * 3)
NEXT i%
LoadImage TempFile$, (H.xMax - H.xMin + 1), (H.yMax - H.yMin + 1), ErrorCode%
IF ErrorCode% <> 0 THEN
	SCREEN 0, 0, 0, 0
	WIDTH 80
	PRINT "Error:"; ErrorCode:
	IF ErrorCode% > 0 THEN
		ERR = ErrorCode
		PRINT ERROR$
	END IF
	END
END IF
DO: LOOP UNTIL INKEY$ <> ""
SCREEN 0, 0, 0, 0
WIDTH 80

'LoadImage
'
'Parameters:
'   FileSpec$ = Name of the file you wish to display
'   ImageWidth = The width of the IMAGE, not screen or the such
'   ImageHeight = The Height of the IMAGE, not screen or the such
'   ErrorCode = The Return code
'               ErrorCode = 0 -- Success
'               ErrorCode < 0 -- DOS Error * -1
'               ErrorCode > 0 -- VBDOS Error (ERR when error made)
'
SUB LoadImage (FileSpec$, ImageWidth AS INTEGER, ImageHeight AS INTEGER, ErrorCode AS INTEGER)
	ErrorCode = 0
	DIM Handle AS INTEGER
	DIM DOSHandle AS INTEGER
	DIM ReadErrorCode AS INTEGER

	ON LOCAL ERROR GOTO ErrorOpening
	IF DIR$(FileSpec$) = "" THEN ERROR 53
	Handle = FREEFILE
	OPEN FileSpec$ FOR BINARY ACCESS READ AS #Handle
	ON LOCAL ERROR GOTO ErrorLoading
	DOSHandle = FILEATTR(Handle, 2)
	Top% = 0
	Lft% = 0
	Rght% = 319
	Bottom% = 199
	IF ImageHeight - 1 < Bottom% THEN Bottom% = ImageHeight - 1
	IF ImageWidth - 1 < Rght% THEN Rght% = ImageWidth - 1
	FOR y% = Top% TO Bottom%
		SEEK #Handle, CLNG(y%) * ImageWidth + 1
		IF y% < 100 THEN
			Segment% = &HA000
			address% = y% * 320
		ELSE
			Segment% = &HA7D0
			address% = (y% - 100) * 320
		END IF
		ReadToScreen DOSHandle, Segment%, address%, Rght% + 1, ReadErrorCode
		IF ReadErrorCode <> 0 THEN
			ErrorCode = -ReadErrorCode
			EXIT FOR
		END IF
	NEXT y%
	CLOSE #Handle
	EXIT SUB
ErrorLoading:
	CLOSE #Handle
	ErrorCode = ERR
	EXIT SUB
ErrorOpening:
	ErrorCode = ERR
	EXIT SUB
END SUB

SUB ReadToScreen (Handle AS INTEGER, Segment AS INTEGER, address AS INTEGER, NumberOfBytes AS INTEGER, ErrorCode AS INTEGER)
	DIM Registers AS RegTypeX
	ErrorCode = 0

	Registers.ax = &H3F00
	Registers.bx = Handle
	Registers.cx = NumberOfBytes
	Registers.dx = address
	Registers.ds = Segment

	CALL INTERRUPTX(&H21, Registers, Registers)
	IF Registers.flags AND 1 THEN ErrorCode = Registers.ax
END SUB

