DECLARE FUNCTION DecodePCXtoFile% (FileSpec$, Pal%(), Handle AS INTEGER, H AS ANY)
'==========================================================
'                          DECPCX.BAS
'                  Written by Matt Houser
'==========================================================
'Written and for use with VBDOS v1.0
'I hope it's fast enough.  I'm working on makeing it faster.
'From what I've heard, Microsoft is NOT planning a v2.0
'Use at your own risk. (I did)
'This file is yours to use and abuse.
'I don't think that there is anything wrong with
'this program.  If there is, let me know (somehow).
'Just one thing, please give credit where credit is due.
'I could have created a QLB, just distributed that, and expect
'you to pay for the source and LIB file.  But I didn't.

'DECPCX.BI should be $INCLUDE:ed in any module that calls
'this function.
'$INCLUDE: 'DECPCX.BI'

'DecodePCXtoFile% is a function that decodes a ZSoft PCX file
'and stores the data in a file.  The format of the file (starting
'at the byte the function is called at) is:
'   Byte    Coordinate
'   1       (0,0)
'   2       (1,0)
'   3       (2,0)
'   ...
'   n       (Width,Height)
'If there is more than one plane to the PCX file then
'   Byte        Coordinate  Plane
'   1           (0,0)       1
'   2           (1,0)       1
'   3           (2,0)       1
'   ...
'   Width       (Width,0)   1
'   Width+1     (0,0)       2
'   Width+2     (1,0)       2
'   Width+3     (2,0)       2
'   ...
'   2*Width     (Width,0)   2
'   2*Width+1   (0,0)       3
'   2*Width+2   (1,0)       3
'   2*Width+3   (2,0)       3
'   ...
'   3*Width     (Width,0)   3
'
'   When all the planes are done, then the next scan line is put in
'   Following the same format except that (0,0) would become (0,1)
'   etc.
'
'Syntax:
'     Ok% = DecodePCXtoFile%(FileSpec$, Pal%(), Handle%, H)
'
'Return values:
'     -1 = Success
'      0 = Error
'
'Explanation of Parameters:
'FileSpec$  A string containing a valid DOS filename of
'           the PCX file to be decoded.
'
'Pal%()     A integer array containing the palette
'           register values used in the image.  This will
'           be redimensioned depending on the number of colors.
'               Pal%(0) = Red of Color 0
'               Pal%(1) = Blue of Color 0
'               Pal%(2) = Green of Color 0
'               Pal%(3) = Red of Color 1
'               ...
'               Pal%(NumberOfColors*3-1) = Green of Color
'                                          NumberOfColors
'           EXCEPTION:
'               If the BitsPerPixel of the image is 2
'               (H.BitsPerPixel = 2) meaning a CGA palette,
'               Pal%() is read the following way:
'                   Pal%(0) = Background Color
'                             (0 - 15)
'                   Pal%(1) = Color Burst Enable
'                             (0 = Color, 1 = Monochrome)
'                   Pal%(2) = Palette
'                             (0 = Yellow, 1 = White)
'                   Pal%(3) = Intensity
'                             (0 = Dim, 1 = Bright)
'
'Handle     An integer containing the handle (VBDOS) of
'           file that the image data will be placed in.  The data
'           will be placed starting at the current byte location.
'           No SEEK #...'s will be performed.  So SEEK #... before
'           this function is called.
'
'H          A variable of type PCXHeader where the header
'           information will be returned in.
'               TYPE PCXHeader
'                   Manufacturer AS INTEGER
'                   Version AS INTEGER
'                   Encoding AS INTEGER
'                   BitsPerPixel AS INTEGER
'                   xMin AS INTEGER
'                   yMin AS INTEGER
'                   xMax AS INTEGER
'                   yMax AS INTEGER
'                   NumberOfPlanes AS INTEGER
'                   BytesPerLine AS INTEGER
'               END TYPE
'
FUNCTION DecodePCXtoFile% (FileSpec$, Pal%(), Handle AS INTEGER, H AS PCXHeader)
    DIM PCX AS INTEGER

    'Check to see if the file exists
    IF DIR$(FileSpec$) = "" THEN EXIT FUNCTION

    'Open up the PCX file
    PCX = FREEFILE
    OPEN FileSpec$ FOR BINARY AS #PCX

    Manufacturer$ = SPACE$(1)
    GET #PCX, 1, Manufacturer$
    Manufacturer% = ASC(Manufacturer$)
    'Check to see if the file is a valid PCX file
    IF Manufacturer% <> 10 THEN EXIT FUNCTION

    'Get Header information
    Version$ = SPACE$(1)
    GET #PCX, 2, Version$
    Version% = ASC(Version$)

    Encoding$ = SPACE$(1)
    GET #PCX, 3, Encoding$
    Encoding% = ASC(Encoding$)

    BitsPerPixel$ = SPACE$(1)
    GET #PCX, 4, BitsPerPixel$
    BitsPerPixel% = ASC(BitsPerPixel$)

    Dimensions$ = SPACE$(8)
    GET #PCX, 5, Dimensions$
    xMin% = CVI(MID$(Dimensions$, 1, 2))
    yMin% = CVI(MID$(Dimensions$, 3, 2))
    xMax% = CVI(MID$(Dimensions$, 5, 2))
    yMax% = CVI(MID$(Dimensions$, 7, 2))

    NPlanes$ = SPACE$(1)
    GET #PCX, 66, NPlanes$
    NPlanes% = ASC(NPlanes$)

    BytesPerLine$ = SPACE$(2)
    GET #PCX, 67, BytesPerLine$
    BytesPerLine% = CVI(BytesPerLine$)

    PaletteInfo$ = SPACE$(2)
    GET #PCX, 69, PaletteInfo$
    PaletteInfo% = CVI(PaletteInfo$)

    H.Manufacturer = Manufacturer%
    H.Version = Version%
    H.Encoding = Encoding%
    H.BitsPerPixel = BitsPerPixel%
    H.xMin = xMin%
    H.yMin = yMin%
    H.xMax = xMax%
    H.yMax = yMax%
    H.NumberOfPlanes = NPlanes%
    H.BytesPerLine = BytesPerLine%

    Dimx% = xMax% - xMin% + 1
    dimy% = yMax% - yMin% + 1
    TotalBytes% = NPlanes% * BytesPerLine%

    IF BitsPerPixel% = 1 THEN
        MaxColor% = 2
    ELSEIF BitsPerPixel% = 2 THEN
        MaxColor% = 4
    ELSEIF BitsPerPixel% = 4 THEN
        MaxColor% = 16
    ELSEIF BitsPerPixel% = 8 THEN
        MaxColor% = 256
    END IF
    REDIM Pal%(0 TO MaxColor% * 3 - 1)

    IF BitsPerPixel% = 1 THEN
        'Set the Monochrome Palette information
        'Set color 0 to Black
        Pal%(0) = 0
        Pal%(1) = 0
        Pal%(2) = 0
        'Set color 1 to White
        Pal%(3) = 63
        Pal%(4) = 63
        Pal%(5) = 63
    ELSEIF BitsPerPixel% = 2 THEN
        'Get the CGA Palette information
        'This is a little different than
        'the other modes
        BGColor$ = STRING$(1, 0)
        GET #PCX, 17, BGColor$
        Pal%(0) = ASC(BGColor$) \ 16
        CPI$ = STRING$(1, 0)
        GET #PCX, 20, CPI$
        CPI = ASC(CPI$)
        Pal%(1) = (CPI AND 128) \ 128
        Pal%(2) = (CPI AND 64) \ 64
        Pal%(3) = (CPI AND 32) \ 32
    ELSEIF BitsPerPixel% = 4 THEN
        'Get the EGA color map
        ColorMap$ = STRING$(48, 0)
        GET #PCX, 17, ColorMap$
        'Separate it into RGB values
        FOR i% = 0 TO 15
            Pal%(i% * 3) = ASC(MID$(ColorMap$, i% * 3 + 1)) \ 4
            Pal%(i% * 3 + 1) = ASC(MID$(ColorMap$, i% * 3 + 2)) \ 4
            Pal%(i% * 3 + 2) = ASC(MID$(ColorMap$, i% * 3 + 3)) \ 4
        NEXT i%
    ELSEIF BitsPerPixel% = 8 THEN
        'See if there is a VGA Palette
        TestFor12$ = SPACE$(1)
        GET #PCX, LOF(PCX) - 768, TestFor12$
        IF ASC(TestFor12$) = 12 THEN
            'There is
            'Get the VGA RGB Values
            FOR i% = 0 TO 255
                Clr$ = STRING$(3, 0)
                GET #PCX, , Clr$

                Pal%(i% * 3) = ASC(MID$(Clr$, 1, 1)) \ 4
                Pal%(i% * 3 + 1) = ASC(MID$(Clr$, 2, 1)) \ 4
                Pal%(i% * 3 + 2) = ASC(MID$(Clr$, 3, 1)) \ 4
            NEXT i%
        END IF
    ELSE
        EXIT FUNCTION
    END IF

    SEEK #PCX, 129
  
    FOR y% = 0 TO dimy% - 1
        'Go once for every scan line

        Buffer$ = STRING$(TotalBytes%, 0)
        Spot% = 0
        Pointer% = 0
        DO
            'Get a byte from the PCX file
            Byte$ = SPACE$(1)
            GET #PCX, , Byte$
            Byte% = ASC(Byte$)
            'Is is a count byte or data byte
            IF Byte% >= 192 THEN
                'Count byte
                Count% = Byte% - 192
                'Get another byte
                Byte$ = SPACE$(1)
                GET #PCX, , Byte$
            ELSE
                'Data byte
                Count% = 1
            END IF
            Pointer% = Pointer% + Count%
            FOR x% = 1 TO Count%
                'Repeat the data 'Count' times
                Spot% = Spot% + 1
                MID$(Buffer$, Spot%, 1) = Byte$
                IF Spot% = TotalBytes% THEN EXIT DO
            NEXT x%
        LOOP
        'We need to do some rearranging for different
        'screen modes
        IF BitsPerPixel% = 1 THEN
            Bytes$ = STRING$(LEN(Buffer$) * 8, 0)
            FOR i% = 1 TO LEN(Buffer$)
                Num% = ASC(MID$(Buffer$, i%, 1))
                MID$(Bytes$, (i% - 1) * 8 + 1, 1) = CHR$((Num% AND 128) \ 128)
                MID$(Bytes$, (i% - 1) * 8 + 2, 1) = CHR$((Num% AND 64) \ 64)
                MID$(Bytes$, (i% - 1) * 8 + 3, 1) = CHR$((Num% AND 32) \ 32)
                MID$(Bytes$, (i% - 1) * 8 + 4, 1) = CHR$((Num% AND 16) \ 16)
                MID$(Bytes$, (i% - 1) * 8 + 5, 1) = CHR$((Num% AND 8) \ 8)
                MID$(Bytes$, (i% - 1) * 8 + 6, 1) = CHR$((Num% AND 4) \ 4)
                MID$(Bytes$, (i% - 1) * 8 + 7, 1) = CHR$((Num% AND 2) \ 2)
                MID$(Bytes$, (i% - 1) * 8 + 8, 1) = CHR$((Num% AND 1))
            NEXT i%
        ELSEIF BitsPerPixel% = 2 THEN
            Bytes$ = STRING$(LEN(Buffer$) * 4, 0)
            FOR i% = 1 TO LEN(Buffer$)
                Num% = ASC(MID$(Buffer$, i%, 1))
                MID$(Bytes$, (i% - 1) * 4 + 1, 1) = CHR$((Num% AND 192) \ 64)
                MID$(Bytes$, (i% - 1) * 4 + 2, 1) = CHR$((Num% AND 48) \ 16)
                MID$(Bytes$, (i% - 1) * 4 + 3, 1) = CHR$((Num% AND 12) \ 4)
                MID$(Bytes$, (i% - 1) * 4 + 4, 1) = CHR$((Num% AND 3))
            NEXT i%
        ELSEIF BitsPerPixel% = 4 THEN
            Bytes$ = STRING$(LEN(Buffer$) * 2, 0)
            FOR i% = 1 TO LEN(Buffer$)
                Num% = ASC(MID$(Buffer$, i%, 1))
                MID$(Bytes$, (i% - 1) * 2 + 1, 1) = CHR$((Num% AND 240) \ 16)
                MID$(Bytes$, (i% - 1) * 2 + 2, 1) = CHR$((Num% AND 15))
            NEXT i%
        ELSEIF BitsPerPixel% = 8 THEN
            Bytes$ = Buffer$
        END IF
        'Put the final pixel values to file
        PUT #Handle, , Bytes$
    NEXT y%
    'Close 'em up (seuchers, forcepts, scalpal)
    CLOSE #PCX
    'Exit 'OK'
    DecodePCXtoFile% = -1
END FUNCTION

