'==============================================
' FUNDEMO.BAS - Demo and Test Fungus Routines
' By Mike DeBacker
'==============================================

'$INCLUDE: 'FUNGUS_B.BI'
    DECLARE SUB StringMenu ()
    DECLARE SUB DemoStrTok ()
    DECLARE SUB MainMenu ()
    DECLARE SUB DateMenu ()
    DECLARE SUB DemoIsLeapYear ()
    DECLARE SUB ConvertMenu ()
    DECLARE SUB DemoCalcMargin ()
    DECLARE SUB DemoCalcFactor ()
    DECLARE SUB DemoJulianToDate ()
    DECLARE SUB DemoDateToJulian ()
    DECLARE SUB DemoCalcMoon ()
    DECLARE SUB DemoDayOfWeek ()
    DECLARE SUB DemoIsHoliday ()
    DECLARE SUB DemoCalcSunRise ()
    DECLARE SUB DemoMiles ()
    DECLARE SUB DemoCompInt ()
    DECLARE SUB DemoRanString ()
    DECLARE SUB DemoXorEncrypt ()
    DECLARE SUB AboutFungus ()
    

    CALL MainMenu

END

SUB AboutFungus
DIM sCMsg AS STRING

    CLS
    PRINT Center("The Not Ready For Wide Release Programmers Presents", 80)
    PRINT Center("F   U   N  G  U  S", 80)
    PRINT Center("FUNctions: Global, Universal & Simple", 80)
    PRINT Center("Rel. 2.03.06", 80)


    PRINT
    PRINT Center("C O N T R I B U T O R S", 80)
    PRINT "Mike DeBacker - Corona, California, USA"
    PRINT "Wouter De Backer - Belgium"

    PRINT
    PRINT Center("N E W   T O   T H I S   V E R S I O N...", 80)
    PRINT "1] Fixed error in IsLeapYear function"
    PRINT "2] "

    PRINT
    PRINT Center("N E W    F U N C T I O N S...", 80)

    PRINT
    PRINT Center("These functions have been tried and tested in ", 80)
    PRINT Center("QBasic, QBX, VB DOS, VB Win, and VBA environments;", 80)
    PRINT Center("however no warranty is guarrenteed or implied ", 80)
    PRINT Center("through the use of any these functions. Have Fun (gus)!", 80)

    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""

END SUB

SUB ConvertMenu
    DO WHILE -1
        CLS
        PRINT "==========================================="
        PRINT "        GLOBAL FUNCTIONS TEST PROGRAM"
        PRINT "===========Conversion Functions============"
        PRINT "1] Calc Margin"
        PRINT "2] Calc Factor"
        PRINT "3] Calc Miles"
        PRINT "4] Calc Compound Interest & Time To Double"
        PRINT "M] Return To Main"
        PRINT ""
        PRINT "Please Select"
        A$ = ""
        DO
            A$ = INKEY$
        LOOP WHILE A$ = ""
        A$ = UCASE$(A$)
        SELECT CASE A$
            CASE "1": CALL DemoCalcMargin
            CASE "2": CALL DemoCalcFactor
            CASE "3": CALL DemoMiles
            CASE "4": CALL DemoCompInt
            CASE "M": EXIT SUB
            CASE ELSE: BEEP
        END SELECT
    LOOP

END SUB

SUB DateMenu
    DO WHILE -1
        CLS
        PRINT "==========================================="
        PRINT "        GLOBAL FUNCTIONS TEST PROGRAM"
        PRINT "===========Date/Time Functions============="
        PRINT "1] Is Leap Year?"
        PRINT "2] Date to Julian"
        PRINT "3] Julian to Date"
        PRINT "4] Lunar Phase"
        PRINT "5] Day of Week"
        PRINT "6] Is Today A Holiday"
        PRINT "7] Time of Sun Rise"
        PRINT "M] Return To Main"
        PRINT ""
        PRINT "Please Select"
        A$ = ""
        DO
            A$ = INKEY$
        LOOP WHILE A$ = ""
        A$ = UCASE$(A$)
        SELECT CASE A$
            CASE "1": CALL DemoIsLeapYear
            CASE "2": CALL DemoDateToJulian
            CASE "3": CALL DemoJulianToDate
            CASE "4": CALL DemoCalcMoon
            CASE "5": CALL DemoDayOfWeek
            CASE "6": CALL DemoIsHoliday
            CASE "7": CALL DemoCalcSunRise
            CASE "M": EXIT SUB
            CASE ELSE: BEEP
        END SELECT
    LOOP
END SUB

SUB DemoCalcFactor
    PRINT : PRINT
    PRINT "CalcFactor"
    INPUT "Please Enter Profit Margin (xx): "; X!
    y! = CalcFactor(X!)
    PRINT "The answer is :"; STR$(y!)

    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""

END SUB

SUB DemoCalcMargin
    PRINT : PRINT
    PRINT "CalcMargin"
    INPUT "Please Enter Margin Factor (xx.xx): "; X!
    y! = CalcMargin(X!)
    PRINT "The answer is :"; STR$(y!)

    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""
END SUB

SUB DemoCalcMoon
    PRINT : PRINT
    PRINT "CalcMoon"
    INPUT "Please Enter Month (mm): "; mn%
    INPUT "Please Enter Day (dd): "; dy%
    INPUT "Please Enter Year (yyyy): "; yr%
    X% = CalcMoon(mn%, dy%, yr%)
    PRINT "The answer is :"; X%

    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""
END SUB

SUB DemoCalcSunRise

    PRINT : PRINT
    PRINT "CalcSunrise and SunSet For Los Angeles"
    PRINT "Demos the following:"
    PRINT "IsValidDate"
    PRINT "CalcDegToDec"
    PRINT "CalcDecToHM"
    PRINT "CalcSunRise"
    PRINT "CalcSunSet"
    PRINT "IsDstNow"


    INPUT "Please Enter Month (mm): "; mn%
    INPUT "Please Enter Day (dd): "; dy%
    INPUT "Please Enter Year (yyyy): "; yr%

    'Change the comments on the next 4 lines to do a different city
    'INPUT "Please Enter Latitude (ddd, mm): "; latdeg%, latmin%
    'INPUT "Please Enter Longitude (ddd, mm): "; longdeg%, longmin%
    latdeg% = 36: latmin% = 15: latsec% = 18
    longdeg% = 122: longmin% = 1: longsec% = 18

IF IsValidDate(mn%, dy%, yr%) THEN
    Latdec! = CalcDegToDec(latdeg%, latmin%, latsec%)
    Longdec! = CalcDegToDec(longdeg%, longmin%, longsec%)
    t# = CalcSunRise(Latdec!, Longdec!, mn%, dy%, yr%)
    IF IsDstNow(mn%, dy%, yr%) THEN
        t# = t# + 1
        sT$ = "DST"
    ELSE
        sT$ = "STD"
    END IF
    X% = CalcDecToHM(t#, hh%, mm%)
  
    PRINT "Sunrise :"; t#; " or "; hh%; ":"; mm%; sT$

    t# = CalcSunSet(Latdec!, Longdec!, mn%, dy%, yr%)
    IF IsDstNow(mn%, dy%, yr%) THEN
        t# = t# + 1
        sT$ = "DST"
    ELSE
        sT$ = "STD"
    END IF
    X% = CalcDecToHM%(t#, hh%, mm%)
    PRINT "Sunset :"; t#; " or "; hh%; ":"; mm%; sT$
ELSE
    PRINT "Invalid Date!"
END IF

    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""
END SUB

SUB DemoCompInt
    PRINT : PRINT
    PRINT "Compound Interest & Time To Double"
    INPUT "Principle: "; p!
    INPUT "Annual Int Rate: "; i!
    INPUT "Num. Times Compounded: "; c!
    INPUT "Num. Periods to Calculate: "; n!

    y! = CompInt(p!, i!, c!, n!)
    PRINT "The answer is: "; y!
    X% = TimeToDouble%(i!, c!)
    PRINT "Num Periods it would take to double your money: "; X%
    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""
END SUB

SUB DemoDateToJulian
    PRINT : PRINT
    PRINT "DateToJulian"
    INPUT "Please Enter Month (mm): "; mn%
    INPUT "Please Enter Day (dd): "; dy%
    INPUT "Please Enter Year (yyyy): "; yr%
    X& = DateToJulian(mn%, dy%, yr%)
    PRINT "The Julian Date is: "; X&
    y# = JulianToSerial(X&)
    PRINT "The Serial Date is: "; y#
    X& = SerialToJulian(y#)
    PRINT "From Serial To Julian: "; X&
    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""
END SUB

SUB DemoDayOfWeek
    PRINT : PRINT
    PRINT "Day of Week"
    INPUT "Please Enter Month (mm): "; mn%
    INPUT "Please Enter Day (dd): "; dy%
    INPUT "Please Enter Year (yyyy): "; yr%
    X% = DayOfWeek(mn%, dy%, yr%)
    PRINT "The answer is :"; X%

    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""

END SUB

SUB DemoIsHoliday
    DIM sh1 AS STRING
    DIM sh2 AS STRING

    PRINT : PRINT
    PRINT "Is Today A Holiday?"
    INPUT "Please Enter Month (mm): "; mn%
    INPUT "Please Enter Day (dd): "; dy%
    INPUT "Please Enter Year (yyyy): "; yr%
    IF IsHoliday(sh1, sh2, mn%, dy%, yr%) THEN
        PRINT "Yes! : "; sh1; " & "; sh2
    ELSE
        PRINT "Sorry no..."
    END IF

    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""
END SUB

SUB DemoIsLeapYear
    PRINT : PRINT
    PRINT "IsLeapYear"
    INPUT "Please Enter Year (xxxx): "; X%
    y% = IsLeapYear(X%)
    PRINT "The answer is :"; y%

    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""

END SUB

SUB DemoJulianToDate
    PRINT : PRINT
    PRINT "JulianToDate"
    INPUT "Please Enter Julian Date: "; jd&
    X% = JulianToDate(jd&, mn%, dy%, yr%)
    PRINT "The answer is :"; mn%; "/"; dy%; "/"; yr%

    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""
END SUB

SUB DemoMiles
    PRINT : PRINT
    PRINT "Miles Conversion Demo"
    INPUT "Please Enter Miles: "; m!
    ft! = MilesToFeet(m!)
    mi! = FeetToMiles(ft!)
    PRINT "Feet : "; ft!
    PRINT "Back to miles : "; mi!

    in! = FeetToInches(ft!)
    ft! = InchesToFeet(in!)
    PRINT "In Inches : "; in!
    PRINT "And Back to feet : "; ft!

    mt! = InchesToMeters(in!)
    in! = MetersToInches(mt!)
    PRINT "From inches to meters : "; mt!
    PRINT "And back to inches : "; in!

    km! = MilesToKm(mi!)
    mi! = KmToMiles(km!)
    PRINT "From miles to kilometers : "; km!
    PRINT "And back to miles : "; mi!

    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""
END SUB

SUB DemoRanString
DIM nDigits AS INTEGER
DIM RetStr AS STRING

    CLS
    PRINT "Test the Ran String Function"
    LINE INPUT "Enter length of string [4-10]: ", n$
    nDigits = VAL(n$)

    RetStr = RanString$(nDigits)
    PRINT RetStr

    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""

END SUB

SUB DemoStrTok
'Test the Strtoken Function
CLS
PRINT "Test the Strtoken Function"
LINE INPUT "Enter string: ", p$
' Set up the characters that separate tokens.
Delimiters$ = " ,;:().?" + CHR$(9) + CHR$(34)
' Invoke StrTok$ with the string to tokenize.
Token$ = StrTok$(p$, Delimiters$)
WHILE Token$ <> ""
   PRINT Token$
   ' Call StrTok$ with a null string so it knows this
   ' isn't the first call.
   Token$ = StrTok$("", Delimiters$)
WEND
PRINT "Press Any Key To Continue..."
DO
LOOP WHILE INKEY$ = ""
END SUB

SUB DemoXorEncrypt
DIM nDigits AS INTEGER
DIM enckey AS STRING
DIM StringIn AS STRING
DIM StringOut AS STRING
DIM SecondString AS STRING

    'see notes and comments in both functions for more information
    'on their use.

    CLS
    PRINT "Test the Encryption Functions"
    LINE INPUT "Enter length of string [1-255]: ", n$
    nDigits = VAL(n$)

    'first create the key
    enckey = XorGenKey(nDigits)

    'get a string and encrypt it
    LINE INPUT "Enter String of Text: ", StringIn
    StringOut = XorCrypt(StringIn, enckey)
    PRINT
    PRINT "Encrypted String: "; StringOut

    'now decrypt the back
    SecondString = XorCrypt(StringOut, enckey)
    PRINT
    PRINT "Same string - Decrypted: "; SecondString
    PRINT "Press Any Key To Continue..."
    DO
    LOOP WHILE INKEY$ = ""

END SUB

SUB MainMenu
    DO WHILE -1
        'Main Menu
        CLS
        PRINT "==========================================="
        PRINT "        FUNGUS DEMO PROGRAM"
        PRINT "              Rel. 2.03.06"
        PRINT "================MAIN MENU=================="
        PRINT "1] String Functions"
        PRINT "2] Conversion Functions"
        PRINT "3] Date/Time Functions"
        PRINT "4] About This Demo..."
        PRINT ""
        PRINT "Q] Quit"
        PRINT ""
        PRINT "Please Select"
        DO
            A$ = INKEY$
        LOOP WHILE A$ = ""
        A$ = UCASE$(A$)
        SELECT CASE A$
            CASE "1": CALL StringMenu
            CASE "2": CALL ConvertMenu
            CASE "3": CALL DateMenu
            CASE "4": CALL AboutFungus
            CASE "Q": END
        END SELECT
        LOOP
END SUB

SUB StringMenu
    DO WHILE -1
        CLS
        PRINT "==========================================="
        PRINT "        GLOBAL FUNCTIONS TEST PROGRAM"
        PRINT "===========String Functions================"
        PRINT "1] String Token"
        PRINT "2] Random Numbers"
        PRINT "3] Encryption/Decryption"
        PRINT "M] Return To Main"
        PRINT ""
        PRINT "Please Select"
        A$ = ""
        DO
            A$ = INKEY$
        LOOP WHILE A$ = ""
        A$ = UCASE$(A$)
        SELECT CASE A$
            CASE "1": CALL DemoStrTok
            CASE "2": CALL DemoRanString
            CASE "3": CALL DemoXorEncrypt
            CASE "M": EXIT SUB
            CASE ELSE: BEEP
        END SELECT
    LOOP
END SUB

