'======================================================================
' FUNGUS - FUNCTIONS (GLOBAL, UNIVERSAL & SIMPLE)
' Presented By The Not Ready For Wide Release Programmers
'
' FGB003.BAS - Conversion Functions - Version 1.01
' Compiled and Gathered From the Four Corners of Planet Earth
' By Mike DeBacker
'
' Most of these routines were written and tested in QBX PDS 7.1 and then
' tested in VB 3.0 to ensure compatibility
'
' PURPOSE: I get a little tired of doing the same things over and over
' and over again. ("Hey, I need a new battery!")
'
' OTHER FILES: For use with QBasic be sure and include the include
' FUNGUS_B.BI
' ------------------------------------------------------------------
'Version History
' 1.00 - Original, One, and Only with all flaws included
' 1.01 - Fixed CalcAcre, CalcSqMiles, CelToFahr
'-------------------------------------------------------------
'Never fear VB users... VB treats the following line as a comment, but
'a must for QBasic PDS and VB-DOS...
'$INCLUDE: 'FUNGUS_B.BI'

'----------------------------------------------------------------------
' NAME:     CalcAcre(..)
' PURPOSE:  Returns number of acres given the number of square feet
' INPUT:    square feet - sf as single
' OUPUT:    None
' RETURNS:  Acreage as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION CalcAcre! (sf AS SINGLE)
	CalcAcre! = sf / 43560
END FUNCTION

'-------------------------------------------------------------
' CalcDegToHM - Converts Degrees/Minutes to Decimal Form
'
' INPUT:
'   dTime as a double
'   nHour as integer
'   nMinute as integer
'
' OUTPUT: Modifies nHour and nMinute
' RETURNS: True (but who cares)
'-------------------------------------------------------------
FUNCTION CalcDecToHM% (BYVAL dTime AS DOUBLE, nHour AS INTEGER, nMinute AS INTEGER)
	nHour = INT(dTime)
	nMinute = (dTime - INT(dTime)) * 60
	CalDecToHM% = TRUE
END FUNCTION

'-------------------------------------------------------------
' CalcDegToDec - Converts Degrees/Minutes to Decimal Form
'
'-------------------------------------------------------------
FUNCTION CalcDegToDec! (BYVAL nDegree AS INTEGER, BYVAL nMinutes AS INTEGER, BYVAL nSeconds AS INTEGER)
	 CalcDegToDec! = CSNG(nDegree + (nMinutes / 60) + ((nSeconds / 60) / 60))
END FUNCTION

'----------------------------------------------------------------------
' NAME:     CalcDMSToRad!(..)
' PURPOSE:  Converts Degrees,Minutes,Seconds to Radians
' INPUT:    Degrees, Minutes, Seconds as integer
' OUPUT:    None
' RETURNS:  Radians as single
' NOTES:    To convert values from degrees to radians, multiply the angle
'           (in degrees) times PI/180 (or .0174532925199433) where PI = 3.141593.
'----------------------------------------------------------------------
FUNCTION CalcDMSToRad! (BYVAL nDegree AS INTEGER, BYVAL nMinute AS INTEGER, BYVAL nSecond AS INTEGER)
DIM snPI AS SINGLE
DIM snDecDeg AS SINGLE

	snPI = 3.141593
	snDecDeg = CalcDegToDec(nDegree, nMinute, nSecond)
	CalDMSToRad! = snDecDeg * (snPI / 180)

END FUNCTION

'----------------------------------------------------------------------
' NAME:     CalcSqMile(..)
' PURPOSE:  Returns square miles given the number of acres
' INPUT:    acres - acre as single
' OUPUT:    None
' RETURNS:  sq miles as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION CalcSqMile! (acre AS SINGLE)
	CalcSqMile! = acre / 640
END FUNCTION

'----------------------------------------------------------------------
' NAME:     CcToCi(..)
' PURPOSE:  Returns number of cubic inches given the number of cc's
' INPUT:    cubic centimeters as single
' OUPUT:    None
' RETURNS:  cubic inches as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION CcToCi! (cc AS SINGLE)
	CcToCi! = cc * .0610237
END FUNCTION

'----------------------------------------------------------------------
' NAME:     CelToFahr(..)
' PURPOSE:  Returns degrees fahrenheit given degrees celcius
' INPUT:    celcius as single
' OUPUT:    None
' RETURNS:  fahrenheit as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION CelToFahr! (cel AS SINGLE)
	CelToFahr! = 1.8 * (cel + 32)
END FUNCTION

'----------------------------------------------------------------------
' NAME:     CelToKel(..)
' PURPOSE:  Returns degrees kelvin given degrees celcius
' INPUT:    celcius as single
' OUPUT:    None
' RETURNS:  kelvin as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION CelToKel! (cel AS SINGLE)
	CelToKel! = cel + 273.15
END FUNCTION

'----------------------------------------------------------------------
' NAME:     CiToCc(..)
' PURPOSE:  Returns cubic centimeters given cubic inches
' INPUT:    cubic inches as single
' OUPUT:    None
' RETURNS:  cubic centimeters as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION CiToCc! (ci AS SINGLE)
	CiToCc! = ci * 16.387064#
END FUNCTION

'----------------------------------------------------------------------
' NAME:     CupToOz(..)
' PURPOSE:  Returns ounces given cups
' INPUT:    cups as single
' OUPUT:    None
' RETURNS:  ounces as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION CupToOz! (cup AS SINGLE)
	CupToOz! = cup * 8
END FUNCTION

'----------------------------------------------------------------------
' NAME:     FahrToCel(..)
' PURPOSE:  Returns degrees celcius given degrees fahrenheit
' INPUT:    fahrenheit as single
' OUPUT:    None
' RETURNS:  celcius as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION FahrToCel! (fahr AS SINGLE)
	FahrToCel! = (5 * (fahr - 32)) / 9
END FUNCTION

'----------------------------------------------------------------------
' NAME:     FeetToInches(..)
' PURPOSE:  Returns feet given inches
' INPUT:    feet as single
' OUPUT:    None
' RETURNS:  Inches as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION FeetToInches! (feet AS SINGLE)
	FeetToInches! = feet * 12
END FUNCTION

'----------------------------------------------------------------------
' NAME:     FeetToMiles(..)
' PURPOSE:  Returns miles given feet
' INPUT:    feet as single
' OUPUT:    None
' RETURNS:  miles as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION FeetToMiles! (feet AS SINGLE)
	FeetToMiles! = feet * 5280
END FUNCTION

'----------------------------------------------------------------------
' NAME:     InchesToFeet(..)
' PURPOSE:  Returns feet given Inches
' INPUT:    inches as single
' OUPUT:    None
' RETURNS:  feet as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION InchesToFeet! (inches AS SINGLE)
	InchesToFeet! = inches * .0833333
END FUNCTION

'----------------------------------------------------------------------
' NAME:     InchesToMeters(..)
' PURPOSE:  Returns meters given inches
' INPUT:    inches as single
' OUPUT:    None
' RETURNS:  meters as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION InchesToMeters! (inches AS SINGLE)
	InchesToMeters! = inches * .0254
END FUNCTION

'----------------------------------------------------------------------
' NAME:     KmToMiles(..)
' PURPOSE:  Returns miles given kilometers
' INPUT:    kilometers as single
' OUPUT:    None
' RETURNS:  miles as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION KmToMiles! (km AS SINGLE)
	KmToMiles! = km * .6213711
END FUNCTION

'----------------------------------------------------------------------
' NAME:     LbsToKgm(..)
' PURPOSE:  Returns kilograms given pounds
' INPUT:    pounds as single
' OUPUT:    None
' RETURNS:  kilograms as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION LbsToKgm! (lbs AS SINGLE)
	LbsToKgm! = lbs * .45359
END FUNCTION

'----------------------------------------------------------------------
' NAME:     LiterToQt(..)
' PURPOSE:  Returns quarts given liters
' INPUT:    liters as single
' OUPUT:    None
' RETURNS:  quarts as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION LiterToQt! (lt AS SINGLE)
	LiterToQt! = lt * 1.0567
END FUNCTION

'----------------------------------------------------------------------
' NAME:     MetersToInches(..)
' PURPOSE:  Returns inches given meters
' INPUT:    meters as single
' OUPUT:    None
' RETURNS:  inches as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION MetersToInches! (meters AS SINGLE)
	MetersToInches! = CSNG(meters * 39.370078#)
END FUNCTION

'----------------------------------------------------------------------
' NAME:     MilesToFeet(..)
' PURPOSE:  Returns feet given miles
' INPUT:    miles as single
' OUPUT:    None
' RETURNS:  feet as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION MilesToFeet! (miles AS SINGLE)
	MilesToFeet! = miles / 5280
END FUNCTION

'----------------------------------------------------------------------
' NAME:     MilesToKm(..)
' PURPOSE:  Returns kilometers given miles
' INPUT:    miles as single
' OUPUT:    None
' RETURNS:  kilometers as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION MilesToKm! (miles AS SINGLE)
	MilesToKm! = miles * 1.609344
END FUNCTION

'----------------------------------------------------------------------
' NAME:     OzToGm(..)
' PURPOSE:  Returns grams given ounces
' INPUT:    ounces as single
' OUPUT:    None
' RETURNS:  grams as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION OzToGm! (oz AS SINGLE)
	OzToGm! = oz * 28.3495
END FUNCTION

'----------------------------------------------------------------------
' NAME:     OzToTbs(..)
' PURPOSE:  Returns tablespoons given ounces
' INPUT:    ounces as single
' OUPUT:    None
' RETURNS:  tablespoons as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION OzToTbs! (oz AS SINGLE)
	OzToTbs! = oz * 2
END FUNCTION

'----------------------------------------------------------------------
' NAME:     PtToOz(..)
' PURPOSE:  Returns ounces given pints
' INPUT:    pints as single
' OUPUT:    None
' RETURNS:  ounces as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION PtToOz! (pt AS SINGLE)
	PtToOz! = pt * 16
END FUNCTION

'----------------------------------------------------------------------
' NAME:     QtToLiter(..)
' PURPOSE:  Returns liters given quarts
' INPUT:    quarts as single
' OUPUT:    None
' RETURNS:  liters as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION QtToLiter! (qt AS SINGLE)
	QtToLiter! = qt * .9463529
END FUNCTION

'----------------------------------------------------------------------
' NAME:     QtToOz(..)
' PURPOSE:  Returns ounces given quarts
' INPUT:    quarts as single
' OUPUT:    None
' RETURNS:  ounces as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION QtToOz! (qt AS SINGLE)
	QtToOz! = qt * 32
END FUNCTION

'----------------------------------------------------------------------
' NAME:     SqFtToSqIn(..)
' PURPOSE:  Returns sq inches given sq ft
' INPUT:    sq ft as single
' OUPUT:    None
' RETURNS:  sq inch as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION SqFtToSqIn! (sf AS SINGLE)
	SqFtToSqIn! = sf * 144
END FUNCTION

'----------------------------------------------------------------------
' NAME:     SqInToSqCm(..)
' PURPOSE:  Returns sq cm given sq inches
' INPUT:    sq inches as single
' OUPUT:    None
' RETURNS:  sq cm as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION SqInToSqCm! (si AS SINGLE)
	SqInToSqCm! = si * 6.4516
END FUNCTION

'----------------------------------------------------------------------
' NAME:     SqInToSqFt(..)
' PURPOSE:  Returns sq ft given sq inches
' INPUT:    Sq Inches as single
' OUPUT:    None
' RETURNS:  Sq Feet as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION SqInToSqFt! (si AS SINGLE)
	SqInToSqFt! = si * .0069444
END FUNCTION

'----------------------------------------------------------------------
' NAME:     TbsToOz(..)
' PURPOSE:  Returns ounces given tablespoons
' INPUT:    tablespoons as single
' OUPUT:    None
' RETURNS:  ounces as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION TbsToOz! (tbs AS SINGLE)
	TbsToOz! = tbs * .5
END FUNCTION

'----------------------------------------------------------------------
' NAME:     TbsToTsp(..)
' PURPOSE:  Returns teaspoons given tablespoons
' INPUT:    tablespoon as single
' OUPUT:    None
' RETURNS:  teaspoons as single
' NOTES:
'----------------------------------------------------------------------
FUNCTION TbsToTsp! (tbs AS SINGLE)
	TbsToTsp! = tbs * 3
END FUNCTION

