'======================================================================
' FUNGUS - FUNCTIONS (GLOBAL, UNIVERSAL & SIMPLE)
' Presented By The Not Ready For Wide Release Programmers
'
' FGB001.BAS - Ver. 2.03
' Compiled and Gathered From the Four Corners of Planet Earth
' By Mike DeBacker
'
' Most of these routines were written and tested in QBX PDS 7.1 and then
' tested in VB 3.0 to ensure compatibility
'
' PURPOSE: I get a little tired of doing the same things over and over
' and over again.
'
' OTHER FILES: For use with QBasic be sure and include the include
' FUNGUS_B.BI
'**************************Version History*********************
'       1.00 (4/23/94) - First version what more can you ask?
'               StrTok, CalcMargin, CalcFactor, SQLFmtStr
'       1.01 (4/24/94) - Added DateToJulian and JulianToDate
'       1.02 (5/15/94) - Fixed IsNowDST
'       2.03 (6/25/94) - Fixed IsLeapYear
'=============================================================
' ------------------------------------------------------------------
' Have something that you would like to submit to the pile? Here are the
' requirements:
' 1] Must be a Function and not a Sub-Procedure (i.e. it must return
'    something.)
' 2] Must be able to run under QBasic, VB for DOS, and VB for Windows.
' 3] Must not write to anything (Disk, Screen, or I/O ports).
' 4] Must have a header section that clearly describes inputs,
'   outputs (i.e. variables passed by reference that are modified), and
'   what is returned. Also it must be stated if the functions calls any
'   other functions.
' 5] The only global constants that are used are TRUE and FALSE. These
'   are declared as CONST in the QB Include file, but this is not required
'   in VB 2 and above where TRUE and FALSE are reserved keywords (or
'   something of that sort.)
'
' Sample Header:
'----------------------------------------------------------------------
' NAME:     MyFunkyFunction(..)
' PURPOSE:  Does everything have to have a purpose?
' INPUT:    nNumber as integer
' OUPUT:    None
' RETURNS:  TRUE if false and FALSE if True.
' NOTES:    Note well, my friends...
'----------------------------------------------------------------------
'
'-------------------------------------------------------------
'Never fear VB users... VB treats the following line as a comment, but
'a must for QBasic PDS and VB-DOS...
'$INCLUDE: 'FUNGUS_B.BI'

'------------------------------------------------
' NAME : CalcMoon
' INPUT : nYear, nMonth, nDay
' RETURNS: integer indicating the phase of the moon where:
'   -1  If date is invalid
'    0  Full Moon
'    7  Waxing Gibbeous
'    6  First Quarter
'    5  Waxing Crescent
'    4  New Moon
'    3  Waning Crescent
'    2  Last Quarter
'    1  Waning Gibbeous
' DESC: Calculates approximate phase of the moon
'-------------------------------------------------
FUNCTION CalcMoon% (BYVAL nMonth AS INTEGER, BYVAL nDay AS INTEGER, BYVAL nYear AS INTEGER)
DIM dnPhase AS DOUBLE
DIM nPhase AS INTEGER
DIM lnJulian AS LONG
DIM i%

	IF NOT IsValidDate%(nMonth, nDay, nYear) THEN
		CalcMoon% = TRUE
		EXIT FUNCTION
	END IF

	'Calculate the astronomical lnJulian day number
	 lnJulian = DateToJulian(nMonth, nDay, nYear)

	'Calculate the approximate dnPhase of the moon
	 dnPhase = (lnJulian + 4.867) / 29.53059
	 dnPhase = dnPhase - INT(dnPhase)

	IF dnPhase <= 1 THEN nPhase = 0      'Full Moon
	IF dnPhase <= .9375 THEN nPhase = 7  'Waxing Gibbeous
	IF dnPhase <= .75 THEN nPhase = 6    'First Quarter
	IF dnPhase <= .6875 THEN nPhase = 5  'Waxing Crescent
	IF dnPhase <= .5 THEN nPhase = 4     'New Moon
	IF dnPhase <= .4375 THEN nPhase = 3  'Waning Crescent
	IF dnPhase <= .25 THEN nPhase = 2    'Last Quarter
	IF dnPhase <= .1875 THEN nPhase = 1  'Waning Gibbeous

	CalcMoon% = nPhase

END FUNCTION

'--------------------------------------
'CalcSunRise - Calculates Sun Rise Time
'Purpose: Given the month, day, year,
'       Latitude and Longitude
'Input: Latitude in decimal format as single,
'   Longitude in decimal format as single,
'   month, day and year as integer
'Returns: time of sunrise in decimal format as double
'Uses: CalcRadToDec, DateToJulian
'NOTE: see the functions CalcDeg2Dec and CalcDec2HM
'--------------------------------------
FUNCTION CalcSunRise# (BYVAL Latdec AS SINGLE, BYVAL Longdec AS SINGLE, BYVAL nMonth AS INTEGER, BYVAL nDay AS INTEGER, BYVAL nYear AS INTEGER)
DIM snPI AS SINGLE
DIM snJ AS SINGLE
DIM nZ AS INTEGER
DIM timeRise AS DOUBLE

	snPI = 3.141593
	snJ = CalcRadToDec(1)

	IF (Longdec MOD 15) > 7.5 THEN nZ = 1 ELSE nZ = 0
	dDate = DateToJulian(nMonth, nDay, nYear)

	pd = snPI * (dDate - DateToJulian(1, 1, nYear) + 1) / 182.5

	lo = INT((Longdec / 15) + nZ) * 15

	'Declination of Sun
	decl = .456 - 22.915 * COS(pd) - .43 * COS(2 * pd) - .156 * COS(3 * pd) + 3.83 * SIN(pd) + .06 * SIN(2 * pd) - .082 * SIN(3 * pd)

	'Equation of Time
	equat = .008 + .51 * COS(pd) - 3.197 * COS(2 * pd) - .106 * COS(3 * pd) - .15 * COS(4 * pd) - 7.317 * SIN(pd) - 9.471 * SIN(2 * pd) - .391 * SIN(3 * pd) - .242 * SIN(4 * pd)

	'Azimuth of Sunrise
	IF ABS(SIN(decl / snJ) / COS(Latdec / snJ)) < 1 THEN
		azrise = 90 - snJ * ATN(SIN(decl / snJ) / COS(Latdec / snJ) / SQR(1 - (SIN(decl / snJ) / COS(Latdec / snJ)) ^ 2))
	ELSE
		azrise = 0
	END IF

	'Azimuth of Sunset
	azset = 360 - azrise

	'Alt of Sun at Noon
	altitude = 90 + decl - Latdec

	IF ABS(SIN(azrise / snJ) / COS(decl / snJ)) >= 1 THEN
		tt1 = 6
	ELSE
		tt1 = snJ / 15 * ATN(SIN(azrise / snJ) / COS(decl / snJ) / SQR(1 - (SIN(azrise / snJ) / COS(decl / snJ)) ^ 2))
	END IF

'Local Sunrise
	IF decl >= 0 THEN
		X = tt1
	ELSE
		X = 12 - tt1
	END IF
	timeRise = (X + (Longdec - lo) / 15 - equat / 60 - .04) / 24
	timeRise = timeRise * 24
	CalcSunRise# = timeRise
END FUNCTION

'--------------------------------------
'CalcSunSet - Calculates Sun Set Time
'Purpose: Given the month, day, year,
'       Latitude and Longitude
'Input: Latitude in decimal format as single,
'   Longitude in decimal format as single,
'   month, day and year as integer
'Returns: time of sunset in decimal format as double
'Uses: CalcRadToDec and DateToJulian
'NOTE: see the functions CalcDeg2Dec and CalcDec2HM
'--------------------------------------
FUNCTION CalcSunSet# (BYVAL Latdec AS SINGLE, BYVAL Longdec AS SINGLE, BYVAL nMonth AS INTEGER, BYVAL nDay AS INTEGER, BYVAL nYear AS INTEGER)
DIM snPI AS SINGLE
DIM snJ AS SINGLE
DIM nZ AS INTEGER
DIM timeSet AS DOUBLE

	snPI = 3.141593
	snJ = CalcRadToDec(1)

	IF (Longdec MOD 15) > 7.5 THEN nZ = 1 ELSE nZ = 0
	dDate = DateToJulian(nMonth, nDay, nYear)

	pd = snPI * (dDate - DateToJulian(1, 1, nYear) + 1) / 182.5

	lo = INT((Longdec / 15) + nZ) * 15

	'Declination of Sun
	decl = .456 - 22.915 * COS(pd) - .43 * COS(2 * pd) - .156 * COS(3 * pd) + 3.83 * SIN(pd) + .06 * SIN(2 * pd) - .082 * SIN(3 * pd)

	'Equation of Time
	equat = .008 + .51 * COS(pd) - 3.197 * COS(2 * pd) - .106 * COS(3 * pd) - .15 * COS(4 * pd) - 7.317 * SIN(pd) - 9.471 * SIN(2 * pd) - .391 * SIN(3 * pd) - .242 * SIN(4 * pd)

	'Azimuth of Sunrise
	IF ABS(SIN(decl / snJ) / COS(Latdec / snJ)) < 1 THEN
		azrise = 90 - snJ * ATN(SIN(decl / snJ) / COS(Latdec / snJ) / SQR(1 - (SIN(decl / snJ) / COS(Latdec / snJ)) ^ 2))
	ELSE
		azrise = 0
	END IF

	'Azimuth of Sunset
	azset = 360 - azrise

	'Alt of Sun at Noon
	altitude = 90 + decl - Latdec

	IF ABS(SIN(azrise / snJ) / COS(decl / snJ)) >= 1 THEN
		tt1 = 6
	ELSE
		tt1 = snJ / 15 * ATN(SIN(azrise / snJ) / COS(decl / snJ) / SQR(1 - (SIN(azrise / snJ) / COS(decl / snJ)) ^ 2))
	END IF

' Local Sunset
	IF decl >= 0 THEN
		snx = -tt1
	ELSE
		snx = -(12 - tt1)
	END IF
	timeSet = 1 + (snx + (Longdec - lo) / 15 - equat / 60 + .04) / 24
	timeSet = timeSet * 24
	CalcSunSet# = timeSet

END FUNCTION

'--------------------------------------
'DateToJulian - Calculate Julian Date
'Purpose: Given the month, day, and year
'       calculates the julian Date
'Input: month, day and year as integer
'Returns: astronomical julian date as long integer
'   or zero if year < 1584
'Calls: DaysInMonth(..)
'--------------------------------------
FUNCTION DateToJulian& (BYVAL nMonth AS INTEGER, BYVAL nDay AS INTEGER, BYVAL nYear AS INTEGER)
DIM lTermA AS LONG
DIM lTermB AS LONG
DIM lTermC AS LONG

	IF nYear < 1584 THEN
		DateToJulian& = CLNG(0)
		EXIT FUNCTION
	END IF

	IF nDay > DaysInMonth(nMonth, nYear) OR nDay < 1 THEN
		DateToJulian& = CLNG(0)
		EXIT FUNCTION
	END IF

	IF nMonth > 2 THEN
		nMonth = nMonth - 3
	ELSE
		nMonth = nMonth + 9
		nYear = nYear - 1
	END IF

	lTermA = 146097 * (nYear \ 100) \ 4
	lTermB = CLNG(1461) * (nYear MOD 100) \ 4
	lTermC = (CLNG(153) * nMonth + 2) \ 5 + nDay + 1721119

	DateToJulian& = lTermA + lTermB + lTermC

END FUNCTION

'--------------------------------------
'DayOfWeek - Calculate Day of the Week
'Purpose: Given the month, day, and year
'       calculates the Day of the Week
'Input: month, day and year as integer
'Returns: Number for day of the week
'  0= Sunday, 1 = Monday ... 6 = Saturday
'  Returns True (NOT FALSE) if error occurs
'--------------------------------------
FUNCTION DayOfWeek% (BYVAL nMonth AS INTEGER, BYVAL nDay AS INTEGER, BYVAL nYear AS INTEGER)
DIM lnJulian AS LONG

	IF NOT IsValidDate%(nMonth, nDay, nYear) THEN
		DayOfWeek% = TRUE
		EXIT FUNCTION
	END IF

	lnJulian = DateToJulian(nMonth, nDay, nYear)
	IF (lnJulian) THEN
		DayOfWeek% = CINT((lnJulian + 1) MOD 7)
	ELSE
		DayOfWeek% = TRUE
	END IF

END FUNCTION

'----------------------------------------------------------------------
' NAME:     DaysBtwnDates&(..)
' PURPOSE:  Calculates the number of days between two dates
' INPUT:    m1 as integer
'           d1 as integer
'           y1 as integer
'           m2 as integer
'           d2 as integer
'           y2 as integer
' OUPUT:    None
' RETURNS:  Number as days as long integer.
'           A zero could mean that both dates are the same or that
'           one or both dates are invalid. Checking dates first with
'           the IsValidDate function would solve this problem.
' NOTES:    Uses DateToJulian and is called by other functions
'           in the FUNGUS Toolbox.
'           Also, If a negative number is return then it goes
'           without saying j1 > j2
'----------------------------------------------------------------------
FUNCTION DaysBtwnDates& (BYVAL m1 AS INTEGER, BYVAL d1 AS INTEGER, BYVAL y1 AS INTEGER, BYVAL m2 AS INTEGER, BYVAL d2 AS INTEGER, BYVAL y2 AS INTEGER)
DIM j1 AS LONG
DIM j2 AS LONG

	j1 = DateToJulian(m1, d1, y1)
	j2 = DateToJulian(m2, d2, y2)

	IF (j1 = 0) OR (j2 = 0) THEN
		DaysBtwnDates& = CLNG(0)
	ELSE
		DaysBtwnDates& = (j2 - j1)
	END IF

END FUNCTION

'----------------------------------------------------------------------
' NAME:     DaysInMonth%(..)
' PURPOSE:  Returns the number of days in the month
' INPUT:    month and year as integer
' OUPUT:    None
' RETURNS:  number of days as integer
' NOTES:
'----------------------------------------------------------------------
FUNCTION DaysInMonth% (BYVAL nMonth AS INTEGER, BYVAL nYear AS INTEGER)
	SELECT CASE nMonth
		CASE 1: DaysInMonth% = 31
		CASE 2
			IF IsLeapYear(nYear) THEN
				DaysInMonth% = 29
			ELSE
				DaysInMonth% = 28
			END IF
		CASE 3: DaysInMonth% = 31
		CASE 4: DaysInMonth% = 30
		CASE 5: DaysInMonth% = 31
		CASE 6: DaysInMonth% = 30
		CASE 7: DaysInMonth% = 31
		CASE 8: DaysInMonth% = 31
		CASE 9: DaysInMonth% = 30
		CASE 10: DaysInMonth% = 31
		CASE 11: DaysInMonth% = 30
		CASE 12: DaysInMonth% = 31
		CASE ELSE: DaysInMonth% = 0
	END SELECT
END FUNCTION

'--------------------------------------
'IsDstNow - Calculates whether not it is currently Daylight Savings Time
'Input:
'   month, day and year as integer
'Returns: True if DST and False if not
'--------------------------------------
FUNCTION IsDstNow% (BYVAL nMonth AS INTEGER, BYVAL nDay AS INTEGER, BYVAL nYear AS INTEGER)
DIM nDayWeek AS INTEGER
DIM nDayMonth AS INTEGER
DIM targetDate AS LONG
DIM lnJulian AS LONG

	'get the julian date
	lnJulian = DateToJulian(nMonth, nDay, nYear)

	'get the day of the week
	nDayWeek = DayOfWeek(nMonth, nDay, nYear) + 1

	'determine the occurance of the weekday within the month
	nDayMonth = ABS(INT(-(nDay / 7)))

	IF nMonth < 4 OR nMonth > 10 THEN
		IsDstNow% = FALSE
	ELSEIF nMonth > 4 AND nMonth < 11 THEN
		IsDstNow% = TRUE
	END IF

	IF nMonth = 4 THEN
		FOR i% = 1 TO 8
			'get the day of the week
			nDayWeek = DayOfWeek(nMonth, i%, nYear) + 1

			'determine the occurance of the weekday within the month
			nDayMonth = ABS(INT(-(i% / 7)))

			IF (nDayWeek = 1 AND nDayMonth = 1) THEN
				targetDate = DateToJulian(nMonth, i%, nYear)
			END IF
		NEXT i%
		IF lnJulian >= targetDate THEN
			IsDstNow% = TRUE
		END IF
	END IF

	IF nMonth = 10 THEN
		FOR i% = 23 TO 31
			'get the day of the week
			nDayWeek = DayOfWeek(nMonth, i%, nYear) + 1

			'determine the occurance of the weekday within the month
			nDayMonth = ABS(INT(-(i% / 7)))

			IF (i% > 24 AND nDayMonth > 3 AND nDayWeek = 1) THEN
				targetDate = DateToJulian(nMonth, i%, nYear)
			END IF
		NEXT i%
		IF lnJulian >= targetDate THEN
			IsDstNow% = FALSE
		END IF
   END IF

END FUNCTION

'------------------------------------------------
' NAME: IsHoliday (..)
' INPUT:sHoliday1 as string
'       sHoliday2 as string
'       nMonth as integer
'       nDay as integer
'       nYear as integer
' OUTPUT:
'       sHoliday1 as string
'       sHoliday1 as string
' RETURNS: True if Holiday, False if not
'-------------------------------------------------
FUNCTION IsHoliday% (sHoliday1 AS STRING, sHoliday2 AS STRING, BYVAL nMonth AS INTEGER, BYVAL nDay AS INTEGER, BYVAL nYear AS INTEGER)
DIM nDayWeek AS INTEGER
DIM nDayMonth AS INTEGER
DIM pNum AS INTEGER
DIM pMonth AS INTEGER
DIM pDay AS INTEGER
DIM pJulian AS LONG
DIM pDayWeek AS INTEGER
DIM eJulian AS LONG

REDIM paschal(0 TO 18, 0 TO 1) AS INTEGER

	'clear the strings
	sHoliday1 = "": sHoliday2 = ""

'Easter falls on the first Sunday following the arbitrary Paschal Full Moon,
'which does not necessarily coincide with a real or astronomical full moon.
'The date of the Paschal Full Moon is obtained by dividing the year by 19
'and applying the remainder to the following table:
'
'
'         0: Apr 14       5: Apr 18      10: Mar 25      15: Mar 30
'         1: Apr  3       6: Apr  8      11: Apr 13      16: Apr 17
'         2: Mar 23       7: Mar 28      12: Apr  2      17: Apr  7
'         3: Apr 11       8: Apr 16      13: Mar 22      18: Mar 27
'         4: Mar 31       9: Apr  5      14: Apr 10
'
'Thus, for the year 2000 the key is 5 or April 18.  Since April 18th in the
'year 2000 is a Tuesday, Easter Sunday is April 23rd.  CAUTION - If the
'Paschal Full Moon falls on a Sunday, Easter is the following Sunday.  The
'earliest Easter can fall is March 23rd and the latest is April 25th.
'Lent begins on Ash Wednesday which comes 40 days before Easter, excluding
'Sundays, or 45 days overall.

	paschal(0, 0) = 4: paschal(0, 1) = 14
	paschal(1, 0) = 4: paschal(1, 1) = 3
	paschal(2, 0) = 3: paschal(2, 1) = 23
	paschal(3, 0) = 4: paschal(3, 1) = 11
	paschal(4, 0) = 3: paschal(4, 1) = 31
	paschal(5, 0) = 4: paschal(5, 1) = 18
	paschal(6, 0) = 4: paschal(6, 1) = 8
	paschal(7, 0) = 3: paschal(7, 1) = 28
	paschal(8, 0) = 4: paschal(8, 1) = 16
	paschal(9, 0) = 4: paschal(9, 1) = 5
	paschal(10, 0) = 3: paschal(10, 1) = 25
	paschal(11, 0) = 4: paschal(11, 1) = 13
	paschal(12, 0) = 4: paschal(12, 1) = 2
	paschal(13, 0) = 3: paschal(13, 1) = 22
	paschal(14, 0) = 4: paschal(14, 1) = 10
	paschal(15, 0) = 3: paschal(15, 1) = 30
	paschal(16, 0) = 4: paschal(16, 1) = 17
	paschal(17, 0) = 4: paschal(17, 1) = 7
	paschal(18, 0) = 3: paschal(18, 1) = 27


	'get the julian date
	lnJulian = DateToJulian(nMonth, nDay, nYear)

	'get the day of the week
	nDayWeek = DayOfWeek(nMonth, nDay, nYear) + 1

	'determine the occurance of the weekday within the month
	nDayMonth = ABS(INT(-(nDay / 7)))

	sHoliday1 = ""
	sHoliday2 = ""

'find out if there is a federal or common holiday on this date
SELECT CASE nMonth
	CASE 1
	IF nDay = 1 THEN
		sHoliday1 = "New Year's Day"
	END IF
	IF (nDayWeek = 2 AND nDayMonth = 3) THEN
		sHoliday1 = "Martin Luther King Day"
	END IF
	CASE 2
	IF nDay = 2 THEN
		sHoliday1 = "Ground Hog Day"
	END IF
	IF nDay = 14 THEN
		sHoliday1 = "Valentine's Day"
	END IF
	IF nDay = 15 THEN
		sHoliday1 = "Susan B. Anthony Day"
	END IF
	IF (nDayWeek = 2 AND nDayMonth = 3) THEN
		sHoliday1 = "President's Day"
	END IF
	CASE 3
	IF nDay = 17 THEN
		sHoliday1 = "St. Patrick's Day"
	END IF
	CASE 4
	IF nDay = 1 THEN
		sHoliday1 = "April Fool's Day"
	END IF
	IF (nDayWeek = 1 AND nDayMonth = 1) THEN
		sHoliday1 = "Daylight Saving Time Begins"
	END IF
	IF (nDay > 23 AND nDayWeek = 6) THEN
		sHoliday1 = "Arbor Day" 'last friday in April
	END IF
	CASE 5
	IF (nDayWeek = 3 AND (nDay > 1 AND nDay < 9)) THEN
		sHoliday1 = "National Teacher Day"
	END IF
	IF (nDayWeek = 1 AND nDayMonth = 2) THEN
		sHoliday1 = "Mother's Day"
	END IF
	IF (nDayWeek = 7 AND nDayMonth = 3) THEN
		sHoliday1 = "Armed Forces Day"
	END IF
	IF (nDay > 24 AND nDayMonth > 3 AND nDayWeek = 2) THEN
	  sHoliday1 = "Memorial Day"
	END IF
	IF nDay = 22 THEN
	  IF sHoliday1 <> "" THEN
		sHoliday2 = "National Maritime Day"
	  ELSE
		sHoliday1 = "National Maritime Day"
	  END IF
	END IF
	CASE 6
	IF (nDayWeek = 1 AND nDayMonth = 3) THEN
		sHoliday1 = "Father's Day"
	END IF
	IF nDay = 14 THEN
		sHoliday1 = "Flag Day"
	END IF
	CASE 7
	IF nDay = 4 THEN
		sHoliday1 = "Independence Day"
	END IF
	CASE 8
	IF nDay = 15 AND Holiday4 THEN
		sHoliday1 = "Feast Of Assumption"
	END IF
	CASE 9
	IF (nDayWeek = 2 AND nDayMonth = 1) THEN
		sHoliday1 = "Labor Day"
	END IF
	IF nDay = 17 THEN
		sHoliday1 = "Citzenship Day"
	END IF
	CASE 10
	IF (nDayWeek = 2 AND nDayMonth = 2) THEN
		sHoliday1 = "Columbus Day"
	END IF
	IF nDay = 24 THEN
		sHoliday1 = "United Nations Day"
	END IF
	IF nDay = 31 THEN
		sHoliday1 = "Halloween"
	END IF
	IF (nDay > 24 AND nDayMonth > 3 AND nDayWeek = 1) THEN
	  IF sHoliday1 <> "" THEN
		sHoliday2 = "Daylight Saving Time Ends"
	  ELSE
		sHoliday1 = "Daylight Saving Time Ends"
	  END IF
	END IF
	CASE 11
	IF (nDayWeek = 3 AND (nDay > 1 AND nDay < 9)) THEN
		sHoliday1 = "Election Day"
	END IF
	IF nDay = 11 THEN
		sHoliday1 = "Veteran's Day"
	END IF
	IF (nDayWeek = 5 AND nDayMonth = 4) THEN
		sHoliday1 = "Thanksgiving Day"
	END IF
	CASE 12
	IF nDay = 25 THEN
		sHoliday1 = "Christmas Day"
	END IF
	CASE ELSE
END SELECT

'--------------------------------------------------------------------------
'get the date of passover for this year
'    this algorithm has been tested and works for determining the date of
'    of easter, but there seems to be a problem with the actual date of
'    passover
'--------------------------------------------------------------------------
	pNum = nYear MOD 19
	pMonth = paschal(pNum, 0)
	pDay = paschal(pNum, 1)

	'this is supposed to be the date of passover but is not always
	'correct. sometimes +/- 1 day
	pDayWeek = DayOfWeek(pMonth, pDay, nYear)
	
	'now get the date of easter
	pJulian = DateToJulian(pMonth, pDay, nYear)
	eJulian = pJulian + (7 - pDayWeek)

	'see if our current date matches
	IF lnJulian = eJulian THEN sHoliday2 = "Easter Sunday"
	IF lnJulian = eJulian - 47 THEN sHoliday2 = "Mardi Gras"
	IF lnJulian = eJulian - 46 THEN sHoliday2 = "Ash Wednesday"
	IF lnJulian = eJulian - 7 THEN sHoliday2 = "Palm Sunday"
	IF lnJulian = eJulian - 2 THEN sHoliday2 = "Good Friday"
	IF lnJulian = eJulian + 49 THEN sHoliday2 = "Pentecost"
	IF lnJulian = eJulian + 56 THEN sHoliday2 = "Trinity Sunday"
	IF sHoliday2 <> "" THEN
		IF lnJulian = pJulian THEN sHoliday1 = "First Day of Passover"
	ELSE
		IF lnJulian = pJulian THEN sHoliday2 = "First Day of Passover"
	END IF
	IF nMonth = 12 AND nDayWeek = 1 AND nDayMonth = 1 THEN sHoliday2 = "First Sunday Of Advent"

	IF sHoliday1 <> "" THEN sHoliday1 = UCASE$(sHoliday1)
	IF sHoliday2 <> "" THEN sHoliday2 = UCASE$(sHoliday2)

	IF sHoliday1 <> "" OR sHoliday2 <> "" THEN
		IsHoliday% = TRUE
	ELSE
		IsHoliday% = FALSE
	END IF

END FUNCTION

'------------------------------------------------
' NAME : IsLeapYear(..)
'
' PARMS:
'   INPUT : yearNum as Integer
'   OUTPUT:
'
' RETURNS:  True if yearNum is a leap year
'           False if yearNum is not a leap year
'
' CALLED BY:
'
' DESC:
'-------------------------------------------------
FUNCTION IsLeapYear% (YearNum AS INTEGER)
	IF YearNum MOD 4 = 0 THEN
		IsLeapYear% = TRUE
		IF YearNum MOD 100 = 0 THEN
			IF YearNum MOD 400 = 0 THEN
				IsLeapYear% = TRUE
			ELSE
				IsLeapYear% = FALSE
			END IF
		END IF
	ELSE
		IsLeapYear% = FALSE
	END IF
END FUNCTION

'--------------------------------------
'IsValidDate - Determine whether given date is valid
'Purpose: Given the month, day, and year
'       the validity of a date
'Input: month, day and year as integer
'Returns: False (0) if invalid, True (NOT False) if valid
'Calls DateToJulian and JulianToDate
'--------------------------------------
FUNCTION IsValidDate% (BYVAL nMonth AS INTEGER, BYVAL nDay AS INTEGER, BYVAL nYear AS INTEGER)
DIM m2 AS INTEGER
DIM d2 AS INTEGER
DIM y2 AS INTEGER
DIM nx AS INTEGER
DIM lnJulian AS LONG

	lnJulian = DateToJulian(nMonth, nDay, nYear)
	nx = JulianToDate(lnJulian, m2, d2, y2)
	IF (nMonth = m2) AND (nDay = d2) AND (nYear = y2) THEN
		IsValidDate% = TRUE
	ELSE
		IsValidDate% = FALSE
	END IF
END FUNCTION

'--------------------------------------
'JulianToDate - Calculate Month, Day & Year
'Purpose: Given the lnJulian Date
'       calculates the Month, Day, & Year
'Input: lnJulian as long, month, day and year as integer
'Modifies: Month, Day, & Year
'Returns: False if Julian date < 2299604
'--------------------------------------
FUNCTION JulianToDate% (BYVAL lnJulian AS LONG, nMonth AS INTEGER, nDay AS INTEGER, nYear AS INTEGER)
DIM lx AS LONG
DIM ly AS LONG
DIM ld AS LONG
DIM lm AS LONG

	IF lnJulian < 2299604 THEN
		nMonth = 0
		nDay = 0
		nYear = 0
		JulianToDate% = FALSE
	ELSE
		lx = 4 * lnJulian - 6884477
		ly = (lx \ 146097)
		ly = ly * 100
		ld = (lx MOD 146097) \ 4
		lx = 4 * ld + 3
		ly = (lx \ 1461) + ly
		ld = (lx MOD 1461) \ 4
		ld = ld + 1
		lx = 5 * ld - 3
		lm = lx \ 153
		lm = lm + 1
		ld = (lx MOD 153) \ 5
		ld = ld + 1
		IF lm < 11 THEN
			nMonth = INT(lm + 2)
		ELSE
			nMonth = INT(lm - 10)
		END IF
		nDay = INT(ld)
		nYear = INT(ly + lm \ 11)
		JulianToDate% = TRUE
	END IF
END FUNCTION

'----------------------------------------------------------------------
' NAME:     JulianToSerial#(..)
' PURPOSE:  Calculates the Serial Date from the astronomical julian date
' INPUT:    lnJulian - Julian Date as long integer
' OUPUT:    None
' RETURNS:  Serial Date if valid, 0 if invalid
' NOTES:
'----------------------------------------------------------------------
FUNCTION JulianToSerial# (BYVAL lnJulian AS LONG)
DIM nMonth AS INTEGER
DIM nDay AS INTEGER
DIM nYear AS INTEGER
DIM retVal AS INTEGER

	'first validate the date
	IF NOT JulianToDate(lnJulian, nMonth, nDay, nYear) THEN
		JulianToSerial# = 0
		EXIT FUNCTION
	ELSEIF NOT IsValidDate%(nMonth, nDay, nYear) THEN
		JulianToSerial# = 0
		EXIT FUNCTION
	END IF

	JulianToSerial# = lnJulian - 2415019
END FUNCTION

'----------------------------------------------------------------------
' NAME:     SerialToJulian&(..)
' PURPOSE:  Calculates the astronomical julian date from the Date Serial
' INPUT:    dSerial - Serial Date as double
' OUPUT:    None
' RETURNS:  Julian date as long integer
' NOTES:    If the serial date is 0 then this will return 2415019
'           Which is 12/30/1899
'----------------------------------------------------------------------
FUNCTION SerialToJulian& (BYVAL dSerial AS DOUBLE)
	SerialToJulian& = CLNG(dSerial + 2415019)
END FUNCTION

