'======================================================================
' FUNGUS - FUNCTIONS (GLOBAL, UNIVERSAL & SIMPLE)
' Presented By The Not Ready For Wide Release Programmers
'
' FGB004.BAS - Mathematical Functions - Version 1.00
' Compiled and Gathered From the Four Corners of Planet Earth
' By Mike DeBacker
'
' Most of these routines were written and tested in QBX PDS 7.1 and then
' tested in VB 3.0 to ensure compatibility
'
' PURPOSE: I get a little tired of doing the same things over and over
' and over again. ("Hey, I need a new battery")
'
' OTHER FILES: For use with QBasic be sure and include the include
' FUNGUS_B.BI
' ------------------------------------------------------------------
'-------------------------------------------------------------
'Never fear VB users... VB treats the following line as a comment, but
'a must for QBasic PDS and VB-DOS...
'$INCLUDE: 'FUNGUS_B.BI'

FUNCTION ARCCSC! (snx AS SINGLE)
	ARCCSC! = ATN(snx / SQR(snx * snx - 1)) + SGN(SGN(snx) - 1) * 1.5708
END FUNCTION

FUNCTION ARCSIN! (snx AS SINGLE)
	ARCSIN! = -ATN(snx / SQR(-snx * snx + 1)) + 1.5708
END FUNCTION

'--------------------------------------
'CalcFactor - Calculate Margin Factor
'Purpose: Given the margin percent as integer value
'       calculates the margin factor
'Input: margin as single
'Returns: Factor as single
'--------------------------------------
FUNCTION CalcFactor! (margin AS SINGLE)
	IF margin > 100 THEN
	BEEP
	CalcFactor! = 0
	END IF
	IF margin = 100 THEN margin = 99
	IF margin <> 0 THEN
	CalcFactor! = 100 / (100 - margin)
	ELSE
	CalcFactor! = 0
	END IF
END FUNCTION

'--------------------------------------
'CalcMargin - Calculate Margin Percent
'Purpose: Given the margin factor
'       calculates the margin percent
'Input: Factor as single
'Returns: percent as single
'--------------------------------------
FUNCTION CalcMargin! (factor AS SINGLE)
	IF factor >= 100 THEN factor = 99

	CalcMargin! = (100 - (100 / factor)) / 100
END FUNCTION

'----------------------------------------------------------------------
' NAME:     CalcRadToDec!(..)
' PURPOSE:  Converts Radians to decimal degrees
' INPUT:    Radians as singles
' OUPUT:    None
' RETURNS:  Radians as single
' NOTES:    To convert a radian value to degrees, multiply it by 180/PI
'           (or 57.2957795130824) where PI = 3.141593.
'----------------------------------------------------------------------
FUNCTION CalcRadToDec! (snRadians AS SINGLE)
DIM snPI AS SINGLE
	snPI = 3.141593
	CalcRadToDec! = snRadians * (180 / snPI)
END FUNCTION

'----------------------------------------------------------------------
' NAME:     CompInt
' PURPOSE:  Calculates Compound Interest S = P * (1 + i)^n
' INPUT:    snPrin = Principle as single
'           snRate = Rate as single (enter as percent; e.g. .12 not 12%)
'           nComp = Number of times per year that the interest is compounded as integer.
'           nPeriod = Number of interest periods as integer
' OUPUT:    None
' RETURNS:  Final Amount of money (principle plus interest).
'           Or returns 0 if error occurs.
' CALLS:    None
' NOTES:    The variable i used in the formula above is the periodic
'           interest rate. But the function expects the "quoted" interest
'           rate and then will calculate the periodic rate. Given the number
'           of compounding periods (i.e if it is to compounded monthly, the
'           number of periods would be 12)
'----------------------------------------------------------------------
FUNCTION CompInt! (BYVAL snPrin AS SINGLE, BYVAL snRate AS SINGLE, BYVAL nComp AS INTEGER, BYVAL nPeriod AS INTEGER)
DIM snI AS SINGLE
DIM snCI AS SINGLE
DIM nPers AS INTEGER

	IF (snPrin = 0) OR (snRate = 0) OR (nComp = 0) OR (nPeriod = 0) THEN
		CompInt! = 0
		EXIT FUNCTION
	END IF

	'calculate the periodic interest rate
	snI = 1 + (snRate / nComp)

	'calculate the compounded interest rate
	snCI = snI
	FOR nPers = 2 TO nPeriod
		snCI = snCI * snI
	NEXT nPers

	CompInt! = snPrin * snCI

END FUNCTION

FUNCTION COT! (snx AS SINGLE)
	COT! = 1 / TAN(snx)
END FUNCTION

FUNCTION CSC! (snx AS SINGLE)
	CSC! = 1 / SIN(snx)
END FUNCTION

FUNCTION LogTen! (X)
	LogTen! = LOG(X) / LOG(10#)
END FUNCTION

FUNCTION Sec! (snx AS SINGLE)
	Sec! = 1 / COS(snx)
END FUNCTION

'----------------------------------------------------------------------
' NAME:     SimpInt
' PURPOSE:  Calculates simple interest (I=PRT)
' INPUT:    Principle, Rate and Time as single
' OUPUT:    None
' RETURNS:  Interest
' CALLS:    None
' NOTES:    None
'----------------------------------------------------------------------
FUNCTION SimpInt! (BYVAL snPrin AS SINGLE, BYVAL snRate AS SINGLE, BYVAL snTime AS SINGLE)
	SimpInt! = snPrin * snRate * snTime
END FUNCTION

'----------------------------------------------------------------------
' NAME:     TimeToDouble
' PURPOSE:  To find how long it will take to double your money. Using the
'           the formula n=.30103 / LOG(1 + i)
' INPUT:    snRate = Rate as single (enter as percent; e.g. .12 not 12%)
'           nComp = Number of times per year that the interest is compounded as integer.
' OUPUT:    None
' RETURNS:  The number of interest periods required as an integer
'           Or returns 0 if error occurs.
' CALLS:    None
' NOTES:    The variable 'i' used in the formula above is the periodic
'           interest rate. But the function expects the "quoted" interest
'           rate and then will calculate the periodic rate. Given the number
'           of compounding periods (i.e if it is to compounded monthly, the
'           number of periods would be 12)
'----------------------------------------------------------------------
FUNCTION TimeToDouble% (BYVAL snRate AS SINGLE, BYVAL nComp AS SINGLE)
DIM snI AS SINGLE

	'calculate the periodic interest rate
	snI = 1 + (snRate / nComp)
	
	TimeToDouble% = INT(.30103 / (LogTen(snI)))
	'this is nothing
END FUNCTION

