'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'%  (C) 1987 HUMBLEWARE Custom Programming    Author: Lawrence A. Westhaver  %
'%        247 Paul Martin Drive,  Baltimore MD  21227  (301) 799-1975        %
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'%                                                                           %
'%     FILENAME: FNSGR$.FUN                      LAST UPDATE: 06/12/1987     %
'%                                                                           %
'%  DESCRIPTION: Set graphics rendition (set color for screen writes). This  %
'%               routine mimics the QuickBASIC COLOR n,n statement format.   %
'%                                                                           %
'%        USAGE: PRINT #1, FNSGR$(FG%,BG%);                                  %
'%                                                                           %
'%       INPUTS: FG% = Foreground color (0-31).                              %
'%                                                                           %
'%               BG% = Background color (0-7).                               %
'%                                                                           %
'%      RETURNS: ANSI.SYS compatible SGR string.                             %
'%                                                                           %
'%         NOTE: The ANSI.SYS device driver must be installed on your        %
'%               computer before this function can be used.                  %
'%                                                                           %
'%               This routine assumes that you have opened a disk file,      %
'%               communications port or the console prior to printing        %
'%               the ANSI control string returned by this function.          %
'%                                                                           %
'%               If either the foreground or the background color is         %
'%               out of range, the foreground color will be returned as      %
'%               white (37) and the background color will be returned        %
'%               as black (40).                                              %
'%                                                                           %
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


DEF FNSGR$(FG%,BG%)


'initialize ansi color control strings

	DIM FG$(7),BG$(7)

	FG$(0)="30;" : BG$(0)="40m"
	FG$(1)="34;" : BG$(1)="44m"
	FG$(2)="32;" : BG$(2)="42m"
	FG$(3)="36;" : BG$(3)="46m"
	FG$(4)="31;" : BG$(4)="41m"
	FG$(5)="35;" : BG$(5)="45m"
	FG$(6)="33;" : BG$(6)="43m"
	FG$(7)="37;" : BG$(7)="47m"


'check foreground for out of range

	IF FG%<0 OR FG%>31 THEN
	  FNSGR$=CHR$(27)+"[0;40;37m"
	  EXIT DEF
	END IF


'check background for out of range

	IF BG%<0 OR BG%>7 THEN
	  FNSGR$=CHR$(27)+"[0;40;37m"
	  EXIT DEF
	END IF


'build ANSI control string

	'initialize ansi color control string
	ANSI$=CHR$(27)+"[0;"


	'set foreground blink
	IF (FG% AND 16) THEN
	  ANSI$=ANSI$+"5;"
	END IF


	'set foreground intensity
	IF (FG% AND 8) THEN
	  ANSI$=ANSI$+"1;"
	END IF


	'set foreground color
	BITSUM%=0

	IF (FG% AND 4) THEN
	  BITSUM%=BITSUM%+4
	END IF

	IF (FG% AND 2) THEN
	  BITSUM%=BITSUM%+2
	END IF

	IF (FG% AND 1) THEN
	  BITSUM%=BITSUM%+1
	END IF

	ANSI$=ANSI$+FG$(BITSUM%)


	'set background color
	BITSUM%=0

	IF (BG% AND 4) THEN
	  BITSUM%=BITSUM%+4
	END IF

	IF (BG% AND 2) THEN
	  BITSUM%=BITSUM%+2
	END IF

	IF (BG% AND 1) THEN
	  BITSUM%=BITSUM%+1
	END IF

	ANSI$=ANSI$+BG$(BITSUM%)


	FNSGR$=ANSI$


END DEF 'fnsgr$
