'========================================
' dBHeader.bi
' Include file to set up dBase parameters
' 03/01/93   kso
'========================================
'Set up user defined types
   DEFINT A-Z

   CONST FALSE = 0
   CONST TRUE = -1

TYPE dbHdr1
   Version        AS STRING * 1                  'dBaseIII file header after
   LastUpd        AS STRING * 3                  'deblocking
   NumRecs        AS LONG
   HdrLen         AS INTEGER
   RecLen         AS INTEGER
   NumFields      AS INTEGER
   HdrOffset      AS INTEGER
   LstUpdate      AS STRING * 8
   Fill1          AS STRING * 10
END TYPE

TYPE dbMemHdr1
   NumSegs AS LONG
   Filler AS STRING * 508
END TYPE

TYPE dbNdxHdr1
   Root   AS LONG
   Pages  AS LONG
   Fill1  AS STRING * 4
   KeySiz AS INTEGER
   KeysPg AS INTEGER
   KeyTyp AS INTEGER
   RecSiz AS INTEGER
   Fill2  AS INTEGER
   Unique AS INTEGER
   KeyExp AS STRING * 256
   Ver    AS LONG
END TYPE

TYPE FldDsc                                      'Field Descriptions
   FldName  AS STRING * 11                       '32 bytes * Number of Fields
   FldType  AS STRING * 1                        'Up to 128
   DataAddr AS LONG
   RLen     AS STRING * 1
   RDec     AS STRING * 1
   Length   AS INTEGER
   Decimal  AS INTEGER
   Offset   AS INTEGER
   Fill     AS STRING * 8
END TYPE

'========================================
' RegType contains the register structure
' for performing BIOS calls using
' CALL INTERRUPT - found in QBX library
'========================================

TYPE RegType              'for CALL INTERRUPT
     ax    AS INTEGER
     bx    AS INTEGER
     cx    AS INTEGER
     dx    AS INTEGER
     bp    AS INTEGER
     si    AS INTEGER
     di    AS INTEGER
     flags AS INTEGER
END TYPE

'Function declarations
   DECLARE FUNCTION dbGetDsc (dbChn, InFld AS FldDsc, Fld1() AS FldDsc, nFlds)
   DECLARE FUNCTION dbGetDbfHdr (dbChn, Hdr1 AS dbHdr1)
   DECLARE FUNCTION dbGetMemHdr (dmChn, Hdr1 AS dbMemHdr1)
   DECLARE FUNCTION dbGetNdxHdr (dnChn, Hdr1 AS dbNdxHdr1)
   DECLARE FUNCTION dbOpnDbf (dbNme$)
   DECLARE FUNCTION dbOpnMem (dbNme$)
   DECLARE FUNCTION dbOpnNdx (dbNdx$)
   DECLARE FUNCTION dbGetRec$ (dbChn, dbRec, Hdr1 AS dbHdr1)
   DECLARE FUNCTION dbGetField$ (dbRec$, DscRec AS FldDsc, FldNo)
   DECLARE FUNCTION dbPutField$ (dbRec$, DscRec AS FldDsc, FldNo, FldDat$)
   DECLARE FUNCTION dbPutRec (dbChn, dbRec, Hdr1 AS dbHdr1, dbRec$)
   DECLARE FUNCTION dbAddRec (dbChn, Hdr1 AS dbHdr1)
   DECLARE FUNCTION dbDelRec (dbChn, dbRec, Hdr1 AS dbHdr1, DelSw)
   DECLARE FUNCTION dbGetMem$ (dmChn, dbPtr&)
   DECLARE FUNCTION utEdtText (Buffer$, Lines, Columns, row1, col1)
   DECLARE FUNCTION dbBottom (dbChn, Hdr1 AS dbHdr1)
   DECLARE FUNCTION dbTop (dbChn, Hdr1 AS dbHdr1)
   DECLARE FUNCTION dbZap (dbChn, Hdr1 AS dbHdr1, dbNme$)
   DECLARE FUNCTION dbCpyFil (dbChn%, Hdr1 AS dbHdr1, dbNme$)
   DECLARE FUNCTION dbCpyStr (dbChn%, Hdr1 AS dbHdr1, dbNme$)
   DECLARE FUNCTION dbDeletd (dbChn%, Hdr1 AS dbHdr1)
   DECLARE FUNCTION dbMemLen (dbMemPtr$, dmChn%)
   DECLARE FUNCTION dbPck (dbChn%, Hdr1 AS dbHdr1, dbNme$)
   DECLARE FUNCTION dbDelRng (dbChn, BegRec, EndRec, Hdr1 AS dbHdr1)

'Sub Program declarations
   DECLARE SUB utStrChr (InStr$)
   DECLARE SUB utWrpPrn (text$, row1, col1, row2, col2)
   DECLARE SUB utBox (row1, col1, row2, col2, fore, back, border, fillFlag)
   DECLARE SUB utScroll (row1, col1, row2, col2, Lines, attr)
   DECLARE SUB INTERRUPT (intnum AS INTEGER, inreg AS RegType, outreg AS RegType)

'Declare record variables
   DIM Header1            AS dbHdr1              'Variable for dBase headers
   DIM MemHeader          AS dbMemHdr1
   DIM NdxHeader          AS dbNdxHdr1
   DIM Flds               AS FldDsc
   DIM SHARED debug       AS INTEGER             'Debugging flag


