'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Create a database file (DBF).
'

 DEFINT A-Z

 '--- DBF type & declarations
 '$INCLUDE: 'DBFUNC.BI'

 DECLARE SUB StampRecord (File, Records&)
 DECLARE SUB PutRec (File, Record&, Record$)
 DECLARE SUB StampDate (File)
 DECLARE SUB CloseFile (FileHandle)
 DECLARE SUB CreateFile (filename$, FileHandle)
 DECLARE SUB OpenFile (filename$, FileHandle)
 DECLARE SUB SeekWrite (FileHandle, OffSet&, data$)
 DECLARE SUB KillFile (Name$)
 DECLARE SUB WriteFile (FileHandle, data$)
 DECLARE SUB SeekFile (FileHandle, OffSet&)

 DECLARE FUNCTION Exist (filename$)
 DECLARE FUNCTION NumToBCD$ (Num&)
 DECLARE FUNCTION Trim$ (A$)

SUB CreateDBF (DBFName$, Mode)
  
   '
   'This routine creates a DBF using the stucture found in Fld() type array
   'with the name DBFName$. The DBF file will contain no records. The file
   'will be a totally valid dBASE III+ type file. The file will not be
   'opened by this call though.
   '
   'On entry:
   '
   '    Mode = 0 -> Create DBF if not already exist -- if exist then do
   '                nothing and exit immediatly. (default)
   '
   '    Mode = 1 -> Erase old, if any, then create new.
   '
   'NOTE: The Fld() type array MUST be preset before this call.
   '
   'NOTE: dBASE fields use NULLS (CHR$(0)) not SPACES (CHR$(32)) -- do not
   '      change this.
   '
  
   '---make some variables
   Startb& = 32           'start field descriptors at byte 33
   NumFlds = UBOUND(Fld)  'number of fields
  
   '--- check mode
   IF Exist(DBFName$) THEN IF Mode = 1 THEN KillFile DBFName$ ELSE EXIT SUB
  
   '--- open DBF
   CreateFile DBFName$, File                    'zap and open DBF

   '--- write dbf header
   HeadSize& = 33 + (NumFlds * 32)              'headsize
   Type$ = STRING$(HeadSize&, 0)                'make header blank
   MID$(Type$, 1) = CHR$(3)                     'add marker -- CHR$(3)
   SeekWrite File, 0, Type$                     'write it
   
   '--- get field data
   SeekFile File, Startb&                           'goto start of field info

   '--- lets play . . . "build a header!"
   FOR flds = 1 TO NumFlds
    
     '--- 32 byte field descriptor -- NULLS
     Type$ = STRING$(32, 0)

     '--- field definitions
     MID$(Type$, 1, 11) = Trim$(UCASE$(Fld(flds).FName))
     MID$(Type$, 12, 1) = UCASE$(Fld(flds).FType)
     MID$(Type$, 17, 1) = UCASE$(CHR$((Fld(flds).FLen)))
     MID$(Type$, 18, 1) = UCASE$(CHR$((Fld(flds).Decimal)))
   
     '--- write field descriptor
     WriteFile File, Type$

     '--- gen record size
     RecSize& = RecSize& + Fld(flds).FLen
 
  NEXT  'flds
 
  '--- write end-of-header
  Type$ = CHR$(13)              'dBIII+ has CR @ end of header
  SeekWrite File, HeadSize& - 1, Type$
 
  '--- write record size
  Type$ = NumToBCD(RecSize& + 1)                  '-->BCD
  IF LEN(Type$) = 1 THEN Type$ = Type$ + CHR$(0)  'append NULL (if needed)
  SeekWrite File, 10, Type$                       'start of header size
 
  '--- write head size
  Type$ = NumToBCD(HeadSize&)                     '-->BCD
  IF LEN(Type$) = 1 THEN Type$ = Type$ + CHR$(0)  'append NULL (if needed)
  SeekWrite File, 8, Type$                        'start of header size
 
  '--- write end of header
  Type$ = CHR$(26)                      'EOF
  SeekWrite File, HeadSize&, Type$
 
  '--- stamp records & date
  StampRecord File, 0
  StampDate File
 
  '--- close file & exit
  CloseFile File

  'thats all folkes! - You now have a REAL dBASE III+ database
  

END SUB

