'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'
'Returns a database (DBF) fields name or number.
'

 DEFINT A-Z
 
 '--- DBF type & declarations
 '$INCLUDE: 'DBFUNC.BI'

 DECLARE SUB CheckFields (File)
 
 DECLARE FUNCTION Trim$ (A$)

SUB FldInfo (FileNum, FldNum, FldName$)
   
    '
    'Returns the field name if given field number or returns field number
    'if given field name. Use it to determine the field number or name when
    'one or the other is known only.
    '
    'NOTE: FldNum has priority over FldName$.
    '
   
    '--- get DBF definition
    CheckFields FileNum
   
    '---do it
    IF FldNum <> 0 THEN                 'want FldName$ . . .
     
      '--- simply assign the field name
      FldName$ = Fld(FldNum).FName
      EXIT SUB

    ELSE                                'want FldNum . . .
     
      '--- assign field name
      FldName$ = LTRIM$(RTRIM$(UCASE$(FldName$)))

      '--- search through Fld() looking for the field name
      FOR FldNum = 1 TO Fld(0).Decimal
       
        '--- strip out any nulls
        temp$ = Trim$(Fld(FldNum).FName)

        '--- compare them
        IF UCASE$(temp$) = FldName$ THEN EXIT SUB
       
      NEXT 'FldNum
   
    END IF 'fldnum <> 0

    '--- if you got here then there was an error
    FldNum = 0

END SUB

