'
'(C) 1990 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Seeks to a file location using DOS calls: replaces QuickBASIC SEEK
'routine.
'
DEFINT A-Z

TYPE RegType
  AX AS INTEGER
  BX AS INTEGER
  CX AS INTEGER
  DX AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
END TYPE

DECLARE SUB Interrupt (IntNum, InRegs AS RegType, OutRegs AS RegType)
DECLARE SUB SetMAXError (ErrNum)

SUB SeekFile (FileHandle, OffSet&)

   '
   'Seeks to position OffSet& in file filehandle.
   'Top of file is 0.
   '
   'MAXBASIC routines use DOS & ROM BIOS instead of BASIC for four reasons:
   '    1) Using DOS dosen't crash system like BASIC errors due...
   '    2) ...so your program is smaller from not using ON ERROR.
   '    3) These are faster than QB as they have minial "hand-holding".
   '    4) BASIC can't do some of the functions I use DOS & ROM for!
   '
   'Sets MAXError to error if error occurs.
   '
  
   '--- if valid handle
   IF FileHandle > 0 THEN
  
        '---DOS type
        DIM Regs  AS RegType
        SetMAXError 0         'assume success

        '--- chop OffSet into High and Low integers
        HighByte& = OffSet& \ 32767
        LowByte& = OffSet& - (HighByte& * 32767)

        '--- do it
        Regs.AX = &H4200                        'DOS seek to
        Regs.BX = FileHandle                    'file
        Regs.CX = HighByte&                     'large portion
        Regs.DX = LowByte&                      'small portion
        Interrupt &H21, Regs, Regs              'do it
  
   END IF
  
   '--- check for errors
   IF (Regs.Flags AND 1) OR (FileHandle < 1) THEN SetMAXError Regs.AX
  
END SUB

