'
'(C) 1990 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Returns the file-pointer position using DOS calls: replaces
'QuickBASIC LOC() routine.
'

DEFINT A-Z

TYPE RegType
  AX AS INTEGER
  BX AS INTEGER
  CX AS INTEGER
  DX AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
END TYPE

DECLARE SUB Interrupt (IntNum, InRegs AS RegType, OutRegs AS RegType)
DECLARE SUB SeekFile (FileHandle, OffSet&)
DECLARE SUB SetMAXError (ErrNum)

DECLARE FUNCTION FLOC& (FileHandle)
DECLARE FUNCTION SizeOf& (FileHandle)

FUNCTION FLOC& (FileHandle)

   '
   'Returns the current DOS pointer inside of a file with handle FileHandle.
   'Functional equivalent of the BASIC LOC() function.
   '
   'The only method to do this not using BASIC is to move 1 byte ahead
   'and then see where we are. INT &H21, function &H4200 returns the current
   'offset in the file only AFTER you call it. So, we move ahead 1 byte,
   'see where we are, and then move one byte back to where we were!
   '
   'NOTE : This is ONLY for files opened using the MAXBASIC FILEFUNC.BAS
   '       library. It won't work for files opened in BASIC or for
   '       closed files.
   '
  
   '--- assume sucess
   Status = 0

   '--- check for error
   IF FileHandle = 0 THEN                       'no handle?
     '--- error
     Status = 100                               'invalid file handle
   ELSE                                         'valid file handle
     '--- DOS type
     DIM Regs  AS RegType                       'DOS type

     '--- seek 1 byte ahead                
     Regs.AX = &H4201                           'move "down" from here
     Regs.BX = FileHandle                       'file no.
     Regs.CX = 0                                'high order byte (0)
     Regs.DX = 1                                'move one byte
     Interrupt &H21, Regs, Regs                 'do it
    
     '--- if no error then move back        
     IF Regs.Flags AND 1 THEN                   'errors?
        Status = Regs.AX                        'assign error
     ELSE
        '--- determine position             
        Location& = ((Regs.DX * 256) + Regs.AX) - 1 'backup to where we were
    
        '--- chop Location& into High and Low integers
        HighByte& = Location& \ 32767                'high part for CX
        LowByte& = Location& - (HighByte& * 32767)   'low part for DX
    
        '--- go back one byte
        Regs.AX = &H4200                             'absolute offset from 0
        Regs.BX = FileHandle                         'file
        Regs.CX = HighByte&                          'high order
        Regs.DX = LowByte&                           'low order
        Interrupt &H21, Regs, Regs                   'do it
       
        '--- if no error then assign function
        IF Regs.Flags AND 1 THEN                     'errors?
           Status = Regs.AX                          'error handler
        ELSE                                         'sucess
           '--- assign function
           Location& = ((Regs.DX * 256) + Regs.AX)   'determine offset
           FLOC& = Location&                         'assign function
        END IF
     END IF
   END IF

   '--- error handler
   SetMAXError Status                                'set error level

END FUNCTION

