'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Determines if a file exists or not using DOS calls.
'
'NOTE: BASIC COMPILER 7.X users -- change VARSEG to SSEG.
'      QuickBASIC 4.X users     -- no modifications needed.
'

DEFINT A-Z

TYPE RegTypeX
  AX AS INTEGER
  BX AS INTEGER
  CX AS INTEGER
  DX AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
  DS AS INTEGER
  ES AS INTEGER
END TYPE

DECLARE SUB InterruptX (IntNum, InRegsX AS RegTypeX, OutRegsX AS RegTypeX)
DECLARE SUB SetMAXError (ErrNum)
DECLARE FUNCTION Exist (FileName$)
DECLARE FUNCTION CheckDrive (Drive$)

  'CLS
  'filename$ = "c:\windows\word\winword.exe"
  'IF Exist(filename$) THEN PRINT "Yes" ELSE PRINT "no"

FUNCTION Exist (FileName$)
 
     '
     'Sees if a file exists. Returns TRUE (-1) if file exists or FALSE (0) if
     'it does not. This allows the use of . . .
     '
     '             IF Exist(FileName$) THEN
     '             IF NOT Exist(FileName$) THEN
     '
     '       . . . type BASIC constructs.
     '
 
    '--- make sure drive is ready so DOS dosen't hang
    IF INSTR(FileName$, ":") > 0 THEN
      IF NOT CheckDrive(FileName$) THEN EXIT FUNCTION
    END IF
      
    '--- build type array for using DOS services
    DIM Regs  AS RegTypeX                 'QB interrupt type
    Status = 0                            'assume sucess

    '--- now go see if a file exists
    F$ = UCASE$(FileName$) + CHR$(0)      'ASCIIZ
  
    '--- setup disk transfer area
    DTArea$ = SPACE$(128) + CHR$(0)      'make a work area
    Regs.AX = &H1A00                     'DOS set DTA pointer
    Regs.DX = SADD(DTArea$)              'offset of DTA
    Regs.DS = VARSEG(DTArea$)            'segment of DTA
    InterruptX &H21, Regs, Regs          'set DTA
   
    '--- find file
    Regs.AX = &H4E00                      'DOS find first match
    Regs.CX = &H3F                        'attrib of anything (file/sdir/vol)
    Regs.DX = SADD(F$)                    'offset of FCB
    Regs.DS = VARSEG(F$)                  'segment of FCB
    InterruptX &H21, Regs, Regs           'find first match
  
    '--- set function
    IF Regs.AX > 0 THEN
      Exist = 0                           'isn't there
      Status = &H2                        'file not found
    ELSE
      Exist = -1                          'is there
    END IF
  
    '--- error handler
    SetMAXError Status

END FUNCTION

