'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Determines if a drive is ready for access using DOS calls.
'
'NOTE: BASIC COMPILER 7.X users -- change VARSEG to SSEG.
'      QuickBASIC 4.X users     -- no modifications needed.
'

DEFINT A-Z

TYPE RegTypeX
  AX AS INTEGER
  BX AS INTEGER
  CX AS INTEGER
  DX AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
  DS AS INTEGER
  ES AS INTEGER
END TYPE

DECLARE SUB InterruptX (IntNum, InRegsX AS RegTypeX, OutRegsX AS RegTypeX)
DECLARE SUB SetMAXError (ErrNum)
DECLARE FUNCTION CheckDrive (Drive$)

  'Drive$ = "A:\"
  'IF CheckDrive(Drive$) THEN PRINT "Ready" ELSE PRINT "Not ready"

FUNCTION CheckDrive (Drive$)

  '
  'This function checks Drive$ and sees if it is ready for read/write
  'operations. It does this in a peculiar manner; a QuickBASIC DOS call
  'will fail and lock up the system if, for example, you try to read,
  'write or access a floppy drive with no diskette in it.
  '
  'This routine attempts to read a sector from a disk. If the disk is
  'ready then CheckDrive returns a TRUE (-1). If the disk is not ready,
  'a FALSE (0) is returned. This is not a DOS call, it is a ROM BIOS
  'call which simply fails upon failure and does not lock up the system.
  '

  '--- check for drive
  IF LEN(Drive$) = 0 THEN                       'no drive passed?
    SetMAXError &H1                             'invalid function
    EXIT FUNCTION                               'bug out
  END IF
 
  '--- DOS type
  DIM Regs AS RegTypeX                          'make DOS type

  '--- Convert drive into a number for DOS
  IF INSTR(Drive$, ":") > 0 THEN                'a drive present?
    Drive = ASC(UCASE$(LEFT$(Drive$, 1))) - 65  'change drive to a number
  ELSE                                          'no drive, use default
    Regs.AX = &H1900                            'DOS get default drive
    InterruptX &H21, Regs, Regs                 'get current drive
    Drive = Regs.AX AND &HFF                    'convert into number
  END IF
 
  '--- for ROM call &H13, function &H02 need to specifically indicate
  '    drive type as shown below.
  SELECT CASE Drive
    CASE 0 TO 1                                 'this is a floppy A=0, B=1
      HardOrFloppy = 0                          'set floppy ID
    CASE ELSE                                   'this is a hard disk
      Drive = &H80 + Drive - 2                  'make ROM disk ID
      HardOrFloppy = 256                        'set hard disk ID
  END SELECT
 
  '--- IBM says do this three times before you decide the drive is not ready
  '    and not simply spun-down. So . . .
  DO
      '--- loop counter
      Count = Count + 1                         'pop loop counter
      '--- make a string
      SectorSize = 512                          'this is true is IBM world
      Tmp$ = STRING$(512, 0)                    'a work string
      '--- use ROM to (try to) read a sector
      Regs.AX = &H201                           '1 sector to read
      Regs.BX = SADD(Tmp$)                      'offset to recieve data
      Regs.ES = VARSEG(Tmp$)                    'segment to recieve data
      Regs.CX = &H1                             'cylnder 0, sector 1
      Regs.DX = HardOrFloppy + Drive            'head 0 of drive
      InterruptX &H13, Regs, Regs               'do it
      IF (Regs.Flags AND 1) = 0 THEN EXIT DO    'exit on NO error
   LOOP UNTIL Count = 3                         'try three times only
        
   '--- assign function for a PASS              'errors?
   IF (Regs.Flags AND 1) = 0 THEN               'no errors
      CheckDrive = -1                           'assign function TRUE
      Status = 0                                'error status 0
   ELSE                                         'disk not ready
      Status = &H15                             'error status drive not ready
   END IF

   '--- error handler
   SetMAXError Status                           'set error level
  
END FUNCTION

